local lua_profile = require "jit.profile"

local data = {}

local Profiler = {}

function Profiler.start()
  data = {}

  lua_profile.start("f", function(thread, samples, vmstate)
    local f = lua_profile.dumpstack(thread, "l:f", 1)
    data[f] = (data[f] or 0) + samples
  end)
end

function Profiler.stop()
  lua_profile.stop()
end

function Profiler.getSamples()
  return data
end

return Profiler
