local _L = _L

Screen = {}

function Screen.getSize()
  local x, y = _L._screenGetResolution()
  return Vector(x, y)
end

function Screen.isFullscreen()
  return _L._screenIsFullscreen()
end

function Screen.getAvailableVideoModes()
  local modes = {}
  _L._screenGetAvailableResolutions(modes)
  return modes
end

function Screen.setVideoMode(width, height, fullscreen)
  _L._screenSetResolution(width, height, fullscreen)
end

function Screen.getPixelSize()
  local x, y = _L._screenGetResolution()
  return Vector(1.0 / x, 1.0 / y)
end

Screen = ReadOnlyClass(Screen, "Screen")
