local _L = _L

Time = {}

function Time.setTimeScale(timeScale)
  _L._timeSetTimeScale(timeScale)
end

function Time.getTimeScale()
  return _L._timeGetTimeScale()
end

function Time.setDeltaTime(deltaTime, timeScale)
  rawset(Time, "timeScale", timeScale)
  rawset(Time, "deltaTime", deltaTime * timeScale)
  rawset(Time, "realDeltaTime", deltaTime)
  rawset(Time, "globalTime", Time.globalTime + deltaTime * timeScale)
end

function Time.setFixedDeltaTime(fixedDeltaTime)
  rawset(Time, "fixedDeltaTime", fixedDeltaTime * Time.timeScale)
end

Time.timeScale = 1.0
Time.deltaTime = 0.0
Time.realDeltaTime = 0.0
Time.fixedDeltaTime = 0.0
Time.globalTime = 0.0

Time = ReadOnlyClass(Time, "Time")
