local timers = {}
local nextTimerId = 1

function setTimeout(fn, timeout)
  timers[nextTimerId] = {
    timeout = timeout,
    timeLeft = timeout,
    fn = fn
  }
  
  nextTimerId = nextTimerId + 1
  return nextTimerId - 1
end

function clearTimeout(timeout)
  table.removeItem(timers, timeout)
end

function _updateTimers(deltaTime)
  local localTimers = timers

  for index, timer in pairs(localTimers) do
    timer.timeLeft = timer.timeLeft - deltaTime

    if timer.timeLeft < 0.0 then
      timer.fn()

      localTimers[index] = nil
    end
  end
end

CountdownTimer = Class()

function CountdownTimer:construct(countdown)
  self.expired = false
  setTimeout(function()
    self.expired = true
  end, countdown)
end
