function flags(...)
  local value = 0

  for i, v in ipairs{...} do
    value = Bitwise.bor(value, v)
  end

  return value
end

function spairs(t, order)
  -- collect the keys
  local keys = {}
  for k in pairs(t) do keys[#keys+1] = k end

  -- if order function given, sort by it by passing the table and keys a, b,
  -- otherwise just sort the keys 
  if order then
    table.sort(keys, function(a,b) return order(t, a, b) end)
  else
    table.sort(keys)
  end

  -- return the iterator function
  local i = 0
  return function()
    i = i + 1
    if keys[i] then
      return keys[i], t[keys[i]]
    end
  end
end

function lines(str)
  local t = {}
  local function helper(line) table.insert(t, line) return "" end
  helper((str:gsub("(.-)\r?\n", helper)))
  return t
end

function table.find(t, item)
  for index, it in pairs(t) do
    if type(item) == "function" then
      if item(it) then
        return it
      end
    else
      if it == item then
        return index
      end
    end
  end
  
  return nil
end

function table.removeItem(t, item)
  local index = table.find(t, item)
  if index then
    table.remove(t, index)
  end
end

function table.filter(t, fn)
  local nt = {}
  
  for key, value in pairs(t) do
    if fn(value) then
      rawset(nt, key, value)
    end
  end
  
  return nt
end

function table.map(t, fn)
  local nt = {}
  
  for key, value in pairs(t) do
    rawset(nt, key, fn(value))
  end
  
  return nt
end

function table.push(t, v)
  t[#t+1] = v
  return #t
end

function table.pop(t)
  if #t == 0 then
    return nil
  end
  
  local item = t[#t]
  t[#t] = nil
  return item
end

function table.keys(t)
  local keys = {}

  for key, value in pairs(t) do
    keys[#keys+1] = key
  end

  return keys
end

function table.pickOne(t)
  return t[math.floor(Random.value() * #t)+1]
end

function print_globals()
  for key, value in spairs(_G) do
    print(key .. " - " .. tostring(value))
  end
end
