local SaveGameManager = require "util/savegamemanager"
local SaveGameStats = require "util/savegamestats"

if _EDITOR then
  require "editor/editor"
end

require "data/items"

local Main = Behavior("Main")

function Main:initialize()
  Sound.stopAllSounds()
  Graphics.drawText("abcdefgihjklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,!?:-")

  Time.setTimeScale(1.0)

  Kernel = CreateObject("Kernel")
  Kernel:addComponent("InputController")
  Kernel:addComponent("MenuEvents")
  Kernel:addComponent("MusicController")
  Kernel:addComponent("SoundEmitter")
  Kernel:addComponent("ScreenFade")

  Kernel.screenFade:fadeIn(0.5)

  Kernel:on("destroy", function()
    SaveGameManager.save()
    Sound.stopAllSounds()
  end)

  local lut = AssetUtil.find("no_atlas/default_lut.png")
  Graphics.setColorLUT(lut, false)
  Graphics.setColorLUT(lut, true)
  Graphics.setFogOfWarImage(AssetUtil.find("default/fog_map_empty.png"))
  Graphics.useFogOfWar(true)

  setTimeout(function()
    WorldUtil.initScriptors()
    WorldUtil.initTriggers()
    WorldUtil.initLandmarks()
    WorldUtil.initRoutes()

    SaveGameManager.load()
    
    _callFunctionForAllBehaviors("awake")
  end, 0.15)

  self.playtimeCo = Co.create(function()
    while true do
      SaveGameStats.increase("playtimeMinutes", 1.0)
      Co.sleep(60.0)
    end
  end)
end

function Main:update(deltaTime)
  WorldUtil.spawnAndDespawnScriptors()

  if self.playtimeCo then
    if not self.playtimeCo:update() then
      self.playtimeCo = nil
    end
  end
end
