local ItemDefs = require "data/itemdefs"
require "data/items"

local ConsumableHelper = {}

function ConsumableHelper.useConsumable(object, itemId)
  if not object.statusEffects then
    return
  end

  local itemDef = ItemDefs[itemId]
  if not itemDef then
    return false
  end
  if not itemDef.handler then
    return false
  end

  if itemDef.handler == "Healing" then
    object.statusEffects:applyByName("Healing", itemDef)
  elseif itemDef.handler == "BoostStaminaRegen" then
    object.statusEffects:applyByName("BoostStaminaRegen", itemDef)
  elseif itemDef.handler == "SecondChance" then
    object.statusEffects:applyByName("SecondChance")
  elseif itemDef.handler == "Berserk" then
    object.statusEffects:applyByName("Berserk", itemDef)
  elseif itemDef.handler == "Invisibility" then
    object.statusEffects:applyByName("Invisibility", itemDef)
  else
    print("Unknown item handler \"" .. itemDef.handler .. "\"")
  end

  return true
end

return ConsumableHelper
