local InputContext = require "util/inputcontext"

local GameplayContext = Class(InputContext)

function GameplayContext:construct()
  InputContext.construct(self)

  self:registerAction("attack")
  self:registerAction("evade")
  self:registerAction("lockOn")
  self:registerAction("lockOnClosest")
  self:registerAction("interact")
  self:registerState("block")
  self:registerRange("movement")
  self:registerRange("moveLockOn")
  self:registerAction("openInventory")
  self:registerAction("pause")

  self:registerAction("quickUse1")
  self:registerAction("quickUse2")
  self:registerAction("quickUse3")
  self:registerAction("quickUse4")
  
  -- KEYBOARD DEFAULTS --
  self:addActionBinding("attack", "Keyboard", KEYS.KEY_SPACE)
  self:addActionBinding("evade", "Keyboard", KEYS.KEY_LEFT_CONTROL)
  self:addActionBinding("lockOn", "Keyboard", KEYS.KEY_F)
  self:addActionBinding("lockOnClosest", "Keyboard", KEYS.KEY_Q)
  self:addActionBinding("interact", "Keyboard", KEYS.KEY_E)
  self:addStateBinding("block", "Keyboard", KEYS.KEY_LEFT_SHIFT)
  self:addActionBinding("openInventory", "Keyboard", KEYS.KEY_TAB)
  self:addActionBinding("pause", "Keyboard", KEYS.KEY_ESCAPE)
  self:addActionBinding("quickUse1", "Keyboard", KEYS.KEY_1)
  self:addActionBinding("quickUse2", "Keyboard", KEYS.KEY_2)
  self:addActionBinding("quickUse3", "Keyboard", KEYS.KEY_3)
  self:addActionBinding("quickUse4", "Keyboard", KEYS.KEY_4)

  self:addDiscreteRangeBinding("movement", "Keyboard", KEYS.KEY_W, Vector(0.0, 1.0))
  self:addDiscreteRangeBinding("movement", "Keyboard", KEYS.KEY_S, Vector(0.0, -1.0))
  self:addDiscreteRangeBinding("movement", "Keyboard", KEYS.KEY_A, Vector(-1.0, 0.0))
  self:addDiscreteRangeBinding("movement", "Keyboard", KEYS.KEY_D, Vector(1.0, 0.0))

  -- CONTROLLER DEFAULTS --
  self:addActionBinding("attack", "Controller", "RB")
  self:addActionBinding("evade", "Controller", "B")
  self:addActionBinding("lockOn", "Controller", "RSB")
  self:addActionBinding("interact", "Controller", "A")
  self:addStateBinding("block", "Controller", "LB")
  self:addRangeBinding("movement", "Controller", "LS")
  self:addRangeBinding("moveLockOn", "Controller", "RS")
  self:addActionBinding("openInventory", "Controller", "Y")
  self:addActionBinding("pause", "Controller", "Start")
  self:addActionBinding("quickUse1", "Controller", "DUp")
  self:addActionBinding("quickUse2", "Controller", "DRight")
  self:addActionBinding("quickUse3", "Controller", "DDown")
  self:addActionBinding("quickUse4", "Controller", "DLeft")
end

return GameplayContext
