local Runes = require "util/runes"
local Loot = require "data/loot"

local LootSpawner = {}

function LootSpawner.spawnPouch(position, tableName)
  local pouch = CreateObject("ItemPouch", position):addComponent("ItemPouch", { lootTable = "" })

  LootSpawner.evaluateTableByName(pouch.inventory, tableName)

  if pouch.inventory:isEmpty() then
    pouch.object:destroy()
    return nil
  end

  return pouch
end

function LootSpawner.evaluateTableByName(inventory, tableName)
  local lootTable = Loot[tableName]
  if not lootTable then
    return
  end

  LootSpawner.evaluateTable(inventory, lootTable)
end

function LootSpawner.evaluateTable(inventory, lootTable)
  for i, loot in ipairs(lootTable) do
    local roll = Random.value()
    local chance = loot.chance

    if Runes.isEquipped("Cloverleaf") then
      chance = chance * Runes.getRune("Cloverleaf").dropChanceMultiplier
    end

    if roll < chance then
      local qty = loot.minQty + math.floor((loot.maxQty - loot.minQty) * Random.value())
      if loot.type == "gold" then
        inventory.coins = math.floor(inventory.coins + qty)
      elseif loot.type == "item" then
        if not inventory.items[loot.id] then
          inventory.items[loot.id] = math.floor(qty)
        else
          inventory.items[loot.id] = math.floor(inventory.items[loot.id] + qty)
        end
      end
    end
  end

  if inventory.coins % 5 > 0 then
    inventory.coins = inventory.coins + (5 - inventory.coins % 5)
  end
end

return LootSpawner
