local RuneTypes = {
  Cloverleaf = require "util/runes/cloverleaf"(),
  EldrichInsanity = require "util/runes/eldrichinsanity"(),
  EnergySurge = require "util/runes/energysurge"(),
  Focused = require "util/runes/focused"(),
  Lighting = require "util/runes/lighting"(),
  Vampirism = require "util/runes/vampirism"(),
  StarTwin = require "util/runes/startwin"(),
  Dragonshout = require "util/runes/dragonshout"(),
  Venom = require "util/runes/venom"(),
  Knighted = require "util/runes/knighted"(),
  Guzzler = require "util/runes/guzzler"(),
  SprintBurst = require "util/runes/sprintburst"(),
  Farsight = require "util/runes/farsight"(),
  Bloodthirst = require "util/runes/bloodthirst"(),
  Coldblooded = require "util/runes/coldblooded"(),
  BarrelCrasher = require "util/runes/barrelcrasher"(),
  SecondWind = require "util/runes/secondwind"(),
  Relentless = require "util/runes/relentless"(),
  ElsasTouch = require "util/runes/elsastouch"(),
  Tough = require "util/runes/tough"()
}

local Runes = {
  maxEquipped = 3,
  equipped = {},
  offered = {}
}

function Runes.equip(runeName, hero)
  if Runes.equippedCount() >= Runes.maxEquipped then
    return
  end

  local rune = RuneTypes[runeName]
  if not rune then
    print("Unknown rune name " .. runeName)
    return false
  end

  rune:activate(hero)
  Runes.equipped[runeName] = true
  return true
end

function Runes.unequip(runeName, hero)
  if not Runes.equipped[runeName] then
    return false
  end

  local rune = RuneTypes[runeName]
  rune:deactivate(hero)
  Runes.equipped[runeName] = nil
  return true
end

function Runes.isEquipped(runeName)
  return Runes.equipped[runeName] ~= nil
end

function Runes.getRune(runeName)
  return RuneTypes[runeName]
end

function Runes.equippedCount()
  local count = 0
  for i, runeName in pairs(Runes.equipped) do
    count = count + 1
  end

  return count
end

function Runes.getTypes()
  return RuneTypes
end

function Runes.getCollected(hero)
  local inventory = hero.inventory

  local collected = {}
  for runeName, rune in pairs(RuneTypes) do
    if inventory.items[runeName] then
      collected[#collected+1] = runeName
    end
  end

  return collected
end

function Runes.getUncollected(hero)
  local inventory = hero.inventory

  local uncollected = {}
  for runeName, rune in pairs(RuneTypes) do
    if not inventory.items[runeName] then
      uncollected[#uncollected+1] = runeName
    end
  end

  return uncollected
end

function Runes.update()
  for runeName, _ in pairs(Runes.equipped) do
    RuneTypes[runeName]:update()
  end
end

return Runes
