local Rune = require "util/runes/rune"

local SprintBurst = Class(Rune)

function SprintBurst:construct()
  Rune.construct(self, "SprintBurst")

  self.active = false
  self.timer = 0.0
  self.multiplier = 1.4
end

function SprintBurst:onGetHit()
  self.timer = 2.0
  self.active = true
end

function SprintBurst:update()
  if self.timer > 0.0 then
    self.timer = self.timer - Time.fixedDeltaTime
    if self.timer < 0.0 then
      self.active = false
      self.timer = 0.0
    end
  end
end

return SprintBurst
