local Rune = require "util/runes/rune"

local StarTwin = Class(Rune)

function StarTwin:construct()
  Rune.construct(self, "StarTwin")
  self.heroAvatar = nil
  self.heroRef = nil

  self.cooldown = 0.0
end

function StarTwin:activate(hero)
  self.heroRef = hero

  if self.heroAvatar then
    self.heroAvatar.object:destroy()
  end

  self:spawnAvatar()
end

function StarTwin:deactivate()
  if self.heroAvatar then
    self.heroAvatar.object:destroy()
    self.heroAvatar = nil
  end
end

function StarTwin:update()
  if self.cooldown > 0.0 then
    self.cooldown = math.max(0.0, self.cooldown - Time.fixedDeltaTime)
    
    if self.cooldown > 0.0 then
      return
    end
  end

  if not self.heroAvatar then
    self:spawnAvatar()
  end
end

function StarTwin:spawnAvatar()
  local pos = self.heroRef.transform.worldPosition
  pos = pos + Random.insideUnitCircle() * 128.0
  local size = Vector(72.0, 72.0)

  local collision = false
  Physics.aabbQuery(pos - size, pos + size, function(object)
    collision = true
    return false
  end, flags(World.layer("World"), World.layer("MovementCollider")))

  if collision then
    return
  end

  self.heroAvatar = CreateObject("HeroAvatar", pos):addComponent("HeroAvatar")
  self.heroAvatar:on("destroy", function ()
    self.heroAvatar = nil
    self.cooldown = 15.0
  end)
end

return StarTwin
