local dateFormat = "%d/%m/%Y %H:%M"

local SaveGame = Class()

function SaveGame:construct()
  self.data = {}
  self.date = os.date(dateFormat)
  self.version = 1
end

function SaveGame:saveToFile(filename)
  local json = JSON:encode_pretty({
    version = self.version,
    date = self.date,
    data = self.data
  })

  local dataEmpty = true
  for k, v in pairs(self.data) do
    dataEmpty = false
    break
  end

  if dataEmpty then
    print("ERROR! Trying to save empty save-game object!")
    return
  end
  
  local file = io.open(filename, "w")
  if not file then
    return false
  end

  file:write(json)
  io.close(file)
  return true
end

function SaveGame:loadFromFile(filename)
  local file = io.open(filename, "r")
  if not file then
    return false
  end

  local json = file:read("*all")
  if not json then
    return false
  end

  local saveGame = JSON:decode(json)
  self.version = saveGame.version
  self.data = saveGame.data
  self.date = saveGame.date
  return true
end

function SaveGame:setKey(key, value)
  self.data[key] = value
end

function SaveGame:getKey(key)
  return self.data[key]
end

return SaveGame
