local SaveGame = require "util/savegame"
local SAVE_PATH = PathUtil.join(PathUtil.getApplicationData(), "profile.json")

local current = SaveGame()

local SaveGameManager = EventEmitter()

function SaveGameManager.save()
  if not current then
    current = SaveGame()
  end
  
  SaveGameManager:emit("saveGame", current)
  current:saveToFile(SAVE_PATH)
end

function SaveGameManager.load()
  current = SaveGame()
  if not current:loadFromFile(SAVE_PATH) then
    print("Failed to load save game \"" .. SAVE_PATH .. "\"")
    return
  end
  
  SaveGameManager:emit("loadGame", current)
end

function SaveGameManager.getCurrent()
  return current
end

return SaveGameManager
