local SaveGameManager = require "util/savegamemanager"

local stats = {
  timesDied = 0,
  enemiesSlain = 0,
  maxArenaWaveReached = 1,
  goldCollected = 0,
  goldSpent = 0,
  playtimeMinutes = 0.0
}

SaveGameManager:on("saveGame", function(save)
  save:setKey("stats", stats)
end)

SaveGameManager:on("loadGame", function(save)
  local loadedStats = save:getKey("stats")
  if loadedStats then
    stats = loadedStats
  end
end)

local SaveGameStats = {}

function SaveGameStats.increase(statName, incAmount)
  if not stats[statName] then
    return
  end

  incAmount = incAmount or 1.0
  stats[statName] = stats[statName] + math.floor(incAmount)
end

function SaveGameStats.set(statName, amount)
  stats[statName] = math.floor(amount)
end

function SaveGameStats.get(statName)
  return stats[statName]
end

function SaveGameStats.getStats()
  return stats
end

return SaveGameStats
