local StatusEffect = require "util/statuseffects/statuseffect"

local Berserk = Class(StatusEffect)

function Berserk:construct(object, properties)
  StatusEffect.construct(self, "Berserk")

  self.duration = properties.duration
  local hero = object.hero

  self.co = Co.create(function()
    hero.berserk = true

    while self.duration > 0.0 do
      self.duration = self.duration - 1.0
      Co.sleep(1.0)
    end

    hero.berserk = false
  end)
end

function Berserk:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function Berserk:stackWith(other)
  self.duration = self.duration + other.duration
end

function Berserk:serialize()
  return {
    duration = self.duration
  }
end

return Berserk
