local StatusEffect = require "util/statuseffects/statuseffect"

local BoostStaminaRegen = Class(StatusEffect)

function BoostStaminaRegen:construct(object, properties)
  StatusEffect.construct(self, "BoostStaminaRegen")

  local hero = object.hero
  
  self.duration = properties.duration
  self.multiplier = properties.multiplier

  self.co = Co.create(function()
    while self.duration > 0.0 do
      hero.staminaCostMultiplier = self.multiplier
      self.duration = self.duration - Time.fixedDeltaTime
      Co.yield()
    end
  
    hero.staminaCostMultiplier = 1.0
    self.ended = true
  end)
end

function BoostStaminaRegen:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function BoostStaminaRegen:stackWith(other)
  self.multiplier = self.multiplier * other.multiplier
end

function BoostStaminaRegen:serialize()
  return {
    duration = self.duration,
    multiplier = self.multiplier
  }
end

return BoostStaminaRegen
