local StatusEffect = require "util/statuseffects/statuseffect"

local Healing = Class(StatusEffect)

function Healing:construct(object, properties)
  StatusEffect.construct(self, "Healing")

  local health = object.health
  self.amountPerTick = properties.amount / properties.duration
  self.duration = properties.duration

  self.co = Co.create(function()
    self.fx = CreateObject("HealingFX", Vector.zero(), object.transform):addComponent("HealingFX")

    while self.duration > 0.0 do
      health.hp = health.hp + self.amountPerTick * Time.fixedDeltaTime
      health.hp = math.clamp(health.hp, 0.0, health.totalHp)
      self.duration = self.duration - Time.fixedDeltaTime
      Co.sleep(0.0)
    end

    self.ended = true

    self.fx.object:removeComponent("HealingFX")

    while self.fx.particleEmitter:getAliveParticleCount() > 0 do
      Co.sleep(0.25)
    end

    self.fx.object:destroy()
  end)
end

function Healing:run()
  if not self.co or not self.co:update() then
    self.co = nil
    if self.fx then
      self.fx.object:destroy()
      self.fx = nil
    end

    return false
  end

  return true
end

function Healing:stackWith(other)
  local selfTotal = self.amountPerTick * self.duration
  local otherTotal = other.amountPerTick * other.duration
  local total = selfTotal + otherTotal

  local duration = math.max(self.duration, other.duration)
  if duration < 0.0 then
    self.duration = 0.0
    return
  end

  self.amountPerTick = total / duration
  self.duration = duration
end

function Healing:serialize()
  local amount = self.duration * self.amountPerTick

  return {
    duration = self.duration,
    amount = self.duration * self.amountPerTick
  }
end

function Healing:dispose()
  if not self.fx then
    return
  end
  
  self.co = Co.create(function()
    self.fx.object:removeComponent("HealingFX")

    while self.fx.particleEmitter:getAliveParticleCount() > 0 do
      Co.sleep(0.25)
    end

    self.fx.object:destroy()
  end)
end

return Healing
