local StatusEffect = require "util/statuseffects/statuseffect"

local Invisibility = Class(StatusEffect)

function Invisibility:construct(object, properties)
  StatusEffect.construct(self, "Invisibility")

  local hero = object.hero

  self.duration = properties.duration

  self.co = Co.create(function()
    hero.character.visibilityFactor = 0.3
    hero.skeletonRenderer.tintColor = Color(1.0, 1.0, 1.0, 0.6)

    while self.duration > 0.0 do
      self.duration = self.duration - 1.0
      Co.sleep(1.0)
    end

    hero.character.visibilityFactor = 1.0
    hero.skeletonRenderer.tintColor = Color(1.0, 1.0, 1.0, 1.0)
  end)
end

function Invisibility:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function Invisibility:stackWith(other)
  self.duration = self.duration + other.duration
end

function Invisibility:serialize()
  return {
    duration = self.duration
  }
end

return Invisibility
