local StatusEffect = require "util/statuseffects/statuseffect"

local Knockback = Class(StatusEffect)

function Knockback:construct(object, properties)
  StatusEffect.construct(self, "Knockback")

  self.impulse = properties.impulse
  self.damping = properties.damping or 8.0
  if self.damping <= 0.0 then
    self.damping = 0.01
  end

  self.doNotDisplay = true

  self.co = Co.create(function()
    local transform = object.transform

    while self.impulse:len() > 0.05 do
      self.impulse = self.impulse - self.impulse * Time.fixedDeltaTime * self.damping
      transform.localPosition = transform.worldPosition + (self.impulse / self.damping) * Time.fixedDeltaTime
      Co.yield()
    end
  end)
end

function Knockback:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function Knockback:stackWith(other)
  self.impulse = (self.impulse + other.impulse) * 0.5
  self.damping = (self.damping + other.damping) * 0.5
end

return Knockback
