local StatusEffect = require "util/statuseffects/statuseffect"

local Poison = Class(StatusEffect)

function Poison:construct(object, properties)
  StatusEffect.construct(self, "Poison")

  local health = object.health
  self.amountPerTick = properties.amount / properties.duration
  self.duration = properties.duration

  self.co = Co.create(function()
    self.fx = CreateObject("PoisonFX", Vector.zero(), object.transform):addComponent("PoisonFX")

    if object.skeletonRenderer then
      object.skeletonRenderer.tintColor = Color(0.2, 1.0, 0.2, 1.0)
    end

    while self.duration > 0.0 do
      health.hp = health.hp - self.amountPerTick * Time.fixedDeltaTime
      health.hp = math.clamp(health.hp, 1.0, health.totalHp)
      self.duration = self.duration - Time.fixedDeltaTime
      Co.sleep(0.0)
    end

    if object.skeletonRenderer then
      object.skeletonRenderer.tintColor = Color.white
    end

    self.fx.object:removeComponent("PoisonFX")
    while self.fx.particleEmitter:getAliveParticleCount() > 0 do
      Co.sleep(0.25)
    end

    self.fx.object:destroy()
  end)
end

function Poison:run()
  if not self.co or not self.co:update() then
    self.co = nil

    if self.fx then
      self.fx.object:destroy()
      self.fx = nil
    end

    return false
  end

  return true
end

function Poison:stackWith(other)
  local selfTotal = self.amountPerTick * self.duration
  local otherTotal = other.amountPerTick * other.duration
  local total = selfTotal + otherTotal

  local duration = math.max(self.duration, other.duration)
  self.amountPerTick = duration / total
  self.duration = duration
end

function Poison:serialize()
  return {
    duration = self.duration,
    amount = self.amountPerTick * self.duration
  }
end

function Poison:dispose()
  if not self.fx then
    return
  end
  
  self.co = Co.create(function()
    self.fx.object:removeComponent("HealingFX")

    while self.fx.particleEmitter:getAliveParticleCount() > 0 do
      Co.sleep(0.25)
    end

    self.fx.object:destroy()
  end)
end

return Poison
