local StatusEffect = require "util/statuseffects/statuseffect"

local SecondChance = Class(StatusEffect)

function SecondChance:construct(object, properties)
  StatusEffect.construct(self, "SecondChance")

  local health = object.health

  self.co = Co.create(function()
    while health.isAlive do
      Co.sleep(0.5)
    end

    while health.hp < health.totalHp do
      local t = 0.0
      if health.totalHp > 0.0 then
        t = health.hp / health.totalHp
      end
      
      object.skeletonRenderer.tintColor = Color(1.0, 1.0, 1.0, t)
      health.hp = health.hp + Time.fixedDeltaTime * 128.0
      Co.yield()
    end

    health.hp = health.totalHp
    health.isAlive = true

    object.skeletonRenderer.tintColor = Color.white
    object.actor:stopAllScripts()
    object.actor:playScript("idle")
    Co.sleep(0.1)
  end)
end

function SecondChance:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function SecondChance:serialize()
  return {}
end

return SecondChance
