local StatusEffect = require "util/statuseffects/statuseffect"

local Slow = Class(StatusEffect)

function Slow:construct(object, properties)
  StatusEffect.construct(self, "Slow")

  self.amount = properties.amount
  self.duration = properties.duration

  self.doNotDisplay = true

  self.co = Co.create(function()
    local transform = object.transform

    if object.skeletonRenderer then
      object.skeletonRenderer.tintColor = Color(0.2, 1.2, 1.4, 1.0)
    end

    local lastPos = transform.worldPosition

    while self.duration > 0.0 do
      self.duration = self.duration - Time.fixedDeltaTime

      local pos = transform.worldPosition
      local diff = pos - lastPos
      lastPos = pos

      transform.localPosition = transform.localPosition - diff * self.amount
      Co.yield()
    end

    self.ended = true

    if object.skeletonRenderer then
      local color = object.skeletonRenderer.tintColor

      local t = 0.0
      while t < 1.0 do
        t = t + Time.fixedDeltaTime
        object.skeletonRenderer.tintColor = Color.mix(color, Color.white, t)
        Co.yield()
      end

      object.skeletonRenderer.tintColor = Color.white
    end
  end)
end

function Slow:run()
  if not self.co or not self.co:update() then
    self.co = nil
    return false
  end

  return true
end

function Slow:stackWith(other)
  self.amount = (self.amount + other.amount) * 0.5
  self.duration = (self.duration + other.duration) * 0.5
end

return Slow
