local InputContext = require "util/inputcontext"

local UIContext = Class(InputContext)

function UIContext:construct()
  InputContext.construct(self)

  self:registerAction("menuLeft")
  self:registerAction("menuRight")
  self:registerAction("menuUp")
  self:registerAction("menuDown")
  self:registerAction("menuSelect")
  self:registerAction("menuBack")
  self:registerAction("menuOption")

  -- KEYBOARD DEFAULTS --
  self:addActionBinding("menuLeft", "Keyboard", KEYS.KEY_A)
  self:addActionBinding("menuRight", "Keyboard", KEYS.KEY_D)
  self:addActionBinding("menuUp", "Keyboard", KEYS.KEY_W)
  self:addActionBinding("menuDown", "Keyboard", KEYS.KEY_S)

  self:addActionBinding("menuLeft", "Keyboard", KEYS.KEY_LEFT)
  self:addActionBinding("menuRight", "Keyboard", KEYS.KEY_RIGHT)
  self:addActionBinding("menuUp", "Keyboard", KEYS.KEY_UP)
  self:addActionBinding("menuDown", "Keyboard", KEYS.KEY_DOWN)

  self:addActionBinding("menuBack", "Keyboard", KEYS.KEY_ESCAPE)
  self:addActionBinding("menuSelect", "Keyboard", KEYS.KEY_F)
  self:addActionBinding("menuSelect", "Keyboard", KEYS.KEY_ENTER)
  self:addActionBinding("menuOption", "Keyboard", KEYS.KEY_E)


  -- CONTROLLER DEFAULTS --
  self:addActionBinding("menuLeft", "Controller", "DLeft")
  self:addActionBinding("menuRight", "Controller", "DRight")
  self:addActionBinding("menuLeft", "Controller", "LB")
  self:addActionBinding("menuRight", "Controller", "RB")

  self:addActionBinding("menuUp", "Controller", "DUp")
  self:addActionBinding("menuDown", "Controller", "DDown")
  self:addActionBinding("menuBack", "Controller", "B")
  self:addActionBinding("menuSelect", "Controller", "A")
  self:addActionBinding("menuOption", "Controller", "X")
end

return UIContext
