#ifdef GL_ES
precision lowp float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

void main()
{
	float deltaX = 2.0 / 1366.0;
	float deltaY = 2.0 / 768.0;
	vec4 sum = texture2D( CC_Texture0, vec2( v_texCoord.x, v_texCoord.y ) );
	
	float radius = 5.0;
	for( float i=1.0; i <= radius; ++i)
	{
		float y_2 = - deltaY * i;
		float y2 =  + deltaY * i;
		float x_2 = - deltaX * i;
		float x2 =  + deltaX * i;

		sum += texture2D( CC_Texture0, vec2( v_texCoord.x + x_2, v_texCoord.y + y2 ) );
		sum += texture2D( CC_Texture0, vec2( v_texCoord.x + x2, v_texCoord.y + y2 ) );
		sum += texture2D( CC_Texture0, vec2( v_texCoord.x + x_2, v_texCoord.y + y_2 ) );
		sum += texture2D( CC_Texture0, vec2( v_texCoord.x + x2, v_texCoord.y + y_2 ) );
	}
	
	sum = sum / ((4.0 * radius)+1.0);
	sum.a = min( 1.0, sum.a );
	sum.r = min( 1.0, sum.r );
	sum.g = min( 1.0, sum.g );
	sum.b = min( 1.0, sum.b );
	sum.rgb /= 2.0;
	gl_FragColor = sum * v_fragmentColor;
}
