Scriptname SKWMIncomeScript extends ObjectReference  

;Message Properties

Message Property SKWMIncomeMenu Auto

;ObjectReference Properties

ObjectReference Property SKWMHireMineMainXMarker Auto
ObjectReference Property SKWMHireMineShaft1XMarker Auto
ObjectReference Property SKWMHireMIneShaft2XMarker Auto
ObjectReference Property SKWMHireFisheryXMarker Auto
ObjectReference Property SKWMHireGuardsXMarker Auto
ObjectReference Property SKWMWindstadProfitSafe Auto
ObjectReference Property SKWMLightsOnXMarker Auto
ObjectReference Property SKWMLightsOffXMarker Auto
ObjectReference Property SKWMIronOreContainer Auto
ObjectReference Property SKWMCorundumOreContainer Auto
ObjectReference Property SKWMOrichalcumOreContainer Auto
ObjectReference Property SKWMMoonstoneOreContainer Auto
ObjectReference Property SKWMMalachiteOreContainer Auto
ObjectReference Property SKWMEbonyOreContainer Auto
ObjectReference Property SKWMSilverOreContainer Auto
ObjectReference Property SKWMQuicksilverOreContainer Auto
ObjectReference Property SKWMGoldOreContainer Auto
ObjectReference Property SKWMArmorMainContainer Auto
ObjectReference Property SKWMWeaponsMainContainer Auto

;Item Properties

MiscObject Property Gold001 Auto
MiscObject Property OreIron Auto
MiscObject Property OreCorundum Auto
MiscObject Property OreSilver Auto
MiscObject Property OreOrichalcum Auto
MiscObject Property OreMoonstone Auto
MiscObject Property OreQuicksilver Auto
MiscObject Property OreEbony Auto
MiscObject Property OreMalachite Auto
MiscObject Property OreGold Auto

;Leveled Item Properties
LeveledItem Property SKWMLeveledMineMainArmor Auto
LeveledItem Property SKWMLeveledMineMainWeapons Auto
LeveledItem Property SKWMLeveledMineS1Armor Auto
LeveledItem Property SKWMLeveledMineS1Weapons Auto
LeveledItem Property SKWMLeveledMineS2Armor Auto
LeveledItem Property SKWMLeveledMineS2Weapons Auto

;Global Properties

GlobalVariable Property GameHour Auto

;Float Properties

Float Property EarningsAddTime = 9.0 auto
{The time at which earnings are added}
float Property EarningsNullTime = 19.0 auto
{The time at which nothing occurs}

Float Function GetCurrentHourOfDay() global
{Returns the current time of day in hours since midnight}
 
	float Time = Utility.GetCurrentGameTime()
	Time -= Math.Floor(Time) ; Remove "previous in-game days passed" bit
	Time *= 24 ; Convert from fraction of a day to number of hours
	Return Time
 
EndFunction

Function RegisterForSingleUpdateGameTimeAt(float GameTime)
{Registers for a single UpdateGameTime event at the next occurrence
of the specified GameTime (in hours since midnight)}
 
	Float CurrentTime = GetCurrentHourOfDay()
	If (GameTime < CurrentTime)
		GameTime += 24
	EndIf
 
	RegisterForSingleUpdateGameTime(GameTime - CurrentTime)
 
EndFunction

Event OnActivate(ObjectReference akActionRef)
	Menu()
EndEvent

Function Menu(int aiButton = 0)
	aiButton = SKWMIncomeMenu.show()
	If aiButton == 0
		If  SKWMHireMineMainXMarker.IsDisabled()
			Debug.MessageBox("You must hire employees before you can start earning money from your mining business.")
		ElseIf (GetCurrentHourOfDay() > EarningsAddTime)
				GoToState("EarningsAdd")
			Debug.Notification("Trade agreement arranged.")
		Else
			GoToState("EarningsNull")
			Debug.Notification("Income script activated.")
		EndIf
	ElseIf aiButton == 1
		If  SKWMHireMineMainXMarker.IsDisabled()
			Debug.MessageBox("You must hire employees before you can start ordering them to collect ore.")
		ElseIf (GetCurrentHourOfDay() > EarningsAddTime)
				GoToState("OreAdd")
			Debug.Notification("Income script activated.")
		Else
			GoToState("OreNull")
			Debug.Notification("Ore extraction operations ordered.")
		EndIf
	ElseIf aiButton == 2
		GoToState("Inactive")
			Debug.Notification("Income script halted.")

	ElseIf aiButton == 3

		EndIf
EndFunction

;States
State EarningsAdd

	Event OnBeginState()
		If  SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 3690)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf  SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 3550)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 3220)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 3100)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 1790)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 1650)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 1620)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 1500)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 690)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 550)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 620)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled()
			SKWMWindstadProfitSafe.AddItem(Gold001, 500)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		EndIf
	Debug.Notification("Windstad Mine earnings available.")
	RegisterForSingleUpdateGameTimeAt(EarningsNullTime)
	EndEvent
	Event OnUpdateGameTime()
		GoToState("EarningsNull")
	EndEvent
EndState
 
State EarningsNull
 
	Event OnBeginState()
		RegisterForSingleUpdateGameTimeAt(EarningsAddTime)
		SKWMLightsOnXMarker.Enable()
		SKWMLightsOffXMarker.Disable()
	EndEvent
	Event OnUpdateGameTime()
		GoToState("EarningsAdd")
	EndEvent
EndState

State OreAdd

	Event OnBeginState()
		If  SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMEbonyOreContainer.AddItem(OreEbony,10)
			SKWMMalachiteOreContainer.AddItem(OreMalachite,8)
			SKWMGoldOreContainer.AddItem(OreGold,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf  SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMEbonyOreContainer.AddItem(OreEbony,10)
			SKWMMalachiteOreContainer.AddItem(OreMalachite,8)
			SKWMGoldOreContainer.AddItem(OreGold,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMEbonyOreContainer.AddItem(OreEbony,10)
			SKWMMalachiteOreContainer.AddItem(OreMalachite,8)
			SKWMGoldOreContainer.AddItem(OreGold,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireMIneShaft2XMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMEbonyOreContainer.AddItem(OreEbony,10)
			SKWMMalachiteOreContainer.AddItem(OreMalachite,8)
			SKWMGoldOreContainer.AddItem(OreGold,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS2Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireMineShaft1XMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMOrichalcumOreContainer.AddItem(OreOrichalcum,10)
			SKWMMoonstoneOreContainer.AddItem(OreMoonstone,8)
			SKWMQuicksilverOreContainer.AddItem(OreQuicksilver,6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineS1Armor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineS1Weapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireGuardsXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled() && SKWMHireFisheryXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		ElseIf SKWMHireMineMainXMarker.IsEnabled()
			SKWMIronOreContainer.AddItem(OreIron, 10)
			SKWMCorundumOreContainer.AddItem(OreCorundum, 8)
			SKWMSilverOreContainer.AddItem(OreSilver, 6)
			SKWMArmorMainContainer.AddItem(SKWMLeveledMineMainArmor, 1)
			SKWMWeaponsMainContainer.AddItem(SKWMLeveledMineMainWeapons, 1)
			SKWMLightsOnXMarker.Disable()
			SKWMLightsOffXMarker.Enable()
		EndIf
	Debug.Notification("Windstad Mine ores available.")
	RegisterForSingleUpdateGameTimeAt(EarningsNullTime)
	EndEvent
	Event OnUpdateGameTime()
		GoToState("OreNull")
	EndEvent
EndState

State OreNull
 
	Event OnBeginState()
		RegisterForSingleUpdateGameTimeAt(EarningsAddTime)
		SKWMLightsOnXMarker.Enable()
		SKWMLightsOffXMarker.Disable()
	EndEvent
	Event OnUpdateGameTime()
		GoToState("OreAdd")
	EndEvent
EndState


State Inactive
	Event OnBeginState()
		; Do nothing
	EndEvent
EndState
LeveledItem Property NewProperty  Auto  
