﻿################################################################################
## Initialization
################################################################################

init offset = -1


################################################################################
## Styles
################################################################################

style default:
    font gui.default_font
    size gui.text_size
    color gui.text_color
    language gui.language

style input:
    color gui.accent_color

style hyperlink_text:
    color gui.accent_color
    hover_color gui.hover_color
    hover_underline True


style gui_text:
    font gui.interface_font
    color gui.interface_text_color
    size gui.interface_text_size


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.button_text_properties("button")
    yalign 0.5


style label_text is gui_text:
    color gui.accent_color
    size gui.label_text_size

style prompt_text is gui_text:
    color gui.text_color
    size gui.interface_text_size


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)
 
 



################################################################################
## In-game screens
################################################################################


## Say screen ##################################################################
##
## The say screen is used to display dialogue to the player. It takes two
## parameters, who and what, which are the name of the speaking character and
## the text to be displayed, respectively. (The who parameter can be None if no
## name is given.)
##
## This screen must create a text displayable with id "what", as Ren'Py uses
## this to manage text display. It can also create displayables with id "who"
## and id "window" to apply style properties.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):
    style_prefix "say"

    window:
        id "window"

        if who is not None:

            window:
                style "namebox"
                text who id "who"

        text what id "what"


    ## If there's a side image, display it above the text. Do not display on the
    ## phone variant - there's no room.
    if not renpy.variant("small"):
        add SideImage() xalign 0.12 yalign 1.0


style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    background Image("gui/textbox.png", xalign=0.5, yalign=1.0)

style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    color gui.accent_color
    font gui.name_font
    size gui.name_text_size
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    xpos gui.text_xpos
    xanchor gui.text_xalign
    xsize gui.text_width
    ypos gui.text_ypos

    text_align gui.text_xalign
    layout ("subtitle" if gui.text_xalign else "tex")


## Input screen ################################################################
##
## This screen is used to display renpy.input. The prompt parameter is used to
## pass a text prompt in.
##
## This screen must create an input displayable with id "input" to accept the
## various input parameters.
##
## http://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"

    window:

        vbox:
            xpos gui.text_xpos
            xanchor gui.text_xalign
            ypos gui.text_ypos

            text prompt style "input_prompt"
            input id "input"


style input_prompt is default

style input_prompt:
    xmaximum gui.text_width
    xalign gui.text_xalign
    text_align gui.text_xalign

style input:
    xmaximum gui.text_width
    xalign gui.text_xalign
    text_align gui.text_xalign

## Choice screen ###############################################################
##
## This screen is used to display the in-game choices presented by the menu
## statement. The one parameter, items, is a list of objects, each with caption
## and action fields.
##
## http://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action


## When this is true, menu captions will be spoken by the narrator. When false,
## menu captions will be displayed as empty buttons.
define config.narrator_menu = True


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    ypos 0.7
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")


## Quick Menu screen ###########################################################
##
## The quick menu is displayed in-game to provide easy access to the out-of-game
## menus.

screen quick_menu():

    ## Ensure this appears on top of other screens.
    zorder 100


    if quick_menu:

     imagemap:
        xpos 20
        ypos 3
        alpha True
        cache True
        ground "gui/menus/quickmenu/qm_ground.png"
        hover "gui/menus/quickmenu/qm_hover.png"
        selected_idle "gui/menus/quickmenu/qm_hover.png"
        selected_hover "gui/menus/quickmenu/qm_hover.png"   


        hotspot (854,07,96,39) action Rollback()
        hotspot (954,07,89,39) action Skip() alternate Skip(fast=True, confirm=True)
        hotspot (1043,07,97,39) action ShowMenu('save')
        hotspot (1146,07,113,39) action ShowMenu('preferences')

## This code ensures that the quick_menu screen is displayed in-game, whenever
## the player has not explicitly hidden the interface.
init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.button_text_properties("quick_button")




################################################################################
## Main and Game Menu Screens
################################################################################

## Navigation screen ###########################################################
##
## This screen is included in the main and game menus, and provides navigation
## to other menus, and to start the game.

screen navigation():

    vbox:
        style_prefix "navigation"

        xpos gui.navigation_xpos
        yalign 0.8

        spacing gui.navigation_spacing

        if main_menu:

            textbutton _("start") action Start()

        else:

            textbutton _("history") action ShowMenu("history")

            textbutton _("save") action ShowMenu("save")

        textbutton _("load") action ShowMenu("load")

        textbutton _("preferences") action ShowMenu("preferences")

        if _in_replay:

            textbutton _("end Replay") action EndReplay(confirm=True)

        elif not main_menu:

            textbutton _("main Menu") action MainMenu()

        textbutton _("about") action ShowMenu("about")

        if renpy.variant("pc"):

            ## Help isn't necessary or relevant to mobile devices.
            textbutton _("help") action ShowMenu("help")

            ## The quit button is banned on iOS and unnecessary on Android.
            textbutton _("quit") action Quit(confirm=not main_menu)


style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")


##############################################################################
# Main Menu
screen main_menu:

    tag menu
    add "gui/main_menu.png"
    
    imagemap:
        
        ground "gui/menus/mainmenu/mm_ground.png"
        idle "gui/menus/mainmenu/mm_ground.png"
        hover "gui/menus/mainmenu/mm_hover.png"
        alpha False
        cache False
        
        
        hotspot (37,611,219,70) action Start()
        hotspot (294,611,163,70) action ShowMenu('load')
        hotspot (508, 611, 210, 70) action ShowMenu("preferences")
        hotspot (766, 611, 243, 70) action ShowMenu("credits")
        hotspot (1070,611,148,70) action Quit(confirm=False)
        



##############################################################################
# Navigation

screen navigation:

    # The background of the game menu.
    window:
        style "gm_root"

    # The various buttons.
    frame:
        style_group "gm_nav"
        xalign .98
        yalign .98

        has vbox

        textbutton _("Return") action Return()
        textbutton _("Preferences") action ShowMenu("preferences")
        textbutton _("Save Game") action ShowMenu("save")
        textbutton _("Load Game") action ShowMenu("load")
        textbutton _("Main Menu") action MainMenu()
        textbutton _("Help") action Help()
        textbutton _("Quit") action Quit()

init -2:

    # Make all game menu navigation buttons the same size.
    style gm_nav_button:
        size_group "gm_nav"


##############################################################################
# Save, Load
#
screen file_picker:
    
    imagemap:
            ground "gui/menus/saveload/sl_ground.png"
            hover "gui/menus/saveload/sl_hover.png"
            
            
            idle "gui/menus/saveload/sl_ground.png"
            selected_idle "gui/menus/saveload/sl_hover.png"
            selected_hover "gui/menus/saveload/sl_hover.png"   
            
            
            add "gui/menus/saveload/sl_ground.png"

            
            cache False
            alpha False
    
            hotspot (100,460,100,130) action FilePagePrevious() 
            hotspot (850,460,100,130) action FilePageNext(max=5)
            
            
            #hotspot (100, 460, 100, 130) at buttonfade clicked FilePage("auto") 
            hotspot (205, 460, 100, 130) clicked FilePage("1")
            hotspot (305, 460, 100, 130) clicked FilePage("2")
            hotspot (450, 460, 100, 130) clicked FilePage("3")
            hotspot (590, 460, 100, 130) clicked FilePage("4")
            hotspot (730, 460, 100, 130) clicked FilePage("5")
            
            hotspot(920,260,290,72) action MainMenu()
            hotspot(941,330,290,72) action Quit(confirm=True)
            
            hotspot(50,590,400,200) action Return()
            
            
            hotspot (135,176,264,246) clicked FileAction(1):
                use load_save_slot(number=1)
                key "save_delete" action FileDelete(1)
            hotspot (399,176,259,246)   clicked FileAction(2):
                use load_save_slot(number=2)
                key "save_delete" action FileDelete(2)
            hotspot (659,176,264,246)   clicked FileAction(3):
                use load_save_slot(number=3)
                key "save_delete" action FileDelete(3)
            
           
            
            
    

screen save:

    # This ensures that any other menu screen is replaced.
    tag menu

   
    use file_picker

    add "gui/menus/saveload/add_save_label.png"
    
    
    
screen load:

    # This ensures that any other menu screen is replaced.
    tag menu
    
   
    use file_picker

    add "gui/menus/saveload/add_load_label.png"
    
        
  ##############################################
#LOAD SAVE SLOTS


         
screen load_save_slot:
    $ file_text = "%2s. %s\n  %s" % (
                        FileSlotName(number, 3),
                        FileTime(number, empty=_("Empty Slot")),
                        FileSaveName(number))

    add FileScreenshot(number) xpos 4 ypos 38
    text file_text xpos 15 ypos 190 size 23 drop_shadow [(1, 2)] 
    
    
    
    
    
   
init -2 python:
               
    config.thumbnail_width = 100
    config.thumbnail_height = 80
               
##############################################################################
# Preferences


screen preferences:


    tag menu
    
    add "gui/background.png"

  
    
    imagemap:
            
            ground "gui/menus/prefs/pm_ground.png"
            hover "gui/menus/prefs/pm_hover.png"
            selected_idle "gui/menus/prefs/pm_hover.png"
            alpha False
            cache False
            
            hotspot(145,206,250,85) action Preference("display", "window")
            hotspot(395,206,255,87) action Preference("display", "fullscreen")
            
            hotspot(145,345,250,75) action Preference("skip", "seen")
            hotspot(395,345,250,75) action Preference("skip", "all")
            
            hotspot(145,425,250,75) action Preference("after choices", "skip")
            hotspot(395,425,250,75) action Preference("after choices", "stop")
            
            hotspot(800,500,290,65) action MainMenu()
            hotspot(800,565,160,65) action ShowMenu("save")
            hotspot(1000,565,160,65) action ShowMenu("load")
            
            hotspot(50,580,400,200) action Return()
            
            bar pos (900, 155) value Preference("music volume") style "pref_slider"
            bar pos (900, 230) value Preference("sound volume") style "pref_slider"
            bar pos (900, 300) value Preference("text speed") style "pref_slider"
            bar pos (900, 375) value Preference("auto-forward time") style "pref_slider"


init -2 python:
    style.pref_frame.xfill = True
    style.pref_frame.xmargin = 5
    style.pref_frame.top_margin = 5

    style.pref_vbox.xfill = True

    style.pref_button.size_group = "pref"
    style.pref_button.xalign = 1.0

    style.pref_slider.left_bar = "gui/menus/prefs/bar_full.png"
    style.pref_slider.right_bar = "gui/menus/prefs/bar_empty.png"
    style.pref_slider.hover_left_bar = "gui/menus/prefs/bar_full.png"
    style.pref_slider.ymaximum = 50
    style.pref_slider.xmaximum = 250
    style.pref_slider.thumb = "gui/menus/prefs/thumb.png"


##############################################################################
# Yes/No Prompt


screen yesno_prompt:
    #on "show" action With(dissolve)
    
    #modal True
    
    add "gui/background.png"

    imagemap:
        ground 'gui/menus/yesno/yesno_ground.png'
        idle 'gui/menus/yesno/yesno_idle.png' 
        hover 'gui/menus/yesno/yesno_hover.png'
        
       
        hotspot (400,350,235,150) action yes_action
        hotspot (640,350,235,150) action no_action

  

    if message == layout.ARE_YOU_SURE:
        add "gui/menus/yesno/yesno_are_you_sure.png"
        
    elif message == layout.DELETE_SAVE:
        add "gui/menus/yesno/yesno_delete_save.png"
        
    elif message == layout.OVERWRITE_SAVE:
        add "gui/menus/yesno/yesno_overwrite_save.png"
        
    elif message == layout.LOADING:
        add "gui/menus/yesno/yesno_load_save.png"
        
    elif message == layout.QUIT:
        add "gui/menus/yesno/yesno_quit.png"
        
    elif message == layout.MAIN_MENU:
        add "gui/menus/yesno/yesno_main_menu.png" 


## Skip indicator screen #######################################################
##
## The skip_indicator screen is displayed to indicate that skipping is in
## progress.
##
## https://www.renpy.org/doc/html/screen_special.html#skip-indicator

screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        hbox:
            spacing 6

            text _("skipping")

            text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
            


## This transform is used to blink the arrows one after another.
transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:
    # We have to use a font that has the BLACK RIGHT-POINTING SMALL TRIANGLE
    # glyph in it.
    font "DejaVuSans.ttf"


## Notify screen ###############################################################
##
## The notify screen is used to show the player a message. (For example, when
## the game is quicksaved or a screenshot has been taken.)
##
## https://www.renpy.org/doc/html/screen_special.html#notify-screen

screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text message

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    size gui.notify_text_size


## NVL screen ##################################################################
##
## This screen is used for NVL-mode dialogue and menus.
##
## http://www.renpy.org/doc/html/screen_special.html#nvl


screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing

        ## Displays dialogue in either a vpgrid or the vbox.
        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)

        ## Displays the menu, if given. The menu may be displayed incorrectly if
        ## config.narrator_menu is set to True, as it is above.
        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            fixed:
                yfit gui.nvl_height is None

                if d.who is not None:

                    text d.who:
                        id d.who_id

                text d.what:
                    id d.what_id


## This controls the maximum number of NVL-mode entries that can be displayed at
## once.
define config.nvl_list_length = 6

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")



################################################################################
## Mobile Variants
################################################################################

style pref_vbox:
    variant "medium"
    xsize 450

## Since a mouse may not be present, we replace the quick menu with a version
## that uses fewer and bigger buttons that are easier to touch.
screen quick_menu():
    variant "touch"

    zorder 100

    hbox:
        style_prefix "quick"

        xalign 0.5
        yalign 1.0

        textbutton _("back") action Rollback()
        textbutton _("skip") action Skip() alternate Skip(fast=True, confirm=True)
        textbutton _("auto") action Preference("auto-forward", "toggle")
        textbutton _("menu") action ShowMenu()


style window:
    variant "small"
    background "gui/phone/textbox.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 340

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 400

style slider_pref_vbox:
    variant "small"
    xsize None

style slider_pref_slider:
    variant "small"
    xsize 600
######
screen credits():
    tag menu
    frame:
        background "gui/credits.png"
        align (0.0, 0.2)

        viewport:
            scrollbars "vertical"
            mousewheel True
            has vbox
            $ rows = 50

            text "Writer/Code"
            text "{a=http://roseradetea.tumblr.com}RoseradeTea{/a}"
            text "Proofreaders"
            text "{a=https://tohjofalls.tumblr.com}Tohjofalls{/a}"
            text "{a=https://www.reddit.com/user/samuelroy21}SamuelRoy{/a}"
            text "Editor"
            text "{a=http://roxazlum.tumblr.com}Secundox{/a}"
            text "Character Artists"
            text "{a=https://twitter.com/andernohattsu}{font=arial.ttf}ハッツマン{/font}{/a}- Undyne/Metatton"
            text "{a=https://www.pixiv.net/member.php?id=20679780}{font=arial.ttf}力士{/font}{/a}- Sona"
            text "{a=http://dongoverlord.tumblr.com}Dongoverlord{/a}-Alphys/Frisk"
            text "{a=http://primomon.tumblr.com}Primomon{/a}- Sans/Papyrus"
            text "{a=http://datchidatchi.tumblr.com}Datchi{/a}- Amir, Charlotte, Bruno, MonsterKid, Muffet"
            text "{a=http://atlantart.tumblr.com}Atlantart{/a}- ASGORE/Toriel"
            text "{a=http://starstandby.tumblr.com}Starstandby{/a}- Mayor"
            text "{a=https://unu-nunu-art.tumblr.com}Unu-nunu{/a}- Flowey"
            text "{a=https://www.pixiv.net/member.php?id=4082488}{font=arial.ttf}ししょー{/font}{/a}- Sergeant"
            text "{a=https://kayiiin.tumblr.com}Kayiiin{/a}- Nanny"
            text "Background Artists"
            text "{a=https://www.imgsta.com/user/thecloudheaded}thecloudheaded{/a}"
            text "{a=http://trickstercarlos.tumblr.com}Trickstercarlos{/a}"
            text "{a=http://n0nlee.tumblr.com}n0nlee{/a}"
            text "{a=http://miyako47.tumblr.com}Miyako47{/a}"
            text "Illustration Artists"
            text "{a=http://rahafwabas.tumblr.com}Rahafwabas{/a}"
            text "{a=https://twitter.com/Z_L_A2}Kifu{/a}"
            text "Music"
            text "{a=https://www.youtube.com/watch?v=6g9GT1M4ZGw}SevenUp/DiveBomb{/a}"
            text "{a=https://www.youtube.com/watch?v=Z6hRV-Nq1Q0}TedescoCreations{/a}"
            text "{a=https://www.youtube.com/watch?v=d8B967FGO-U}8BitBrigadier{/a}"
            text "{a=https://www.youtube.com/watch?v=IA-tREKExMI}Nahu Pyrope{/a}"
            text "{a=https://www.youtube.com/watch?v=pvzT_uWnKmc}The Team Players{/a}"
            text "{a=https://www.youtube.com/watch?v=2Egf_CyycfI}Lenich & Kirya{/a}"
            text "{a=https://www.youtube.com/watch?v=d0pHUcX_AM8}Lauren The Flute{/a}"
            text "{a=https://www.youtube.com/watch?v=BKDm-sBmB6E}String Player Gamer{/a}"
            text "{a=https://www.youtube.com/watch?v=h6VE-fdLtLQ}Osirois Music{/a}"
            text "{a=https://www.youtube.com/watch?v=TuIX9rIoOZ8}Giulio Taccon{/a}"
            text "{a=https://www.youtube.com/watch?v=tt4T0-FW3r0}NyxTheShield{/a}"
            text "{a=https://www.youtube.com/watch?v=ZcCj6ei4oYI}Bani-Chan{/a}"
            text "Testers"
            text "{a=http://lesbianrosso.tumblr.com}LesbianRosso{/a}"
            text "{a=http://ayahne.tumblr.com}Ayahne{/a}"

            
            textbutton _("Return") action Return()
