#version 330 core

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;
uniform sampler2D Texture3;

layout(std140) uniform PerFrame
{
    float Time;
};

layout(std140) uniform PerCamera
{
    mat4 Projection;
    mat4 View;
};

layout(std140) uniform PerMesh
{
    mat4 Model;
    vec4 MeshTint;
};

in vec3 fragPosition;
in vec3 fragNormal;
in vec2 fragTexCoord0;
in vec2 fragTexCoord1;
in vec4 fragColor;

out vec4 Output;

void main()
{
    vec2 distanceAndMask = texture(Texture0, fragTexCoord0).rg;
    float distance = distanceAndMask.r;
    float mask = distanceAndMask.g;
    vec2 checkerTiling = fragTexCoord1;
    vec4 glow = texture(Texture1, checkerTiling * fragTexCoord0);
    vec4 edge = texture(Texture2, vec2(1 - distance, 0));

    float insideBoard = mask > 0 ? 1 : 0;
    vec4 tex = vec4(0);
    tex.rgb += glow.rgb * 0.06 * insideBoard;
    tex.rgb += edge.rgb * insideBoard;

    // Anti-alias the edges:
    tex.rgb *= mask;

    Output = tex;
}
