#version 330 core

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;
uniform sampler2D Texture3;

layout(std140) uniform PerFrame
{
    float Time;
};

layout(std140) uniform PerCamera
{
    mat4 Projection;
    mat4 View;
};

layout(std140) uniform PerMesh
{
    mat4 Model;
    vec4 MeshTint;
};

in vec3 fragPosition;
in vec3 fragNormal;
in vec2 fragTexCoord0;
in vec2 fragTexCoord1;
in vec4 fragColor;

out vec4 Output;

void main()
{
    vec2 texCoord0 = fragTexCoord0;
    texCoord0.y = 1 - fragTexCoord0.y;

    // TexCoord1 is used here for parameters.
    // X is zero to blur horizontally, nonzero otherwise.
    // Y is the INVERSE of the width or height of the source texture in pixels (depending on the blur direction).
    float vertically = fragTexCoord1.x;
    float resolutionInverse = fragTexCoord1.y;

    float originalMask = texture(Texture0, texCoord0).g;

    const float MaxDistance = 70;
    vec2 offset = (vertically != 0) ? vec2(0, resolutionInverse) : vec2(resolutionInverse, 0);
    float distancePerPixel = 1.0 / MaxDistance;
    float closest = 1.0;

    for (float i = -MaxDistance; i <= MaxDistance; i++)
    {
        float otherDistance = texture(Texture0, texCoord0 + i * offset).r;
        float distance = otherDistance + abs(i) * distancePerPixel;
        closest = min(closest, distance);
    }

    Output = vec4(closest, originalMask, 0, 1);
}
