#version 330 core

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;
uniform sampler2D Texture3;

layout(std140) uniform PerFrame
{
    float Time;
};

layout(std140) uniform PerCamera
{
    mat4 Projection;
    mat4 View;
};

layout(std140) uniform PerMesh
{
    mat4 Model;
    vec4 MeshTint;
};

in vec3 fragPosition;
in vec3 fragNormal;
in vec2 fragTexCoord0;
in vec2 fragTexCoord1;
in vec4 fragColor;

out vec4 Output;

void main()
{
    // When true, the entire pulse is lit up uniformly and without animation.
    float drawSolidPulse = MeshTint.r;
    float opacity = MeshTint.a;

    float u = (drawSolidPulse != 0) ? 0.3 : fragTexCoord0.x / 2.5 - Time;

    vec4 tex = texture(Texture0, vec2(u, 0));
    
    // Show the final effect:
    Output = opacity * tex;
}
