#version 330 core

layout(std140) uniform PerFrame
{
    float Time;
};

layout(std140) uniform PerCamera
{
    mat4 Projection;
    mat4 View;
};

layout(std140) uniform PerMesh
{
    mat4 Model;
    vec4 MeshTint;
};

in vec3 Position;
in vec3 Normal;
in vec2 TexCoord0;
in vec2 TexCoord1;
in vec4 Color;

out vec3 fragPosition;
out vec3 fragNormal;
out vec2 fragTexCoord0;
out vec2 fragTexCoord1;
out vec4 fragColor;

void main()
{
    vec4 worldPos = Model * vec4(Position, 1);
    fragPosition = worldPos.xyz;
    fragNormal = Normal;
    fragTexCoord0 = TexCoord0;
    fragTexCoord1 = TexCoord1;
    fragColor = Color;
    gl_Position = Projection * View * worldPos;
}
