#version 330 core

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;
uniform sampler2D Texture3;

layout(std140) uniform PerFrame
{
    float Time;
};

layout(std140) uniform PerCamera
{
    mat4 Projection;
    mat4 View;
};

layout(std140) uniform PerMesh
{
    mat4 Model;
    vec4 MeshTint;
};

in vec3 fragPosition;
in vec3 fragNormal;
in vec2 fragTexCoord0;
in vec2 fragTexCoord1;
in vec4 fragColor;

out vec4 Output;

void main()
{
    // When true, the entire path is lit up uniformly:
    float drawSolidPulse = MeshTint.r;

    // Distance along the path (measured in number of grid spaces):
    float t = MeshTint.g;

    float opacity = MeshTint.a;

    float u = clamp(drawSolidPulse != 0 ? 1.0 : fragTexCoord0.x - t, 0, 1);
    vec4 tex = texture(Texture0, vec2(u, 0));

    Output = opacity * tex;
}
