/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static dug spriteGrass = null;
    private static dug spriteGrassSide = null;
    private static dug spriteGrassPath = null;
    private static dug spriteGrassPathSide = null;
    private static dug spriteMycelium = null;
    private static dug spritePodzol = null;
    private static dug spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static dvu modelCubeGrass = null;
    private static dvu modelGrassPath = null;
    private static dvu modelCubeGrassPath = null;
    private static dvu modelCubeMycelium = null;
    private static dvu modelCubePodzol = null;
    private static dvu modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(duf textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            dvu modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(duf textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new qs(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new qs(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new qs(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new qs(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new qs(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new qs(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new qs(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            qs locFile = new qs(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static dug registerSprite(Properties props, String key, String textureDefault, duf textureMap) {
        qs locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new qs("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        qs locSprite = new qs(texture);
        dug sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        if (facing == fa.b || facing == fa.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bml block = blockState.d();
        if (block instanceof bpy) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bov) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmm.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmm.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bou) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bml blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmm.cC || blockUp == bmm.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmm.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmm.dL) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmm.iw) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bml blockTop = BetterGrass.getBlockAt(blockPos, fa.b, blockAccess);
        boolean bl = snowy = blockTop == bmm.cC || blockTop == bmm.cA;
        if (Config.isBetterGrassFancy()) {
            ev posSide;
            bvj stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmm.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.e_(posSide = blockPos.c().a(facing))).d() == bmm.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        bml blockTop = BetterGrass.getBlockAt(blockPos, fa.b, blockAccess);
        if (blockTop == bmm.iw && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmm.iw) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(bgp blockAccess, bvj blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bml blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmm.cC || blockUp == bmm.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmm.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmm.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bml getBlockAt(ev blockPos, fa facing, bgp blockAccess) {
        ev pos = blockPos.a(facing);
        bml block = blockAccess.e_(pos).d();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

