/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.DynamicLights;

public class DynamicLight {
    private aif entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<ev> setLitChunkPos = new HashSet<ev>();
    private ev.a blockPosMutable = new ev.a();

    public DynamicLight(aif entity) {
        this.entity = entity;
        this.offsetY = entity.bM();
    }

    public void update(dkm renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.p - 0.5;
        double posY = this.entity.q - 0.5 + this.offsetY;
        double posZ = this.entity.r - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<ev> setNewPos = new HashSet<ev>();
        if (lightLevel > 0) {
            fa dirX = (zs.c((double)posX) & 0xF) >= 8 ? fa.f : fa.e;
            fa dirY = (zs.c((double)posY) & 0xF) >= 8 ? fa.b : fa.a;
            fa dirZ = (zs.c((double)posZ) & 0xF) >= 8 ? fa.d : fa.c;
            ev chunkPos = new ev(posX, posY, posZ);
            dne chunk = renderGlobal.getRenderChunk(chunkPos);
            ev chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            dne chunkX = renderGlobal.getRenderChunk(chunkPosX);
            ev chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            dne chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            ev chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            dne chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            ev chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            dne chunkY = renderGlobal.getRenderChunk(chunkPosY);
            ev chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            dne chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            ev chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            dne chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            ev chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            dne chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private ev getChunkPos(dne renderChunk, ev pos, fa facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(dne renderChunk, Set<ev> setPrevPos, Set<ev> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        dnc compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        ev pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(dkm renderGlobal) {
        for (ev posOld : this.setLitChunkPos) {
            dne chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public aif getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

