/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.List;
import net.optifine.reflect.Reflector;

public class SpriteDependencies {
    private static int countDependenciesTotal;

    public static dug resolveDependencies(List<dug> listRegisteredSprites, int ix, duf textureMap) {
        dug sprite = listRegisteredSprites.get(ix);
        while (SpriteDependencies.resolveOne(listRegisteredSprites, ix, sprite, textureMap)) {
            sprite = listRegisteredSprites.get(ix);
        }
        sprite.isDependencyParent = false;
        return sprite;
    }

    private static boolean resolveOne(List<dug> listRegisteredSprites, int ix, dug sprite, duf textureMap) {
        int countDep = 0;
        for (qs locDep : sprite.getDependencies()) {
            Config.detail("Sprite dependency: " + sprite.m() + " <- " + locDep);
            ++countDependenciesTotal;
            dug spriteDep = textureMap.getRegisteredSprite(locDep);
            if (spriteDep == null) {
                spriteDep = textureMap.registerSprite(locDep);
            } else {
                int ixDep = listRegisteredSprites.indexOf(spriteDep);
                if (ixDep <= ix + countDep) continue;
                if (spriteDep.isDependencyParent) {
                    String error = "circular dependency: " + sprite.m() + " -> " + spriteDep.m();
                    qs locSpritePng = textureMap.b(sprite.m());
                    Reflector.call(Reflector.ClientHooks_trackBrokenTexture, locSpritePng, error);
                    break;
                }
                listRegisteredSprites.remove(ixDep);
            }
            sprite.isDependencyParent = true;
            listRegisteredSprites.add(ix + countDep, spriteDep);
            ++countDep;
        }
        return countDep > 0;
    }

    public static void reset() {
        countDependenciesTotal = 0;
    }

    public static int getCountDependencies() {
        return countDependenciesTotal;
    }
}

