/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static dvu makeModelCube(String spriteName, int tintIndex) {
        dug sprite = Config.getMinecraft().M().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static dvu makeModelCube(dug sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        fa[] facings = fa.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fa facing = facings[i];
            ArrayList<dlf> quads = new ArrayList<dlf>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        dlq itemOverrideList = dlq.a;
        dwc bakedModel = new dwc(generalQuads, faceQuads, true, true, sprite, dls.a, itemOverrideList);
        return bakedModel;
    }

    public static dvu joinModelsCube(dvu modelBase, dvu modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        fa[] facings = fa.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fa facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        dug sprite = modelBase.d();
        dls transforms = modelBase.e();
        dlq itemOverrideList = modelBase.f();
        dwc bakedModel = new dwc(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static dlf makeBakedQuad(fa facing, dug sprite, int tintIndex) {
        b posFrom = new b(0.0f, 0.0f, 0.0f);
        b posTo = new b(16.0f, 16.0f, 16.0f);
        dlj uv = new dlj(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        dlh face = new dlh(facing, tintIndex, "#" + facing.m(), uv);
        dvv modelRotation = dvv.a;
        dli partRotation = null;
        boolean shade = true;
        dln faceBakery = new dln();
        dlf quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (dwa)modelRotation, partRotation, shade);
        return quad;
    }

    public static dvu makeModel(String modelName, String spriteOldName, String spriteNewName) {
        duf textureMap = Config.getMinecraft().M();
        dug spriteOld = textureMap.getSpriteSafe(spriteOldName);
        dug spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static dvu makeModel(String modelName, dug spriteOld, dug spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        dvy modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        dvz mrl = new dvz(modelName, "");
        dvu model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        dvu modelNew = ModelUtils.duplicateModel(model);
        fa[] faces = fa.n;
        for (int i = 0; i < faces.length; ++i) {
            fa face = faces[i];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<dlf> quads, dug spriteOld, dug spriteNew) {
        ArrayList<dlf> quadsNew = new ArrayList<dlf>();
        for (dlf quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new dlm(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(b pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static crq getOffsetBoundingBox(crq aabb, bml.b offsetType, ev pos) {
        int x = pos.o();
        int z = pos.q();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == bml.b.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

