/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.DynamicLights;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements bgp {
    private final dng chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXY;
    private int[] combinedLights;
    private bvj[] blockStates;
    private final int arraySize;
    private final boolean dynamicLights = Config.isDynamicLights();
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(bvj.class, 16);

    public ChunkCacheOF(dng chunkCache, ev posFromIn, ev posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.o() - subIn >> 4;
        int minChunkY = posFromIn.p() - subIn >> 4;
        int minChunkZ = posFromIn.q() - subIn >> 4;
        int maxChunkX = posToIn.o() + subIn >> 4;
        int maxChunkY = posToIn.p() + subIn >> 4;
        int maxChunkZ = posToIn.q() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXY = this.sizeX * this.sizeY;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    private int getPositionIndex(ev pos) {
        int dx = pos.o() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.p() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.q() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dz * this.sizeXY + dy * this.sizeX + dx;
    }

    public int b(ev pos, int lightValue) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.combinedLights == null) {
            return this.getCombinedLightRaw(pos, lightValue);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = this.getCombinedLightRaw(pos, lightValue);
        }
        return light;
    }

    private int getCombinedLightRaw(ev pos, int lightValue) {
        int light = this.chunkCache.b(pos, lightValue);
        if (this.dynamicLights && !this.e_(pos).g((bgr)this, pos)) {
            light = DynamicLights.getCombinedLight(pos, light);
        }
        return light;
    }

    public bvj e_(ev pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.e_(pos);
        }
        bvj iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.e_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        if (this.blockStates == null) {
            this.blockStates = (bvj[])cacheBlockStates.allocate(this.arraySize);
        }
        Arrays.fill(this.blockStates, null);
    }

    public void renderFinish() {
        cacheCombinedLights.free(this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free(this.blockStates);
        this.blockStates = null;
    }

    public bie c(ev pos) {
        return this.chunkCache.c(pos);
    }

    public btm d(ev pos) {
        return this.chunkCache.a(pos, bxj.a.c);
    }

    public btm getTileEntity(ev pos, bxj.a type) {
        return this.chunkCache.a(pos, type);
    }

    public int a(bhq type, ev pos) {
        return this.chunkCache.a(type, pos);
    }

    public boolean f(ev pos) {
        return this.chunkCache.f(pos);
    }

    public ckz b(ev pos) {
        return this.e_(pos).p();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }
}

