/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.platform.GlStateManager;
import org.lwjgl.opengl.GL11;

public class CloudRenderer {
    private cvi mc;
    private boolean updated = false;
    private boolean renderFancy = false;
    int cloudTickCounter;
    private crv cloudColor;
    float partialTicks;
    private boolean updateRenderFancy = false;
    private int updateCloudTickCounter = 0;
    private crv updateCloudColor = new crv(-1.0, -1.0, -1.0);
    private double updatePlayerX = 0.0;
    private double updatePlayerY = 0.0;
    private double updatePlayerZ = 0.0;
    private int glListClouds = -1;

    public CloudRenderer(cvi mc) {
        this.mc = mc;
        this.glListClouds = ctt.a((int)1);
    }

    public void prepareToRender(boolean renderFancy, int cloudTickCounter, float partialTicks, crv cloudColor) {
        this.renderFancy = renderFancy;
        this.cloudTickCounter = cloudTickCounter;
        this.partialTicks = partialTicks;
        this.cloudColor = cloudColor;
    }

    public boolean shouldUpdateGlList() {
        boolean belowClouds;
        if (!this.updated) {
            return true;
        }
        if (this.renderFancy != this.updateRenderFancy) {
            return true;
        }
        if (this.cloudTickCounter >= this.updateCloudTickCounter + 20) {
            return true;
        }
        if (Math.abs(this.cloudColor.b - this.updateCloudColor.b) > 0.003) {
            return true;
        }
        if (Math.abs(this.cloudColor.c - this.updateCloudColor.c) > 0.003) {
            return true;
        }
        if (Math.abs(this.cloudColor.d - this.updateCloudColor.d) > 0.003) {
            return true;
        }
        aif rve = this.mc.U();
        boolean belowCloudsPrev = this.updatePlayerY + (double)rve.bM() < 128.0 + this.mc.w.ofCloudsHeight * 128.0;
        boolean bl = belowClouds = rve.n + (double)rve.bM() < 128.0 + this.mc.w.ofCloudsHeight * 128.0;
        return belowClouds != belowCloudsPrev;
    }

    public void startUpdateGlList() {
        GL11.glNewList((int)this.glListClouds, (int)4864);
    }

    public void endUpdateGlList() {
        GL11.glEndList();
        this.updateRenderFancy = this.renderFancy;
        this.updateCloudTickCounter = this.cloudTickCounter;
        this.updateCloudColor = this.cloudColor;
        this.updatePlayerX = this.mc.U().m;
        this.updatePlayerY = this.mc.U().n;
        this.updatePlayerZ = this.mc.U().o;
        this.updated = true;
        GlStateManager.clearCurrentColor();
    }

    public void renderGlList() {
        aif entityliving = this.mc.U();
        double exactPlayerX = entityliving.m + (entityliving.p - entityliving.m) * (double)this.partialTicks;
        double exactPlayerY = entityliving.n + (entityliving.q - entityliving.n) * (double)this.partialTicks;
        double exactPlayerZ = entityliving.o + (entityliving.r - entityliving.o) * (double)this.partialTicks;
        double dc = (float)(this.cloudTickCounter - this.updateCloudTickCounter) + this.partialTicks;
        float cdx = (float)(exactPlayerX - this.updatePlayerX + dc * 0.03);
        float cdy = (float)(exactPlayerY - this.updatePlayerY);
        float cdz = (float)(exactPlayerZ - this.updatePlayerZ);
        GlStateManager.pushMatrix();
        if (this.renderFancy) {
            GlStateManager.translatef((float)(-cdx / 12.0f), (float)(-cdy), (float)(-cdz / 12.0f));
        } else {
            GlStateManager.translatef((float)(-cdx), (float)(-cdy), (float)(-cdz));
        }
        GlStateManager.callList((int)this.glListClouds);
        GlStateManager.popMatrix();
        GlStateManager.clearCurrentColor();
    }

    public void reset() {
        this.updated = false;
    }
}

