/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(bvj blockStateIn, bgr blockReaderIn, ev blockPosIn, fa facingIn, RenderEnv renderEnv) {
        ev posNeighbour = blockPosIn.a(facingIn);
        bvj stateNeighbour = blockReaderIn.e_(posNeighbour);
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.o()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(bvj blockStateIn, bgr blockReaderIn, ev blockPosIn, fa facingIn, RenderEnv renderEnv, bvj stateNeighbourIn, ev posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        csp voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        csp voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.d());
        boolean flag = csm.c((csp)voxelshape, (csp)voxelshape1, (crz)crz.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bml block) {
        return fm.j.a((Object)block);
    }

    public static bml getBlock(qs loc) {
        if (!fm.j.c(loc)) {
            return null;
        }
        return (bml)fm.j.a(loc);
    }

    public static int getMetadata(bvj blockState) {
        bml block = blockState.d();
        bvk stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bml block) {
        bvk stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static bvj getBlockState(bml block, int metadata) {
        bvk stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        bvj blockState = (bvj)validStates.get(metadata);
        return blockState;
    }

    public static boolean isFullCube(bvj stateIn, bgr blockReaderIn, ev posIn) {
        return bml.a((csp)stateIn.i(blockReaderIn, posIn));
    }

    public static final class RenderSideCacheKey {
        private bvj blockState1;
        private bvj blockState2;
        private fa facing;
        private int hashCode;

        private RenderSideCacheKey(bvj blockState1In, bvj blockState2In, fa facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(bvj blockState1In, bvj blockState2In, fa facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

