##### Getting Started
## Frequently Asked Questions

#### Table of Contents
* [What is CodeCombat?](#what-is-codecombat-)
* [What ages are appropriate for CodeCombat?](#what-ages-are-appropriate-for-codecombat-)
* [What grades are appropriate for CodeCombat?](#what-grades-are-appropriate-for-codecombat-)
* [What programing languages are available?](#what-programing-languages-are-available-)
* [Can I use CodeCombat as the class’s main curriculum?](#can-i-use-codecombat-as-the-class-s-main-curriculum-)
* [How much does it cost to access all of the available courses and resources?](#how-much-does-it-cost-to-access-all-of-the-available-courses-and-resources-)
* [What does a license provide?](#what-does-a-license-provide-)
* [Do you have any free courses for educators to try before they make their purchasing decision?](#do-you-have-any-free-courses-for-educators-to-try-before-they-make-their-purchasing-decision-)
* [Can my students create an account if they have no email address?](#can-my-students-create-an-account-if-they-have-no-email-address-)
* [Can I track my student’s progress?](#can-i-track-my-student-s-progress-)
* [Does CodeCombat work on an iPad?](#does-codecombat-work-on-an-ipad-)
* [Is there a recommended browser and operating system?](#is-there-a-recommended-browser-and-operating-system-)
* [Students’ computer science backgrounds vary differently in my class, how does CodeCombat help me with that challenge?](#students-computer-science-backgrounds-vary-differently-in-my-class-how-does-codecombat-help-me-with-that-challenge-)
* [What if I need licenses that only last a semester instead of a full year?](#what-if-i-need-licenses-that-only-last-a-semester-instead-of-a-full-year-)
* [What is the Arena level at the end of a course?](#what-is-the-arena-level-at-the-end-of-a-course-)
* [Does CodeCombat have projects that students can work on and share?](#does-codecombat-have-projects-that-students-can-work-on-and-share-)
* [What do you offer in the Web Development and Game Development courses?](#what-do-you-offer-in-the-web-development-and-game-development-courses-)
* [Can students skip earlier levels if they already understand the concepts?](#can-students-skip-earlier-levels-if-they-already-understand-the-concepts-)
* [Does the teacher need to purchase a license if they want to work through the levels like their students?](#does-the-teacher-need-to-purchase-a-license-if-they-want-to-work-through-the-levels-like-their-students-)
* [How do I get started with CodeCombat?](#how-do-i-get-started-with-codecombat-)
* [Is there a limit to how many students I can add in Introduction to Computer Science?](#is-there-a-limit-to-how-many-students-i-can-add-in-introduction-to-computer-science-)


### What is CodeCombat?
CodeCombat is a coding game that uses real typed code and personalized learning to teach computer science with no teacher training needed.

### What ages are appropriate for CodeCombat?
CodeCombat is recommended for students aged 9 and up.

### What grades are appropriate for CodeCombat?
CodeCombat is recommended for schools with students aged 9 and up, which starts in 4th grade in the US.

### What programing languages are available?
We currently support Python and JavaScript.

**Why should you choose Python?**  
Python is both beginner-friendly and currently used by major corporations (such as Google). If you have younger or first-time learners, we strongly recommend Python.

**Why should you choose JavaScript?**  
JavaScript is the language of the web and is used across nearly every website. You may prefer to choose JavaScript if you are planning to also study web development.  We’ve also made it easy for students to transition from Python to JavaScript-based web development.

JavaScript’s syntax is a little more difficult for beginners than Python, so if you cannot decide between the two, we recommend Python.

### Can I use CodeCombat as the class’s main curriculum?
Absolutely! We’ve spent time consulting with education specialists to craft classroom curriculum and materials specifically for teachers who are using CodeCombat without any prior computer science experience themselves. Many schools are implementing CodeCombat as the main computer science curriculum.

We’ve published a set of curriculum resources in our [Resource Hub](https://codecombat.com/teachers/resources), which includes lesson plans, exercises, activities, and writing prompts to encourage reflection and retention. We’re also making printable guides available for students to reference as they work through levels. In addition, we provide level solutions for every course so teachers can help spot and correct errors in students’ code as they come up.  

### How much does it cost to access all of the available courses and resources?
We customize solutions for schools and districts and work with you to understand your use case, context, and budget. Contact schools@codecombat.com for further details!

### What does a license provide?
A license provides a single student access to the entire curriculum beyond the trial course (Introduction to Computer Science).

### Do you have any free courses for educators to try before they make their purchasing decision?
Yes! Our Introduction to Computer Science course does not require student licenses.  It takes 1-3 hours depending on your students' ages and experience. Please feel free to try it out in your school or district. There is no limit to the amount of students who can participate!

### Can my students create an account if they have no email address?
Yes - students signing up with a Class Code or a Class URL are given the option to choose a Username and skip the email field (it's labeled as "Optional"). Please refer to [Teacher Getting Started Guide](https://codecombat.com/teachers/resources/getting-started) more information about adding students to your class .

### Can I track my student’s progress?
Yes - the Teacher Dashboard provides detailed student progress, completion time and overall class statistics, and also allows you to assign manage student course assignments.

### Does CodeCombat work on an iPad?
We do not currently support iPads or Android Tablets at this time.

### Is there a recommended browser and operating system?
CodeCombat runs best on computers with at least 4GB of RAM, on a modern browser such as Chrome, Safari, Firefox, or Edge. Chromebooks with less RAM may have minor graphics issues in later courses.  

### Students’ computer science backgrounds vary differently in my class, how does CodeCombat help me with that challenge?
Many teachers are facing the challenge to address different student needs in the classroom. You are not alone there. CodeCombat solves your problem by providing truly personalized learning experience to your students.    

We know that different students learn at different paces, and sometimes they may need extra assistance with new concepts. We’ve built two new features to help smooth out the learning curve of students who find themselves stuck: Hints, and Practice Levels.

**Hints**  
Hints come in handy when students are struggling with a specific level. Every level has a blue “Hints” button at the top right corner, which gives a more in-depth explanation of the level’s specific concepts and provides additional step by step examples of how to complete it.  

**Practice Levels**  
The second feature is Practice Levels, which helps students get more experience with a particular concept if they are struggling. When the game detects that a student has struggled with a level, the game adapts so the student has more opportunity to practice the same skill until they improve. This provides a personalized learning experience for each student, so they can move past concepts they understand quickly, and get more practice for concepts that are challenging.  

### What if I need licenses that only last a semester instead of a full year?
The standard Student License term is for one year, but it can be broken into semesters or trimesters, or even prorated, as needed. Just talk to one of our [School Specialists](mailto:schools@codecombat.com) to discuss your needs.  

### What is the Arena level at the end of a course?
Arenas are open practice levels where students can hone the skills they learned in each course. You may use the arena to let faster students explore a deeper multiplayer strategy while the slower students catch up, and then when everyone is at the arena level, optionally have some class time for an in-class tournament. That way you can assign the next course to all students at the same time so that everyone stays roughly in sync within a course.  

### Does CodeCombat have projects that students can work on and share?
Our game development and web development courses are all project-based! Teachers and students love those courses because they get to be the ‘creator’ in those projects. At the end of these courses they will also be able to showcase their projects by sharing permanent project links.  

### What do you offer in the Web Development and Game Development courses?
**Web Development**  
In our Web Development courses, students learn the fundamentals of building
interactive websites using HTML, CSS, and JavaScript. All webpages are automatically published to a custom URL so that students can easily share their finished project with friends and family. Check out this example poster by one of the students from our summer coding camp -- the result of just an hour’s work by a student who had no prior experience with web development!

**Game Development**  
What’s even more fun than playing a game? Making your own! In our Game Development courses, students learn how to build their own CodeCombat-style game levels and unleash them on friends and family to play with a mouse and keyboard. Over time, they’ll unlock the tools needed to create challenging puzzles and practice their game design skills to become the next star game designer. Final projects for each course can be shared are published to a custom URL so that students can easily share their games with friends and family.

Teachers can preview all Web and Game Development levels by going to the [Course Guides](http://codecombat.com/teachers/courses) page and selecting a level from the dropdown menus.

### Can students skip earlier levels if they already understand the concepts?
We strongly encourage that all students play every level even if they already know the concepts, so that they can reinforce their knowledge. The levels are carefully planned out to build confidence and progress in a logical way, and it’s a chance for the students to become familiar with the platform, the user experience, and the basic logic behind our game-play so they know how to tackle the harder, more advanced courses.

Teachers can assign courses at their discretion, but we recommend that your students work through courses in the suggested order.

### Does the teacher need to purchase a license if they want to work through the levels like their students?
No. Teachers can preview and play all game levels by going to the [Course Guides](http://codecombat.com/teachers/courses) page and selecting a level from the dropdown menus.  Level progress is not saved.

### How do I get started with CodeCombat?
To get started:
1. Create your Teacher Account
2. Create a class.
3. Add students.
4. Sit back and watch your students have fun learning to code.

Please refer to [Teacher Getting Started Guide](https://codecombat.com/teachers/resources/getting-started) for instructions on each step .

### Is there a limit to how many students I can add in Introduction to Computer Science?
No.  


[Back to Top](#frequently-asked-questions)
