##### Getting Started
# Start Using CodeCombat in 10 Minutes!
#### Get your class up and running with these steps.

##### STEP 1
## Create a Teacher Account

After you’ve created your Teacher account, you will be able to create classes, invite students, monitor students’ progress, enroll students, and assign course content once students have been enrolled.

Select the **Sign up as a Teacher** option during account creation in order to sign up as a teacher.

<img src="http://files.codecombat.com/docs/getting-started/teacher-account.png" title="Create a Teacher Account" alt="create-teacher-account-modal"/>

Once your teacher account is setup, you’ll be able to access your [Teacher Dashboard](/teachers/classes).

### What if I already have an account?

If you already have a CodeCombat account as a Student or Individual but want to convert it to a Teacher account, visit the [Update to Teacher Account](/teachers/update-account) page. Once you’ve converted, your student account will be removed from any classrooms you may have previously joined.

### What are the technical requirements for CodeCombat?
CodeCombat runs best on computers with at least 4GB of RAM, on a modern browser such as Chrome, Safari,  Firefox, or Edge. Chromebooks with less RAM may have minor graphics issues in later courses.

*We do not currently support iPads or Android Tablets at this time.*

##### STEP 2
## Create a New Class

Once logged in, or if you click the Teacher link in the navigation bar, you’ll see your new [Teacher Dashboard](/teachers/classes). From here, you’ll be able to create classes and monitor your student’s progress.

Click the blue “Create a New Class” button, then choose a class name that will help you and your students identify the class, such as “Mr. Smith 3rd period.”

<img src="http://files.codecombat.com/docs/getting-started/create-new-class-modal.png" title="Create a New Class" alt="create-new-class-modal" width="400px" />



### Should I choose Python or JavaScript?
We recommend Python, because it’s both beginner-friendly and currently used by major corporations (such as Google). If you have younger or first-time learners, we strongly recommend Python.

JavaScript will work great too. It’s the language of the web; used across every website, and still beginner-friendly.  If you are planning to also study web development, you may prefer to choose JavaScript to avoid the confusion some students may have switching from one language’s syntax to another. However, JavaScript’s syntax is a little more difficult for beginners than Python.

##### STEP 3
## Add Students
Once you’ve created your class, you’ll see it under the list of Current Classes. Navigate the class where you want to add students, then choose one of three ways to add students.

<img src="http://files.codecombat.com/docs/getting-started/add-students.png" title="Add Students" alt="add-students" width="400px"/>
_Use your unique class code, class URL or invite students via email._


### Option 1: Invite Students via Email
*Easiest option if your students have email addresses*  
Click the blue "Invite Students by Email" button, then enter your students’ email addresses (you can copy and paste this from your class list or student information system) and click "Invite Students". Students will receive an email instructing them to follow a link, which will allow them to create an account and join your class.

Make sure they are creating a **Student Account** and that the correct class name is displayed when they create their account.

<img src="http://files.codecombat.com/docs/getting-started/test-class.png" title="Create a Student Account" alt="create-student-account" width="400px"/>
_Students should see your class name in place of "Test Class 1"._

Students will need to enter the following to create a Student Account:
- First name
- Last initial
- Username (help them choose an appropriate unique username)
- Password

Email addresses are _not required_ for students creating an account when they have a valid Class Code from you. That said, using an email address is recommended if they have one, for easier password recovery.

*If your school uses Google Apps for Education*, students can connect using the red "Google" button at the top of the screen instead of manually entering their information. They can then sign in to CodeCombat using the G+ Connect button in the future.

After students have created their account, they are shown their username and instructed to write down this information.

That’s it! Students can now use their login credentials to start playing CodeCombat!

### Option 2: Students Join via a Class Code
*Easiest option if you students don’t have email addresses*

Direct your students to [CodeCombat](https://codecombat.com) and have them click “Create Account” on the top navigation bar. Students should select the green "Sign up as a Student" button.

<img src="http://files.codecombat.com/docs/getting-started/student-account.png" title="Create a Student Account" alt="create-student-account" width="400px"/>
_Make sure your students click “Sign up as a Student” when prompted._

The website will request the “Class Code” for your class, which can be found if you click “View Class” on your  Teacher Dashboard. Your classroom will have its own unique three-word code.

<img src="http://files.codecombat.com/docs/getting-started/class-code-example.png" title="Class Code Example" alt="class-code-example" width="400px"/>
_How to find your Class Code as a Teacher: Click on one of your classes, and look for the three-word Class Code next under “Adding Students”._

Once students enter your Class Code, they should see the correct class name and instructor on the screen.

Students will need to enter the following to create a Student Account:
- First name
- Last initial
- Username (help them choose an appropriate unique username)
- Password

Email addresses are _not required_ for students creating an account when they have a valid Class Code from you. That said, using an email address is recommended if they have one, for easier password recovery.

*If your school uses Google Apps for Education*, students can connect using the red "Google" button at the top of the screen instead of manually entering their information. They can then sign in to CodeCombat using the G+ Connect button in the future.

After students have created their account, they are shown their username and instructed to write down this information.

That’s it! Students can now use their login credentials to start playing CodeCombat!

##### STEP 4
## Introduction to Computer Science

All students are automatically granted access to the first course in CodeCombat, Introduction to Computer Science. This is a course that introduces students to concepts such as basic syntax, variables, and while loops. Generally this course takes about 1-3 hours for a middle school class.

<img src="http://files.codecombat.com/docs/getting-started/course-guides.png" title="Course Guides" alt="course-guides" width="400px"/>
_Course Guides allow you to preview course levels and view solutions._

As a teacher, you can access solutions for each course by going to [Course Guides](/teachers/courses/) (located in the blue teacher navigation bar). You can also preview every level using the dropdown selectors.

<img src="http://files.codecombat.com/docs/getting-started/resource-hub.png" title="Resource Hub" alt="resource-hub" width="400px"/>
_Course Guides allow you to preview course levels and view solutions._

If you're new to teaching computer science, we also recommend taking a look at the [Resource Hub](/teachers/resources), where you can find lesson plans, worksheets and supplemental guides to help you kickstart your classroom.

##### STEP 5
## Tracking Progress

<img src="http://files.codecombat.com/docs/getting-started/student-overview.png" title="Student Overview" alt="student-overview" width="400px"/>
_A high-level view of student progress in each course is displayed in the main class view._

After students join the class, you’ll see their progress appear in the individual classroom pages. Any assigned courses and each student’s progress in each course (starting with CS1, Introduction to Computer Science and onwards) is represented by a colored circle. A grey circle means a student has not begun any levels in that course, yellow circle means they have started working on the course’s levels, and a green circle means that they’ve completed all of the levels in the course.

<img src="http://files.codecombat.com/docs/getting-started/student-progress.png" title="Student Progress" alt="student-progress" width="400px"/>
_Navigate to the "Course Progress" tab to view more detailed information of student progress within each course._

If you want to see how your students are doing within a course, click on the “Course Progress” tab. You’ll be able to view how much progress a student has made in a specific course. A gray circle means a level  has not been started, a yellow circle indicates a level has been started but not completed, and a green circle means a level has been completed. By moving your mouse pointer over the circle for a level, you can see information about when they completed the level, as well as a rough estimate of how long the level took to complete.

##### STEP 6
## Licensing Students

Students are required to have a license to access any content after the first course. When you assign a new course, a license will automatically be applied to the student. By default, all licenses expire one year from when they are granted. A single license allows a single student access to all of the courses available.

To manually assign a license to a student, click on the *License Status* tab while viewing a class and use the "Assign License" button.

### How do I get Licenses for my students?

If you would like to purchase more licenses, click on *Student Licenses* in the Teacher Dashboard navigation bar, and follow the instructions under "Get More Licenses". One of CodeCombat’s specialists  will be in contact with you shortly to discuss your needs.

##### STEP 7
## Assigning Courses

<img src="http://files.codecombat.com/docs/getting-started/bulk-assign.png" title="Bulk Assign Courses" alt="bulk-assign" width="400px"/>

Once a student is enrolled, you’ll be able to assign additional courses to them. We recommend not assigning students to more than one course ahead of where they currently are. You can bulk-assign a course to multiple students at a time by selecting students using checkboxes on the left-hand side (or the “Select All” checkbox), then choosing the appropriate course from the dropdown menu, and then clicking “Assign to Selected Students.”

##### STEP 8
## Start Teaching!
There are great supplemental materials for teachers available on our [Course Guides](/teachers/courses/) and [Resource Hub](/teachers/resources). If you're new to teaching computer science, we highly recommend checking these out -- we've built these with first-time teachers in mind. You can also browse our [Teacher Forums](https://discourse.codecombat.com/c/teachers), where you can discuss curriculum planning with other educators, share ideas, or ask questions.

You can also email us at [schools@codecombat.com](mailto:schools@codecombat.com) with any support questions or concerns!
