module.exports = nativeDescription: "Español (América Latina)", englishDescription: "Spanish (Latin America)", translation:
  new_home:
    slogan: "El juego más interesante para aprender programación."
    classroom_edition: "Versión para el Aula:"
    learn_to_code: "Aprende a programar:"
    teacher: "Maestro"
    student: "Estudiante"
    play_now: "Jugar Ahora"
    im_a_teacher: "Soy un Maestro"
    im_a_student: "Soy un Estudiante"
    learn_more: "Aprender más"
    classroom_in_a_box: "Un aula prediseñada para enseñar informática."
    codecombat_is: "CodeCombat es una plataforma para que los estudiantes aprendan informática mientras están jugando un juego de verdad." # {change}
    our_courses: "Nuestros cursos fueron probados especificamente para destacarse en el aula, incluso con maestros con poca o ninguna experiencia previa en programación." # {change}
    top_screenshots_hint: "Los estudiantes escriben código y ven sus cambios actualizarse en tiempo real"
    designed_with: "Diseñado teniendo en cuenta a los maestros"
    real_code: "Escritura real de código"
    from_the_first_level: "desde el primer nivel"
    getting_students: "Conseguir que los estudiantes escriban código lo más pronto posible es fundamental para que aprendan la sintaxis y la estructura apropiada."
    educator_resources: "Recursos para el educador"
    course_guides: "y guías de curso"
    teaching_computer_science: "Enseñar informática no requiere un título costoso, porque proporcionamos herramientas para ayudar a educadores con cualquier conocimiento previo."
    accessible_to: "Comprensible para"
    everyone: "todos"
    democratizing: "Democratizar el proceso de aprender a programar es la esencia de nuestra filosofía. Todos deberían poder aprender a programar"
    forgot_learning: "Creo que ellos en realidad olvidaron de que estaban aprendiendo algo."
    wanted_to_do: "Programar es algo que siempre quise hacer, y que nunca pensé que sería capaz de aprenderlo en la escuela ."
    why_games: "¿Por qué el aprendizaje mediante juegos es importante?"
    games_reward: "Los juegos recompensan el esfuerzo productivo."
    encourage: "El juego es un medio que incentiva la interacción, el descubrimiento, y la prueba-error. Un buen juego desafía al jugador a dominar habilidades con el paso del tiempo, que es un proceso crítico similar al que los estudiantes atraviesan mientran aprenden"
    excel: "Los juegos se destacan en recompensar el"
    struggle: "esfuerzo productivo"
    kind_of_struggle: "el tipo de esfuerzo que se traduce en aprendizaje que interesa y "
    motivating: "que motiva"
    not_tedious: "no tedioso."
    gaming_is_good: "Los estudios sugieren que jugar es bueno para el cerebro de los niños (¡es verdad!)"
    game_based: "Cuando los sistemas de aprendizaje basados en juegos son"
    compared: "comparados"
    conventional: "con los métodos de evaluación convencionales, la diferencia es clara: los juegos son mejores al ayudar a los estudiantes a retener el conocimiento, a concentrarse y"
    perform_at_higher_level: "a desempeñarse con un mayor nivel de éxito"
    feedback: "Los juegos también proveen retroalimentación en tiempo real que permite a los estudiantes ajustar su camino a la solución y entender conceptos de forma más holística, en lugar de estar limitados solamente a respuestas 'correctas' e 'incorrectas'"
    real_game: "Un juego de verdad, jugado con código auténtico."
    great_game: "Un gran juego es más que solo medallas y logros - se trata sobre una travesía del jugador, acertijos bien diseñados, y la habilidad de abordar desafios con voluntad y confianza."
    agency: "CodeCombat es un juego que ofrece a los jugadores esa voluntad y confianza mediante nuestro motor de código robusto, que ayuda tanto a principiantes como a estudiantes avanzados por igual a escribir código correcto y válido."
    request_demo_title: "Invita a tus estudiantes hoy!"
    request_demo_subtitle: "Solicitar una demostración y empieza a jugar con tus estudiantes en menos de una hora."
    get_started_title: "Configure su clase hoy"
    get_started_subtitle: "Prepare su clase, agregue cuentas de estudiantes y siga su progreso a medida que aprenden a programar."
    request_demo: "Solicitar un Demo"
    setup_a_class: "Configurar una Clase"
    have_an_account: "¿Ya tienes una cuenta?" # {change}
    logged_in_as: "Estás actualmente conectado como"
    computer_science: "Cursos de informática para todas las edades"
    show_me_lesson_time: "Muéstrame la duración estimada de las clases para:"
    curriculum: "Horas totales del plan de estudios:"
    ffa: "Gratis para todos los estudiantes"
    lesson_time: "Duración de la clase:"
    coming_soon: "¡Proximamente!"
    courses_available_in: "Los cursos están disponibles en JavaScript, Python, y Java (¡proximamente!)" # {change}
    boast: "Cuenta con acertijos lo suficiente complejos como para fascinar a jugadores y programadores por igual."
    winning: "Una combinación ganadora entre un juego de rol y una tarea sobre programación que consigue hacer de la educación amigable y disfrutable para los niños."
    run_class: "Todo lo que necesitas para organizar una clase de informática en tu escuela hoy mismo, sin necesidad de ningún conocimiento previo de informática."
    goto_classes: "Ir a mis clases" # {change}
    view_profile: "Ver mi perfíl"
    view_progress: "Ver mi progreso"
#    go_to_courses: "Go to My Courses"
    want_coco: "¿Quisiera CodeCombat en su escuela?"

  nav:
    play: "Jugar" # The top nav bar entry where players choose which levels to play
    community: "Comunidad"
    courses: "Cursos" # {change}
    blog: "Blog"
    forum: "Foro"
    account: "Cuenta"
    my_account: "Mi Cuenta"
    profile: "Perfil"
    home: "Inicio"
    contribute: "Contribuir"
    legal: "Legal"
#    privacy: "Privacy"
    about: "Acerca"
    contact: "Contacto"
    twitter_follow: "Seguir"
    teachers: "Maestros"
    students: "Estudiantes"
    careers: "Carreras"
    facebook: "Facebook"
    twitter: "Twitter"
    create_a_class: "Crear una Clase"
    other: "Otro"
    learn_to_code: "¡Aprender a programar!"
#    toggle_nav: "Toggle navigation"
    jobs: "Trabajos"
    schools: "Escuelas"
    get_involved: "Participa"
    open_source: "Código Libre (GitHub)"
    support: "Soporte"
    faqs: "FAQs"
    help_pref: "¿Necesitas ayuda? Envianos un correó electronico!"
    help_suff: "y te contactaremos pronto"
#    resource_hub: "Resource Hub"

  modal:
    close: "Cerrar"
    okay: "OK"

  not_found:
    page_not_found: "Página no encontrada"

  diplomat_suggestion:
    title: "¡Ayuda a traducir CodeCombat!" # This shows up when a player switches to a non-English language using the language selector.
    sub_heading: "Necesitamos tus habilidades de idioma."
    pitch_body: "Desarrollamos CodeCombat en inglés, pero ya tenemos jugadores de todo el mundo. Muchos de ellos quieren jugar en español pero no hablan inglés, así que si puedes hablar ambos, por favor considera registrarte pare ser un Diplomático y ayudar a traducir tanto el sitio de CodeCombat como todos los niveles al español."
    missing_translations: "Hasta que podamos traducir todo al español, verás inglés cuando el español no esté disponible."
    learn_more: "Aprende más sobre ser un Diplomático"
    subscribe_as_diplomat: "Suscríbete como un Diplomático"

  play:
    play_as: "Jugar Como " # Ladder page
    compete: "¡Competir!" # Course details page
    spectate: "Observar" # Ladder page
    players: "Jugadores" # Hover over a level on /play
    hours_played: "horas jugadas" # Hover over a level on /play
    items: "Objetos" # Tooltip on item shop button from /play
    unlock: "Desbloquear" # For purchasing items and heroes
    confirm: "Confirmar"
    owned: "Adquirido" # For items you own
    locked: "Bloqueado"
    purchasable: "Adquirible" # For a hero you unlocked but haven't purchased
    available: "Disponible"
    skills_granted: "Habilidades concedidas" # Property documentation details
    heroes: "Héroes" # Tooltip on hero shop button from /play
    achievements: "Logros" # Tooltip on achievement list button from /play
    settings: "Configuración" # Tooltip on settings button from /play
    poll: "Encuestas" # Tooltip on poll button from /play
    next: "Próximo" # Go from choose hero to choose inventory before playing a level
    change_hero: "Cambiar héroe" # Go back from choose inventory to choose hero
    buy_gems: "Comprar gemas"
    subscription_required: "Requiere Suscripción"
    anonymous: "Jugador Anónimo"
    level_difficulty: "Dificultad: "
    play_classroom_version: "Jugar la Versión de Aula" # Choose a level in campaign version that you also can play in one of your courses
    campaign_beginner: "Campaña para principiantes"
    awaiting_levels_adventurer_prefix: "Nosotros libreamos nuevos niveles cada semana"
    awaiting_levels_adventurer: "Registrate como un aventurero"
    awaiting_levels_adventurer_suffix: "para ser el primero en jugar nuevos niveles."
    adjust_volume: "Ajustar el volumen"
    campaign_multiplayer: "Arenas Multijugador"
    campaign_multiplayer_description: "... en las que programas cara a cara contra otros jugadores."

  code:
    if: "si" # Keywords--these translations show up on hover, so please translate them all, even if it's kind of long. (In the code editor, they will still be in English.)
    else: "otro"
    elif: "si no"
    while: "mientras"
    loop: "ciclo"
    for: "por"
    break: "interrupción"
    continue: "continuar"
    pass: "pasar"
    return: "regresar"
    then: "entonces"
    do: "hacer"
    end: "fin"
    function: "función"
    def: "define"
    var: "variable"
#    self: "self"
    hero: "heroe"
    this: "este"
    or: "o"
    "||": "o"
    and: "y"
    "&&": "y"
    not: "no"
    "!": "no"
    "=": "asigne a"
    "==": "igual a"
    "===": "igual a estrictamente"
    "!=": "no igual a"
    "!==": "no estrictamente igual"
    ">": "es mayor que"
    ">=": "es mayor que o igual"
    "<": "es menor que"
    "<=": "es menor que o igual"
    "*": "multiplicado por"
    "/": "dividido por"
    "+": "más"
    "-": "menos"
    "+=": "añade y asigne"
    "-=": "elimine y asigne"
    True: "Verdadero"
    true: "verdadero"
    False: "Falso"
    false: "falso"
    undefined: "undefinido"
    null: "nulo"
#    nil: "nil"
    None: "Ninguno"

  share_progress_modal:
    blurb: "¡Estás haciendo un gran progreso! Cuéntale a tus padres cuánto has aprendido con CodeCombat."
    email_invalid: "Dirección de Email inválida."
    form_blurb: "¡Escribe su email debajo y les enseñaremos!"
    form_label: "Dirección de Email"
    placeholder: "dirección de email"
    title: "Excelente Trabajo, Aprendiz"

  login:
    sign_up: "Crear Cuenta"
#    email_or_username: "Email or username"
    log_in: "Entrar"
    logging_in: "Entrando"
    log_out: "Salir"
    forgot_password: "¿Olvidaste la contraseña?"
    authenticate_gplus: "Ingresar G+"
    load_profile: "Cargar Perfil G+ "
    finishing: "Finalizando"
    sign_in_with_facebook: "Registrarse con Facebook"
    sign_in_with_gplus: "Registrarse con G+"
    signup_switch: "¿Quieres crear una cuenta?"

  signup:
#    create_student_header: "Create Student Account"
#    create_teacher_header: "Create Teacher Account"
#    create_individual_header: "Create Individual Account"
    email_announcements: "Recibe noticias por email" # {change}
    creating: "Creando Cuenta..."
    sign_up: "Registrarse"
    log_in: "Inicia sesión con tu contraseña"
    required: "Necesitas entrar a tu cuenta antes de continuar."
    login_switch: "¿Ya tienes una cuenta?"
    school_name: "Nombre de Escuela y Ciudad"
    optional: "opcional"
    school_name_placeholder: "Ejemplo: High School, Springfield, IL"
#    connect_with: "Connect with:"
    connected_gplus_header: "Te haz conectado exitosamente a travez de Google+!"
    connected_gplus_p: "Termina el registro para que inicies sesión con tu cuenta de Google+."
    gplus_exists: "Ya tienes asociada una cuenta con Google+!"
    connected_facebook_header: "Te haz conectado exitosamente a travez de Facebook!"
    connected_facebook_p: "Termina el registro para que inicies sesión con tu cuenta de Facebook."
    facebook_exists: "Ya tienes asociada una cuenta Facebook!"
    hey_students: "Estudiante, ingresa el coódigo de clase de tu maestro."
    birthday: "Cumpleaños"
#    parent_email_blurb: "We know you can't wait to learn programming &mdash; we're excited too! Your parents will receive an email with further instructions on how to create an account for you. Email {{email_link}} if you have any questions."
#    classroom_not_found: "No classes exist with this Class Code. Check your spelling or ask your teacher for help."
#    checking: "Checking..."
#    account_exists: "This email is already in use:"
#    sign_in: "Sign in"
#    email_good: "Email looks good!"
#    name_taken: "Username already taken! Try {{suggestedName}}?"
#    name_available: "Username available!"
#    name_is_email: "Username may not be an email"
#    choose_type: "Choose your account type:"
#    teacher_type_1: "Teach programming using CodeCombat!"
#    teacher_type_2: "Set up your class"
#    teacher_type_3: "Access Course Guides"
#    teacher_type_4: "View student progress"
#    signup_as_teacher: "Sign up as a Teacher"
#    student_type_1: "Learn to program while playing an engaging game!"
#    student_type_2: "Play with your class"
#    student_type_3: "Compete in arenas"
#    student_type_4: "Choose your hero!"
#    student_type_5: "Have your Class Code ready!"
#    signup_as_student: "Sign up as a Student"
#    individuals_or_parents: "Individuals & Parents"
#    individual_type: "For players learning to code outside of a class. Parents should sign up for an account here."
#    signup_as_individual: "Sign up as an Individual"
#    enter_class_code: "Enter your Class Code"
#    enter_birthdate: "Enter your birthdate:"
#    parent_use_birthdate: "Parents, use your own birthdate."
#    ask_teacher_1: "Ask your teacher for your Class Code."
#    ask_teacher_2: "Not part of a class? Create an "
#    ask_teacher_3: "Individual Account"
#    ask_teacher_4: " instead."
#    about_to_join: "You're about to join:"
#    enter_parent_email: "Enter your parent’s email address:"
#    parent_email_error: "Something went wrong when trying to send the email. Check the email address and try again."
#    parent_email_sent: "We’ve sent an email with further instructions on how to create an account. Ask your parent to check their inbox."
#    account_created: "Account Created!"
#    confirm_student_blurb: "Write down your information so that you don't forget it. Your teacher can also help you reset your password at any time."
#    confirm_individual_blurb: "Write down your login information in case you need it later. Verify your email so you can recover your account if you ever forget your password - check your inbox!"
#    write_this_down: "Write this down:"
#    start_playing: "Start Playing!"
#    sso_connected: "Successfully connected with:"
#    select_your_starting_hero: "Select Your Starting Hero:"
#    you_can_always_change_your_hero_later: "You can always change your hero later."

  recover:
    recover_account_title: "recuperar cuenta"
    send_password: "Enviar contraseña de recuperación"
    recovery_sent: "Correo de recuperación enviado."

  items:
    primary: "Primario"
    secondary: "Secundario"
    armor: "Armadura"
    accessories: "Accesorios"
    misc: "Misceláneo"
    books: "Libros"

  common:
    back: "Volver" # When used as an action verb, like "Navigate backward"
#    coming_soon: "Coming soon!"
    continue: "Continuar" # When used as an action verb, like "Continue forward"
#    default_code: "Default Code"
    loading: "Cargando..."
#    overview: "Overview"
#    solution: "Solution"
#    intro: "Intro"
    saving: "Guardando..."
    sending: "Enviando..."
    send: "Enviar"
#    sent: "Sent"
    cancel: "Cancelar"
    save: "Guardar"
    publish: "Publicar"
    create: "Crear"
    fork: "Bifurcar"
    play: "Jugar" # When used as an action verb, like "Play next level"
    retry: "Reintentar"
    actions: "Acciones"
    info: "Info"
    help: "Ayuda"
    watch: "Seguir"
    unwatch: "No seguir"
    submit_patch: "Enviar Parche"
    submit_changes: "Enviar cambios"
    save_changes: "Guardar cambios"
    required_field: " Requisito necesario" # {change}

  general:
    and: "y"
    name: "Nombre"
    date: "Fecha"
    body: "Cuerpo"
    version: "Versión"
    pending: "Pendiente"
    accepted: "Aceptado"
    rejected: "Rechazado"
    withdrawn: "Retirado"
    accept: "Aceptar"
    reject: "Rechazar"
    withdraw: "Retirar"
    submitter: "Emisor"
    submitted: "Enviado"
    commit_msg: "Enviar mensaje"
    version_history: "Historial de Versiones"
    version_history_for: "Historial de Versiones para: "
    select_changes: "Selcciona dos cambios abajo para ver la diferencia"
    undo_prefix: "Deshacer"
    undo_shortcut: "(Ctrl+Z)"
    redo_prefix: "Rehacer"
    redo_shortcut: "(Ctrl+Shift+Z)"
    play_preview: "Mira el avance del nivel"
    result: "Resultado"
    results: "Resultados"
    description: "Descripción"
    or: "o"
    subject: "Asunto"
    email: "Email"
    password: "Contraseña"
    confirm_password: "Confirme Contraseña"
    message: "Mensaje"
    code: "Código"
    ladder: "Escalera"
    when: "Cuando"
    opponent: "Oponente"
    rank: "Posición"
    score: "Puntuación"
    win: "Ganada"
    loss: "Perdida"
    tie: "Empate"
    easy: "Fácil"
    medium: "Medio"
    hard: "Difícil"
    player: "Jugador"
    player_level: "Nivel" # Like player level 5, not like level: Dungeons of Kithgard
    warrior: "Guerrero"
    ranger: "Guardabosques"
    wizard: "Mago"
    first_name: " Nombre de pila"
    last_name: "Apellido"
#    last_initial: "Last Initial"
    username: "Nombre de usuario"

  units:
    second: "segundo"
    seconds: "segundos"
    minute: "minuto"
    minutes: "minutos"
    hour: "hora"
    hours: "horas"
    day: "día"
    days: "días"
    week: "semana"
    weeks: "semanas"
    month: "mes"
    months: "meses"
    year: "año"
    years: "años"

  play_level:
    level_complete: "Nivel completo"
    completed_level: "Nivel Completado:"
    course: "Curso:"
    done: "Listo"
    next_level: "Siguiente Nivel"
    next_game: "Siguiente juego"
#    language: "Language"
#    languages: "Languages"
#    programming_language: "Programming language"
    show_menu: "Mostrar menú de juego"
    home: "Inicio" # Not used any more, will be removed soon.
    level: "Nivel" # Like "Level: Dungeons of Kithgard"
    skip: "Omitir"
    game_menu: "Menú del Juego"
    guide: "Guía"
    restart: "Reiniciar"
    goals: "Objetivos"
    goal: "Objetivo"
    running: "Andando..."
    success: "¡Éxito!"
    incomplete: "Incompleto"
    timed_out: "Se te acabó el tiempo"
    failing: "Fallando"
    reload: "Recargar"
    reload_title: "¿Recargar Todo el Código?"
    reload_really: "¿Estás seguro de que quieres empezar este nivel desde el principio?"
    reload_confirm: "Recargar Todo"
    victory: "Victoria"
    victory_title_prefix: "¡"
    victory_title_suffix: " Completo!"
    victory_sign_up: "Regístrate para recibir actualizaciones"
    victory_sign_up_poke: "¿Quieres recibir las ultimas noticias por correo? ¡Crea una cuenta gratuita y te mantendremos informado!"
    victory_rate_the_level: "¿Cómo de divertido estuvo este nivel?"
    victory_return_to_ladder: "Volver a la escalera"
    victory_saving_progress: "Guardando Progreso"
    victory_go_home: "Ir al Inicio"
    victory_review: "¡Cuéntanos más!"
    victory_review_placeholder: "¿Cómo estuvo el nivel?"
    victory_hour_of_code_done: "¿Has acabado?"
    victory_hour_of_code_done_yes: "¡Si, he terminado con mi Hora de Código!"
    victory_experience_gained: "XP Ganada"
    victory_gems_gained: "Gemas Ganadas"
    victory_new_item: "Objeto Nuevo"
#    victory_new_hero: "New Hero"
    victory_viking_code_school: "¡Changos macacos!, el nivel que acabas de pasar era dificil! Si todavía no eres un desarrollador de software, deberías serlo. Acabas de conseguir una aceptación por vía rápida con la Escuela Vikinga de Có, donde tú puedes llevar tus habilidades al siguiente nivel y convertirteen un desarrollador web profesional en 14 semanas."
    victory_become_a_viking: "Conviértete en un Vikingo"
    victory_no_progress_for_teachers: "El progreso no es guardado para maestros. Pero puede añadir cuenta de estudiante a su aula, por su mismo."
    guide_title: "Guía"
    tome_cast_button_run: "Ejecutar"
    tome_cast_button_running: "Ejecutando"
    tome_cast_button_ran: "Ejecutado"
    tome_submit_button: "Enviar"
    tome_reload_method: "Recargar código original para este método" # {change}
    tome_available_spells: "Hechizos Disponibles"
    tome_your_skills: "Tus habilidades"
    tome_current_method: "Método actual"
#    hints: "Hints"
#    hints_title: "Hint {{number}}"
    code_saved: "Código Guardado"
    skip_tutorial: "Saltar (esc)"
    keyboard_shortcuts: "Atajos de teclado"
    loading_ready: "¡Listo!"
    loading_start: "Iniciar nivel"
    problem_alert_title: "Revisa tu código"
    time_current: "Ahora:"
    time_total: "Max:"
    time_goto: "Ir a:"
    non_user_code_problem_title: "No se puede cargar el nivel"
    infinite_loop_title: "Ciclo infinito detectado"
    infinite_loop_description: "El código inicial para construir el mundo no terminó de ejecutarse. Probablemente es muy lento o tiene un loop infinito. O puede ser un bug. Puedes tratar ejecutando este código nuevamente o reiniciar el código a su estado por defecto. Si eso no lo arregla, haznos saber."
    check_dev_console: "Tú puedes también abrir la consola de desarrollo para ver que puede salir mal."
    check_dev_console_link: "(instrucciones)"
    infinite_loop_try_again: "Intentar nuevamente"
    infinite_loop_reset_level: "Reiniciar Nivel"
    infinite_loop_comment_out: "Comenta Mi Código"
    tip_toggle_play: "Activa jugar/pausa con Ctrl+P."
    tip_scrub_shortcut: "Ctrl+[ y Ctrl+] para rebobinar y avanzar rápido."
    tip_guide_exists: "Haga click en la guía en la parte superior de la página para obtener información útil"
    tip_open_source: "¡CodeCombat es 100% código abierto!"
    tip_tell_friends: "¿Disfrutando de CodeCombat? ¡Cuéntale a tus amigos acerca de nosotros!"
    tip_beta_launch: "CodeCombat lanzó su beta en Octubre del 2013."
    tip_think_solution: "Piensa en la solución, no en el problema."
    tip_theory_practice: "En teoría, no hay diferencia entre la teoría y la práctica. Pero en la práctica, si la hay. - Yogi Berra"
    tip_error_free: "Hay dos formas de escribir programas libres de errores; sólo la tercera funciona. - Alan Perlis"
    tip_debugging_program: "Si depurar es el proceso de remover errores, entonces programar debe ser el proceso de colocarlos. - Edsger W. Dijkstra"
    tip_forums: "¡Dirígite a los foros y dinos lo que piensas!"
    tip_baby_coders: "En el futuro, incluso los bebés serán Archimagos."
    tip_morale_improves: "La carga continuará hasta que la moral mejore."
    tip_all_species: "Creemos en la igualdad de oportunidades para aprender a programar para todas las especies."
    tip_reticulating: "Espinas reticulantes."
    tip_harry: "Eres un Hechicero, "
    tip_great_responsibility: "Con una gran habilidad de hacer código viene una gran responsabilidad de depuración."
    tip_munchkin: "Si no comes tus verduras, un enano vendrá por ti mientras estés dormido."
    tip_binary: "Sólo hay 10 tipos de personas en el mundo: aquellas que entienden binario y las que no."
    tip_commitment_yoda: "Un programador debe tener el compromiso más profundo, la mente más seria. ~ Yoda"
    tip_no_try: "Haz. O no hagas. No hay intento. - Yoda"
    tip_patience: "Paciencia debes tener, joven Padawan. - Yoda"
    tip_documented_bug: "Un error documentado no es un error; es una característica."
    tip_impossible: "Siempre parece imposible hasta que se hace. - Nelson Mandela"
    tip_talk_is_cheap: "Hablar es barato. Muéstrame el código. - Linus Torvalds"
    tip_first_language: "La cosa más desastrosa que puedes aprender es tu primer lenguaje de programación. - Alan Kay"
    tip_hardware_problem: "P: ¿Cuántos programadores son necesarios para cambiar una bombilla eléctrica?  R: Ninguno, es un problema de hardware."
    tip_hofstadters_law: "Ley de Hofstadter: Siempre toma más tiempo del que esperas, incluso cuando tienes en cuenta la ley de Hofstadter."
    tip_premature_optimization: "La optimización prematura es la raíz de la maldad. - Donald Knuth"
    tip_brute_force: "Cuando tengas duda, usa la fuerza bruta. - Ken Thompson"
    tip_extrapolation: "Solo hay dos tipos de personas: Esas que pueden extrapolar desde información incompleta..."
    tip_superpower: "Programar es lo más cercano que tenemos a superpoderes."
    tip_control_destiny: "En el Open Source real, tú tienes el derecho de controlar tu propio destino. - Linus Torvalds"
    tip_no_code: "Ningún código es más rápido que nada de código."
    tip_code_never_lies: "El código nunca miente, los comentarios a veces sí. — Ron Jeffries"
    tip_reusable_software: "Antes de que el software sea reusable, primero tiene que ser usable."
    tip_optimization_operator: "Cada lenguaje tiene un operador de optimización. En la mayoría de ellos, ese operador es ‘//’"
    tip_lines_of_code: "Medir el progreso en la programación en líneas de código es como medir el progreso de construcción de una aeronave por su peso. — Bill Gates"
    tip_source_code: "Quisiera cambiar el mundo, pero no me dan el código fuente."
    tip_javascript_java: "Java es a Javascript lo mismo que Comer es a Comercial. - Chris Heilmann"
    tip_move_forward: "Hagas lo que hagas, siempre sigue hacia delante. - Martin Luther King Jr."
    tip_google: "¿Tienes un problema que no puedes resolver? ¡Googléalo!"
    tip_adding_evil: "Agregando una pizca de maldad."
    tip_hate_computers: "Esa es la razón por la cual la gente piensa que odia las computadoras. Lo que ellos odian de verdad, es los pesimos programadores. - Larry Niven"
    tip_open_source_contribute: "¡Tú puedes ayudar a CodeCombat a mejorar!"
    tip_recurse: "Iterar es humano, recursar es divino. - L. Peter Deutsch"
    tip_free_your_mind: "Tienes que dejar ir todo, Neo. Miedo, duda, e incredulidad. Libera tu mente. - Morpheus"
    tip_strong_opponents: "Hasta los oponentes mas fuertes siempre tienen una debilidad. - Itachi Uchiha"
    tip_paper_and_pen: "Antes de comenzar a codificar, siempre puedes planear con una hoja de papel y un lapicero."
    tip_solve_then_write: "Primero, resuelve el problema. Entonces, escribe el código. - John Johnson"
    tip_compiler_ignores_comments: "A veces pienso que el compilador ignora mis comentarios."
    tip_understand_recursion: "La única manera de entender la recursividad es entender la recursividad."
    tip_life_and_polymorphism: "El Open Source es como una estructura heterogénea totalmente polimórfica: Todos los tipos son bienvenidos."
    tip_mistakes_proof_of_trying: "Errores en tu código son solo evidencia de que estas intentando."
#    tip_adding_orgres: "Rounding up ogres."
    tip_sharpening_swords: "Afilando las espadas."
    tip_ratatouille: "No debes dejar que nadie defina tus límites a causa de donde venas. Tu único límite es tu alma. - Gusteau, Ratatouille"
    tip_nemo: "¿Cuando huye la suerte, sabes que hay que hacer? Sigue nadando, sigue nadando. - Dory, Finding Nemo"
    tip_internet_weather: "Debes moverte al intenet, es genial aquí. Tenemos la oportunidad de vivir dentro donde el clima es siempre sorprendente. - John Green"
    tip_nerds: "A los Nerds se les permite amor cosas, como saltar-arriba-y-abajo-en-la-silla-no-te-puedes-controlar-tu-mismo quiérelo. - John Green"
    tip_self_taught: "Me enseñé a mí mismo el 90% de lo que he aprendido. ¡Y eso es normal! - Hank Green"
    tip_luna_lovegood: "No te preocupes, estas tan cuerdo como yo. - Luna Lovegood"
    tip_good_idea: "La mejor forma de tener una buena idea es tener un montón de ideas. - Linus Pauling"
    tip_programming_not_about_computers: "En las Ciencias de la Computación no es más acerca de computadoras que la astronomía acerca de telescopios. - Edsger Dijkstra"
    tip_mulan: "Si crees que puedes, entonces lo harás. - Mulan"

#  play_game_dev_level:
#    created_by: "Created by {{name}}"
#    how_to_play_title: "How to play:"
#    how_to_play_1: "Use the mouse to control the hero!"
#    how_to_play_2: "Click anywhere on the map to move to that location."
#    how_to_play_3: "Click on the ogres to attack them."
#    restart: "Restart Level"
#    play: "Play Level"
#    play_more_codecombat: "Play More CodeCombat"
#    default_student_instructions: "Click to control your hero and win your game!"
#    back_to_coding: "Back to Coding"

  game_menu:
    inventory_tab: "Inventario"
    save_load_tab: "Guardar/Cargar"
    options_tab: "Opciones"
    guide_tab: "Guía"
    guide_video_tutorial: "Guía en video"
    guide_tips: "Pistas"
    multiplayer_tab: "Multijugador"
    auth_tab: "Entrar"
    inventory_caption: "Equipar a tu héroe"
    choose_hero_caption: "Elegir héroe, lenguaje"
    save_load_caption: "... y ver historia"
    options_caption: "Hacer ajustes"
    guide_caption: "Documentos y consejos"
    multiplayer_caption: "¡Jugar con amigos!"
    auth_caption: "Guarda tu progreso."

  leaderboard:
    view_other_solutions: "Ver la Tabla de Posiciones"
    scores: "Puntajes"
    top_players: "Mejores jugadores"
    day: "Hoy"
    week: "Esta Semana"
    all: "Siempre"
    time: "Tiempo"
    damage_taken: "Daño Recibido"
    damage_dealt: "Daño Infligido"
    difficulty: "Dificultad"
    gold_collected: "Oro Recolectado"

  inventory:
    equipped_item: "Equipado"
    required_purchase_title: "Requerido"
    available_item: "Disponible"
    restricted_title: "Restringido"
    should_equip: "(doble-click para equipar)"
    equipped: "(equipado)"
    locked: "(bloqueado)"
    restricted: "(restringido en este nivel)"
    equip: "Equipar"
    unequip: "Sacar"

  buy_gems:
    few_gems: "Pocas gemas"
    pile_gems: "Pila de gemas"
    chest_gems: "Cofre de gemas"
    purchasing: "Comprando..."
    declined: "Su tarjeta fue rechazada"
    retrying: "Error del servidor, recargando."
    prompt_title: "Gemas insuficientes"
    prompt_body: "¿Quieres obtener más?"
    prompt_button: "Entrar al mercado"
    recovered: "Se recuperaron las anteriores compras de gemas. Por favor recarga la página"
    price: "x{{gems}} / mes"

  subscribe:
    comparison_blurb: "Agudiza tus habilidades con la suscripción a CodeCombat!"
    feature1: "Más de __levelsCount__ niveles basicos a lo largo de __worldsCount__ mundos" # {change}
    feature2: "__heroesCount__ poderosos <strong>nuevos heroés</strong> con habilidades unicas!" # {change}
    feature3: "Más de __bonusLevelsCount__ niveles extras" # {change}
    feature4: "<strong>{{gems}} gemas de bono</strong> cada mes!"
    feature6: "Soporte Premium vía email"
    feature7: "<strong>Clan</strong> Privado"
    feature8: "<strong>¡Sin publicidad!</strong>"
    free: "Gratis"
    month: "mes"
    must_be_logged: "Debes iniciar sesión primero. Por favor crea una cuenta o inicia sesión desde el menú superior."
    subscribe_title: "Suscribirse"
    unsubscribe: "Des-suscribirse"
    confirm_unsubscribe: "Confirmar cancelacion de suscripción"
    never_mind: "Olvidalo, Te sigo queriendo"
    thank_you_months_prefix: "Gracias por tu apoyo en estos ultimos"
    thank_you_months_suffix: "meses."
    thank_you: "Gracias por apoyar CodeCombat."
    sorry_to_see_you_go: "¡Sentimos que te vayas! Por favor, haznos saber lo que podríamos haber hecho mejor."
    unsubscribe_feedback_placeholder: "¿Pero qué hemos hecho?"
    parent_button: "Preguntale a tus padres"
    parent_email_description: "Nosotros les mandaremos un email a ellos, así pueden comprarte la suscripción a CodeCombat."
    parent_email_input_invalid: "Dirección de email invalida."
    parent_email_input_label: "Dirección email padres"
    parent_email_input_placeholder: "Ingresa el email de tus padres"
    parent_email_send: "Enviar email"
    parent_email_sent: "Email enviado!"
    parent_email_title: "Cuál es el email de tus padres?"
    parents: "Para padres"
    parents_title: "Estimado Padre de Familia: Su hijo está aprendiendo a programar. ¿Le apoyaría a continuar?"
    parents_blurb1: "Con CodeCombat, su hijo aprenderá a escribiendo código real. Empezaran aprendiendo comandos simples avanzando a temas más complejos."
    parents_blurb1a: "La Programación es una habilidad escencial que su hijo sin duda usará en la adultez. Para el 2020, habilidades básicas en software serán requeridas por el 77% de trabajos, y los ingenieros de software están en alta demanda alrededor del mundo. ¿Sabía que Ciencias de la Computación es la carrera mejor pagada?"
    parents_blurb2: "Por ${{price}} USD mensuales, su hijo recibirá nuevos desafíos todas las semanas y soporte personal por email de programadores profesionales."
    parents_blurb3: "Sin Riesgo: Garantía de 100% de devolución, fácil 1-click y des- suscribirse."
    payment_methods: "Metodos de pago"
    payment_methods_title: "Metodos de pago aceptados."
    payment_methods_blurb1: "Actualmente aceptamos tarjetas de credito y Alipay. Tambíen puedes usar PayPal, enviando a nick@codecombat tu correo electrónico, y pudiendo adquirir por {{three_month_price}} USD una suscripción de tres meses y gemas, o por ${{year_price}} una de un año."
    payment_methods_blurb2: "Si necesitas una forma alternativa de pago, por favor contactarse"
    sale_button: "Venta!"
    sale_button_title: "Ahorre $21 al adquirir una suscripción por 1 año"
    stripe_description: "Suscripción Mensual"
    stripe_description_year_sale: "Suscripción por 1 año (${{discount}} de descuento)"
    subscription_required_to_play: "Necesitas una suscripción para jugar este nivel."
    unlock_help_videos: "Suscríbete para desbloquear todos los video tutoriales."
    personal_sub: "Suscripción Personal" # Accounts Subscription View below
    loading_info: "Cargando información de suscripción..."
    managed_by: "Administrado por"
    will_be_cancelled: "Será cancelado en"
    currently_free: "Actualmente tienes una suscripción gratuita"
    currently_free_until: "Actualmente tienes una suscripción gratuita hasta"
    was_free_until: "Tuviste una suscripción gratuita hasta"
    managed_subs: "Suscripciones administradas"
    subscribing: "Suscribiendo..."
    current_recipients: "Recipientes actuales"
    unsubscribing: "Dando de baja..."
    subscribe_prepaid: "Click en suscribirse para utlizar un código prepago"
    using_prepaid: "Usar código prepago para una suscribción mensual"

  choose_hero:
    choose_hero: "Elige tu héroe"
    programming_language: "Lenguaje de programación"
    programming_language_description: "¿Qué lenguaje de programación vas a elegir?"
    default: "por Defecto"
    experimental: "Experimental"
    python_blurb: "Simple pero poderoso."
    javascript_blurb: "El lenguaje de la web (no es Java)."
    coffeescript_blurb: "JavaScript pero más bonito."
    lua_blurb: "Lenguaje para Juegos."
#    java_blurb: "(Subscriber Only) Android and enterprise."
    status: "Estado"
    weapons: "Armas"
    weapons_warrior: "Espada - Corto Alcance, Sin Magia"
    weapons_ranger: "Ballestas, Armas - Largo Alcance, Sin Magia"
    weapons_wizard: "Barita,  - Largo Alcance, Mágico"
    attack: "Daño" # Can also translate as "Attack"
    health: "Salud"
    speed: "Velocidad"
    regeneration: "Regeneración"
    range: "Rango" # As in "attack or visual range"
    blocks: "Bloqueo" # As in "this shield blocks this much damage"
    backstab: "Apuñala" # As in "this dagger does this much backstab damage"
    skills: "Habilidades"
    attack_1: "Ofertas"
    attack_2: "de la lista"
    attack_3: "daño de arma."
    health_1: "Gana"
    health_2: "de la lista"
    health_3: "salud de la armadura."
    speed_1: "Se mueve a"
    speed_2: "metros por segundo."
    available_for_purchase: "Disponible para Comprar" # Shows up when you have unlocked, but not purchased, a hero in the hero store
    level_to_unlock: "Nivel para desbloquear:" # Label for which level you have to beat to unlock a particular hero (click a locked hero in the store to see)
    restricted_to_certain_heroes: "Sólo ciertos héroes pueden jugar este nivel."

  skill_docs:
    function: "función" # skill types
    method: "método"
#    snippet: "snippet"
    number: "número"
    array: "arreglo"
    object: "objeto"
    string: "cadena"
    writable: "escribible" # Hover over "attack" in Your Skills while playing a level to see most of this
    read_only: "Sólo Lectura"
    action: "Acción"
    spell: "Conjuro"
    action_name: "nombre"
    action_cooldown: "Toma"
    action_specific_cooldown: "Enfriamiento"
    action_damage: "Daño"
    action_range: "Rango"
    action_radius: "Radio"
    action_duration: "Duración"
    example: "Ejemplo"
    ex: "ej" # Abbreviation of "example"
    current_value: "Valor actual"
    default_value: "Valor por defecto"
    parameters: "Parámetros"
#    required_parameters: "Required Parameters"
#    optional_parameters: "Optional Parameters"
    returns: "Devoluciones"
    granted_by: "Concedido por"

  save_load:
    granularity_saved_games: "Guardado"
    granularity_change_history: "Historia"

  options:
    general_options: "Opciones Generales" # Check out the Options tab in the Game Menu while playing a level
    volume_label: "Volúmen"
    music_label: "Música"
    music_description: "Música encendida/apagada."
    editor_config_title: "Configuración del Editor"
    editor_config_livecompletion_label: "Autocompletado automático"
    editor_config_livecompletion_description: "Despliega sugerencias de autocompletado mientras escribes."
    editor_config_invisibles_label: "Mostrar Invisibles"
    editor_config_invisibles_description: "Visualiza invisibles tales como espacios o tabulaciones."
    editor_config_indentguides_label: "Mostrar guías de indentación"
    editor_config_indentguides_description: "Visualiza líneas verticales para ver mejor la indentación."
    editor_config_behaviors_label: "Comportamientos Inteligentes"
    editor_config_behaviors_description: "Autocompleta corchetes, llaves y comillas."

  about:
    main_title: "Si queres aprender a programar, necesitas escribir (un montón de) código."
    main_description: "En CodeCombat, nuestro trabajo es asegurarnos que estás haciendo eso con una sonrisa en tu cara."
    mission_link: "Misión"
    team_link: "Equipo"
    story_link: "Historia"
    press_link: "Prensa"
    mission_title: "Nuestra misión: hacer accesible la programación para cada estudiante en la Tierra."
    mission_description_1: "<strong>La programación es mágica</strong>. Es la habilidad de crear cosas desde la pura imaginación. Empezamos CodeCombat para dar a los estudiantes la sensación de poder de la magia en la punta de sus dedos mediante el <strong>tipeo de código</strong>."
    mission_description_2: "Como resultado, eso les permite tambien aprender más rápido. De una FORMA más rápida. Es como tener una conversación en vez de leer un manual. Queremos llevar esa conversación a todas las escuelas y a <strong>cada estudiante</strong>, porque todos deberían tener la oportunidad de aprender la magia de la programación"
    team_title: "Conoce al equipo de CodeCombat"
    team_values: "Valoramos el diálogo abierto y respetuoso, donde gana la mejor idea. Nuestras decisiones se basan en la investigación del cliente y nuestro método se centra en obtener resultados tangibles para ellas. Todos están echando una mano, desde nuestro CEO hasta nuestros contribuidores en GitHub, porque en nuestro equipo valoramos el crecimiento y el aprendizaje. "
    nick_title: "Cofundador, CEO"
    nick_blurb: "Gurú motivacional"
    matt_title: "Cofundador, CTO"
    cat_title: "Diseñadora de Juegos"
    cat_blurb: "Maestro del Aire"
    scott_title: "Cofundador, Ingeniero de Software"
    scott_blurb: "Razonable"
    maka_title: "Defensor del Consumidor"
    maka_blurb: "Cuentista"
    rob_title: "Ingeniero de Software"
    rob_blurb: "Hace código y demás"
    josh_c_title: "Diseñador de Juegos"
    josh_c_blurb: "Diseña juegos"
    robin_title: "Diseñadora de UX & Investigadora"
    robin_blurb: "Scaffolding"
    josh_title: "Diseñador de Juegos"
    josh_blurb: "El piso es Lava"
    phoenix_title: "Ingeniero de Software"
    nolan_title: "Administrador de territorio"
    elliot_title: "Administrador de Asociación"
#    elliot_blurb: "Mindreader"
#    lisa_title: "School Specialist"
#    lisa_blurb: "A gritty one"
#    sean_title: "Territory Manager"
    retrostyle_title: "Ilustración"
    retrostyle_blurb: "Juegos con estilo Retro"
    jose_title: "Música"
    jose_blurb: "Despegar"
    community_title: "...y nuestra comunidad open-source"
    community_subtitle: "¡Más de 450 contribuidores que ayudaron a contruir CodeCombat, y más uniendose cada semana!"
#    community_description_3: "CodeCombat is a"
#    community_description_link_2: "community project"
    community_description_1: "CodeCombat es un proyecto comunitario, con cientos de jugadores haciendo trabajo voluntario al crear niveles, contribuir a nuestro código para añadir características, arreglar bugs, testear, e incluso traducir el juego a 50 idiomas hasta ahora. Empleados, contribuidores y la página ganan al compartir las ideas Echa un vistazo a nuestra" # {change}
    community_description_link: "página de contribución"
    community_description_2: "para más información."
    number_contributors: "Más de 450 contribuidores dieron su apoyo y tiempo a este proyecto."
    story_title: "Nuestra historia hasta ahora"
    story_subtitle: "Desde 2013, CodeCombat creció desde un mero conjunto de bocetos hasta un juego próspero, vivo."
    story_statistic_1a: "+5,000,000"
    story_statistic_1b: "jugadores totales"
    story_statistic_1c: "comenzaron su viaje en la programación mediante CodeCombat"
    story_statistic_2a: "We’ve been translated into over 50 languages — nuestros jugadores son de"
    story_statistic_2b: "+200 países"
    story_statistic_3a: "Juntos, escribieron"
    story_statistic_3b: "1 mil millones de líneas de código, y contando"
    story_statistic_3c: "en seis lenguajes de programación distintos" # {change}
    story_long_way_1: "Aunque hemos recorrido un largo camino..."
    story_sketch_caption: "El primer boceto de Nick representando un juego de programación en acción."
    story_long_way_2: "todavía nos queda mucho por hacer antes de que completemos nuestra misión, asi que..."
    jobs_title: "¡Ven a trabajar con nosotros y ayuda a escribir la historia de CodeCombat!"
    jobs_subtitle: "¿No encontras una buena opción pero estás interesado en mantener el  contacto? Mirá nuestra entrada \"Crear Tu Propio\"."
    jobs_benefits: "Beneficios del empleado"
    jobs_benefit_4: "Días personales/enfermo ilimitados" # {change}
    jobs_benefit_5: "Desarrollo profesional y soporte de formación continua" # {change}
    jobs_benefit_6: "Seguro médico/dental/vista" # {change}
#    jobs_benefit_7: "Sit-stand desks for all"
#    jobs_benefit_9: "10-year option exercise window"
#    jobs_benefit_10: "Maternity leave: 10 weeks paid, next 6 @ 55% salary"
#    jobs_benefit_11: "Paternity leave: 10 weeks paid"
    learn_more: "Aprender Más"
    jobs_custom_title: "Crear Tu Propio"
    jobs_custom_description: "¿Te apasiona CodeCombat pero nos ves un puesto de trabajo que coincida con tus cualificaciones? Escríbenos y muestrenos como cree que puede contribuir a nuestro equipo. ¡Nos encantaría saber de vos!"
    jobs_custom_contact_1: "¡Envíanos una nota a"
    jobs_custom_contact_2: "presentándote y podremos estar en contacto en el futuro!"
    contact_title: "Prensa & Contacto"
    contact_subtitle: "¿Necesitas más información? Contáctanos en"
    screenshots_title: "Capturas de pantalla del Juego"
    screenshots_hint: "(click para ver en tamaño completo)"
    downloads_title: "Descargar Recursos & Información"
    about_codecombat: "Acerca de CodeCombat"
    logo: "Logo"
    screenshots: "Capturas de pantalla"
    character_art: "Arte de Personajes"
    download_all: "Descargar Todo"
    previous: "Anterior"
    location_title: "Nos encontramos en el centro de SF:"

  teachers:
    who_for_title: "¿Para quienes es CodeCombat?"
    who_for_1: "Recomendamos CodeCombat para estudiantes con +9 años de edad. No se require experiencia en programación. Diseñamos CodeCombat para que sea atractivo tanto para los chicos como para las chicas."
    who_for_2: "Nuestro sistema de Cursos permite a los maestros configurar las clases, monitorizar el progreso y asignar contenido adicional a los estudiantes a través de una interfaz dedicada."
    more_info_title: "¿Dónde puedo encontrar más información?"
    more_info_1: "Nuestro"
    more_info_2: "el foro de profesores"
    more_info_3: "es un buen lugar para connectarse con los educadores que estan usando CodeCombat."
#    licenses_needed: "Licenses needed"

  teachers_quote:
    name: "Formulario de Presupuesto"
    subtitle: "¡Obtén CodeCombat en tu clase, club, escuela o distrito!"
    email_exists: "Existe un usuario con este email."
    phone_number: "Teléfono"
    phone_number_help: "¿Dónde podemos contactarte durante el horario de trabajo ?"
    primary_role_label: "Tu Rol Primario"
    role_default: "Seleccione Rol"
    primary_role_default: "Seleccione Rol Primario"
    purchaser_role_default: "Seleccione Rol de Comprador"
    tech_coordinator: "Coordinador de tecnología"
    advisor: "Tutor"
    principal: "Director"
    superintendent: "Supervisor"
    parent: "Padre"
    purchaser_role_label: "Tu Rol de Comprador"
    influence_advocate: "Influencia/Partidario"
    evaluate_recommend: "Evaluar/Recomendar"
    approve_funds: "Aprobar Fondos"
#    no_purchaser_role: "No role in purchase decisions"
#    district_label: "District"
#    district_na: "Enter N/A if not applicable"
    organization_label: "Escuela / Distrito" # {change}
    city: "Ciudad"
    state: "Estado"
    country: "País"
    num_students_help: "¿Cuántos prevees inscribir en CodeCombat?"
    num_students_default: "Seleccionar Rango"
    education_level_label: "Nivel Educativo de los Estudiantes"
    education_level_help: "Elegí todas las que correspondan."
    elementary_school: "Escuela Primaria"
    high_school: "Escuela Secundaria"
    please_explain: "(describa, por favor)"
    middle_school: "Escuela Intermedia"
    college_plus: "Universidad o superior"
    anything_else: "¿Algo más que deberíamos saber?"
    thanks_header: "¡Gracias por solicitar un presupuesto!" # {change}
    thanks_sub_header: "Gracias por el interés de su institución en CodeCombat"
    thanks_p: "Estaremos en contacto pronto. ¿Preguntas? Escríbenos:" # {change}
    back_to_classes: "Volver a las clases"
    finish_signup: "Termine la creación de su cuenta de maestro:"
    finish_signup_p: "Crear una cuenta para configurar la clase, agregar estudiante y monitorear su progreso a medida que aprenden programacioón"
    signup_with: "Registrarse con:"
    connect_with: "Conectar con:"
    conversion_warning: "ADVERTENCIA: Su cuenta actual es de tipo <em>Estudiante</em>. Una vez que envie este formulario, su cuenta será actualizada como cuenta de Profesor."
    learn_more_modal: "Cuentas de Profesor en CodeCombat tienen la ventaja de monitorear el progreso del estudiante, asignar inscripciónes y administrar salones de clases. Cuentas de Profesor no pueden ser parte de los salones de clases. Si usted está registrado en una clase utilizando una cuenta de estudiante, no podrá acceder hasta que tenga una Cuenta de Profesor." # {change}
    create_account: "Crear una Cuenta de maestro"
    create_account_subtitle: "Obtenga acceso a herramientas exclusivas para profesores de CodeCombat. <strong>Configurar una clase</strong>, agregar estudiantes, y <strong>monitorear su progreso</strong>!"
    convert_account_title: "Actualizar mi perfil a Cuenta de Profesor"
    not: "No"

  versions:
    save_version_title: "Guardar nueva versión"
    new_major_version: "Nueva Gran Versión"
    submitting_patch: "Publicando Parche..."
    cla_prefix: "Para guardar los cambios, primero debes estar de acuerdo con nuestro"
    cla_url: "CLA"
    cla_suffix: "."
    cla_agree: "ACEPTO"
    owner_approve: "Necesita la aprobación de un propietario para que los cambios sean visibles."

  contact:
    contact_us: "Contacta a CodeCombat"
    welcome: "¡Qué bueno es escuchar algo de ti! Usa este formulario para enviarnos un mensaje"
    forum_prefix: "Para cualquier cosa pública, por favor prueba "
    forum_page: "nuestro foro "
    forum_suffix: "en su lugar."
    faq_prefix: "También hay un"
    faq: "FAQ"
    subscribe_prefix: "Si necesitas ayuda para resolver un nivel, por favor"
    subscribe: "compra una suscripción de CodeCombat"
    subscribe_suffix: "y nosotros estaremos felices de ayudarte con tu código."
    subscriber_support: "Como estás suscrito a CodeCombat, tu email tendrá prioridad."
    screenshot_included: "Captura de pantalla incluida."
    where_reply: "¿A dónde deberíamos responder?"
    send: "Enviar Comentario"

  account_settings:
    title: "Configuración de la Cuenta"
    not_logged_in: "Inicia sesión o crea una cuenta para cambiar tu configuración."
    autosave: "Cambios Guardados Automáticamente"
    me_tab: "Yo"
    picture_tab: "Imagen"
    delete_account_tab: "Borra tu cuenta"
    wrong_email: "Mail Incorrecto"
    wrong_password: "Contraseña incorrecta"
    upload_picture: "Sube una imagen"
    delete_this_account: "Borrar esta cuenta permanentemente"
    reset_progress_tab: "Reiniciar Todo Progreso"
    reset_your_progress: "Limpiar todo tu progreso y comenzar de nuevo"
    god_mode: "Modo Dios"
    emails_tab: "Correos"
    admin: "Admin"
    manage_subscription: "Click aquí para administrar tu subscripción"
    new_password: "Nueva Contraseña"
    new_password_verify: "Verificar"
    type_in_email: "Ingrese su correo electrónico para confirmar la eliminación de su cuenta." # {change}
    type_in_email_progress: "Ingrese su correo para confirmar la eliminación de su progreso."
    type_in_password: "Asimismo, ingrese su contraseña."
    email_subscriptions: "Suscripciones de Email"
    email_subscriptions_none: "No tienes suscripciones."
    email_announcements: "Noticias"
    email_announcements_description: "Recibe correos electrónicos con las últimas noticias y desarrollos de CodeCombat."
    email_notifications: "Notificaciones"
    email_notifications_summary: "Controles para tus notificaciones por correo electrónico automáticas y personalizadas relativas a tu actividad en CodeCombat."
    email_any_notes: "Algunas notificaciones"
    email_any_notes_description: "Desactiva para detener toda la actividad de correos de notificaciones."
    email_news: "Noticias"
    email_recruit_notes: "Oportunidades Laborales"
    email_recruit_notes_description: "Si juegas realmente bien podríamos contactarte para ofrecerte un (mejor) trabajo."
    contributor_emails: "Emails Clase Contribuyente"
    contribute_prefix: "¡Estamos buscando gente que se una a nuestro grupo! Echa un vistazo a la "
    contribute_page: "página de contribución"
    contribute_suffix: "para averiguar más."
    email_toggle: "Activar Todo"
    error_saving: "Error al Guardar"
    saved: "Cambios Guardados"
    password_mismatch: "La contraseña no coincide."
    password_repeat: "Por favor repita su contraseña."

  keyboard_shortcuts:
    keyboard_shortcuts: "Atajos de teclado"
    space: "Barra espaciadora"
    enter: "Enter"
    press_enter: "Toca enter"
    escape: "Escape"
    shift: "Shift"
    run_code: "Ejecutar el código."
    run_real_time: "Ejecutar en tiempo real."
    continue_script: "Continuar hasta finalizado el script."
    skip_scripts: "Omitir todos los scripts omitibles."
    toggle_playback: "Aplicar ejecutar/pausar."
    scrub_playback: "Devolverse y avanzar en el tiempo."
    single_scrub_playback: "Devolverse y avanzar en el tiempo de a un cuadro."
    scrub_execution: "Scrub through la ejecución del hechizo actual."
    toggle_debug: "Mostrar/ocultar depuración."
    toggle_grid: "Mostrar/ocultar rejilla."
    toggle_pathfinding: "Mostrar/ocultar buscador de rutas."
    beautify: "Hacer bello tu código estandarizando formato."
    maximize_editor: "Maximizar/minimizar editor de código."

  community:
    main_title: "Comunidad CodeCombat"
    introduction: "Mira las maneras en las que puedes involucrarte adelante y decide qué es más divertido. ¡Queremos trabajar contigo!"
    level_editor_prefix: "Usar CodeCombat"
    level_editor_suffix: "para crear y editar niveles. Los han creado niveles para sus clases, amigos, hackatones, estudiantes, familiares. Si crear un nuevo juego luce intimidante puedes ¡comenzar con base en uno nuestro!"
    thang_editor_prefix: "Nosotros llamamos a las unidades del juego 'Tiliches'. Usa el"
    thang_editor_suffix: "para modificar el arte de CodeCombat. Permite a las unidades lanzar proyectiles, altera la dirección de una animación, cambia los puntos de vida de una unidad o sube tu propio sprite de vectores."
    article_editor_prefix: "¿Ves algún error en nuestros documentos? ¿Quieres hacer algunas instrucciones para tus propias creaciones? Revisa el"
    article_editor_suffix: "y ayuda a los jugadores de CodeCombat conseguir lo más posible de su tiempo jugando."
    find_us: "Encuentranos en etsos sitios"
    social_github: "Revisa todo nuestro código en GitHub"
    social_blog: "Lee el blog de CodeCombat en Sett"
    social_discource: "Únete a la discusión en nuestro foro"
    social_facebook: "Me Gusta CodeCombat en Facebook"
    social_twitter: "Sigue a CodeCombat en Twitter"
    social_gplus: "Únete a CodeCombat con Google+"
    social_slack: "Conversa con nosotros en nuestro canal de Slack"
    contribute_to_the_project: "Contribuir al proyecto"

  clans:
    clan: "Clan"
    clans: "Clanes"
    new_name: "Nuevo nombre de clan"
    new_description: "descripción del clan"
    make_private: "Hacer clan privado"
    subs_only: "solo suscriptores"
    create_clan: "Crear nuevo clan"
    private_preview: "Vista previa"
    private_clans: "Clanes Privados"
    public_clans: "Clanes publicos"
    my_clans: "Mis Clanes"
    clan_name: "Nombre del clan"
    name: "Nombre"
    chieftain: "Líder del Clan"
    edit_clan_name: "Editar el nombre del Clan"
    edit_clan_description: "Editar descripción del clan"
    edit_name: "editar nombre"
    edit_description: "editar descripción"
    private: "(privado)"
    summary: "Resumen"
    average_level: "Nivel Promedio"
    average_achievements: "Logros Promedio"
    delete_clan: "Borrar Clan"
    leave_clan: "Abandonar Clan"
    join_clan: "Ingresar Clan"
    invite_1: "Invitar:"
    invite_2: "*Invitar jugadores al clan, mandandoles este link."
    members: "Miembros"
    progress: "Progreso"
    not_started_1: "no iniciado"
    started_1: "iniciado"
    complete_1: "completo"
    exp_levels: "Expand levels"
    rem_hero: "Remover Heróe"
    status: "Stado"
    complete_2: "Completo"
    started_2: "Iniciado"
    not_started_2: "No inciiado"
    view_solution: "Click para ver la solución."
    view_attempt: "Click para ver intento."
    latest_achievement: "último logro"
    playtime: "Tiempo de juego"
    last_played: "Último jugado"
    leagues_explanation: "Juega en una liga contra otros miembros del clan en estas instancias de arena multijugador."
    track_concepts1: "Haga un seguimiento de los conceptos"
    track_concepts2a: "aprendidos por cada estudiante"
    track_concepts2b: "aprendidos por cada miembro"
    track_concepts3a: "Haga un seguimiento de los niveles completados por cada estudiante"
    track_concepts3b: "Haga un seguimiento de los niveles completados por cada miembro"
    track_concepts4a: "Ve a tus estudiantes'"
    track_concepts4b: "Ve a tus miembros'"
    track_concepts5: "soluciones"
    track_concepts6a: "Ordene a sus estudiantes por nombre o progreso"
    track_concepts6b: "Ordene a sus miembros por nombre o progreso"
    track_concepts7: "Requiere invitación"
    track_concepts8: "para unirse"
    private_require_sub: "Los clanes privados requieren una suscripción para crearlos o unírseles."

  courses:
    course: "Curso"
    courses: "cursos"
    create_new_class: "Crear Nueva Clase"
    not_enrolled: "No estás inscrito en este curso."
    visit_pref: "Por favor visite la"
    visit_suf: "página para inscribirse."
    select_class: "Seleccione uno de sus grupos"
    unnamed: "*anónimo*"
    select: "Seleccionar"
    unnamed_class: "Grupo Anónimo"
    edit_settings: "editar configuraciónes de grupo"
    edit_settings1: "Editar Configuraciónes de Grupos"
    progress: "Progreso del Grupo"
    add_students: "Agregar Estudiantes"
    stats: "Estadísticas"
    total_students: "Total de Estudiantes:"
    average_time: "Tiempo Promedio de juego por nivel:"
    total_time: "Tiempo total de juego:"
    average_levels: "Niveles Promedio completados:"
    total_levels: "Total de niveles completados:"
    furthest_level: "Máximo nivel completado:"
    students: "Estudiantes"
    students1: "estudiantes"
    concepts: "Conceptos"
    levels: "niveles"
    played: "Jugados"
    play_time: "Tiempo de Juego:"
    completed: "Completados:"
    invite_students: "Invite a sus estudiantes a unirse a este grupo."
    invite_link_header: "Enlace para unirse al curso"
    invite_link_p_1: "Proporciones este enalce a los estudiantes que desee que se unan al curso."
    invite_link_p_2: "O envíenoslos directamente mediante el correo electrónico:"
    capacity_used: "Espacios de curso usados:"
    enter_emails: "Introducir los emails de los estudiantes a invitar, uno por línea" # {change}
    send_invites: "¿Mandar Invitaciones?" # {change}
    creating_class: "Creando clase..."
    purchasing_course: "Adquiriendo curso..."
    buy_course: "Comprar Curso"
    buy_course1: "Comprar este curso"
    select_all_courses: "Seleccione 'Todos los cursos' para un 50% de descuento!"
    all_courses: "Todos los Cursos"
    number_programming_students: "Número de Estudiantes"
    number_total_students: "Total de Estudiantes en Escuela/Distrito/Facultad"
    enter_number_students: "Introducir el número de estudiantes que necesita para este grupo."
    name_class: "Nombre de su grupo"
    displayed_course_page: "Se mostrará en la página de curso para usted y sus estudiantes. Puede cambiarse después."
    buy: "Comprar"
    purchasing_for: "Está adquiriendo una licencia para"
    creating_for: "Está creando un grupo para"
    for: "para" # Like in 'for 30 students'
    receive_code: "Posteriormente recibirá un código de desbloqueo con el fin de distribuirlo a sus estudiantes, el cual podrán usar para inscribirse en su grupo."
    free_trial: "¡Prueba gratuita para maestros!"
    get_access: "para obtener acceso individual a todos los cursos con propósitos de evaluación."
    questions: "¿Preguntas?"
    teachers_click: "Maestros Click Aquí"
    students_click: "Estudiantes Click Aquí"
    courses_on_coco: "Curso en CodeCombat"
    designed_to: "Los cursos están diseñados para presentar los conceptos de ciencia computacional mediante el uso del divertido y envolvente ambiente de CodeCombat. Los niveles de CodeCombat están organizados en torno a los temas principales para alentar el aprendizaje progresivo, durante el curso de 5 horas."
    more_in_less: "Aprenda más en menos tiempo"
    no_experience: "No se necesita experiencia de programación"
    easy_monitor: "Monitoree fácilmente el progreso del estudiante"
    purchase_for_class: "Adquirir un curso para toda su grupo. ¡Es fácil registrar a sus estudiantes!"
    see_the: "Vea la"
    more_info: "para más información."
    choose_course: "Elige tu Curso:"
    enter_code: "Introducir un código de desbloqueo para ingresar a una clase"
    enter_code1: "Introducir código de desbloqueo"
    enroll: "Inscribirse"
    pick_from_classes: "Elije de tus clases actuales"
    enter: "Entrar"
    or: "O"
    topics: "Tópicos"
    hours_content: "Horas de contenido:"
    get_free: "Obtenga curso GRATIS"
    enroll_paid: "Anotar estudiantes en cursos pagos."
    you_have1: "Tiene"
    you_have2: "matrículas pagadas no utilizadas" # {change}
    use_one: "Utilizar 1 matrícula pagada para" # {change}
    use_multiple: "Utilizar matrículas pagadas para los siguientes estudiantes:" # {change}
    already_enrolled: "ya matriculados"
    licenses_remaining: "licencias restantes:"
    insufficient_enrollments: "matrículas pagas insuficientes" # {change}
    get_enrollments: "Obtener Más Matrículas"
    change_language: "Cambiar idioma del curso"
    keep_using: "Seguir Usando"
    switch_to: "Cambiar a"
    greetings: "Saludos!"
    back_classrooms: "Volver a mis aulas"
    back_courses: "Volver a mis cursos"
    edit_details: "Editar detallesde clase"
    enrolled_courses: "matriculados en cursos pagos:"
    purchase_enrollments: "Comprar Matrículas" # {change}
    remove_student: "Quitar alumno"
    assign: "Asignar"
    to_assign: "para asignar cursos pagos."
#    student: "Student"
    teacher: "Maestro"
    complete: "Completado"
    none: "Ninguno"
    play_campaign_title: "Jugar Campaña"
    play_campaign_description: "Estas listo para dar el siguiente paso! Explora cientos de desafiantes niveles, aprende habilidades avanzadas de programación, y compite en arenas multijugador!"
    create_account_title: "Crea una Cuenta"
    create_account_description: "Registrate gratis con una cuenta CodeCombat y obten acceso a mas niveles, mas habilidades de programacion, y mas diversion!"
    preview_campaign_title: "Previsualizar campaña"
    preview_campaign_description: "Echa un vistazo a todo lo que CodeCombat tiene para ofrecer antes de registrarse con una cuenta GRATUITA."
    arena: "Arena"
    arena_soon_title: "Arena pronto disponible"
    arena_soon_description: "Estamos trabajando en una arena multijugador para las aulas para finales de"
    not_enrolled1: "No inscrito"
    not_enrolled2: "Preguntale a tu maestro para anotarte en el proximo curso."
    next_course: "Próximo curso"
    coming_soon1: "Próximamente"
    coming_soon2: "Estamos trabajando duro para hacer mas cursos para ti!"
    available_levels: "Niveles Disponibles"
    welcome_to_courses: "Aventureros, Bienvenidos a los Cursos!"
    ready_to_play: "Estas listo?"
    start_new_game: "Iniciar un Nuevo Juego"
    play_now_learn_header: "Juega y Aprende"
    play_now_learn_1: "Sintaxis básica para controlar a tu personaje"
    play_now_learn_2: "bucles while para resolver rompecabezas molestos"
    play_now_learn_3: "cadenas & variables para personalizar acciones"
    play_now_learn_4: "como vencer a un ogro (habilidades importantes en la vida!)"
    welcome_to_page: "¡Bienvenido a tu página de cursose!" # {change}
    completed_hoc: "¡Asombroso! ¡Has completado el curso de la hora de código!"
    ready_for_more_header: "Listo para mas? Juega el modo campaña!"
    ready_for_more_1: "Usa las gemas para desbloquear nuevos objetos!"
    ready_for_more_2: "Juega atravez de nuevos mundos y desafios"
    ready_for_more_3: "¡Aprendé todavía más programando!"
    saved_games: "Juegos Guardados"
    hoc: "Hora del código"
    my_classes: "Mis Clases" # {change}
    class_added: "Clase añadida satisfactoriamente!"
    view_levels: "ver niveles" # {change}
    join_class: "Unirse a clase"
#    join_class_2: "Join class"
    ask_teacher_for_code: "Preguntalé a tu profesor si tu tienes un código de CodeCombat! Si lo tiene, ingresalo debajo:"
    enter_c_code: "<Ingresar Código de la Clase>"
    join: "Unirse"
    joining: "Uniendose a claseJoining class"
    course_complete: "Curso completo"
    play_arena: "Jugar Arena"
#    view_project: "View Project"
    start: "Iniciar"
    last_level: "Último nivel" # {change}
    welcome_to_hoc: "Aventureros, bienvenidos a su Hora del Código!!"
    logged_in_as: "Logeado como:"
    not_you: "No eres tú?"
    welcome_back: "Hola aventurero, bienvenido nuevamente!"
    continue_playing: "Seguir jugando"
    more_options: "Másopciones:"
    option1_header: "Opción 1: Invitar estudiantes vía email" # {change}
    option1_body: "Se enviará automaticamente una invitación a los estudiantes para unirse a esta clase, y tendrán que crear una cuenta con un nombre de usuario y una contraseña." # {change}
    thank_you_pref: "Gracias por tu compra! Ahora puedes asignar"
    thank_you_suff: "más estudiantes a cursos pagos."
    return_to_class: "Regresar al aula"
    return_to_course_man: "Regresar a la administración del curso."
    students_not_enrolled: "estudiantes no matriculados"
    total_all_classes: "Total Por Todas las Clases"
    how_many_enrollments: "¿Cuántas matriculas pagas adicionales necesitas?" # {change}
    each_student_access: "Cada estudiante en una clase obtendrá acceso a los Cursos 2-4 una vez que esten matriculados en los cursos pagos. Puedes asignar cada curso a cada estudiante de forma individual."
    purchase_now: "Comprar Ahora"
    enrollments: "matrículas" # {change}
    remove_student1: "Quitar alumno"
    are_you_sure: "¿Estás seguro que quieres quitar este alumno de tu clase?"
    remove_description1: "El estudiante perderá acceso a esta aula y a sus clases asignadas. El progreso y la experiencia del juego NO se pierde, y el estudiante puede ser agregado de vuelta al aula en cualquier momento."
    remove_description2: "La matrícula paga activada no será devuelta."
    keep_student: "Mantener alumno"
    removing_user: "Removiendo usuario"
    to_join_ask: "Para ingresar a una clase, preguntale a tu maestro por un código de acceso."
    join_this_class: "Ingresar clase"
    enter_here: "<Ingresar el código aquí>"
    successfully_joined: "Ingresado exitosamente"
    click_to_start: "Click aquí para comenzar a hablar"
    my_courses: "Mis Cursos"
    classroom: "Aulas"
    use_school_email: "utilize su correo electrónico de la escuela si tiene uno"
    unique_name: "un nombre único, no uno que ya esté escogido"
    pick_something: "Escoge algo que recuerdes"
    class_code: "Código de acceso"
    optional_ask: "opcional - pregunta a tu maestro para que te de uno!"
    optional_school: "opcional - a qué escuela vas?"
    start_playing: "Comienza a Jugar"
    skip_this: "Saltar esto, Crearé una cuenta mas tarde!"
    welcome: "Bienvenido"
    getting_started: "Cómo empezar con los Cursos"
    download_getting_started: "Descargar Guía de Introducción [PDF]"
    getting_started_1: "Crea una nueva clase haciendo click en el botón verde 'Crear Nueva Clase' de más abajo."
    getting_started_2: "Una vez que creaste una clase, haz click en el botón azul 'Añadir Estudiantes'"
    getting_started_3: "Verás los progresos de los estudiantes más abajo cuando se registren e ingresen a tu clase."
    educator_wiki_pref: "O echa un vistazo a nuestra nieva"
    educator_wiki_mid: "wiki de educador"
    educator_wiki_suff: "busca en nuestra guía en línea."
    your_classes: "Tus Clases"
    no_classes: "Aún no hay clases!"
    create_new_class1: "crear nueva clase"
    available_courses: "Cursos Disponibles"
    unused_enrollments: "Matrículas no utilizadas disponibles:" # {change}
    students_access: "Todos los estudiantes obtienen acceso gratuito a Introducción a la Informática. Una matrícula por estudiante es necesaria para asignarles los cursos pagos de CodeCombat. Un solo estudiante no necesita múltiples matrículas para acceder a todos los cursos pagos." # {change}
    active_courses: "cursos activos"
    no_students: "Aún no hay alumnos!"
    add_students1: "añadir alumnos"
    view_edit: "ver/editar"
    students_enrolled: "estudiantes matriculados"
    students_assigned: "estudiantes asignados"
    length: "Duración:"
    subtitle: "Revisar guías del curso, soluciones y niveles." # Flat style redesign {change}
    changelog: "Ver los últimos cambios en los niveles del curso."
    select_language: "Seleccione lenguaje"
    select_level: "Seleccione nivel"
    play_level: "Juga Nivel"
    concepts_covered: "Conceptos Cubiertos"
    print_guide: "Guía Impresa (PDF)"
    view_guide_online: "Ver Guía En Línea(PDF)" # {change}
    grants_lifetime_access: "Otorgar derecho de acceso a todos los cursos."
    enrollment_credits_available: "Créditos de Inscripción Disponibles :" # {change}
    language_select: "Seleccionar Lenguaje" # ClassroomSettingsModal
    language_cannot_change: "El lenguaje no puede ser cambiado una vez que el estudiante ingreso a la clase."
    learn_p: "Aprender Python"
    learn_j: "Aprender JavaScript"
    avg_student_exp_label: "Promedio de la experiencia en programación del estudiante"
    avg_student_exp_desc: "Esto nos ayudará a entender como llevar el ritmo de los cursos."
    avg_student_exp_select: "Selecciona la mejor opción"
    avg_student_exp_none: "Sin experiencia - poca o ninguna experiencia"
    avg_student_exp_beginner: "Principiante - cierto grado de exposición o basado en bloque"
    avg_student_exp_intermediate: "Intermedio - un poco de experiencia con código tipeado"
    avg_student_exp_advanced: "Avanzado - amplia experiencia con código tipeado"
    avg_student_exp_varied: "Niveles Variados de Experiencia"
    student_age_range_label: "Rango de Edad del Estudiante"
    student_age_range_younger: "Menor que 6"
    student_age_range_older: "Mayor que 18"
    student_age_range_to: "a"
    create_class: "Crear Grupo"
    class_name: "Nombre de clase"
    teacher_account_restricted: "Tu cuenta es una cuenta de maestro, y no puedes acceder al contenido del estudiante." # {change}
#    account_restricted: "A student account is required to access this page."
#    update_account_login_title: "Log in to update your account"
#    update_account_title: "Your account needs attention!"
#    update_account_blurb: "Before you can access your classes, choose how you want to use this account."
#    update_account_current_type: "Current Account Type:"
#    update_account_account_email: "Account Email/Username:"
#    update_account_am_teacher: "I am a teacher"
#    update_account_keep_access: "Keep access to classes I've created"
#    update_account_teachers_can: "Teacher accounts can:"
#    update_account_teachers_can1: "Create/manage/add classes"
#    update_account_teachers_can2: "Assign/enroll students in courses"
#    update_account_teachers_can3: "Unlock all course levels to try out"
#    update_account_teachers_can4: "Access new teacher-only features as we release them"
#    update_account_teachers_warning: "Warning: You will be removed from all classes that you have previously joined and will not be able to play as a student."
#    update_account_remain_teacher: "Remain a Teacher"
#    update_account_update_teacher: "Update to Teacher"
#    update_account_am_student: "I am a student"
#    update_account_remove_access: "Remove access to classes I have created"
#    update_account_students_can: "Student accounts can:"
#    update_account_students_can1: "Join classes"
#    update_account_students_can2: "Play through courses as a student and track your own progress"
#    update_account_students_can3: "Compete against classmates in arenas"
#    update_account_students_can4: "Access new student-only features as we release them"
#    update_account_students_warning: "Warning: You will not be able to manage any classes that you have previously created or create new classes."
#    update_account_remain_student: "Remain a Student"
#    update_account_update_student: "Update to Student"
#    need_a_class_code: "You'll need a Class Code for the class you're joining:"
#    update_account_not_sure: "Not sure which one to choose? Email"
#    update_account_confirm_update_student: "Are you sure you want to update your account to a Student experience?"
#    update_account_confirm_update_student2: "You will not be able to manage any classes that you have previously created or create new classes. Your previously created classes will be removed from CodeCombat and cannot be restored."
#    instructor: "Instructor: "
#    youve_been_invited_1: "You've been invited to join "
#    youve_been_invited_2: ", where you'll learn "
#    youve_been_invited_3: " with your classmates in CodeCombat."
#    by_joining_1: "By joining "
#    by_joining_2: "will be able to help reset your password if you forget or lose it. You can also verify your email address so that you can reset the password yourself!"
#    sent_verification: "We've sent a verification email to:"
#    you_can_edit: "You can edit your email address in "
#    account_settings: "Account Settings"
#    select_your_hero: "Select Your Hero"
#    select_your_hero_description: "You can always change your hero by going to your Courses page and clicking \"Change Hero\""
#    select_this_hero: "Select this Hero"
#    current_hero: "Current Hero:"
#    change_hero: "Change Hero"
#    web_dev_language_transition: "All classes program in HTML / JavaScript for this course.  Classes that have been using Python will start with extra JavaScript intro levels to ease the transition.  Classes that are already using JavaScript will skip the intro levels."

  teacher:
#    course_solution: "Course Solution"
#    level_overview_solutions: "Level Overview and Solutions"
    teacher_dashboard: "Tablero del maestro" # Navbar
    my_classes: "Mis Clases" # {change}
    courses: "Cursos" # {change}
    enrollments: "Recursos" # {change}
    resources: "Resources"
    help: "Ayuda"
    students: "Estudiantes" # Shared
    language: "Lenguaje"
    edit_class_settings: "editar configuración de la clase"
    complete: "Completo"
    access_restricted: "Se requiere Actualización de la Cuenta"
    teacher_account_required: "Una cuenta de Maestro es requerida para acceder a este contenido."
    create_teacher_account: "Crear Cuenta de Maestro"
    what_is_a_teacher_account: "Qué es una Cuenta de Maestro?"
    teacher_account_explanation: "Una Cuenta de Maestro en CodeCombat da permiso a crear salones de clases, monitorear el progreso de los estudiantes mientras ellos trabajan a través de los cursos, manejar inscripciones y acceder a recursos para la creación de su plan de estudio." # {change}
    current_classes: "Clases Recientes"
    archived_classes: "Clases Archivadas"
    archived_classes_blurb: "Las Clases pueden ser archivadas para futuras referencias. Desarchiva una Clase para verla en la lista de Clases Recientes de nuevo."
    view_class: "ver clase"
    archive_class: "almacenar clase"
    unarchive_class: "desarchivar clase"
    unarchive_this_class: "desarchivar esta clase"
    no_students_yet: "Esta clase no tienes estudiantes todavía."
#    no_students_yet_view_class: "View class to add students."
#    try_refreshing: "(You may need to refresh the page)"
    add_students: "Agregar Estudiantes"
    create_new_class: "Crear una Nueva Clase"
    class_overview: "Resumen de la Clase" # View Class page
    avg_playtime: "Nivel medio de tiempo de juego"
    total_playtime: "Tiempo Total de juego"
    avg_completed: "Promedio de niveles completados"
    total_completed: "Total de niveles completados"
    created: "Creado"
    concepts_covered: "Conceptos cubiertos"
    earliest_incomplete: "Nivel incompleto más Reciente"
    latest_complete: "Último nivel completado"
    enroll_student: "Inscribir estudiante"
#    apply_license: "Apply License"
    course_progress: "Progreso del curso"
#    not_applicable: "N/A"
    edit: "editar"
#    edit_2: "Edit"
    remove: "eliminar"
    latest_completed: "Último Completado" # {change}
    sort_by: "Ordenado por"
    progress: "Progreso"
    completed: "Completado"
    started: "Iniciado"
    click_to_view_progress: "click para ver el progreso"
    no_progress: "Sin progreso"
    select_course: "Selecciona el curso a ver"
#    students_not_assigned: "Students who have not been assigned {{courseName}}"
    course_overview: "Resumen del Curso"
    copy_class_code: "Copiar código de la Clase"
    class_code_blurb: "Nuevos estudiantes pueden entrar a este código de la clase en su tablero o visitar codecombat.com/courses para unirse a la clase." # {change}
    copy_class_url: "Copia la URL de la Clase"
    class_join_url_blurb: "Nuevos estudiantes pueden visitar esta URL mientras esten logeados para unirse a la clase." # {change}
    add_students_manually: "Agregar Estudiantes Manualmente" # {change}
    bulk_assign: "Mayor a asignar"
#    assigned_msg_1: "{{numberAssigned}} students were assigned {{courseName}}."
#    assigned_msg_2: "{{numberEnrolled}} licenses were applied."
#    assigned_msg_3: "You now have {{remainingSpots}} available licenses remaining."
#    assign_course: "Assign Course"
#    not_assigned_modal_title: "Courses were not assigned"
#    not_assigned_modal_body_1: "You do not have enough licenses available to assign additional Courses to all {{selected}} selected students."
#    not_assigned_modal_body_2: "You only have {{totalSpotsAvailable}} licenses available ({{unenrolledStudents}} students did not have an active license)."
#    not_assigned_modal_body_3: "Please select fewer students, or reach out to {{email}} for assistance."
    assign_to_selected_students: "Asignar a los Estudiantes Seleccionados"
    assigned: "Asignado"
    enroll_selected_students: "Inscribir Estudiantes Seleccionados"
    no_students_selected: "No fueron seleccionados estudiantes."
    guides_coming_soon: "¡Guías próximamente!" # Courses
    show_students_from: "Muestra estudiantes de" # Enroll students modal
#    apply_licenses_to_the_following_students: "Apply Licenses to the Following Students"
#    students_have_licenses: "The following students already have licenses applied:"
    all_students: "Todos los estudiantes"
#    apply_licenses: "Apply Licenses"
    not_enough_enrollments: "No tienes suficientes Inscripciones disponibles." # {change}
#    enrollments_blurb: "Students are required to have a license to access any content after the first course."
    credits_available: "Cŕeditos Disponibles" # {change}
    total_unique_students: "Total de Estudiantes Únicos" # {change}
    total_enrolled_students: "Total de Estudiantes Inscritos" # {change}
    unenrolled_students: "Estudiantes no Inscritos"
    add_enrollment_credits: "Agregar Cŕeditos de Inscripción" # {change}
    purchasing: "Adquiriendo..."
    purchased: "Adquirido!"
    purchase_now: "Adquirir Ahora"
    how_to_enroll: "¿Cómo inscribir estudiantes?"
#    how_to_apply_licenses: "How to Apply Licenses"
    bulk_pricing_blurb: "Quieres comprar más de 25 cuentas de estudiante? Contáctanos para hablar del siguiente paso."
    total_unenrolled: "Total de Estudiantes no Inscritos"
    export_student_progress: "Exportar el Progreso del Estudiante(CSV)"
#    send_email_to: "Send Recover Password Email to:"
#    email_sent: "Email sent"
#    send_recovery_email: "Send recovery email"
#    enter_new_password_below: "Enter new password below:"
#    change_password: "Change Password"
#    changed: "Changed"
#    available_credits: "Available Licenses"
#    pending_credits: "Pending Licenses"
#    credits: "licenses"
#    start_date: "start date:"
#    end_date: "end date:"
#    get_enrollments_blurb: " We'll help you build a solution that meets the needs of your class, school or district."
#    how_to_apply_licenses_blurb_1: "When a teacher assigns a course to a student for the first time, we’ll automatically apply a license. Use the bulk-assign dropdown in your classroom to assign a course to selected students:"
#    how_to_apply_licenses_blurb_2: "Can I still apply a license without assigning a course?"
#    how_to_apply_licenses_blurb_3: "Yes — go to the License Status tab in your classroom and click \"Apply License\" to any student who does not have an active license."
#    request_sent: "Request Sent!"
#    enrollment_status: "Enrollment Status"
#    license_status: "License Status"
#    status_expired: "Expired on {{date}}"
#    status_not_enrolled: "Not Enrolled"
#    status_enrolled: "Expires on {{date}}"
#    select_all: "Select All"
#    projects: "Projects"
#    project: "Project"
#    view_student_project: "View Student Project"
#    view_arena_ladder: "View Arena Ladder"
#    resource_hub: "Resource Hub"
#    getting_started: "Getting Started"
#    educator_faq: "Educator FAQ"
#    educator_faq_desc: "Frequently asked questions about using CodeCombat in your classroom or school."
#    teacher_getting_started: "Teacher Getting Started Guide"
#    teacher_getting_started_desc: "New to CodeCombat? Download this Teacher Getting Started Guide to set up your account, create your first class, and invite students to the first course."
#    student_getting_started: "Student Quick Start Guide"
#    student_getting_started_desc: "You can distribute this guide to your students before starting CodeCombat so that they can familiarize themselves with the code editor. This guide can be used for both Python and JavaScript classrooms."
#    cs1: "Introduction to Computer Science"
#    cs2: "Computer Science 2"
#    cs3: "Computer Science 3"
#    cs1_syntax_python: "Course 1 Python Syntax Guide"
#    cs1_syntax_python_desc: "Cheatsheet with references to common Python syntax that students will learn in Introduction to Computer Science."
#    cs1_syntax_javascript: "Course 1 JavaScript Syntax Guide"
#    cs1_syntax_javascript_desc: "Cheatsheet with references to common JavaScript syntax that students will learn in Introduction to Computer Science."
#    coming_soon: "Additional guides coming soon!"
#    engineering_cycle_worksheet: "Engineering Cycle Worksheet"
#    engineering_cycle_worksheet_desc: "Use this worksheet to teach students the basics of the engineering cycle: Assess, Design, Implement and Debug. Refer to the completed example worksheet as a guide."
#    engineering_cycle_worksheet_link: "View example"
#    progress_journal: "Progress Journal"
#    progress_journal_desc: "Encourage students to keep track of their progress via a progress journal."
#    cs1_curriculum: "Introduction to Computer Science - Curriculum Guide"
#    cs1_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 1."
#    cs2_curriculum: "Computer Science 2 - Curriculum Guide"
#    cs2_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 2."
#    cs3_curriculum: "Computer Science 3 - Curriculum Guide"
#    cs3_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 3."
#    cs1_pairprogramming: "Pair Programming Activity"
#    cs1_pairprogramming_desc: "Introduce students to a pair programming exercise that will help them become better listeners and communicators."
#    unlock_resources: "Unlock more resources!"
#    unlock_resources_desc: "Gain access to additional guides by adding student licenses to your account. Request a demo today to get started."
#    request_demo: "Request Demo"
#    student_overview: "Overview"
#    student_email: "Student Email"
#    no_email: "Student has no email address set."
#    student_profile: "Student Profile"
#    playtime_detail: "Playtime Detail"
#    student_completed: "Student Completed"
#    student_in_progress: "Student in Progress"
#    class_average: "Class Average"
#    not_assigned: "has not been assigned the following courses"
#    playtime_axis: "Playtime in Seconds"
#    levels_axis: "Levels in"
#    student_state: "How is"
#    student_state_2: "doing?"
#    student_good: "is doing well in"
#    student_good_detail: "This student is keeping pace with the class."
#    student_warn: "might need some help in"
#    student_warn_detail: "This student might need some help with new concepts that have been introduced in this course."
#    student_great: "is doing great in"
#    student_great_detail: "This student might be a good candidate to help other students working through this course."

#  sharing:
#    game: "Game"
#    webpage: "Webpage"
#    your_students_preview: "Your students will click here to see their finished projects! Unavailable in teacher preview."
#    unavailable: "Link sharing not available in teacher preview."
#    share_game: "Share This Game"
#    share_web: "Share This Webpage"
#    victory_share_prefix: "Share this link to invite your friends & family to"
#    victory_share_game: "play your game level"
#    victory_share_web: "view your webpage"
#    victory_share_suffix: "."
#    victory_course_share_prefix: "This link will let your friends & family"
#    victory_course_share_game: "play the game"
#    victory_course_share_web: "view the webpage"
#    victory_course_share_suffix: "you just created."
#    copy_url: "Copy URL"

#  game_dev:
#    creator: "Creator"

#  web_dev:
#    image_gallery_title: "Image Gallery"
#    select_an_image: "Select an image you want to use"
#    scroll_down_for_more_images: "(Scroll down for more images)"
#    copy_the_url: "Copy the URL below"
#    copy_the_url_description: "Useful if you want to replace an existing image."
#    copy_the_img_tag: "Copy the <img> tag"
#    copy_the_img_tag_description: "Useful if you want to insert a new image."
#    copy_url: "Copy URL"
#    copy_img: "Copy <img>"
#    how_to_copy_paste: "How to Copy/Paste"
#    copy: "Copy"
#    paste: "Paste"
#    back_to_editing: "Back to Editing"

  classes:
    archmage_title: "Archimago"
    archmage_title_description: "(Desarrollador)"
    archmage_summary: "Si eres un programador interesado en juegos educativos, conviértete en un archimago y ayúdanos a construir CodeCombat!"
    artisan_title: "Artesano"
    artisan_title_description: "(Constructor de Niveles)"
    artisan_summary: "Construye y comparte niveles para que tú y tus amigos jueguen. Conviértete en un Artesano y aprende el arte the enseñar a los demás a programar."
    adventurer_title: "Aventurero"
    adventurer_title_description: "(Probador de Niveles)"
    adventurer_summary: "Consigue nuestros nuevos niveles| (even our subscriber content) for free one week early and help us work out bugs before our public release."
    scribe_title: "Escriba"
    scribe_title_description: "(Editor de Artículos)"
    scribe_summary: "Buen código necesita buena documentación. Escribe, edita y mejora los documentos leídos por millones de jugadores en el mundo."
    diplomat_title: "Diplomático"
    diplomat_title_description: "(Traductor)"
    diplomat_summary: "CodeCombat está traducido a más de 45 idiomas por nuestros diplomáticos. Ayúdanos y contribuye con las traducciones."
    ambassador_title: "Embajador"
    ambassador_title_description: "(Soporte)"
    ambassador_summary: "Ayuda a responder las preguntas de los usuarios del foro. Nuestros Embajadores representan CodeCombat en todo el mundo."
    teacher_title: "Maestro"

  editor:
    main_title: "Editor de CodeCombat"
    article_title: "Editor de Artículo"
    thang_title: "Editor de Tiliches"
    level_title: "Editor de Nivel"
#    course_title: "Course Editor"
    achievement_title: "Editor de logros"
    poll_title: "Editor de Encuesta"
    back: "Atrás"
    revert: "Revertir"
    revert_models: "Revertir Modelos"
    pick_a_terrain: "Elije un Terreno"
    dungeon: "Calabozo"
    indoor: "Interior"
    desert: "Desierto"
    grassy: "Herboso"
    mountain: "Montaña"
    glacier: "Glaciar"
    small: "Pequeño"
    large: "Grande"
    fork_title: "Fork de Nueva Versión"
    fork_creating: "Creando Fork..."
    generate_terrain: "Generar terreno"
    more: "Más"
    wiki: "Wiki"
    live_chat: "Chat en vivo"
    thang_main: "Principal"
    thang_spritesheets: "Hojas de figuras( para animaciones )"
    thang_colors: "Colores"
    level_some_options: "¿Algunas opciones?"
    level_tab_thangs: "Tiliches"
    level_tab_scripts: "Scripts"
    level_tab_components: "Componentes"
    level_tab_systems: "Sistemas"
    level_tab_docs: "Documentación"
    level_tab_thangs_title: "Tiliches Actuales"
    level_tab_thangs_all: "Todo"
    level_tab_thangs_conditions: "Condiciones Iniciales"
    level_tab_thangs_add: "Agregar Thangs"
    level_tab_thangs_search: "Buscar Thangs"
    add_components: "Agregar Componentes"
    component_configs: "Configuraciones del Componente"
    config_thang: "Doble clic para configurar un Tiliche"
    delete: "Borrar"
    duplicate: "Duplicar"
    stop_duplicate: "Parar de Duplicar"
    rotate: "Rotar"
    level_component_tab_title: "Componentes Actuales"
    level_component_btn_new: "Crear Nuevo Componente"
    level_systems_tab_title: "Sistemas Actuales"
    level_systems_btn_new: "Crear Nuevo Sistema"
    level_systems_btn_add: "Agregar Sistema"
    level_components_title: "Regresar a todos los Tiliches"
    level_components_type: "Tipo"
    level_component_edit_title: "Editar Componente"
    level_component_config_schema: "Config Schema"
    level_system_edit_title: "Editar Sistema"
    create_system_title: "Crear Nuevo Sistema"
    new_component_title: "Crear Nuevo Componente"
    new_component_field_system: "Sistema"
    new_article_title: "Crear un Nuevo Artículo"
    new_thang_title: "Crear un Nuevo tipo de Tiliche"
    new_level_title: "Crear un Nuevo Nivel"
    new_article_title_login: "Ingresa para Crear un Nuevo Artículo"
    new_thang_title_login: "Ingresa para crear un nuevo tipo de Tiliche"
    new_level_title_login: "Ingresa para Crear un Nuevo Nivel"
    new_achievement_title: "Crear un Nuevo Logro"
    new_achievement_title_login: "Ingresa para Crear un Nuevo Logro"
    new_poll_title: "Crear una nueva encuesta"
    new_poll_title_login: "Ingresa para crear una nueva encuesta"
    article_search_title: "Buscar Artículos aquí"
    thang_search_title: "Buscar tipos de Tiliche aquí"
    level_search_title: "Buscar Niveles aquí"
    achievement_search_title: "Buscar logros"
    poll_search_title: "Buscar Encuesta"
    read_only_warning2: "Nota: no puedes guardar ediciones aquí, porque no estas logueado."
    no_achievements: "No hay logros agregados en este nivel por ahora."
    achievement_query_misc: "Objetivo clave de misceláneo"
    achievement_query_goals: "Objetivo clave de los objetivos de nivel"
    level_completion: "Nivel Completado"
    pop_i18n: "Poblar I18N"
    tasks: "Tareas"
    clear_storage: "Borrar tus cambios locales"
    add_system_title: "Agregar Sistemas al Nivel"
    done_adding: "Finalizar"

  article:
    edit_btn_preview: "Vista previa"
    edit_article_title: "Editar Artículo"

  polls:
    priority: "Prioridad"

  contribute:
    page_title: "Contribuyendo"
    intro_blurb: "CodeCombat es 100% open source! Cientos de jugadores dedicados nos han ayudado a contruir el juego. Únete y escribe el siguiente capítulo de la misión de CodeCombat de enseñar al mundo a programar!"
    alert_account_message_intro: "¡Hola!"
    alert_account_message: "Para suscribirte para los correos, necesitas ingresar primero."
    archmage_introduction: "Una de las mejores partes de hacer juegos es que sintetizan muchas cosas diferentes. Gráficas, sonido, redes, redes sociales y muchos aspectos comunes de programación, desde manejo de bases de datos y administración de servidores, hasta trabajar en el diseño y construcción de interfaces. Hay mucho para hacer, y si eres un programador con experiencia con el deseo de ingresar en el meollo del asunto de CodeCombat, esta clase puede ser para ti. Nos encantaría contar con tu ayuda para construir el mejor juego de programación."
    class_attributes: "Atributos de Clase"
    archmage_attribute_1_pref: "Conocimiento en "
    archmage_attribute_1_suf: ", o un deseo de aprender. La mayor parte de nuestro código está en este lenguaje. Si eres un fan de Python o Ruby, te sentirás en casa. Es Javascript, pero con un mejor syntax."
    archmage_attribute_2: "Alguna experiencia programando e iniciativa personal. Te ayudaremos a orientarte, pero no podemos perder mucho tiempo entrenando."
    how_to_join: "Unirse:"
    join_desc_1: "¡Cualquiera puede unirse! Sólo checa nuestro  "
    join_desc_2: "para comenzar, y pon un check abajo para marcarte como un valiente Archimago y conseguir las últimas noticias por email. ¿Quieres chatear sobre qué hacer o cómo involucrarte más? "
    join_desc_3: ", o encuéntranos en "
    join_desc_4: "y ahí empezaremos!"
    join_url_email: "Escríbenos"
    join_url_slack: "Canal de Slack"
    archmage_subscribe_desc: "Obten correos de nuevas oportunidades y anuncios."
    artisan_introduction_pref: "¡Debemos construir niveles adicionales! La gente ruega por más contenido, y podemos hacer tanto por nosotros mismos. De momento tu estación de trabajo es nivel 1 ; Nuestro editor de niveles es apenas útil incluso para sus creadores, así que sea cauteloso. Si tuviera visiones de campañas apareciendo para ciclos for"
    artisan_introduction_suf: ", entonces esta lase es ideal para ti."
    artisan_attribute_1: "Cualquier experiencia creando contenido similar estaría bien, como por ejemplo el editor de niveles de Blizzard. ¡Aunque no es necesaria!"
    artisan_attribute_2: "Un anhelo de hacer un montón de pruebas e iteraciones. Para hacer buenos niveles necesitas mostrárselos a otros y mirar como juegan, además de estar preparado para encontrar los fallos a reparar."
    artisan_attribute_3: "Por el momento, la resistencia va a la par con el Aventurero. Nuestro editor de niveles está a un nivel de desarrollo temprano y puede ser muy frustrante usarlo. ¡Estás advertido!"
    artisan_join_desc: "Sigue las siguientes indicaciones para usar el editor de niveles. Tómalo o déjalo:"
    artisan_join_step1: "Lee la documentación."
    artisan_join_step2: "Crea un nuevo nivel y explora los niveles existentes."
    artisan_join_step3: "Busca nuestra sala pública de Slack en busca de ayuda."
    artisan_join_step4: "Publica tus niveles en el foro para recibir comentarios críticos."
    artisan_subscribe_desc: "Recibe correos sobre actualizaciones del editor de niveles y anuncios."
    adventurer_introduction: "Hablemos claro sobre tu papel: eres el tanque. Vas a recibir fuertes daños. Necesitamos gente para probar nuestros flamantes niveles y ayudar a mejorarlos. El dolor será enorme; hacer buenos juegos es un proceso largo y nadie lo consigue a la primera. Si puedes resistir y tener una puntuación alta en resistencia, entonces esta clase es para ti."
    adventurer_attribute_1: "Estar sediento de conocimientos. Quieres aprender a programar y nosotros queremos enseñarte a hacerlo. Aunque en este caso es más probable que seas tú el que esté haciendo la mayor parte de la enseñanza."
    adventurer_attribute_2: "Carismático. Se amable pero claro a la hora de desglosar qué necesita ser mejorado y sugiere de qué formas podría hacerse."
    adventurer_join_pref: "Reúnete con (¡o recluta!) un Artesano y trabaja con ellos, o marca la casilla de abajo para recibir un correo cuando haya nuevos niveles para probar. También publicaremos en nuestras redes nuevos niveles para revisar"
    adventurer_forum_url: "nuestro foro"
    adventurer_join_suf: "así que si prefieres estar informado en esa forma, ¡crea una cuenta allí!"
    adventurer_subscribe_desc: "Recibe correos cuando haya nuevos niveles para testar."
    scribe_introduction_pref: "CodeCombat no será solo un montón de niveles. También será una fuente de conocimientos, una wiki de conceptos de programación a la que los niveles se engancharan. De esa forma, en lugar de que cada Artesano tenga que describir en detalle qué es un operador de comparación, podrá simplemente enlazar el nivel al Artículo que los describe y que ya ha sido escrito para edificación del jugador. Algo en la línea de lo que la "
    scribe_introduction_url_mozilla: "Mozilla Developer Network"
    scribe_introduction_suf: " ha construido. Si tu idea de diversión es articular los conceptos de la programación de una forma sencilla, entonces esta clase es para ti."
    scribe_attribute_1: "Habilidad a la hora de escribir es casi todo lo que necesitas. No solo dominar la gramática y la ortografía sino también expresar ideas complicadas a los demás de forma sencilla."
    contact_us_url: "Escribenos un correo electrónico" # {change}
    scribe_join_description: "cuéntanos más sobre ti, tu experiencia en el mundo de la programación y sobre qué cosas te gustaría escribir. ¡Y continuaremos a partir de ahí!"
    scribe_subscribe_desc: "Recibe correos sobre anuncios de redacción de Artículos."
    diplomat_introduction_pref: "Así, si hemos aprendido algo desde el "
    diplomat_launch_url: "lanzamiento en octubre"
    diplomat_introduction_suf: "hay un interés considerable en CodeCombat en otros paises, ¡especialmente Brasil! Estamos formando un cuerpo de traductores con ganas de traducir un grupo de palabras tras otro para hacer CodeCombat tan accesible para todo el mundo como sea posible. Si quieres recibir avances de próximos contenidos y quieres poner esos niveles a disposición de los que comparten tu idioma tan pronto como sea posible, entonces esta Clase es para ti."
    diplomat_attribute_1: "Fluidez con el ingles y el lenguaje al que quieras traducir. Cuando de transmitir ideas complejas se trata, ¡es importante tener grandes conocimientos de ambas!"
    diplomat_i18n_page_prefix: "Puedes traducir nuestros niveles yendo a nuestra"
    diplomat_i18n_page: "página de traducciones"
    diplomat_i18n_page_suffix: ", o en nuestra interfaz y sitio web en GitHub."
    diplomat_join_pref_github: "Encuentra el fichero local de tu idioma "
    diplomat_github_url: "en GitHub"
    diplomat_join_suf_github: ", edítalo online, y solicita que sea revisado. Además, marca la casilla de abajo para mantenerte informado en nuevos progresos en Internacionalización."
    diplomat_subscribe_desc: "Recibe correos sobre nuevos niveles y desarrollos para traducir."
    ambassador_introduction: "Esta es una comunidad en construcción y tú eres parte de las conexiones. Tenemos chat Olark, correos electrónicos y las redes sociales con una gran cantidad de personas con quienes hablar, ayudar a familiarizarse con el juego y aprender. Si quieres ayudar a la gente a que se involucre, se divierta, y tenga buenas sensaciones sobre CodeCombat y hacia dónde vamos, entonces esta clase es para ti."
    ambassador_attribute_1: "Habilidades de comunicación. Ser capaz de identificar los problemas que los jugadores están teniendo y ayudarles a resolverlos. Además, mantener al resto de nosotros informados sobre lo que los jugadores están diciendo, lo que les gusta, lo que no ¡y de lo que quieren más!"
    ambassador_join_desc: "cuéntanos más sobre ti, que has hecho y qué estarías interesado en hacer. ¡Y continuaremos a partir de ahí!"
    ambassador_join_note_strong: "Nota"
    ambassador_join_note_desc: "Una de nuestras principales prioridades es construir un modo multijugador donde los jugadores con mayores dificultades a la hora de resolver un nivel, puedan invocar a los magos más avanzados para que les ayuden. Será una buena manera de que los Embajadores puedan hacer su trabajo. ¡Te mantendremos informado!"
    ambassador_subscribe_desc: "Recibe correos sobre actualizaciones de soporte y desarrollo del multijugador."
    teacher_subscribe_desc: "Obtener actulizaciones y anuncios para maestros en su correo electrónico."
    changes_auto_save: "Los cambios son guardados automáticamente cuando marcas las casillas de verificación."
    diligent_scribes: "Nuestros diligentes Escribas:"
    powerful_archmages: "Nuestros poderosos Archimagos:"
    creative_artisans: "Nuestros creativos Artesanos:"
    brave_adventurers: "Nuestros bravos Aventureros:"
    translating_diplomats: "Nuestros políglotas Diplomáticos:"
    helpful_ambassadors: "Nuestros amables Embajadores:"

  ladder:
    please_login: "Por favor inicia sesión antes de jugar una partida de clasificación."
    my_matches: "Mis Partidas"
    simulate: "Simular"
    simulation_explanation: "¡Simulando tus juegos puedes mejorar tu posición más rápido!"
    simulation_explanation_leagues: "Principalmente ayudarás a simular juegos para jugadores aliados en tus clanes y cursos."
    simulate_games: "¡Simular Juegos!"
    games_simulated_by: "Juegos simulados por ti:"
    games_simulated_for: "Juegos simulados para ti:"
    games_in_queue: "Juegos actualmente en cola:"
    games_simulated: "Juegos simulados"
    games_played: "Juegos jugados"
    ratio: "Proporción"
    leaderboard: "Tabla de Posiciones"
    battle_as: "Combate como "
    summary_your: "Tus "
    summary_matches: "Partidas - "
    summary_wins: " Ganadas, "
    summary_losses: " Perdidas"
    rank_no_code: "Sin Código Nuevo para Clasificar"
    rank_my_game: "¡Clasifica Mi Juego!"
    rank_submitting: "Enviando..."
    rank_submitted: "Enviado para Clasificación"
    rank_failed: "Fallo al Clasificar"
    rank_being_ranked: "Juego Siendo Clasificado"
    rank_last_submitted: "Presentado"
    help_simulate: "¿Ayudar simulando juego?"
    code_being_simulated: "Tu nuevo código está siendo simulado por otros jugadores para clasificación. Esto se refrescará a medida que vengan nuevas partidas."
    no_ranked_matches_pre: "Sin partidas clasificadas para el "
    no_ranked_matches_post: " equipo! Juega en contra de algunos competidores y luego vuelve aquí para ver tu juego clasificado."
    choose_opponent: "Escoge un Oponente"
    select_your_language: "Selecciona tu idioma"
    tutorial_play: "Juega el Tutorial"
    tutorial_recommended: "Recomendado si nunca has jugado antes"
    tutorial_skip: "Saltar Tutorial"
    tutorial_not_sure: "¿No estás seguro de que sucede?"
    tutorial_play_first: "Juega el Tutorial primero."
    simple_ai: "IA Simple"
    warmup: "Calentamiento"
    friends_playing: "Amigos Jugando"
    log_in_for_friends: "Ingresa para jugar con tus amigos!"
    social_connect_blurb: "Conectate y juega contra tus amigos!"
    invite_friends_to_battle: "Invita a tus amigos para que se unan a la Batalla!"
    fight: "Pelea!"
    watch_victory: "Observa tu Victoria"
    defeat_the: "Derrota a"
    watch_battle: "Mirar la batalla"
    tournament_started: ", iniciado"
    tournament_ends: "Final de Torneo"
    tournament_ended: "Finalizó el Torneo"
    tournament_rules: "Reglas del Torneo"
    tournament_blurb: "Escribe código, recolecta oro, arma ejercitos, aplasta adversarios, gana premios, y asciende en tu carrera por $40,000 en el Torneo Codicia! Echa un vistazo a los detalles"
    tournament_blurb_criss_cross: "Gana apuestas, construye caminos, burla tus oponentes, agarra gemas, y asciende tu perfil en nuestro torneo Cruzado! Echa un vistazo a los detalles"
    tournament_blurb_zero_sum: "Suelta tus habilidades de código en recolección de oro y tácticas de batalla en este partido espejo alpino entre el hechicero rojo y el hechicero azul. El torneo comenzó el Viernes, 27 de Marzo y se extenderá hasta el Lunes, 6 de Abril a las 5PM PDT. Compite por la diversión y la gloria ! Echa un vistazo a los detalles:"
    tournament_blurb_ace_of_coders: "¡Lucha en el glaciar congelado en este encuentro con estilo dominación en espejo! El torneo comienza el Miércoles 16 de Septiembre, y se ejecutará hasta el Miércoles 14 de Octubre hasta las 5PM PDT. Revisa los detalles"
    tournament_blurb_blog: "en nuestro blog"
    rules: "Reglas"
    winners: "Ganadores"
    league: "Liga"
    red_ai: "IA Roja" # "Red AI Wins", at end of multiplayer match playback
    blue_ai: "IA Azul"
    wins: "Gana" # At end of multiplayer match playback
    humans: "Rojo" # Ladder page display team name
    ogres: "Azul"

  user:
    stats: "Estados"
    singleplayer_title: "Nivel un jugador"
    multiplayer_title: "Niveles multijugador"
    achievements_title: "Logros"
    last_played: "Último jugado"
    status: "Estado"
    status_completed: "Completo"
    status_unfinished: "Incompleto"
    no_singleplayer: "No hay juegos para un jugador todavía."
    no_multiplayer: "No hay juegos multijugador todavía."
    no_achievements: "Sin Logros todavía."
    favorite_prefix: "Idioma favorito "
    favorite_postfix: "."
    not_member_of_clans: "No eres miembro de ningún clan todavía."

  achievements:
    last_earned: "Último Ganado"
    amount_achieved: "Cantidad"
    achievement: "Logros"
    current_xp_prefix: ""
    current_xp_postfix: " en total"
    new_xp_prefix: ""
    new_xp_postfix: " ganado"
    left_xp_prefix: ""
    left_xp_infix: " hasta el nivel "
    left_xp_postfix: ""

  account:
    payments: "Pagos"
    prepaid_codes: "Códigos Prepagados"
    purchased: "Comprado"
    subscription: "Suscripción"
    invoices: "Facturas"
    service_apple: "Apple"
    service_web: "Web"
    paid_on: "Pagado en"
    service: "Servicio"
    price: "Precio"
    gems: "Gemas"
    active: "Activo"
    subscribed: "Suscrito"
    unsubscribed: "Desuscrito"
    active_until: "Activo Hasta"
    cost: "Costo"
    next_payment: "Próximo Pago"
    card: "Tarjeta"
    status_unsubscribed_active: "No estas suscrito y no se te cobrará, pero tu cuenta está activa por ahora."
    status_unsubscribed: "¡Obtén acceso a nuevos niveles, héroes, items y gemas extras con la suscripción a CodeCombat!"
#    not_yet_verified: "Not yet verified."
#    resend_email: "Resend email"
#    email_sent: "Email sent! Check your inbox."
#    verifying_email: "Verifying your email address..."
#    successfully_verified: "You've successfully verified your email address!"
#    back_to_student_page: "Go back to student things"
#    back_to_teacher_page: "Go to My Classes"
#    back_to_game: "Go play some more levels!"
#    verify_error: "Something went wrong when verifying your email :("

  account_invoices:
    amount: "Cantidad en dólares."
    declined: "La tarjeta fue rechazada."
    invalid_amount: "Por favor ingrese cantidad en dólares."
    not_logged_in: "Ingresate o crea una cuenta para acceder a las facturas."
    pay: "Pagar Factura"
    purchasing: "Comprando..."
    retrying: "Error de Servidor, reintentando..."
    success: "Listo, fue cobrado. Gracias!"

  account_prepaid:
    purchase_code: "Adquirir un Código de Suscripción"
    purchase_code1: "Los códigos de suscripción pueden ser canjeados para agregar tiempo de suscripción premium para una o más cuentas CodeCombat."
    purchase_code2: "Cada cuenta CodeCombat puede canjear una sola vez un Código de Suscripción en particular."
    purchase_code3: "Los meses del Código de Suscripción serán agregados al final de la suscripción existente de la cuenta."
    users: "Usuarios"
    months: "Meses"
    purchase_total: "Total"
    purchase_button: "Enviar Adquisición"
    your_codes: "Tus Códigos:"
    redeem_codes: "Reclamar un Código de Suscripción"
    prepaid_code: "Código Prepagado"
    lookup_code: "Buscar código prepagado"
    apply_account: "Aplicara tu cuenta"
    copy_link: "Puedes copiarl el enlace del código y enviarlo a alguien."
    quantity: "Cantidad"
    redeemed: "Reclamado"
    no_codes: "¡Aún sin códigos!"
    you_can1: "Puedes"
    you_can2: "comprar un código prepagado"
    you_can3: "que puede ser aplicado a tu propia cuenta o regalado a otros."

  coppa_deny:
    text1: "¿No puedes esperar para aprender a programar?"
    text2: "Pide a tus papás que creen una cuenta por ti!" # {change}
    close: "Cerrar ventana"

  loading_error:
    could_not_load: "Error cargando del servidor"
    connection_failure: "Fallo de conexión."
    connection_failure_desc: "Al parecer no estás conectado a internet! Revisa tu conección de red y actualiza la página."
    login_required: "Login Requerido"
    login_required_desc: "Necesitas iniciar sesión para acceder a esta página."
    unauthorized: "Necesitas acceder. ¿Tienes desabilitadas las cookies?"
    forbidden: "No tienes los permisos."
    forbidden_desc: "Oh no, no hay nada que podemos mostrarte aquí! Asegurate que has iniciado sesión en la cuenta correcta, o visita uno de los siguientes enlaces para regresar a programar!"
    not_found: "No encontrado."
    not_found_desc: "Mmm, no hay nada aquí. Visita uno de los siguientes enlaces para regresar a programar!"
    not_allowed: "Método no permitido."
    timeout: "Expiró el tiempo del servidor." # {change}
    conflict: "Conflicto de recurso."
    bad_input: "Mala entrada."
    server_error: "Error de servidor."
    unknown: "Error desconocido." # {change}
    error: "ERROR"
    general_desc: "Ocurrió un errór, probablemente es tu culpa. Espera un poco y luego refresca la página, o visíta uno de los siguientes enlaces para regresar a programar!"

  resources:
    level: "Nivel"
    patch: "Parche"
    patches: "Parches"
    system: "Sistema"
    systems: "Sistemas"
    component: "Componente"
    components: "Componentes"
    hero: "Heróe"
    campaigns: "Campañas"

  concepts:
    advanced_strings: "Cadenas - Avanzado"
    algorithms: "Algoritmos"
    arguments: "Argumentos"
    arithmetic: "Aritmética"
    arrays: "Arreglos"
    basic_syntax: "Sintaxis Básica"
    boolean_logic: "Lógica Booleana"
    break_statements: "Sentencias Break"
    classes: "Clases"
    continue_statements: "Sentencias Continue"
    for_loops: "Bucle For"
    functions: "Funciones"
    graphics: "Gráficos"
    if_statements: "Sentencias If"
    input_handling: "Manejo de Entradas"
    math_operations: "Operaciones Matemáticas"
    object_literals: "Objetos Literales"
    parameters: "Parámetros"
    strings: "Cadenas"
    variables: "Variables"
    vectors: "Vectores"
    while_loops: "Bucles" # {change}
    recursion: "Recursividad"
#    basic_html: "Basic HTML" # TODO: these web-dev concepts will change, don't need to translate
#    basic_css: "Basic CSS"
#    basic_web_scripting: "Basic Web Scripting"
#    intermediate_html: "Intermediate HTML"
#    intermediate_css: "Intermediate CSS"
#    intermediate_web_scripting: "Intermediate Web Scripting"
#    advanced_html: "Advanced HTML"
#    advanced_css: "Advanced CSS"
#    advanced_web_scripting: "Advanced Web Scripting"
#    jquery: "jQuery"
#    bootstrap: "Bootstrap"

  delta:
    added: "Agregado"
    modified: "Modificado"
    not_modified: "No Modificado"
    deleted: "Borrado"
    moved_index: "Índice movido"
    text_diff: "Diferir Texto"
    merge_conflict_with: "UNIR CONFLICTO CON"
    no_changes: "Sin cambios"

  legal:
    page_title: "Información legal"
    opensource_intro: "CodeCombat es completamente open source."
    opensource_description_prefix: "Echa un vistazo a "
    github_url: "nuestro GitHub"
    opensource_description_center: "y ayudanos si quieres! CodeCombat esta construido por docenas de proyectos open source, y los amamos. Mira "
    archmage_wiki_url: "nuestra wiki de Archimago"
    opensource_description_suffix: "Para la lista de softwares que hacen al juego posible."
    practices_title: "Mejores prácticas respetuosas"
    practices_description: "Estas son nuestras promesas hacia ti, el jugador, en términos menos legales."
    privacy_title: "Privacidad"
    privacy_description: "No vederemos nada sobre tu información personalWe will not sell any of your personal information."
    security_title: "Seguridad"
    security_description: "Queremos mantener tu información personal privada. Como un proyecto open source, cualquiera puede revisar y mejorar nuestros sistemas de seguridad."
    email_title: "Mail"
    email_description_prefix: "No te vamos a inundar de Spam. Mediante"
    email_settings_url: "tus opciones de mail"
    email_description_suffix: "o mediante links en los mails que mandamos, tu puedas cambiar tus preferencias y fácilmente desuscribirte en cualquier momento."
    cost_title: "Costo"
    cost_description: "CodeCombat es gratuito para todos sus niveles principales, con una suscripción de ${{price}} USD/mes con acceso a niveles adicionales y un bonus de {{gems}} gemas cada mes. Puedes cancelar con un click y ofrecemos una garantía del 100%."
    copyrights_title: "Derechos y Licencias"
    contributor_title: "Contributor License Agreement"
    contributor_description_prefix: "Todas las Contribuciones, tanto en el website como en nuestro Repositorio GitHub, estan sujetos a nuestra aprobación."
    cla_url: "CLA"
    contributor_description_suffix: "A lo que debes de estar de acuerdo antes de contribuir."
    code_title: "Código - MIT"
    code_description_prefix: "Todo el código pertenece a CodeCombat u hospedado en codecombat.com, sea en el repositorio GitHub o en la base de datos en codecombat.com, está bajo licencia"
    mit_license_url: "Licencia MIT"
    code_description_suffix: "Esto incluye todo el código en Systems and Components that are made available by CodeCombat for the purpose of creating levels."
    art_title: "Arte/Música - Comunas Creativas "
    art_description_prefix: "Todo el Contenido Comunal está disponible bajo la"
    cc_license_url: "Licencia Internacional de Atribución Comunas Creativas (CC) 4.0"
    art_description_suffix: "Contenido Comunal es cualquiera hecho por CodeCombat y disponile con el propósito de crear niveles. Esto incluye:"
    art_music: "Música"
    art_sound: "Sonido"
    art_artwork: "Trabajo Artístico"
    art_sprites: "Sprites"
    art_other: "Cualquier otro trabajo creativo (no necesariamente código) que están disponibles cuando se crean niveles."
    art_access: "Actualmente no hay un sistema fácil y universal para obtener estos activos. En general, obtenlos de los URLs tal y como son usados por el sitio, contáctanos si necesitas ayuda, o ayúdanos extendiendo el sitio para hacer estos activos accesibles más fácilmente."
    art_paragraph_1: "Para atribución, por favor nombre y enlace a codecombat.com cerca de donde esta fuente sea usada o donde sea apropiado en el medio usado. Por ejemplo:"
    use_list_1: "Si es usado en una película o en otro juego, incluya codecombat.com en los créditos."
    use_list_2: "Si es usado en un website, incluya un link cerca donde es usado, por ejemplo debajo de una imagen, o en las atribuciones generales de la página, donde pueda mencionar también otros trabajos bajo Creative Commons o de código abierto que sean usados en el sitio web. Cualquier otro website que haga clara referencia a CodeCombat, tal como un blog post mencionando a CodeCombat, no necesita una atribución separada."
    art_paragraph_2: "Si el contenido usado no fue creado por CodeCombat, sino por un usuario de codecombat.com, atribuya al usuario y siga las directivas de atribución provistas en la descripción del recurso, en caso las haya."
    rights_title: "Derechos Reservados"
    rights_desc: "Todos los derechos estan reservados para los niveles mismos. Esto incluye."
    rights_scripts: "Scripts"
    rights_unit: "Configuración de la unidad"
    rights_writings: "Escritos"
    rights_media: "Media (sonidos, música) y cualquier otro contenido creativo hecho específicamente para un nivel y que no haya sido hecho disponible al público cuando se crearon los niveles."
    rights_clarification: "Aclarando, todo contenido puesto a disposición en el Editor de Niveles con el propósito de hacer más niveles se encuentra bajo licencia CC, mientras todo contenido creado con el Editor de Niveles o cargado durante la creación de Niveles no lo está."
    nutshell_title: "En una palabra"
    nutshell_description: "Cualquier recurso que te proveamos en el Editor de Niveles es gratis de usar como te plazca para la creación de Niveles. Sin embargo, nos reservamos el derecho de restringir la distribución de los niveles por sí mismos (aquellos creados en codecombat.com) para así poder cobrar por ellos en el futuro, si es que eso es lo que termina pasando."
    canonical: "La versión en inglés de este documento es la versión canónica y definitiva. Si hay alguna discrepancia entre las traducciones, la versión en inglés toma precedencia."
    third_party_title: "Servicios de Terceros"
    third_party_description: "CodeCombat utiliza los siguientes servicios de terceros (entre otros):"

  ladder_prizes:
    title: "Premios de Torneos" # This section was for an old tournament and doesn't need new translations now.
    blurb_1: "Estos premios seran dados de acuerdo a "
    blurb_2: "las reglas del torneo"
    blurb_3: "a los mejores jugadores humanos y ogros."
    blurb_4: "Dos equipos significan el doble de premios!"
    blurb_5: "(Habrán dos ganadores en el primer puesto, dos en el segundo puesto, etc.)"
    rank: "Ranking"
    prizes: "Premios"
    total_value: "Valor Total"
    in_cash: "en dinero"
    custom_wizard: "CodeCombat Mago Personalizado"
    custom_avatar: " CodeCombat Avatar Personalizado"
    heap: "Por seis meses acceso \"Startup\"."
    credits: "creditos"
    one_month_coupon: "Cupón: elige entre Rails o HTML."
    one_month_discount: "descuento del 30%: elige entre Rails o HTML"
    license: "licencia"
    oreilly: "ebook de su elección"

  calendar:
    year: "Año"
    day: "Día"
    month: "Mes"
    january: "Enero"
    february: "Febrero"
    march: "Marzo"
    april: "Abril"
    may: "Mayo"
    june: "Junio"
    july: "Julio"
    august: "Agosto"
    september: "Septiembre"
    october: "Octubre"
    november: "Noviembre"
    december: "Diciembre"
