module.exports = nativeDescription: "français", englishDescription: "French", translation:
  new_home:
    slogan: "Le jeu le plus engageant pour apprendre la programmation."
    classroom_edition: "Édition Salle de Classe:"
    learn_to_code: "Apprend à programmer:"
    teacher: "Enseignant"
    student: "Scolaire"
    play_now: "Allons-y !"
    im_a_teacher: "Je suis un enseignant"
    im_a_student: "Je suis un étudiant"
    learn_more: "Apprenez-en plus"
    classroom_in_a_box: "Une classe tout-inclus pour enseigner l'informatique."
    codecombat_is: "CodeCombat est une plateforme <strong>pour les étudiants</strong> afin d'apprendre l'informatique tout en jouant."
    our_courses: "Nos cours ont été testés spécifiquement pour <strong>exceller en classe</strong>, même si les enseignants ont peu ou pas d'expérience en programmation."
    top_screenshots_hint: "Les étudiants écrivent du code et voient leurs changements s'appliquer en temps-réel"
    designed_with: "Concu en pensant aux enseignants"
    real_code: "Vrai code entré au clavier"
    from_the_first_level: "à partir du premier niveau"
    getting_students: "Encourager les étudiants à écrire du code aussi rapidement que possible est primordial afin qu'ils apprennent comment bien structurer et écrire un programme."
    educator_resources: "Resources pour les enseignants"
    course_guides: "et les guides de cours"
    teaching_computer_science: "Enseigner l'informatique ne nécessite pas un diplôme dispendieux, parce que nous fournissons des outils afin d'aider les enseignants, peu importe leurs curriculums."
    accessible_to: "Accessible à"
    everyone: "tout le monde"
    democratizing: "Démocratiser le processus d'apprendre à programmer est au coeur de notre philosophie. Tout le monde devrait être capable d'apprendre la programmation."
    forgot_learning: "Je crois qu'ils ont oublié qu'ils étaient en train d'apprendre quelquechose."
    wanted_to_do: " Programmer est quelquechose que j'ai toujours voulu faire, et je n'ai jamais pensé que je pourrais l'apprendre à l'école."
    why_games: "Pourquoi est-ce qu'apprendre en jouant est important?"
    games_reward: "Les jeux récompensent l'effort productif."
    encourage: "Le jeu est une plateforme qui encourage l'interaction, la découverte et l'essaie et erreur. Un bon jeu défit le joeur d'apprendre à maîtriser de nouvelles habiletés au fil du temps, ce qui correspond au même processus critique que l'on retrouve au niveau de l'éducation."
    excel: "Les jeux sont excellents afin de récompenser"
    struggle: "l'effort productif"
    kind_of_struggle: "le type d'effort qui permet d'apprendre, qui nous engage et"
    motivating: "qui nous motive"
    not_tedious: "non pas fastidieux."
    gaming_is_good: "Des études suggèrent que jouer est bon pour le cerveau des enfants. (C'est vrai!)"
    game_based: "Quand les systèmes d'apprentissage basés sur le jeu sont"
    compared: "comparés"
    conventional: "aux méthodes d'évaluation conventionnelles, la différence est claire: les jeux sont meilleurs afin d'aider les enfants à retenir ce qu'ils apprennent, à se concentrer et"
    perform_at_higher_level: "à performer à un niveau supérieur d'accomplissement"
    feedback: "Les jeux procurent aussi des résultats en temps réel qui permettent aux étudiants d'ajuster leur solution et de comprendre des concepts de façon plus holistique, au lieu d'être limité aux simples réponses “correct” ou “incorrect”."
    real_game: "Un vrai jeu, joué en programmant pour de vrai."
    great_game: "Un bon jeu c'est plus qu'une série d'insignes et d'accomplissements - c'est à propos de l'aventure d'un joueur, des énigmes bien conçues et la capacité d'entreprendre des défis avec confiance et détermination."
    agency: "CodeCombat est un jeu qui donne aux joueurs cette confiance et détermination à l'aide de notre interpretteur de lignes de code, qui aide les étudiants débutants ainsi qu'avancés à concevoir des programmes bien écrits et valides."
    request_demo_title: "Débutez avec vos étudiants aujourd'hui!"
    request_demo_subtitle: "Demandez une démonstration et permettez à vos étudiants de démarrer en moins d'une heure."
    get_started_title: "Mettez en place votre classe aujourd'hui"
    get_started_subtitle: "Mettez en place une classe, ajoutez vos étudiants et surveillez leurs progrès au fur et à mesure qu'ils apprennent l'informatique."
    request_demo: "Demandez une Démonstration"
    setup_a_class: "Mettre en place une classe"
    have_an_account: "Avez-vous un compte?"
    logged_in_as: "Vous êtes présentement enregistré en tant que"
    computer_science: "Des cours d'informatique pour tous âges"
    show_me_lesson_time: "Montrez-moi des estimés de temps de cours pour:"
    curriculum: "Total des heures du curriculum:"
    ffa: "Gratuis pour tous les étudiants"
    lesson_time: "Temps de cours:"
    coming_soon: "Bientôt disponible!"
    courses_available_in: "Les cours sont disponibles en JavaScript, Python et Java (bientôt disponible!)" # {change}
    boast: "Comprend des énigmes assez complexes pour fasciner autant les joueurs que les programmeurs."
    winning: "Une combinaison gagnante d'élément de jeux de rôles et programmation qui permet aux enfants d'apprendre de façon légitimement plaisante."
    run_class: "Tous ce dont vous avez besoin pour enseigner l'informaique dans votre classe aujourd'hui, sans expérience préalable en informatique."
    goto_classes: "Aller à Mes Classes"
    view_profile: "Voir Mon Profil"
    view_progress: "Voir Progrès"
#    go_to_courses: "Go to My Courses"
    want_coco: "Voulez-vous CodeCombat à votre école?"

  nav:
    play: "Jouer" # The top nav bar entry where players choose which levels to play
    community: "Communauté"
    courses: "Cours"
    blog: "Blog"
    forum: "Forum"
    account: "Compte"
    my_account: "Mon compte"
    profile: "Profil"
    home: "Accueil"
    contribute: "Contribuer"
    legal: "Mentions légales"
#    privacy: "Privacy"
    about: "À propos"
    contact: "Contact"
    twitter_follow: "Suivre"
    teachers: "Enseignants"
    students: "Étudiants"
    careers: "Emplois"
    facebook: "Facebook"
    twitter: "Twitter"
    create_a_class: "Créer une classe"
    other: "Autre"
    learn_to_code: "Apprenez à programmer !"
    toggle_nav: "Basculer la navigation"
    jobs: "Emplois"
    schools: "Écoles"
    get_involved: "Devenez impliqué"
    open_source: "Code libre (GitHub)"
    support: "Support"
    faqs: "FAQs"
    help_pref: "Besoin d'aide? Email"
    help_suff: "et nous entrerons en contact!"
#    resource_hub: "Resource Hub"

  modal:
    close: "Fermer"
    okay: "D'accord"

  not_found:
    page_not_found: "Page introuvable"

  diplomat_suggestion:
    title: "Aidez à traduire CodeCombat !" # This shows up when a player switches to a non-English language using the language selector.
    sub_heading: "Nous avons besoin de vos compétences linguistiques."
    pitch_body: "Nous développons CodeCombat en anglais, mais nous avons déjà des joueurs de partout dans le monde. Beaucoup d'entre eux veulent jouer en français mais ne parlent pas anglais, donc si vous parlez aussi bien l'anglais que le français, aidez-nous en devenant traducteur et aidez à traduire aussi bien le site que tous les niveaux en français."
    missing_translations: "Jusqu'à ce que nous ayons tout traduit en français, vous verrez de l'anglais quand le français ne sera pas disponible."
    learn_more: "Apprenez-en plus sur les traducteurs"
    subscribe_as_diplomat: "S'inscrire en tant que traducteur"

  play:
    play_as: "Jouer comme " # Ladder page
    compete: "Participer !" # Course details page
    spectate: "Spectateur" # Ladder page
    players: "Joueurs" # Hover over a level on /play
    hours_played: "Heures jouées" # Hover over a level on /play
    items: "Objets" # Tooltip on item shop button from /play
    unlock: "Déverrouiller" # For purchasing items and heroes
    confirm: "Confirmer"
    owned: "Acquis" # For items you own
    locked: "Verrouillé"
    purchasable: "Achetable" # For a hero you unlocked but haven't purchased
    available: "Disponible"
    skills_granted: "Compétences acquises" # Property documentation details
    heroes: "Héros" # Tooltip on hero shop button from /play
    achievements: "Succès" # Tooltip on achievement list button from /play
    settings: "Réglages" # Tooltip on settings button from /play
    poll: "Sondage" # Tooltip on poll button from /play
    next: "Suivant" # Go from choose hero to choose inventory before playing a level
    change_hero: "Changer le héros" # Go back from choose inventory to choose hero
    buy_gems: "Acheter des gemmes"
    subscription_required: "Enregistrement nécessaire"
    anonymous: "Joueur anonyme"
    level_difficulty: "Difficulté : "
    play_classroom_version: "Jouer à la version Classe" # Choose a level in campaign version that you also can play in one of your courses
    campaign_beginner: "Campagne du Débutant"
    awaiting_levels_adventurer_prefix: "Nous produisons cinq niveaux par semaine." # {change}
    awaiting_levels_adventurer: "S'inscrire comme aventurier"
    awaiting_levels_adventurer_suffix: "afin d'être le premier à jouer de nouveaux niveaux."
    adjust_volume: "Ajuster le volume"
    campaign_multiplayer: "Campagne multi-joueurs"
    campaign_multiplayer_description: "... dans laquelle vous coderez en face-à-face contre d'autres joueurs."

  code:
    if: "Si" # Keywords--these translations show up on hover, so please translate them all, even if it's kind of long. (In the code editor, they will still be in English.)
    else: "Sinon"
    elif: "Sinon si"
    while: "tant que"
    loop: "boucle"
    for: "pour"
    break: "sortir"
    continue: "continuer"
    pass: "passer"
    return: "retour"
    then: "alors"
    do: "fait"
    end: "fin"
    function: "fonction"
    def: "definir"
    var: "variable"
    self: "soi-même"
    hero: "héros"
    this: "ceci"
    or: "ou"
    "||": "ou"
    and: "et"
    "&&": "et"
    not: "non"
    "!": "non"
    "=": "assigner"
    "==": "équivalent à"
    "===": "strictement équivalent à"
    "!=": "non équivalent à"
    "!==": "non strictement équivalent à"
    ">": "est plus grand que"
    ">=": "est plus grand que ou équivalent à"
    "<": "est plus petit que"
    "<=": "est plus petit que ou équivalent à"
    "*": "multiplié par"
    "/": "divisé par"
    "+": "ajouté à"
    "-": "soustrait à"
    "+=": "ajouté et assigné"
    "-=": "soustrait et assigné"
    True: "Vrai"
    true: "vrai"
    False: "Faux"
    false: "faux"
    undefined: "non défini"
    null: "nul"
    nil: "nil"
    None: "Aucune valeur"

  share_progress_modal:
    blurb: "Vous faites beaucoup de progrès ! Partagez ce que vous avez appris grâce à CodeCombat avec vos amis !" # {change}
    email_invalid: "Adresse e-mail non valide"
    form_blurb: "Entres leur adresse e-mail ci-dessous, on leur montrera !"
    form_label: "Adresse e-mail"
    placeholder: "adresse e-mail"
    title: "Très bon travail apprenti !"

  login:
    sign_up: "Créer un compte"
    email_or_username: "Email ou nom d'utilisateur"
    log_in: "Connexion"
    logging_in: "Connecter"
    log_out: "Déconnexion"
    forgot_password: "Avez-vous oublié votre mot de passe ?"
    authenticate_gplus: "Authentication de Google+"
    load_profile: "Charger votre profil Google+"
    finishing: "Finalisation"
    sign_in_with_facebook: "Connecter avec Facebook"
    sign_in_with_gplus: "Connecter avec Google+"
    signup_switch: "Voulez-vous créer un compte ?"

  signup:
    create_student_header: "Créer un compte étudiant"
    create_teacher_header: "Créer un compte enseignant"
    create_individual_header: "Créer un compte individuel"
    email_announcements: "Recevoir les annonces par e-mail" # {change}
    creating: "Création du compte en cours..."
    sign_up: "S'abonner"
    log_in: "se connecter avec votre mot de passe"
    required: "Vous devez être connecté pour voir cela"
    login_switch: "Avez-vous déjà un compte ?"
    school_name: "Nom et ville de votre école"
    optional: "optionnel"
    school_name_placeholder: "Exemple : Lycée Champollion, Figeac"
    connect_with: "Se connecter avec :"
    connected_gplus_header: "Vous avez réussi à vous connecter avec votre compte Google+!"
    connected_gplus_p: "Finissez de vous abonnez pour pouvoir vous connecter avec votre compte Google+."
    gplus_exists: "Vous avez déjà un compte associé à Google+!"
    connected_facebook_header: "Vous avez réussi à vous connecter avec votre compte Facebook!"
    connected_facebook_p: "Finissez de vous abonnez pour pouvoir vous connecter avec votre compte Facebook."
    facebook_exists: "Vous avez réussi à vous connecter avec votre compte Facebook!"
    hey_students: "Étudiants, entrez le code de cours de votre enseignant."
    birthday: "Anniversaire"
#    parent_email_blurb: "We know you can't wait to learn programming &mdash; we're excited too! Your parents will receive an email with further instructions on how to create an account for you. Email {{email_link}} if you have any questions."
#    classroom_not_found: "No classes exist with this Class Code. Check your spelling or ask your teacher for help."
#    checking: "Checking..."
#    account_exists: "This email is already in use:"
#    sign_in: "Sign in"
#    email_good: "Email looks good!"
#    name_taken: "Username already taken! Try {{suggestedName}}?"
#    name_available: "Username available!"
#    name_is_email: "Username may not be an email"
#    choose_type: "Choose your account type:"
#    teacher_type_1: "Teach programming using CodeCombat!"
#    teacher_type_2: "Set up your class"
#    teacher_type_3: "Access Course Guides"
#    teacher_type_4: "View student progress"
#    signup_as_teacher: "Sign up as a Teacher"
#    student_type_1: "Learn to program while playing an engaging game!"
#    student_type_2: "Play with your class"
#    student_type_3: "Compete in arenas"
#    student_type_4: "Choose your hero!"
#    student_type_5: "Have your Class Code ready!"
#    signup_as_student: "Sign up as a Student"
#    individuals_or_parents: "Individuals & Parents"
#    individual_type: "For players learning to code outside of a class. Parents should sign up for an account here."
#    signup_as_individual: "Sign up as an Individual"
#    enter_class_code: "Enter your Class Code"
#    enter_birthdate: "Enter your birthdate:"
#    parent_use_birthdate: "Parents, use your own birthdate."
#    ask_teacher_1: "Ask your teacher for your Class Code."
#    ask_teacher_2: "Not part of a class? Create an "
#    ask_teacher_3: "Individual Account"
#    ask_teacher_4: " instead."
#    about_to_join: "You're about to join:"
#    enter_parent_email: "Enter your parent’s email address:"
#    parent_email_error: "Something went wrong when trying to send the email. Check the email address and try again."
#    parent_email_sent: "We’ve sent an email with further instructions on how to create an account. Ask your parent to check their inbox."
#    account_created: "Account Created!"
#    confirm_student_blurb: "Write down your information so that you don't forget it. Your teacher can also help you reset your password at any time."
#    confirm_individual_blurb: "Write down your login information in case you need it later. Verify your email so you can recover your account if you ever forget your password - check your inbox!"
#    write_this_down: "Write this down:"
#    start_playing: "Start Playing!"
#    sso_connected: "Successfully connected with:"
#    select_your_starting_hero: "Select Your Starting Hero:"
#    you_can_always_change_your_hero_later: "You can always change your hero later."

  recover:
    recover_account_title: "Récupérer son compte"
    send_password: "Envoyer le mot de passe de récupération"
    recovery_sent: "Email de récupération envoyé"

  items:
    primary: "Primaire"
    secondary: "Secondaire"
    armor: "Armure"
    accessories: "Accessoires"
    misc: "Divers"
    books: "Livres"

  common:
    back: "Retour" # When used as an action verb, like "Navigate backward"
    coming_soon: "Arrive prochainement !"
    continue: "Continuer" # When used as an action verb, like "Continue forward"
    default_code: "Code par défaut"
    loading: "Chargement..."
    overview: "Vue d'ensemble"
    solution: "Solution"
    intro: "Intro"
    saving: "Sauvegarde..."
    sending: "Envoi..."
    send: "Envoyer"
    sent: "Envoyé"
    cancel: "Annuler"
    save: "Sauvegarder"
    publish: "Publier"
    create: "Créer"
    fork: "Répliquer"
    play: "Jouer" # When used as an action verb, like "Play next level"
    retry: "Réessayer"
    actions: "Actions"
    info: "Info"
    help: "Au-Secours !"
    watch: "Regarder"
    unwatch: "Ne plus regarder"
    submit_patch: "Soumettre un correctif"
    submit_changes: "Soumettre des Changements"
    save_changes: "Sauvegarder les modifications"
    required_field: "Champ requis" # {change}

  general:
    and: "et"
    name: "Nom"
    date: "Date"
    body: "Corps"
    version: "Version"
    pending: "En attente"
    accepted: "Accepté"
    rejected: "Rejeté"
    withdrawn: "Retiré"
    accept: "Accepter"
    reject: "Refuser"
    withdraw: "Abandonner"
    submitter: "Soumissionnaire"
    submitted: "Soumis"
    commit_msg: "Message de mise à jour"
    version_history: "Historique des versions"
    version_history_for: "Historique des versions pour : "
    select_changes: "Sélectionner deux changements plus bas pour voir la différence."
    undo_prefix: "Annuler"
    undo_shortcut: "(Ctrl+Z)"
    redo_prefix: "Refaire"
    redo_shortcut: "(Ctrl+Shift+Z)"
    play_preview: "Jouer un aperçu du niveau actuel"
    result: "Résultat"
    results: "Résultats"
    description: "Description"
    or: "ou"
    subject: "Sujet"
    email: "E-mail"
    password: "Mot de passe"
    confirm_password: "Confirmez votre mot de passe"
    message: "Message"
    code: "Code"
    ladder: "Companion"
    when: "Quand"
    opponent: "Adversaire"
    rank: "Rang"
    score: "Score"
    win: "Victoire"
    loss: "Défaite"
    tie: "Ex-aequo"
    easy: "Facile"
    medium: "Moyen"
    hard: "Difficile"
    player: "Joueur"
    player_level: "Niveau" # Like player level 5, not like level: Dungeons of Kithgard
    warrior: "Guerrier"
    ranger: "Ranger"
    wizard: "Magicien"
    first_name: "Prénom"
    last_name: "Nom de famille"
#    last_initial: "Last Initial"
    username: "Nom d'utilisateur"

  units:
    second: "seconde"
    seconds: "secondes"
    minute: "minute"
    minutes: "minutes"
    hour: "heure"
    hours: "heures"
    day: "jour"
    days: "journées"
    week: "semaine"
    weeks: "semaines"
    month: "mois"
    months: "mois"
    year: "année"
    years: "années"

  play_level:
    level_complete: "Niveau terminé"
    completed_level: "Niveau terminé:"
    course: "Cours:"
    done: "Terminé"
    next_level: "Niveau Suivant"
    next_game: "Prochaine jeu"
#    language: "Language"
#    languages: "Languages"
#    programming_language: "Programming language"
    show_menu: "Afficher le menu"
    home: "Accueil" # Not used any more, will be removed soon.
    level: "Niveau" # Like "Level: Dungeons of Kithgard"
    skip: "Passer"
    game_menu: "Menu du jeu"
    guide: "Guide"
    restart: "Relancer"
    goals: "Objectifs"
    goal: "Objectif"
    running: "en cours..."
    success: "Succès"
    incomplete: "Incomplet"
    timed_out: "temps écoulé"
    failing: "Échec"
    reload: "Recommencer"
    reload_title: "Recommencer tout le code ?"
    reload_really: "Êtes-vous sûr de vouloir recommencer ce niveau et retourner au début ?"
    reload_confirm: "Tout recommencer"
    victory: "Victoire"
    victory_title_prefix: ""
    victory_title_suffix: " Terminé"
    victory_sign_up: "Inscrivez-vous pour recevoir les mises à jour"
    victory_sign_up_poke: "Vous voulez recevoir les dernières actualités par e-mail ? Créez un compte gratuitement et nous vous tiendrons informés !"
    victory_rate_the_level: "Notez ce niveau: " # {change}
    victory_return_to_ladder: "Retourner à l'échelle"
    victory_saving_progress: "Sauvegarder la progression"
    victory_go_home: "Retourner à l'accueil"
    victory_review: "Dites-nous en plus !"
    victory_review_placeholder: "Comment était ce niveau?"
    victory_hour_of_code_done: "Déjà fini ?"
    victory_hour_of_code_done_yes: "Oui, j'ai fini mon heure de code !"
    victory_experience_gained: "XP gagnée"
    victory_gems_gained: "Gemmes gagnées"
    victory_new_item: "Nouvel item"
    victory_new_hero: "Nouveau héros"
    victory_viking_code_school: "Par la barbe d'Odin, c'est un niveau difficile que tu viens de compléter! Si tu n'est pas un développeur de logiciel, tu devrais l'être ! Ceci vient de te propulser dans l'école de Code Vikings où tu pourras amener tes habilités au prochain niveau et devenir un développer web profesionnel en deux semaines."
    victory_become_a_viking: "Devenez un viking"
    victory_no_progress_for_teachers: "La progression n'est pas sauvegardé pour les enseignants. Mais vous pouvez ajouter un compte étudiant à votre salle de cours pour vous."
    guide_title: "Guide"
    tome_cast_button_run: "Exécuter"
    tome_cast_button_running: "En cours d'exécution"
    tome_cast_button_ran: "Exécuter"
    tome_submit_button: "Envoyer"
    tome_reload_method: "Recharger le code original pour cette méthode" # {change}
    tome_available_spells: "Sorts diponibles"
    tome_your_skills: "Vos compétences"
    tome_current_method: "Méthode actuelle"
    hints: "Aide"
    hints_title: "Aide {{number}}"
    code_saved: "Code sauvergardé"
    skip_tutorial: "Passer (esc)"
    keyboard_shortcuts: "Raccourcis clavier"
    loading_ready: "Pret!"
    loading_start: "Démarrer niveau"
    problem_alert_title: "Corriger votre code"
    time_current: "Maintenant :"
    time_total: "Max :"
    time_goto: "Allez à :"
    non_user_code_problem_title: "Chargement du niveau impossible"
    infinite_loop_title: "Détection d'une boucle infinie"
    infinite_loop_description: "Le code initial pour initialiser le monde n'a jamais terminé de s'exécuter. Soit la connection internet est trop lente ou soit il y a une présence d'une boucle infinie. Peut-être il s'agit d'un bug. Essayez de soit relancer le code à nouveau ou reinitialiser le code à son état par défaut. Si la situation ne change pas, veuillez nous aviser."
    check_dev_console: "Vous pouvez ouvrir la console du développeur et tenter d'observer ce qui se passe qui causerait un souci."
    check_dev_console_link: "(instructions)"
    infinite_loop_try_again: "Réessayer"
    infinite_loop_reset_level: "Redémarrer le niveau"
    infinite_loop_comment_out: "Supprimez les commentaires de mon code"
    tip_toggle_play: "Jouer/Pause avec Ctrl+P."
    tip_scrub_shortcut: "Ctrl+[ and Ctrl+] : rembobinage et avance rapide." # {change}
    tip_guide_exists: "Cliquez sur le guide en haut de la page pour des informations utiles."
    tip_open_source: "CodeCombat est 100% open source !"
    tip_tell_friends: "Vous aimez CodeCombat? Parlez de nous à vos amis !"
    tip_beta_launch: "La beta de CodeCombat a été lancée en Octobre 2013"
    tip_think_solution: "Reflechissez à propos de la solution et non du problème."
    tip_theory_practice: "En théorie, il n'y a pas de différence entre la théorie et la pratique. Mais en pratique, il y en a. - Yogi Berra"
    tip_error_free: "Il ya deux façons d'écrire des programmes sans erreur; seulement la troisième marche. - Alan Perlis"
    tip_debugging_program: "Si débugger est l'art de corriger les bugs, alors programmer est l'art d'en créer. - Edsger W. Dijkstra"
    tip_forums: "Rendez-vous sur le forum et dites-nous ce que vous en pensez !"
    tip_baby_coders: "Dans le futur, même les bébés seront des archimages."
    tip_morale_improves: "Le chargement se poursuivra jusqu'à ce que la morale s'améliore."
    tip_all_species: "Nous croyons en l'égalité des chances d'apprendre la programmation pour toutes les espèces."
    tip_reticulating: "Réticulation des spines."
    tip_harry: "T'es un magicien, "
    tip_great_responsibility: "Avec de grandes compétences en programmation vient une grande responsabilité de débogage."
    tip_munchkin: "Si vous ne mangez pas vos légumes, un munchkin viendra après vous pendant que vous dormirez."
    tip_binary: "Il ya seulement 10 types de personnes dans le monde: ceux qui comprennent le binaire, et ceux qui ne le comprennent pas."
    tip_commitment_yoda: "Un programmeur doit avoir l'engagement le plus profond, l'esprit le plus grave. ~ Yoda"
    tip_no_try: "Faire. Ou ne pas faire. Il n'y a pas d'essai. - Yoda"
    tip_patience: "Patience tu dois avoir, jeune Padawan. - Yoda"
    tip_documented_bug: "Un bug documenté n'est pas un bug; c'est une caractéristique"
    tip_impossible: "Cela semble toujours impossible jusqu'à ce que l'on y arrive. - Nelson Mandela"
    tip_talk_is_cheap: "Discuter est facile. Montrez-moi le code. - Linus Torvalds"
    tip_first_language: "La chose la plus désastreuse que vous ne pourrez jamais apprendre est votre premier langage de programmation. - Alan Kay"
    tip_hardware_problem: "Q: Combien de programmeurs faut-il pour changer une ampoule ? R: Aucun, c'est un problème de matériel."
    tip_hofstadters_law: "Loi de Hofstadter : Il faut toujours plus de temps que prévu, même si vous prenez en compte la loi de Hofstadter."
    tip_premature_optimization: "L'optimisation prématurée est la racine de tous les maux. - Donald Knuth"
    tip_brute_force: "En cas de doute, utiliser la force brute. - Ken Thompson"
    tip_extrapolation: "Il y a seulement deux types de personnes : celles qui peuvent extrapoler à partir de données incomplètes..."
    tip_superpower: "Le développement est la chose la plus proche d'un super pouvoir."
    tip_control_destiny: "Dans le vrai open source, vous avez le controle sur votre propre destinée. - Linus Torvalds"
    tip_no_code: "Aucun code n'est plus rapide qu'aucun code."
    tip_code_never_lies: "Le code ne ment jamais, les commentaires... parfois — Ron Jeffries"
    tip_reusable_software: "Avant qu'un logiciel soit réutilisable, il doit être utilisable"
    tip_optimization_operator: "Tout les langages ont un opérateur d'optimisation. Dans la plupart des langages, cet opérateur est ‘//’"
    tip_lines_of_code: "Mesurer l'avancé d'un programme par le nombre de lignes de code, c'est comme mesurer l'avancé d'un avion par son poid. - Bill Gates"
    tip_source_code: "Je voudrais changer le monde, mais ils ne veulent pas me donner le code source."
    tip_javascript_java: "le Java est au Javascript ce que le tapis est à la tapisserie"
    tip_move_forward: "Quoi que vous fassiez, continuez d'avancer. - Martin Luther King Jr."
    tip_google: "*Vous avez un problème que vous n'arrivez pas à résoudre ? Googlez le !"
    tip_adding_evil: "Ajout d'une pincée de méchanceté"
    tip_hate_computers: "C'est ça le problème avec les gens qui pensent qu'ils détestent les ordinateur. Ce qu'ils détestent vraiment, c'est des piètres programmeurs. - Larry Niven"
    tip_open_source_contribute: "Vous pouvez aider CodeCombat à s'améliorer !"
    tip_recurse: "Itérer c'est humain, mais faire des récursion, c'est divin. - L. Peter Deutsch"
    tip_free_your_mind: "Vous devez laisser aller , Neo . La peur , le doute et l'incrédulité . Libère ton esprit. - Morpheus"
    tip_strong_opponents: "Même les ennemis les plus puissant ont une faiblesse. - Itachi Uchiha"
    tip_paper_and_pen: "Avant de commencer à coder, vous pouvez plannifier les choses sur papier."
    tip_solve_then_write: "D'abord, résolvez le problème. Ensuite, écrivez le code. - John Johnson"
    tip_compiler_ignores_comments: "Des fois, je pense que le compilateur ignore mes commentaires."
    tip_understand_recursion: "La seule manière de comprendre la récursion est de comprendre la récursion."
    tip_life_and_polymorphism: "Le code libre est une structure hétérogène polymorphique. Tous les types sont les bienvenues."
    tip_mistakes_proof_of_trying: "Les erreurs dans votre code sont la preuve que vous essayez."
    tip_adding_orgres: "Rassembler les ogres."
    tip_sharpening_swords: "Aiguiser les épées."
    tip_ratatouille: "Tu ne dois laisser personne définir où se trouvent tes limites. La seule vraie limite est c'est ton âme. - Gusteau, Ratatouille"
    tip_nemo: "Quand la vie vous rabaisse, vous savez ce que vous devenez faire ? Juste continuer de nager, juste continuer de nager. - Dory, Finding Nemo"
    tip_internet_weather: "Just move to the internet, it's great here. We get to live inside where the weather is always awesome. - John Green"
#    tip_nerds: "Nerds are allowed to love stuff, like jump-up-and-down-in-the-chair-can't-control-yourself love it. - John Green"
    tip_self_taught: "Je me suis enseigné 90% de ce que j'ai appris. Et c'est normal! - Hank Green"
    tip_luna_lovegood: "Ne t'en fais pas, tu es aussi sain que moi. - Luna Lovegood"
    tip_good_idea: "La meilleure façon d'avoir une bonne idée est d'avoir beaucoup d'idées. - Linus Pauling"
#    tip_programming_not_about_computers: "Computer Science is no more about computers than astronomy is about telescopes. - Edsger Dijkstra"
#    tip_mulan: "Believe you can, then you will. - Mulan"

#  play_game_dev_level:
#    created_by: "Created by {{name}}"
#    how_to_play_title: "How to play:"
#    how_to_play_1: "Use the mouse to control the hero!"
#    how_to_play_2: "Click anywhere on the map to move to that location."
#    how_to_play_3: "Click on the ogres to attack them."
#    restart: "Restart Level"
#    play: "Play Level"
#    play_more_codecombat: "Play More CodeCombat"
#    default_student_instructions: "Click to control your hero and win your game!"
#    back_to_coding: "Back to Coding"

  game_menu:
    inventory_tab: "Inventaire"
    save_load_tab: "Sauvegarder/Charger"
    options_tab: "Options"
    guide_tab: "Guide"
    guide_video_tutorial: "Tutoriel vidéo"
    guide_tips: "Astuces"
    multiplayer_tab: "Multijoueur"
    auth_tab: "S'inscrire"
    inventory_caption: "Équipez votre héros"
    choose_hero_caption: "Choisissez votre héros, langage"
    save_load_caption: "... et voir l'historique"
    options_caption: "Configurer les réglages"
    guide_caption: "Docs et conseils"
    multiplayer_caption: "Jouer avec des amis !"
    auth_caption: "Sauvegarder votre progression."

  leaderboard:
    view_other_solutions: "Voir les autres solutions" # {change}
    scores: "Scores"
    top_players: "Classement des meilleurs joueurs"
    day: "Aujourd'hui"
    week: "Cette semaine"
    all: "Tous les temps"
    time: "Temps"
    damage_taken: "Dégât subis"
    damage_dealt: "Dégât infligés"
    difficulty: "Difficulté"
    gold_collected: "Or collecté"

  inventory:
    equipped_item: "Equipé"
    required_purchase_title: "Requis"
    available_item: "Disponible"
    restricted_title: "Limité"
    should_equip: "(double-clic pour s'équiper)"
    equipped: "(équipé)"
    locked: "(verrouillé)"
    restricted: "(verrouillé à ce niveau)"
    equip: "Equiper"
    unequip: "Retirer"

  buy_gems:
    few_gems: "Quelques gemmes"
    pile_gems: "Pile de gemmes"
    chest_gems: "Coffre de gemmes"
    purchasing: "Achat..."
    declined: "Votre carte a été refusée"
    retrying: "Erreur serveur, nouvelle tentative."
    prompt_title: "Pas assez de gemmes"
    prompt_body: "En voulez-vous plus ?"
    prompt_button: "Entrer dans la boutique"
    recovered: "Gemmes précédemment achetées récupérées. Merci de rafraîchir la page."
    price: "x{{gems}} / mo"

  subscribe:
    comparison_blurb: "Aiguisez vos compétences avec un abonnement CodeCombat !"
    feature1: "Plus de __levelsCount__ niveaux au travers de __worldsCount__ mondes" # {change}
    feature2: "__heroesCount__ puissants <strong>nouveaux héros</strong> avec des compétences uniques !" # {change}
    feature3: "Plus de __bonusLevelsCount__ niveaux bonus" # {change}
    feature4: "<strong>{{gems}} gemmes bonus</strong> tous les mois !"
    feature6: "Assitance par e-mail dédiée"
    feature7: "<strong>Clans</strong> privés"
    feature8: "<strong>Sans pubs!</strong>"
    free: "Gratuit"
    month: "mois"
    must_be_logged: "Vous devez être identifié. Veuillez créer un compte ou vous identifier depuis le menu ci-dessus."
    subscribe_title: "Abonnement"
    unsubscribe: "Désinscription"
    confirm_unsubscribe: "Confirmer la désinscription"
    never_mind: "Ça ne fait rien, je t'aime toujours"
    thank_you_months_prefix: "Merci de nous avoir supporté pendant"
    thank_you_months_suffix: "mois."
    thank_you: "Merci de supporter CodeCombat."
    sorry_to_see_you_go: "Désolé de te voir partir ! Fais-nous savoir ce que nous aurions pu faire mieux"
    unsubscribe_feedback_placeholder: "Nom de zeus, qu'avons nous fait ?"
    parent_button: "Demande à tes parents"
    parent_email_description: "Nous leur enverrons un e-mail pour qu'ils t'achètent un abonnement CodeCombat."
    parent_email_input_invalid: "Adresse e-mail non valide"
    parent_email_input_label: "Adresse e-mail des parents"
    parent_email_input_placeholder: "Entrer l'adresse e-mail des parents"
    parent_email_send: "Envoyer l'e-mail"
    parent_email_sent: "E-mail envoyé !"
    parent_email_title: "Quelle est l'adresse e-mail de tes parents ?"
    parents: "Pour les parents"
    parents_title: "Votre enfant va apprendre à programmer." # {change}
    parents_blurb1: "Avec CodeCombat, votre enfant apprend en écrivant de vrais programmes. Il commence en apprenant des instructions simples, puis progresse sur des thèmes plus complexes."
    parents_blurb1a: "La programmation informatique est une compétence essentielle que votre fils va indubitablement utiliser comme un adulte. En 2020, les compétences basiques en informatique seront obligatoires pour 77% des travails, et les ingénieurs logiciels seront fortement demandés partout dans le monde. Saviez-vous que l'informatique est la compétence universitaire la mieux payée ?"
    parents_blurb2: "Pour ${{price}} USD/mois, il obtient de nouveaux défis chaque semaine et le support par e-mail de programmeurs professionnels." # {change}
    parents_blurb3: "Pas de risque : garantie 100% remboursé, désinscription facile en 1 clic."
    payment_methods: "Moyens de paiement"
    payment_methods_title: "Moyens de paiement acceptés"
    payment_methods_blurb1: "Nous acceptons, pour le moment, les cartes de crédit et les paiment par Alipay." # {change}
    payment_methods_blurb2: "Si vous avez besoins d'un autre moyen de paiement, merci de nous contacter"
    sale_button: "Promotion!"
    sale_button_title: "Économisez 21$ en achetant un abonnement d'un an"
    stripe_description: "Inscription mensuelle"
    stripe_description_year_sale: "1 an d'abonnement (Économie de {{discount}}$ !)"
    subscription_required_to_play: "Vous avez besoin d'un abonnement pour jouer à ce niveau."
    unlock_help_videos: "Abonnez vous pour débloquer tous les tutoriels vidéo."
    personal_sub: "Abonnement individuel" # Accounts Subscription View below
    loading_info: "Chargement des informations sur votre abonnement..."
    managed_by: "Gérer par"
    will_be_cancelled: "Ceci va être annulé"
    currently_free: "Vous avez un abonnement gratuit en ce moment"
    currently_free_until: "Vous avez un abonnement gratuit jusqu'à"
    was_free_until: "Vous aviez un abonnement gratuit jusqu'à"
    managed_subs: "Gestion des abonnements"
    subscribing: "S'inscrit..."
    current_recipients: "Recipients courant"
    unsubscribing: "Desincription en cours..." # {change}
    subscribe_prepaid: "Cliquer S'abonner pour utiliser du code prépayé"
    using_prepaid: "Utiliser le code prépayé pour un abonnement mensuel"

  choose_hero:
    choose_hero: "Choisissez votre héros"
    programming_language: "Langage de programmation"
    programming_language_description: "Quel langage de programmation voulez-vous utiliser ?"
    default: "Défaut"
    experimental: "Expérimental"
    python_blurb: "Simple mais puissant, idéal pour les débutants et les experts."
    javascript_blurb: "Le langage du web. (Pas le même que Java.)"
    coffeescript_blurb: "Une syntaxe Javascript plus agréable."
    lua_blurb: "Langage de script de jeu."
#    java_blurb: "(Subscriber Only) Android and enterprise."
    status: "Statut"
    weapons: "Arme"
    weapons_warrior: "Epées - Courte portée, pas de magie"
    weapons_ranger: "Arbalètes, pistolets - Longue portée, pas de magie"
    weapons_wizard: "Baguettes, bâtons - Longue portée, Magie"
    attack: "Dégâts" # Can also translate as "Attack"
    health: "Santé"
    speed: "Vitesse"
    regeneration: "Régénération"
    range: "Portée" # As in "attack or visual range"
    blocks: "Absorbe" # As in "this shield blocks this much damage"
    backstab: "Poignardé" # As in "this dagger does this much backstab damage"
    skills: "Compétences"
    attack_1: "Inflige"
    attack_2: "Classé de"
    attack_3: "Dommage causé par l'arme"
    health_1: "Gains"
    health_2: "Provenance de la liste"
    health_3: "Endurance de l'armure"
    speed_1: "Se mouvoit à"
    speed_2: "mètres par seconde"
    available_for_purchase: "Disponible à l'achat" # Shows up when you have unlocked, but not purchased, a hero in the hero store
    level_to_unlock: "Niveau à débloquer :" # Label for which level you have to beat to unlock a particular hero (click a locked hero in the store to see)
    restricted_to_certain_heroes: "Seulement certains héros peuvent jouer ce niveau."

  skill_docs:
    function: "fonction" # skill types
    method: "méthode"
#    snippet: "snippet"
    number: "nombre"
    array: "tableau"
    object: "objet"
    string: "chaîne de charactères"
    writable: "éditable" # Hover over "attack" in Your Skills while playing a level to see most of this
    read_only: "lecture seulement"
    action: "Action"
    spell: "Sort"
    action_name: "Nom"
    action_cooldown: "Durée"
    action_specific_cooldown: "Rechargement"
    action_damage: "Dégât"
    action_range: "Portée"
    action_radius: "Rayon"
    action_duration: "Durée"
    example: "Exemple"
    ex: "ex" # Abbreviation of "example"
    current_value: "Valeur actuelle"
    default_value: "Valeur par défaut"
    parameters: "Paramètres"
#    required_parameters: "Required Parameters"
#    optional_parameters: "Optional Parameters"
    returns: "Retour"
    granted_by: "Accordé par"

  save_load:
    granularity_saved_games: "Sauvegardé"
    granularity_change_history: "Historique"

  options:
    general_options: "Options Générales" # Check out the Options tab in the Game Menu while playing a level
    volume_label: "Volume"
    music_label: "Musique"
    music_description: "Arrêter/Reprendre la musique de fond."
    editor_config_title: "Configuration de l'éditeur"
    editor_config_livecompletion_label: "Saisie semi-automatique en direct"
    editor_config_livecompletion_description: "Afficher les suggestions de saisie semi-automatique lors de la frappe."
    editor_config_invisibles_label: "Afficher les caractères non-imprimables"
    editor_config_invisibles_description: "Permet d'afficher les caractères comme les espaces et les tabulations."
    editor_config_indentguides_label: "Montrer les indentations"
    editor_config_indentguides_description: "Affiche des guides verticaux qui permettent de visualiser l'indentation."
    editor_config_behaviors_label: "Auto-complétion"
    editor_config_behaviors_description: "Ferme automatiquement les accolades, parenthèses, et chaînes de caractères."

  about:
    main_title: "Si tu veux apprendre la programmation, tu dois écrire beaucoup de code."
    main_description: "Chez CodeCombat, notre but est d'assurer que tu le fasses avec un sourire."
    mission_link: "Mission"
    team_link: "Equipe"
    story_link: "Histoire"
    press_link: "Presse"
    mission_title: "Notre mission: faire en sorte que la programmation soit accessible à chaque élève sur la Terre."
#    mission_description_1: "<strong>Programming is magic</strong>. It's the ability to create things from pure imagination. We started CodeCombat to give learners the feeling of wizardly power at their fingertips by using <strong>typed code</strong>."
#    mission_description_2: "As it turns out, that enables them to learn faster too. WAY faster. It's like having a conversation instead of reading a manual. We want to bring that conversation to every school and to <strong>every student</strong>, because everyone should have the chance to learn the magic of programming."
    team_title: "Rencontrez l'équipe CodeCombat."
#    team_values: "We value open and respectful dialog, where the best idea wins. Our decisions are grounded in customer research and our process is focused on delivering tangible results for them. Everyone is hands-on, from our CEO to our GitHub contributors, because we value growth and learning in our team."
    nick_title: "Programmeur" # {change}
    nick_blurb: "Gourou de Motivation"
    matt_title: "Programmeur" # {change}
    cat_title: "Chef Artisan" # {change}
    cat_blurb: "Seigneur de l'air"
    scott_title: "Programmeur" # {change}
    scott_blurb: "Raisonable"
    maka_title: "Responsable clientèle"
    maka_blurb: "Conteur"
#    rob_title: "Software Engineer"
#    rob_blurb: "Codes things and stuff"
    josh_c_title: "Game Designer"
    josh_c_blurb: "Conçoit des jeux"
#    robin_title: "UX Design & Research"
#    robin_blurb: "Scaffolding"
    josh_title: "Game Designer"
    josh_blurb: "Le plancher est de la lave"
#    phoenix_title: "Software Engineer"
#    nolan_title: "Territory Manager"
#    elliot_title: "Partnership Manager"
#    elliot_blurb: "Mindreader"
#    lisa_title: "School Specialist"
#    lisa_blurb: "A gritty one"
#    sean_title: "Territory Manager"
    retrostyle_title: "Illustration"
    retrostyle_blurb: "Jeux RetroStyle"
    jose_title: "Musique"
    jose_blurb: "Décollage"
#    community_title: "...and our open-source community"
#    community_subtitle: "Over 450 contributors have helped build CodeCombat, with more joining every week!"
#    community_description_3: "CodeCombat is a"
#    community_description_link_2: "community project"
#    community_description_1: "with hundreds of players volunteering to create levels, contribute to our code to add features, fix bugs, playtest, and even translate the game into 50 languages so far. Employees, contributors and the site gain by sharing ideas and pooling effort, as does the open source community in general. The site is built on numerous open source projects, and we are open sourced to give back to the community and provide code-curious players a familiar project to explore and experiment with. Anyone can join the CodeCombat community! Check out our"
#    community_description_link: "contribute page"
#    community_description_2: "for more info."
#    number_contributors: "Over 450 contributors have lent their support and time to this project."
#    story_title: "Our story so far"
#    story_subtitle: "Since 2013, CodeCombat has grown from a mere set of sketches to a living, thriving game."
#    story_statistic_1a: "5,000,000+"
#    story_statistic_1b: "total players"
#    story_statistic_1c: "have started their programming journey through CodeCombat"
#    story_statistic_2a: "We’ve been translated into over 50 languages — our players hail from"
#    story_statistic_2b: "200+ countries"
#    story_statistic_3a: "Together, they have written"
#    story_statistic_3b: "1 billion lines of code and counting"
#    story_statistic_3c: "across many different programming languages"
#    story_long_way_1: "Though we've come a long way..."
#    story_sketch_caption: "Nick's very first sketch depicting a programming game in action."
#    story_long_way_2: "we still have much to do before we complete our quest, so..."
#    jobs_title: "Come work with us and help write CodeCombat history!"
#    jobs_subtitle: "Don't see a good fit but interested in keeping in touch? See our \"Create Your Own\" listing."
#    jobs_benefits: "Employee Benefits"
#    jobs_benefit_4: "Unlimited vacation"
#    jobs_benefit_5: "Professional development and continuing education support – free books and games!"
#    jobs_benefit_6: "Medical (gold), dental, vision"
#    jobs_benefit_7: "Sit-stand desks for all"
#    jobs_benefit_9: "10-year option exercise window"
#    jobs_benefit_10: "Maternity leave: 10 weeks paid, next 6 @ 55% salary"
#    jobs_benefit_11: "Paternity leave: 10 weeks paid"
#    learn_more: "Learn More"
#    jobs_custom_title: "Create Your Own"
#    jobs_custom_description: "Are you passionate about CodeCombat but don't see a job listed that matches your qualifications? Write us and show how you think you can contribute to our team. We'd love to hear from you!"
#    jobs_custom_contact_1: "Send us a note at"
#    jobs_custom_contact_2: "introducing yourself and we might get in touch in the future!"
#    contact_title: "Press & Contact"
#    contact_subtitle: "Need more information? Get in touch with us at"
#    screenshots_title: "Game Screenshots"
#    screenshots_hint: "(click to view full size)"
#    downloads_title: "Download Assets & Information"
#    about_codecombat: "About CodeCombat"
#    logo: "Logo"
#    screenshots: "Screenshots"
#    character_art: "Character Art"
#    download_all: "Download All"
#    previous: "Previous"
#    location_title: "We're located in downtown SF:"

  teachers:
    who_for_title: "A qui CodeCombat est-il destiné ?"
    who_for_1: "Nous recommandons CodeCombat pour les élèves âgés de 9 ans ou plus. Aucune expérience préalable de programmation n'est requise." # {change}
    who_for_2: "Nous avons conçu CodeCombat pour plaire à la fois aux garçons et aux filles." # {change}
    more_info_title: "À quel endroit je peux trouver plus de détails ?"
    more_info_1: "Notre"
    more_info_2: "forum d'enseignants"
    more_info_3: "C'est un bon endroit pour faire des relations entre vos camarades éducateurs utilisant CodeCombat"
#    licenses_needed: "Licenses needed"

#  teachers_quote:
#    name: "Demo Form"
#    subtitle: "Get your students started in less than an hour. You'll be able to <strong>create a class, add students, and monitor their progress</strong> as they learn computer science."
#    email_exists: "User exists with this email."
#    phone_number: "Phone number"
#    phone_number_help: "Where can we reach you during the workday?"
#    primary_role_label: "Your Primary Role"
#    role_default: "Select Role"
#    primary_role_default: "Select Primary Role"
#    purchaser_role_default: "Select Purchaser Role"
#    tech_coordinator: "Technology coordinator"
#    advisor: "Advisor"
#    principal: "Principal"
#    superintendent: "Superintendent"
#    parent: "Parent"
#    purchaser_role_label: "Your Purchaser Role"
#    influence_advocate: "Influence/Advocate"
#    evaluate_recommend: "Evaluate/Recommend"
#    approve_funds: "Approve Funds"
#    no_purchaser_role: "No role in purchase decisions"
#    district_label: "District"
#    district_na: "Enter N/A if not applicable"
#    organization_label: "School"
#    city: "City"
#    state: "State"
#    country: "Country"
#    num_students_help: "How many do you anticipate enrolling in CodeCombat?"
#    num_students_default: "Select Range"
#    education_level_label: "Education Level of Students"
#    education_level_help: "Choose as many as apply."
#    elementary_school: "Elementary School"
#    high_school: "High School"
#    please_explain: "(please explain)"
#    middle_school: "Middle School"
#    college_plus: "College or higher"
#    anything_else: "Anything else we should know?"
#    thanks_header: "Request Received!"
#    thanks_sub_header: "Thanks for expressing interest in CodeCombat for your school."
#    thanks_p: "We'll be in touch soon! If you need to get in contact, you can reach us at:"
#    back_to_classes: "Back to Classes"
#    finish_signup: "Finish creating your teacher account:"
#    finish_signup_p: "Create an account to set up a class, add your students, and monitor their progress as they learn computer science."
#    signup_with: "Sign up with:"
#    connect_with: "Connect with:"
#    conversion_warning: "WARNING: Your current account is a <em>Student Account</em>. Once you submit this form, your account will be updated to a Teacher Account."
#    learn_more_modal: "Teacher accounts on CodeCombat have the ability to monitor student progress, assign licenses and manage classrooms. Teacher accounts cannot be a part of a classroom - if you are currently enrolled in a class using this account, you will no longer be able to access it once you update to a Teacher Account."
#    create_account: "Create a Teacher Account"
#    create_account_subtitle: "Get access to teacher-only tools for using CodeCombat in the classroom.  <strong>Set up a class</strong>, add your students, and <strong>monitor their progress</strong>!"
#    convert_account_title: "Update to Teacher Account"
#    not: "Not"

  versions:
    save_version_title: "Enregistrer une nouvelle version"
    new_major_version: "Nouvelle version majeure"
    submitting_patch: "Soumission du correctif..."
    cla_prefix: "Pour enregistrer vos modifications vous devez d'abord accepter notre"
    cla_url: "Copyright"
    cla_suffix: "."
    cla_agree: "J'accepte"
    owner_approve: "Un propriétaire devra l'approuver avant que vos changements ne soient visibles."

  contact:
    contact_us: "Contacter CodeCombat"
    welcome: "Ravi d'avoir de vos nouvelles ! Utilisez ce formulaire pour nous envoyer un e-mail."
    forum_prefix: "Pour tout sujet d'ordre public, merci d'utiliser "
    forum_page: "notre forum"
    forum_suffix: " À la place."
    faq_prefix: "Il y a aussi une"
    faq: "FAQ"
    subscribe_prefix: "Si vous avez besoin d'aide pour la résolution d'un niveau"
    subscribe: "achetez un abonnement CodeCombat"
    subscribe_suffix: "et nous seront ravis de vous aider avec votre code."
    subscriber_support: "Etant donné que vous êtes abonné à CodeCombat, votre message sera traité en priorité par notre support."
    screenshot_included: "Capture d'écran ajoutée."
    where_reply: "Où devons-nous répondre ?"
    send: "Envoyer un commentaire"

  account_settings:
    title: "Préférences du compte"
    not_logged_in: "Connectez-vous ou créez un compte pour modifier vos préférences."
    autosave: "Enregistrer automatiquement les modifications"
    me_tab: "Moi"
    picture_tab: "Photos"
    delete_account_tab: "Supprimer votre compte"
    wrong_email: "Mauvaise adresse e-mail"
    wrong_password: "Mauvais mot de passe"
    upload_picture: "Télécharger une image"
    delete_this_account: "Supprimer votre compte définitivement"
    reset_progress_tab: "Réinitialiser toute la progression"
    reset_your_progress: "Supprimer toute votre progression et recommencer à zéro"
    god_mode: "Puissance Divine"
    emails_tab: "E-mails"
    admin: "Admin"
    manage_subscription: "Cliquez ici pour gérer votre abonnement.."
    new_password: "Nouveau mot de passe"
    new_password_verify: "Vérifier"
    type_in_email: "Entrez votre adresse e-mail pour confirmer la supression de votre compte" # {change}
    type_in_email_progress: "Entrez votre adresse e-mail pour confirmer la supression de votre progression."
    type_in_password: "Entrez aussi votre mot de passe."
    email_subscriptions: "Abonnements"
    email_subscriptions_none: "Aucun e-mail d'abonnement."
    email_announcements: "Annonces"
    email_announcements_description: "Recevoir des e-mails sur les dernières actualités et sur le développement de CodeCombat."
    email_notifications: "Notifications"
    email_notifications_summary: "Commandes pour personaliser les notifications automatiques d'e-mail liées à votre activité sur CodeCombat."
    email_any_notes: "Toutes les notifications"
    email_any_notes_description: "Désactivez pour ne plus recevoir de notifications par e-mail."
    email_news: "Actualités"
    email_recruit_notes: "Offres d'emploi"
    email_recruit_notes_description: "Si vous jouez vraiment bien, nous pouvons vous contacter pour vous proposer un (meilleur) emploi."
    contributor_emails: "E-mails des contributeurs"
    contribute_prefix: "Nous recherchons des personnes pour se joindre à notre groupe ! Consultez la "
    contribute_page: "page de contributions"
    contribute_suffix: " pour en savoir plus."
    email_toggle: "Tout basculer"
    error_saving: "Problème d'enregistrement"
    saved: "Changements sauvegardés"
    password_mismatch: "Le mot de passe ne correspond pas."
    password_repeat: "Veuillez s'il vous plaît répéter votre mot de passe"

  keyboard_shortcuts:
    keyboard_shortcuts: "Raccourcis Clavier"
    space: "Espace"
    enter: "Entrer"
    press_enter: "Appuyez sur entrée"
    escape: "Echap"
    shift: "Shift"
    run_code: "Exécuter le code actuel."
    run_real_time: "Exécuter en temps réel."
    continue_script: "Continuer le script passé courant."
    skip_scripts: "Passer le plus de scripts possibles."
    toggle_playback: "Basculer entre lecture/pause."
    scrub_playback: "Avancer et reculer dans le temps."
    single_scrub_playback: "Avancer et reculer dans le temps au coup par coup."
    scrub_execution: "Avancer dans l'exécution du sort."
    toggle_debug: "Afficher la console de déboggage"
    toggle_grid: "Afficher une grille"
    toggle_pathfinding: "Toggle pathfinding overlay."
    beautify: "Embellissez votre code en normalisant sa mise en forme."
    maximize_editor: "Maximiser/minimiser l'éditeur de code."

  community:
    main_title: "Communauté CodeCombat"
    introduction: "Découvrez les façons dont vous pouvez vous impliquer ci-dessous et décidez ce qui semble le plus amusant. Nous sommes impatients de travailler avec vous !"
    level_editor_prefix: "Utiliser le CodeCombat"
    level_editor_suffix: "pour créer et modifier des niveaux. Les utilisateurs ont créé des niveaux pour leurs classes, amis, hackathons, étudiants et leurs frères et sœurs. Si créer un nouveau niveau est intimidant, vous pouvez commencer par forker un des nôtres !"
    thang_editor_prefix: "Nous appelons les unités dans le jeu 'thangs'. Utilisez-le"
    thang_editor_suffix: "pour modifier l'illustration de la source de CodeCombat. Permettre aux unités de lancer des projectiles, de modifier la direction de l'animation, de changer les points de vie d'une unité, ou de télécharger vos propres sprites vectorielles."
    article_editor_prefix: "Vous voyez une erreur dans certaines de nos docs ? Vous voulez faire des instructions pour vos propres créations ? Découvrez-le"
    article_editor_suffix: "et aidez les joueurs CodeCombat à tirer le meilleur parti de leur temps de jeu."
    find_us: "Trouvez-nous sur ces sites"
    social_github: "Venez voir tous les codes sources sur Github"
    social_blog: "Lire le blog CodeCombat sur Sett"
    social_discource: "Participez à la discussion sur notre forum Discourse"
    social_facebook: "Aimer CodeCombat sur Facebook"
    social_twitter: "Suivre CodeCombat sur Twitter"
    social_gplus: "Rejoindre CodeCombat sur Google+"
    social_slack: "Bavardez avec nous sur la chaîne publique Slack de CodeCombat."
    contribute_to_the_project: "Contribuer au projet"

  clans:
    clan: "Clan"
    clans: "Clans"
    new_name: "Nouveau nom de clan"
    new_description: "Description du nouveau clan"
    make_private: "Rendre le clan privé"
    subs_only: "Abonnés seulement"
    create_clan: "Créer un nouveau clan"
    private_preview: "Aperçu"
    private_clans: "Clans privés"
    public_clans: "Clans publics"
    my_clans: "Mes clans"
    clan_name: "Nom du clan"
    name: "Nom"
    chieftain: "Chef"
    edit_clan_name: "Modifier le nom du clan"
    edit_clan_description: "Modifier la description du clan"
    edit_name: "Modifier nom"
    edit_description: "modifier description"
    private: "(privé)"
    summary: "Sommaire"
    average_level: "Moyenne de niveau"
    average_achievements: "Moyenne de réalisations"
    delete_clan: "Délétion de clan"
    leave_clan: "Partir du clan"
    join_clan: "Rejoindre le clan"
    invite_1: "Inviter:"
    invite_2: "*Inviter des joueurs au Clan en leur envoyant le lien suivant."
    members: "Membres"
    progress: "Progression"
    not_started_1: "Non commencé"
    started_1: "démarré"
    complete_1: "compléter"
    exp_levels: "Étendre les niveaux"
    rem_hero: "Retirer l'héros"
    status: "Status"
    complete_2: "Compléter"
    started_2: "Démarré"
    not_started_2: "Non démarré"
    view_solution: "Cliquer pour voir la solution"
    view_attempt: "Cliquer pour voir la tentative."
    latest_achievement: "Réalisation Récentes"
    playtime: "Temps de jeu"
    last_played: "Dernière période de jeu"
    leagues_explanation: "Jouer dans une ligue contre d'autres membres de clan dans cette arène multijoueurs.."
#    track_concepts1: "Track concepts"
    track_concepts2a: "appris par chaque élèves"
    track_concepts2b: "appris par chaque membres"
    track_concepts3a: "Suivre les niveaux complétés par chaque élève"
    track_concepts3b: "Suivre les niveaux complétés par chaque membre"
    track_concepts4a: "Voir vos élèves"
    track_concepts4b: "Voir vos membres'"
    track_concepts5: "Solutions"
    track_concepts6a: "Classer les élèves par nom ou avancement"
    track_concepts6b: "Classer les membres par nom ou avancement"
    track_concepts7: "Nécessite une invitation"
    track_concepts8: "Joindre"
    private_require_sub: "Les clans privés nécessitent un abonnement pour être créés ou rejoins."

  courses:
    course: "Cours"
    courses: "cours"
    create_new_class: "Créer une Nouvelle Classe"
    not_enrolled: "Vous n'êtes pas inscrit à ce cours."
    visit_pref: "Veuillez visiter la"
    visit_suf: "page d'inscription."
    select_class: "Selectionnez l'une de vos classes"
#    unnamed: "*unnamed*"
    select: "Selectionner"
    unnamed_class: "Classe sans nom"
    edit_settings: "modifier les réglages de la classe"
    edit_settings1: "Modifier les Réglages de la Classe"
    progress: "Evolution de la Classe"
    add_students: "Ajouter des Elèves"
    stats: "Statistiques"
    total_students: "Nombre total d'élèves:"
    average_time: "Temps moyen de jeu par niveau:"
    total_time: "Temps total de jeu:"
    average_levels: "Nombre de niveaux moyen complétés:"
    total_levels: "Total de niveaux complétés :"
    furthest_level: "Meilleur niveau complété :"
    students: "Elèves"
    students1: "éleves"
    concepts: "Conceptes"
    levels: "niveaux"
    played: "Joué"
    play_time: "Temps de jeu:"
    completed: "Complété:"
    invite_students: "Inviter des élèves à rejoindre cette classe."
    invite_link_header: "Lien pour rejoindre le cours"
    invite_link_p_1: "Partagez ce lien aux élèves voulant rejoindre le cours."
    invite_link_p_2: "Ou laissez-nous leur envoyer un email directement:"
#    capacity_used: "Course slots used:"
    enter_emails: "Entrez les adresses emails des élèves à inviter, à raison d'une par ligne" # {change}
    send_invites: "Envoyer les invitations" # {change}
    creating_class: "Creation de la classe..."
    purchasing_course: "Achat de cours..."
    buy_course: "Acheter des Cours"
    buy_course1: "Acheter ce cours"
    select_all_courses: "Sélectionnez 'Tous les cours' pour une réduction de 50%!"
    all_courses: "Tous les Cours"
#    number_programming_students: "Number of Programming Students"
#    number_total_students: "Total Students in School/District"
    enter_number_students: "Entrez le nombre d'élèves dont vous avez besoin pour cette classe."
    name_class: "Nommez votre classe"
    displayed_course_page: "Cette information sera affichée sur la page des cours pour vous et vos élèves. Elle pourra être changée plus tard."
    buy: "Acheter"
    purchasing_for: "Vous achetez une licence pour"
    creating_for: "Vous créez une classe pour"
    for: "pour" # Like in 'for 30 students'
    receive_code: "Après, vous recevrez un code à distribuer à vos élèves, pour qu'ils puissent s'inscrir dans votre cours."
    free_trial: "Essai gratuit pour les professeurs !"
    get_access: "pour obtenir un accès individuel à tous les cours pour évaluation."
    questions: "Questions?"
    teachers_click: "Professeurs, Clickez Ici"
    students_click: "Elèves, Clickez Ici"
    courses_on_coco: "Cours sur CodeCombat"
#    designed_to: "Courses are designed to introduce computer science concepts using CodeCombat's fun and engaging environment. CodeCombat levels are organized around key topics to encourage progressive learning, over the course of 5 hours."
    more_in_less: "Apprenez plus en moins de temps"
    no_experience: "Aucune expérience en développement requise"
    easy_monitor: "Suivez facilement la progression des élèves"
    purchase_for_class: "Achetez un cours pour votre classe. C'est très simple de rajouter vos élèves !"
    see_the: "Voir"
    more_info: "Pour plus d'informations."
    choose_course: "Choisissez votre cours:"
    enter_code: "Entrez un code de déverouillage pour rejoindre une classe existante"
    enter_code1: "Entrez le code de déverouillage"
    enroll: "Inscription"
    pick_from_classes: "Sélectionnez depuis vos classes actuelles"
    enter: "Entrer"
    or: "Ou"
    topics: "Sujets"
    hours_content: "Heures de contenu :"
    get_free: "Obtenez des cours GRATUITS"
    enroll_paid: "Inscrire des élèves aux cours payants"
    you_have1: "Vous avez"
    you_have2: "inscriptions payantes non utilisées" # {change}
    use_one: "Utilisez 1 inscription payante pour" # {change}
    use_multiple: "Utilisez des inscriptions payantes pour les élèves suivants :" # {change}
    already_enrolled: "déjà inscrit"
    licenses_remaining: "licenses restantes:"
    insufficient_enrollments: "inscriptions payantes insuffisantes" # {change}
    get_enrollments: "Obtenir plus d'inscriptions"
    change_language: "Changez la langue du cours"
    keep_using: "Continuer à utiliser"
    switch_to: "Changer"
    greetings: "Salutations!"
    back_classrooms: "Retour à mes classes"
    back_courses: "Retour à mes cours"
    edit_details: "Modifier les informations de la classe"
    enrolled_courses: "inscrit aux cours payants :"
    purchase_enrollments: "Acheter des inscriptions" # {change}
    remove_student: "enlever l'élève"
    assign: "Assigner"
#    to_assign: "to assign paid courses."
    student: "Etudiant"
    teacher: "Professeur"
    complete: "Terminer"
    none: "Aucun"
    play_campaign_title: "Jouer la Campagne"
    play_campaign_description: "Vous êtes prêts pour la prochaine étape ! Explorez des centaines de niveaux stimulants, apprenez al programmation avancée, et rivalisez avec d'autres dans les arènes multijoueurs !"
    create_account_title: "Créer un compte"
    create_account_description: "Inscrivez-vous GRATUITEMENT à CodeCombat et accédez à plus de niveaux, plus de compétences de programmation et plus de fun !"
    preview_campaign_title: "Campagne de démonstration"
    preview_campaign_description: "Ayez un aperçu de tout ce dont CodeCombat a à offrir avant de s'enregistrer GRATUITEMENT."
    arena: "Arène"
    arena_soon_title: "L'Arène arrive prochainement"
    arena_soon_description: "Nous travaillons sur une arène multijoueur pour les classes à la fin de"
    not_enrolled1: "Non inscrit"
    not_enrolled2: "Demandez à votre professeur de vous inscrire au cours suivant."
    next_course: "Cours suivant"
    coming_soon1: "Prochainement"
    coming_soon2: "Nous travaillons dur pour faire plus de nouveaux cours !"
    available_levels: "Niveaux disponibles"
    welcome_to_courses: "Aventurier, bienvenu dans les leçons !"
    ready_to_play: "Prêt à jouer ?"
    start_new_game: "Nouvelle Partie"
    play_now_learn_header: "Jouer pour apprendre"
    play_now_learn_1: "la syntaxe basique pour controller votre personnage"
    play_now_learn_2: "les boucles while pour résoudre des problèmes complexes"
    play_now_learn_3: "des chaines de caractères & des variables pour personnaliser des actions"
    play_now_learn_4: "comment battre un ogre (compétence importante dans la vie !)"
    welcome_to_page: "Bienvenu sur la page des Cours !" # {change}
    completed_hoc: "Génial! Tu as fini le cours Heur de Codage!"
    ready_for_more_header: "Motivé pour plus ? Jouez au mode campagne !"
    ready_for_more_1: "Utilisez des gemmes pour débloquer de nouveaux acessoires !"
    ready_for_more_2: "Jouez à travers de nouveaux mondes et challenges"
    ready_for_more_3: "Apprenez encore plus de programmation !"
    saved_games: "Parties enregistrées"
    hoc: "Heures de Code"
    my_classes: "Mes Classes"
    class_added: "Classe ajoutée avec succès !"
    view_levels: "voir les niveaux" # {change}
    join_class: "Rejoindre une classe"
#    join_class_2: "Join class"
    ask_teacher_for_code: "Demandez à votre professeur si vous avez un code de classe CodeCombat ! Si c'est le cas, veuillez l'entrer ci-dessous :"
    enter_c_code: "<Entrer le Code de la Classe>"
    join: "Rejoindre"
    joining: "En train de rejoindre la classe"
    course_complete: "Cours Terminé"
    play_arena: "Jouer à l'Arene"
#    view_project: "View Project"
    start: "Démarrer"
    last_level: "Dernier Niveau" # {change}
    welcome_to_hoc: "Aventuriers, bienvenu à note heur de codage!"
    logged_in_as: "Connecté en tant que :"
    not_you: "Pas vous ?"
    welcome_back: "Salut aventurier, content de te revoir !"
    continue_playing: "Continuer à Jouer"
    more_options: "Plus d'options:"
    option1_header: "Option 1 : Inviter les élèves par email" # {change}
    option1_body: "Les élèves recevront automatiquement une invitation à rejoindre cette classe, et devront créer un compte avec un nom d'utilisateur et mot de passe." # {change}
    thank_you_pref: "Merci pour votre achat ! Vous pouvez maintenant assigner"
    thank_you_suff: "plus d'élèves à des cours payants."
    return_to_class: "Retourner à la classe"
    return_to_course_man: "Retourner à la gestion des cours."
    students_not_enrolled: "élèves non inscrits"
    total_all_classes: "Total dans toutes les classes"
    how_many_enrollments: "De combien d'inscriptions payantes supplémentaires avez-vous besoin ?" # {change}
    each_student_access: "Chaque élève dans une classe aura accès aux cours 2 à 4 une fois qu'il sera inscrit dans les cours payants. Vous pouvez assignez chaque cours à chacun des élèves individuellement."
    purchase_now: "Achetez Maintenant"
    enrollments: "inscriptions"
    remove_student1: "Supprimer l'élève"
    are_you_sure: "Êtes-vous certain de vouloir supprimer cet élève de cette classe ?"
    remove_description1: "L'élève n'aura plus accès à cette classe et les classes associées. L'évolution et les personnages ne seront pas supprimés, et l'élève pourra de nouveau rejoindre la classe n'importe quand."
    remove_description2: "Une licence payante activée ne sera pas remboursée."
    keep_student: "Conserver l'élève"
    removing_user: "Suppression de l'utilisateur"
    to_join_ask: "Pour rejoindre une classe, veuillez demander un code de déverouillage à votre professeur."
    join_this_class: "Rejoindre cette classe"
    enter_here: "<entrer le code de déverouillage>"
    successfully_joined: "Inscription avec succès"
    click_to_start: "Cliquer ici pour démarrer"
    my_courses: "Mes Cours"
    classroom: "Classe"
    use_school_email: "utilisez votre email scolaire si vous en avez un"
    unique_name: "un nom unique que personne n'a choisi"
    pick_something: "choisissez quelque chose dont vous pourrez vous souvenir"
    class_code: "Code de la Classe"
    optional_ask: "facultatif - demandez à votre professeur de vous en donner un !"
    optional_school: "facultatif - à quelle école allez-vous?"
    start_playing: "Commencer à Jouer"
    skip_this: "Ignorer cette étape, je créerai un compte ultérieurement !"
    welcome: "Bienvenu"
    getting_started: "Démarrer les cours"
    download_getting_started: "Télécharger le guide de démarrage [PDF]"
    getting_started_1: "Créez une nouvelle classe en cliquant sur le bouton vert ci-dessous 'Créer une Nouvelle Classe'."
    getting_started_2: "Une fois que vous avez créé une classe, cliquez sur le bouton bleu 'Ajouter des élèves'."
    getting_started_3: "Vous verrez la progression des élèves ci-dessous au fur et à mesure qu'ils rejoignent la classe."
#    educator_wiki_pref: "Or check out our new"
#    educator_wiki_mid: "educator wiki"
#    educator_wiki_suff: "to browse the guide online."
    your_classes: "Vos Classes"
    no_classes: "Aucune classe pour le moment !"
    create_new_class1: "créer une nouvelle classe"
    available_courses: "Cours Disponibles"
    unused_enrollments: "Inscriptions non utilisées disponibles :" # {change}
    students_access: "Tous les élèves peuvent accéder gratuitement à l'Introduction aux Sciences Informations. Une inscription par élève est nécessaire pour rejoindre les cours payants de CodeCombat. Une seule inscription est nécessaire par élève pour accéder à tous les cours payants." # {change}
    active_courses: "cours actifs"
    no_students: "Aucun élève pour le moment !"
    add_students1: "ajouter des élèves"
    view_edit: "voir/modifier"
    students_enrolled: "élèves inscrits"
    students_assigned: "élèves attribués"
    length: "Durée:"
#    subtitle: "Review course overviews and levels" # Flat style redesign
#    changelog: "View latest changes to course levels."
    select_language: "Selectionner langue"
    select_level: "Selectionner niveau"
    play_level: "Jouer le niveau"
    concepts_covered: "Conceptes Couverts"
    print_guide: "Imprimer Guide (PDF)"
    view_guide_online: "Voir Guide En Ligne (PDF)" # {change}
#    grants_lifetime_access: "Grants access to all Courses."
#    enrollment_credits_available: "Licenses Available:"
#    language_select: "Select a language" # ClassroomSettingsModal
    language_cannot_change: "Le language ne peut être changé une fois qu'un élève à rejoins la classe."
    learn_p: "Apprendre Python"
    learn_j: "Apprendre JavaScript"
#    avg_student_exp_label: "Average Student Programming Experience"
#    avg_student_exp_desc: "This will help us understand how to pace courses better."
#    avg_student_exp_select: "Select the best option"
#    avg_student_exp_none: "No Experience - little to no experience"
#    avg_student_exp_beginner: "Beginner - some exposure or block-based"
#    avg_student_exp_intermediate: "Intermediate - some experience with typed code"
#    avg_student_exp_advanced: "Advanced - extensive experience with typed code"
#    avg_student_exp_varied: "Varied Levels of Experience"
#    student_age_range_label: "Student Age Range"
#    student_age_range_younger: "Younger than 6"
#    student_age_range_older: "Older than 18"
#    student_age_range_to: "to"
    create_class: "Créer une Classe"
    class_name: "Nom de la classe"
#    teacher_account_restricted: "Your account is a teacher account and cannot access student content."
#    account_restricted: "A student account is required to access this page."
#    update_account_login_title: "Log in to update your account"
#    update_account_title: "Your account needs attention!"
#    update_account_blurb: "Before you can access your classes, choose how you want to use this account."
#    update_account_current_type: "Current Account Type:"
#    update_account_account_email: "Account Email/Username:"
    update_account_am_teacher: "Je suis un professeur"
#    update_account_keep_access: "Keep access to classes I've created"
    update_account_teachers_can: "Les comptes professeurs peuvent :"
    update_account_teachers_can1: "Créer/manager/ajouter des classes"
#    update_account_teachers_can2: "Assign/enroll students in courses"
#    update_account_teachers_can3: "Unlock all course levels to try out"
#    update_account_teachers_can4: "Access new teacher-only features as we release them"
#    update_account_teachers_warning: "Warning: You will be removed from all classes that you have previously joined and will not be able to play as a student."
#    update_account_remain_teacher: "Remain a Teacher"
#    update_account_update_teacher: "Update to Teacher"
    update_account_am_student: "Je suis un étudiant"
#    update_account_remove_access: "Remove access to classes I have created"
    update_account_students_can: "Les comptes étudiant peuvent :"
#    update_account_students_can1: "Join classes"
#    update_account_students_can2: "Play through courses as a student and track your own progress"
#    update_account_students_can3: "Compete against classmates in arenas"
#    update_account_students_can4: "Access new student-only features as we release them"
#    update_account_students_warning: "Warning: You will not be able to manage any classes that you have previously created or create new classes."
#    update_account_remain_student: "Remain a Student"
#    update_account_update_student: "Update to Student"
#    need_a_class_code: "You'll need a Class Code for the class you're joining:"
#    update_account_not_sure: "Not sure which one to choose? Email"
#    update_account_confirm_update_student: "Are you sure you want to update your account to a Student experience?"
#    update_account_confirm_update_student2: "You will not be able to manage any classes that you have previously created or create new classes. Your previously created classes will be removed from CodeCombat and cannot be restored."
#    instructor: "Instructor: "
#    youve_been_invited_1: "You've been invited to join "
#    youve_been_invited_2: ", where you'll learn "
#    youve_been_invited_3: " with your classmates in CodeCombat."
#    by_joining_1: "By joining "
#    by_joining_2: "will be able to help reset your password if you forget or lose it. You can also verify your email address so that you can reset the password yourself!"
#    sent_verification: "We've sent a verification email to:"
#    you_can_edit: "You can edit your email address in "
#    account_settings: "Account Settings"
#    select_your_hero: "Select Your Hero"
#    select_your_hero_description: "You can always change your hero by going to your Courses page and clicking \"Change Hero\""
#    select_this_hero: "Select this Hero"
#    current_hero: "Current Hero:"
#    change_hero: "Change Hero"
#    web_dev_language_transition: "All classes program in HTML / JavaScript for this course.  Classes that have been using Python will start with extra JavaScript intro levels to ease the transition.  Classes that are already using JavaScript will skip the intro levels."

  teacher:
#    course_solution: "Course Solution"
#    level_overview_solutions: "Level Overview and Solutions"
#    teacher_dashboard: "Teacher Dashboard" # Navbar
#    my_classes: "My Classes"
#    courses: "Course Guides"
#    enrollments: "Student Licenses"
#    resources: "Resources"
#    help: "Help"
#    students: "Students" # Shared
#    language: "Language"
#    edit_class_settings: "edit class settings"
#    complete: "Complete"
#    access_restricted: "Account Update Required"
#    teacher_account_required: "A teacher account is required to access this content."
#    create_teacher_account: "Create Teacher Account"
#    what_is_a_teacher_account: "What's a Teacher Account?"
#    teacher_account_explanation: "A CodeCombat Teacher account allows you to set up classrooms, monitor students’ progress as they work through courses, manage licenses and access resources to aid in your curriculum-building."
#    current_classes: "Current Classes"
    archived_classes: "Cours Archivés"
#    archived_classes_blurb: "Classes can be archived for future reference. Unarchive a class to view it in the Current Classes list again."
    view_class: "Voir Cours"
    archive_class: "Archiver Cours"
    unarchive_class: "Désarchiver cours"
    unarchive_this_class: "Désarchiver ce cours"
    no_students_yet: "Ce cours n'a pas encore d'élèves."
#    no_students_yet_view_class: "View class to add students."
#    try_refreshing: "(You may need to refresh the page)"
    add_students: "Ajouter Elèves"
    create_new_class: "Créer une Nouveau Cour"
#    class_overview: "Class Overview" # View Class page
#    avg_playtime: "Average level playtime"
#    total_playtime: "Total play time"
#    avg_completed: "Average levels completed"
#    total_completed: "Total levels completed"
#    created: "Created"
#    concepts_covered: "Concepts covered"
#    earliest_incomplete: "Earliest incomplete level"
#    latest_complete: "Latest completed level"
#    enroll_student: "Enroll student"
#    apply_license: "Apply License"
#    course_progress: "Course Progress"
#    not_applicable: "N/A"
#    edit: "edit"
#    edit_2: "Edit"
#    remove: "remove"
#    latest_completed: "Latest completed:"
#    sort_by: "Sort by"
#    progress: "Progress"
#    completed: "Completed"
#    started: "Started"
#    click_to_view_progress: "click to view progress"
#    no_progress: "No progress"
#    select_course: "Select course to view"
#    students_not_assigned: "Students who have not been assigned {{courseName}}"
#    course_overview: "Course Overview"
#    copy_class_code: "Copy Class Code"
#    class_code_blurb: "Students can join your class using this Class Code. No email address is required when creating a Student account with this Class Code."
#    copy_class_url: "Copy Class URL"
#    class_join_url_blurb: "You can also post this unique class URL to a shared webpage."
#    add_students_manually: "Invite Students by Email"
#    bulk_assign: "Bulk-assign"
#    assigned_msg_1: "{{numberAssigned}} students were assigned {{courseName}}."
#    assigned_msg_2: "{{numberEnrolled}} licenses were applied."
#    assigned_msg_3: "You now have {{remainingSpots}} available licenses remaining."
#    assign_course: "Assign Course"
#    not_assigned_modal_title: "Courses were not assigned"
#    not_assigned_modal_body_1: "You do not have enough licenses available to assign additional Courses to all {{selected}} selected students."
#    not_assigned_modal_body_2: "You only have {{totalSpotsAvailable}} licenses available ({{unenrolledStudents}} students did not have an active license)."
#    not_assigned_modal_body_3: "Please select fewer students, or reach out to {{email}} for assistance."
#    assign_to_selected_students: "Assign to Selected Students"
#    assigned: "Assigned"
#    enroll_selected_students: "Enroll Selected Students"
#    no_students_selected: "No students were selected."
#    guides_coming_soon: "Guides coming soon!" # Courses
#    show_students_from: "Show students from" # Enroll students modal
#    apply_licenses_to_the_following_students: "Apply Licenses to the Following Students"
#    students_have_licenses: "The following students already have licenses applied:"
#    all_students: "All Students"
#    apply_licenses: "Apply Licenses"
#    not_enough_enrollments: "Not enough licenses available."
#    enrollments_blurb: "Students are required to have a license to access any content after the first course."
#    credits_available: "Licenses Available"
#    total_unique_students: "Total Students"
#    total_enrolled_students: "Enrolled Students"
#    unenrolled_students: "Unenrolled Students"
#    add_enrollment_credits: "Add Licenses"
#    purchasing: "Purchasing..."
#    purchased: "Purchased!"
#    purchase_now: "Purchase Now"
#    how_to_enroll: "How to Enroll Students"
#    how_to_apply_licenses: "How to Apply Licenses"
#    bulk_pricing_blurb: "Purchasing for more than 25 students? Contact us to discuss next steps."
#    total_unenrolled: "Total unenrolled"
#    export_student_progress: "Export Student Progress (CSV)"
#    send_email_to: "Send Recover Password Email to:"
#    email_sent: "Email sent"
#    send_recovery_email: "Send recovery email"
#    enter_new_password_below: "Enter new password below:"
#    change_password: "Change Password"
#    changed: "Changed"
#    available_credits: "Available Licenses"
#    pending_credits: "Pending Licenses"
#    credits: "licenses"
#    start_date: "start date:"
#    end_date: "end date:"
#    get_enrollments_blurb: " We'll help you build a solution that meets the needs of your class, school or district."
#    how_to_apply_licenses_blurb_1: "When a teacher assigns a course to a student for the first time, we’ll automatically apply a license. Use the bulk-assign dropdown in your classroom to assign a course to selected students:"
#    how_to_apply_licenses_blurb_2: "Can I still apply a license without assigning a course?"
#    how_to_apply_licenses_blurb_3: "Yes — go to the License Status tab in your classroom and click \"Apply License\" to any student who does not have an active license."
#    request_sent: "Request Sent!"
#    enrollment_status: "Enrollment Status"
#    license_status: "License Status"
#    status_expired: "Expired on {{date}}"
#    status_not_enrolled: "Not Enrolled"
#    status_enrolled: "Expires on {{date}}"
#    select_all: "Select All"
#    projects: "Projects"
#    project: "Project"
#    view_student_project: "View Student Project"
#    view_arena_ladder: "View Arena Ladder"
#    resource_hub: "Resource Hub"
#    getting_started: "Getting Started"
#    educator_faq: "Educator FAQ"
#    educator_faq_desc: "Frequently asked questions about using CodeCombat in your classroom or school."
#    teacher_getting_started: "Teacher Getting Started Guide"
#    teacher_getting_started_desc: "New to CodeCombat? Download this Teacher Getting Started Guide to set up your account, create your first class, and invite students to the first course."
#    student_getting_started: "Student Quick Start Guide"
#    student_getting_started_desc: "You can distribute this guide to your students before starting CodeCombat so that they can familiarize themselves with the code editor. This guide can be used for both Python and JavaScript classrooms."
#    cs1: "Introduction to Computer Science"
#    cs2: "Computer Science 2"
#    cs3: "Computer Science 3"
#    cs1_syntax_python: "Course 1 Python Syntax Guide"
#    cs1_syntax_python_desc: "Cheatsheet with references to common Python syntax that students will learn in Introduction to Computer Science."
#    cs1_syntax_javascript: "Course 1 JavaScript Syntax Guide"
#    cs1_syntax_javascript_desc: "Cheatsheet with references to common JavaScript syntax that students will learn in Introduction to Computer Science."
#    coming_soon: "Additional guides coming soon!"
#    engineering_cycle_worksheet: "Engineering Cycle Worksheet"
#    engineering_cycle_worksheet_desc: "Use this worksheet to teach students the basics of the engineering cycle: Assess, Design, Implement and Debug. Refer to the completed example worksheet as a guide."
#    engineering_cycle_worksheet_link: "View example"
#    progress_journal: "Progress Journal"
#    progress_journal_desc: "Encourage students to keep track of their progress via a progress journal."
#    cs1_curriculum: "Introduction to Computer Science - Curriculum Guide"
#    cs1_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 1."
#    cs2_curriculum: "Computer Science 2 - Curriculum Guide"
#    cs2_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 2."
#    cs3_curriculum: "Computer Science 3 - Curriculum Guide"
#    cs3_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 3."
#    cs1_pairprogramming: "Pair Programming Activity"
#    cs1_pairprogramming_desc: "Introduce students to a pair programming exercise that will help them become better listeners and communicators."
#    unlock_resources: "Unlock more resources!"
#    unlock_resources_desc: "Gain access to additional guides by adding student licenses to your account. Request a demo today to get started."
#    request_demo: "Request Demo"
#    student_overview: "Overview"
#    student_email: "Student Email"
#    no_email: "Student has no email address set."
#    student_profile: "Student Profile"
#    playtime_detail: "Playtime Detail"
#    student_completed: "Student Completed"
#    student_in_progress: "Student in Progress"
#    class_average: "Class Average"
#    not_assigned: "has not been assigned the following courses"
#    playtime_axis: "Playtime in Seconds"
#    levels_axis: "Levels in"
#    student_state: "How is"
#    student_state_2: "doing?"
#    student_good: "is doing well in"
#    student_good_detail: "This student is keeping pace with the class."
#    student_warn: "might need some help in"
#    student_warn_detail: "This student might need some help with new concepts that have been introduced in this course."
#    student_great: "is doing great in"
#    student_great_detail: "This student might be a good candidate to help other students working through this course."

#  sharing:
#    game: "Game"
#    webpage: "Webpage"
#    your_students_preview: "Your students will click here to see their finished projects! Unavailable in teacher preview."
#    unavailable: "Link sharing not available in teacher preview."
#    share_game: "Share This Game"
#    share_web: "Share This Webpage"
#    victory_share_prefix: "Share this link to invite your friends & family to"
#    victory_share_game: "play your game level"
#    victory_share_web: "view your webpage"
#    victory_share_suffix: "."
#    victory_course_share_prefix: "This link will let your friends & family"
#    victory_course_share_game: "play the game"
#    victory_course_share_web: "view the webpage"
#    victory_course_share_suffix: "you just created."
#    copy_url: "Copy URL"

#  game_dev:
#    creator: "Creator"

#  web_dev:
#    image_gallery_title: "Image Gallery"
#    select_an_image: "Select an image you want to use"
#    scroll_down_for_more_images: "(Scroll down for more images)"
#    copy_the_url: "Copy the URL below"
#    copy_the_url_description: "Useful if you want to replace an existing image."
#    copy_the_img_tag: "Copy the <img> tag"
#    copy_the_img_tag_description: "Useful if you want to insert a new image."
#    copy_url: "Copy URL"
#    copy_img: "Copy <img>"
#    how_to_copy_paste: "How to Copy/Paste"
#    copy: "Copy"
#    paste: "Paste"
#    back_to_editing: "Back to Editing"

  classes:
    archmage_title: "Archimage"
    archmage_title_description: "(Développeur)"
    archmage_summary: "Si vous êtes développeur, intéréssé par le développement de jeux éducatifs, devenez un Archimage et aidez-nous à construire CodeCombat !"
    artisan_title: "Artisan"
    artisan_title_description: "(Créateur de niveau)"
    artisan_summary: "Créez et partagez des niveaux pour y jouer avec vos amis. Devenz un Artisan pour apprendre l'art d'enseigner la programmation."
    adventurer_title: "Aventurier"
    adventurer_title_description: "(Testeur de niveau)"
    adventurer_summary: "Jouez aux derniers niveaux (même ceux reservés aux abonnés) une semaine en avance gratuitement, et aidez-nous à déceler les bugs avant la sortie publique."
    scribe_title: "Scribe"
    scribe_title_description: "(Rédacteur d'articles)"
    scribe_summary: "Un bon code nécéssite une bonne documentation. Ecrivez, corrigez et améliorez la documentation lue par des millions de joueurs autour du monde."
    diplomat_title: "Diplomate"
    diplomat_title_description: "(Traducteur)"
    diplomat_summary: "CodeCombat est traduit dans plus de 45 langues par nos Diplomates. Aidez-nous, et contribuez à ces traductions."
    ambassador_title: "Ambassadeur"
    ambassador_title_description: "(Aide)"
    ambassador_summary: "Domptez les membres du forum, et guidez ceux qui ont besoin d'aide. Nos ambassadeurs représentent CodeCombat face au monde."
    teacher_title: "Professeur"

  editor:
    main_title: "Éditeurs CodeCombat"
    article_title: "Éditeur d'article"
    thang_title: "Éditeur Thang"
    level_title: "Éditeur de niveau"
#    course_title: "Course Editor"
    achievement_title: "Éditeur de succès"
    poll_title: "Éditeur de sondage"
    back: "Retour"
    revert: "Annuler"
    revert_models: "Annuler les modèles"
    pick_a_terrain: "Choisir un terrain"
    dungeon: "Donjon"
    indoor: "Intérieur"
    desert: "Desert"
    grassy: "Herbeux"
    mountain: "Montagne"
    glacier: "Glacier"
    small: "Petit"
    large: "Large"
    fork_title: "Fork une nouvelle version"
    fork_creating: "Créer un Fork..."
    generate_terrain: "Générer le terrain"
    more: "Plus"
    wiki: "Wiki"
    live_chat: "Chat en direct"
    thang_main: "Principal"
    thang_spritesheets: "Feuilles des sprites"
    thang_colors: "Couleurs"
    level_some_options: "Quelques options ?"
    level_tab_thangs: "Thangs"
    level_tab_scripts: "Scripts"
    level_tab_components: "Composants"
    level_tab_systems: "Systèmes"
    level_tab_docs: "Documentation"
    level_tab_thangs_title: "Thangs actuels"
    level_tab_thangs_all: "Tout"
    level_tab_thangs_conditions: "Conditions de départ"
    level_tab_thangs_add: "Ajouter des Thangs"
    level_tab_thangs_search: "Rechercher des Thangs"
    add_components: "Ajouter des composants"
    component_configs: "Configuration des composants"
    config_thang: "Double-cliquez pour configurer un Thang"
    delete: "Supprimer"
    duplicate: "Dupliquer"
    stop_duplicate: "Arrêter la duplication"
    rotate: "Pivoter"
    level_component_tab_title: "Composants actuels"
    level_component_btn_new: "Créer un nouveau composant"
    level_systems_tab_title: "Systèmes actuels"
    level_systems_btn_new: "Créer un nouveau système"
    level_systems_btn_add: "Ajouter un système"
    level_components_title: "Retourner à tous les Thangs"
    level_components_type: "Type"
    level_component_edit_title: "Éditer le composant"
    level_component_config_schema: "Configurer le schéma"
    level_system_edit_title: "Éditer le système"
    create_system_title: "Créer un nouveau système"
    new_component_title: "Créer un nouveau composant"
    new_component_field_system: "Système"
    new_article_title: "Créer un nouvel article"
    new_thang_title: "Créer un nouveau type de Thang"
    new_level_title: "Créer un nouveau niveau"
    new_article_title_login: "Identifiez-vous pour créer un nouvel article"
    new_thang_title_login: "Identifiez-vous pour créer un nouveau type de Thang"
    new_level_title_login: "Identifiez-vous pour créer un nouveau niveau"
    new_achievement_title: "Créer un nouveau succès"
    new_achievement_title_login: "Connectez vous pour créer un nouveau succès"
    new_poll_title: "Créer un nouveau sondage"
    new_poll_title_login: "Connectez vous pour créer un nouveau sondage"
    article_search_title: "Rechercher dans les articles"
    thang_search_title: "Rechercher dans les types de Thang"
    level_search_title: "Rechercher dans les niveaux"
    achievement_search_title: "Rechercher des succès"
    poll_search_title: "Recherche de sondages"
    read_only_warning2: "Note: vous ne pouvez sauvegarder aucune édition, car vous n'êtes pas identifié."
    no_achievements: "Aucun succès n'a encore été ajouté à ce niveau."
    achievement_query_misc: "Réalisations clés en provenance de miscellanea"
    achievement_query_goals: "Succés important hors des objectifs de niveau"
    level_completion: "Niveau d'achèvement"
    pop_i18n: "Renseigner I18N"
    tasks: "Tâches"
    clear_storage: "Vider vos changements locaux"
    add_system_title: "Ajouter des sysèmes au niveau"
    done_adding: "Fait Ajouter"

  article:
    edit_btn_preview: "Prévisualiser"
    edit_article_title: "Éditer l'article"

  polls:
    priority: "Priorité"

  contribute:
    page_title: "Contribution"
    intro_blurb: "CodeCombat est 100% open source ! Des centaines de joueurs dévoués nous ont aidé à construire le jeu tel qu'il est aujourd'hui. Rejoignez-nous et écrivez le prochain chapitre dans la quête de CodeCombat d'enseigner au monde à coder !"
    alert_account_message_intro: "Et tiens !"
    alert_account_message: "Pour souscrire aux e-mails, vous devez être connecté"
    archmage_introduction: "L'une des meilleures parties de la création d'un jeu est qu'il regroupe tant de choses différentes. Graphismes, sons, réseau en temps réel, réseaux sociaux, et bien sûr bien d'autres aspects de la programmation, de la gestion bas niveau de base de données, et de l'administration de serveur à l'élaboration d'interfaces utilisateur. Il y a tant à faire, et si vous êtes un programmeur expérimenté avec une aspiration à vraiment plonger dans le fond de CodeCombat, cette classe est faite pour vous. Nous aimerions avoir votre aide pour le meilleur jeu de développement de tous les temps."
    class_attributes: "Attributs de classe"
    archmage_attribute_1_pref: "Connaissance en "
    archmage_attribute_1_suf: ", ou le désir d'apprendre. La plupart de notre code est écrit avec ce langage. Si vous êtes fan de Ruby ou Python, vous vous sentirez chez vous. C'est du JavaScript, mais avec une syntaxe plus sympathique."
    archmage_attribute_2: "De l'expérience en développement et en initiatives personnelles. Nous vous aiderons à vous orienter, mais nous ne pouvons pas passer plus de temps à vous entraîner."
    how_to_join: "Comment nous rejoindre"
    join_desc_1: "N'importe qui peut aider ! Vous avez seulement besoin de regarder "
    join_desc_2: "pour commencer, et cochez la case ci-dessous pour vous marquer comme un courageux archimage et obtenir les dernières nouvelles par e-mail. Envie de discuter de ce qu'il y a à faire ou de comment être plus impliqué ? "
    join_desc_3: ", ou trouvez-nous dans nos "
    join_desc_4: "et nous partirons de là !"
    join_url_email: "Contactez-nous"
#    join_url_slack: "public Slack channel"
    archmage_subscribe_desc: "Recevoir un e-mail sur les nouvelles possibilités de développement et des annonces."
    artisan_introduction_pref: "Nous devons créer des niveaux additionnels ! Les gens veulent plus de contenu, et nous ne pouvons pas tous les créer nous-même. Maintenant votre station de travail est au niveau un ; notre éditeur de niveaux est à peine utilisable même par ses créateurs, donc méfiez-vous. Si vous avez des idées sur la boucle for de"
    artisan_introduction_suf: ", cette classe est faite pour vous."
    artisan_attribute_1: "Une expérience dans la création de contenu comme celui-ci serait un plus, comme utiliser l'éditeur de niveaux de Blizzard. Mais ce n'est pas nécessaire !"
    artisan_attribute_2: "Vous aspirez à faire beaucoup de tests et d'itérations. Pour faire de bons niveaux, vous aurez besoin de les proposer aux autres et les regarder les jouer, et être prêt à trouver un grand nombre de choses à corriger."
    artisan_attribute_3: "Pour l'heure, endurance en binôme avec un Aventurier. Notre éditeur de niveaux est vraiment préliminaire et frustrant à l'utilisation. Vous êtes prévenus !"
    artisan_join_desc: "Utilisez le créateur de niveaux pour à peu près ces étapes :"
    artisan_join_step1: "Lire la documentation."
    artisan_join_step2: "Crééz un nouveau niveau et explorez les niveaux existants."
    artisan_join_step3: "Retrouvez-nous dans notre conversation Slack pour obtenir de l'aide."
    artisan_join_step4: "Postez vos niveaux dans le forum pour avoir des retours."
    artisan_subscribe_desc: "Recevoir un e-mail sur les annonces et mises à jour de l'éditeur de niveaux."
    adventurer_introduction: "Soyons clair à propos de votre rôle : vous êtes le tank. Vous allez subir beaucoup de dégâts. Nous avons besoin de gens pour essayer les nouveaux niveaux et aider à identifier comment améliorer les choses. La douleur sera énorme; faire de bons jeux est une longue tâche et personne n'y arrive du premier coup. Si vous pouvez résister et avez un gros score de constitution, alors cette classe est faite pour vous."
    adventurer_attribute_1: "Une soif d'apprendre. Vous voulez apprendre à développer et nous voulons vous apprendre. Vous allez toutefois faire la plupart de l'apprentissage."
    adventurer_attribute_2: "Charismatique. Soyez doux mais exprimez-vous sur ce qui a besoin d'être amélioré, et faites des propositions sur comment l'améliorer."
    adventurer_join_pref: "Soit faire équipe avec (ou recruter!) un artisan et travailler avec lui, ou cocher la case ci-dessous pour recevoir un e-mail quand il y aura de nouveaux niveaux à tester. Nous parlons aussi des niveaux à réviser sur notre réseau"
    adventurer_forum_url: "notre forum"
    adventurer_join_suf: "si vous préférez être avertis ainsi, inscrivez-vous ici !"
    adventurer_subscribe_desc: "Recevoir un e-mail lorsqu'il y a de nouveaux niveaux à tester."
    scribe_introduction_pref: "CodeCombat n'est pas seulement un ensemble de niveaux. Il contiendra aussi des ressources pour la connaissance, un wiki des concepts de programmation que les niveaux pourront illustrer. Dans ce but, chaque Artisan pourra, au lieu d'avoir à décrire en détail ce qu'est un opérateur de comparaison, seulement lier son niveau à l'article qui le décrit et qui a été écrit pour aider les joueurs. Quelque chose dans le sens de ce que le "
    scribe_introduction_url_mozilla: "Mozilla Developer Network"
    scribe_introduction_suf: " a développé. Si votre définition de l'amusement passe par le format Markdown, alors cette classe est pour vous."
    scribe_attribute_1: "Les compétences rédactionnelles sont quasiment la seule chose dont vous aurez besoin. Pas seulement la grammaire et l'orthographe, mais être également capable de lier des idées ensembles."
    contact_us_url: "Contactez-nous" # {change}
    scribe_join_description: "parlez-nous un peu de vous, de votre expérience en programmation et de quels sujets vous souhaitez traiter. Nous partirons de là !"
    scribe_subscribe_desc: "Recevoir un e-mail sur les annonces d'écriture d'article."
    diplomat_introduction_pref: "Si nous avons appris quelque chose du "
    diplomat_launch_url: "lancement en octobre"
    diplomat_introduction_suf: "c'est qu'il y a un intérêt considérable pour CodeCombat dans d'autres pays, particulièrement au Brésil ! Nous créons une équipe de traducteurs pour changer une liste de mots en une autre pour que CodeCombat soit le plus accessible possible à travers le monde. Si vous souhaitez avoir un aperçu des prochains contenus et avoir les niveaux dans votre langue le plus tôt possible, alors cette classe est faite pour vous."
    diplomat_attribute_1: "Des facilités en anglais et dans la langue que vous souhaitez traduire. Pour transmettre des idées complexes, il est important d'avoir une solide compréhension des deux !"
    diplomat_i18n_page_prefix: "Vous pouvez commencer à traduire nos niveaux en allant sur notre "
    diplomat_i18n_page: "page de traduction"
    diplomat_i18n_page_suffix: ", ou notre interface et le site Web sur GitHub."
    diplomat_join_pref_github: "Trouvez le fichier de langue souhaité "
    diplomat_github_url: "sur GitHub"
    diplomat_join_suf_github: ", modifiez en ligne, et soumettez des requêtes. Cochez aussi cette case ci-dessous pour vous tenir à jour sur les nouveaux développements d'internationalisation !"
    diplomat_subscribe_desc: "Recevoir un e-mail sur le développement i18n et les niveaux à traduire."
    ambassador_introduction: "C'est la communauté que nous construisons, et vous en êtes les connexions. Nous avons des discussions via le chat Olark, e-mails et les réseaux sociaux avec plusieurs personnes, et l'aide vient à la fois du jeu lui-même et grâce à lui. Si vous voulez aider les gens, prendre part à l'aventure et vous amuser, avec un bon feeling de CodeCombat et ce vers quoi nous allons, alors cette classe est faite pour vous."
    ambassador_attribute_1: "Compétences en communication. Être capable d'identifier les problèmes que les joueurs ont et les aider à les résoudre. Mais aussi nous tenir informés de ce que les joueurs disent, ce qu'ils aiment et n'aiment pas et d'autres choses de ce genre !"
    ambassador_join_desc: "parlez-nous un peu de vous, de ce que vous avez fait et ce qui vous aimeriez faire. Nous partirons de ça !"
    ambassador_join_note_strong: "Note"
    ambassador_join_note_desc: "Une de nos priorités est de développer un jeu multijoueur où les joueurs qui ont du mal à réussir un niveau peuvent demander de l'aide à un joueur de plus haut niveau. Ce sera un bon moyen pour que les ambassadeurs fassent leur travail. Nous vous garderons en ligne !"
    ambassador_subscribe_desc: "Recevoir un e-mail sur les mises à jour de l'aide et les développements multijoueur."
#    teacher_subscribe_desc: "Get emails on updates and announcements for teachers."
    changes_auto_save: "Les changements sont sauvegardés automatiquement quand vous changez l'état des cases à cocher."
    diligent_scribes: "Nos Scribes assidus :"
    powerful_archmages: "Nos puissants Archimages :"
    creative_artisans: "Nos Artisans créatifs :"
    brave_adventurers: "Nos braves Aventuriers :"
    translating_diplomats: "Nos Diplomates traducteurs :"
    helpful_ambassadors: "Nos serviables Ambassadeurs :"

  ladder:
    please_login: "Identifie-toi avant de jouer à un ladder game."
    my_matches: "Mes matchs"
    simulate: "Simuler"
    simulation_explanation: "En simulant une partie, tu peux classer ton rang plus rapidement !"
#    simulation_explanation_leagues: "You will mainly help simulate games for allied players in your clans and courses."
    simulate_games: "Simuler une partie !"
    games_simulated_by: "Parties que vous avez simulées :"
    games_simulated_for: "Parties simulées pour vous :"
    games_in_queue: "Parties actuellement en attente :"
    games_simulated: "Parties simulées"
    games_played: "Parties jouées"
    ratio: "Moyenne"
    leaderboard: "Classement"
    battle_as: "Combattre comme "
    summary_your: "Vos "
    summary_matches: "Matchs - "
    summary_wins: " Victoires, "
    summary_losses: " Défaites"
    rank_no_code: "Nouveau code à classer"
    rank_my_game: "Classer ma partie !"
    rank_submitting: "Soumission en cours..."
    rank_submitted: "Soumis pour le classement"
    rank_failed: "Erreur lors du classement"
    rank_being_ranked: "Partie en cours de classement"
    rank_last_submitted: "Envoyé "
    help_simulate: "De l'aide pour simuler vos parties"
    code_being_simulated: "Votre nouveau code est en cours de simulation par les autres joueurs pour le classement. Cela va se rafraîchir lorsque d'autres matchs auront lieu."
    no_ranked_matches_pre: "Pas de match classé pour l'équipe "
    no_ranked_matches_post: "! Affronte d'autres compétiteurs et reviens ici pour classer ta partie."
    choose_opponent: "Choisir un Adversaire"
    select_your_language: "Selectionnez votre langage !"
    tutorial_play: "Jouer au tutoriel"
    tutorial_recommended: "Recommandé si tu n'as jamais joué avant"
    tutorial_skip: "Passer le tutoriel"
    tutorial_not_sure: "Pas sûr de ce qu'il se passe ?"
    tutorial_play_first: "Jouer au tutoriel d'abord."
    simple_ai: "IA simple" # {change}
    warmup: "Échauffement"
    friends_playing: "Amis en train de jouer"
    log_in_for_friends: "Connectez-vous pour jouer avec vos amis !"
    social_connect_blurb: "Connectez-vous pour jouer contre vos amis !"
    invite_friends_to_battle: "Invitez vos amis à rejoindre la bataille !"
    fight: "Combattez !"
    watch_victory: "Regardez votre victoire"
    defeat_the: "Vaincre le"
    watch_battle: "Regarder le combat"
    tournament_started: ", a démarré"
    tournament_ends: "Fin du tournoi"
    tournament_ended: "Tournoi terminé"
    tournament_rules: "Règles du tournoi"
    tournament_blurb: "Écrire du code, collecter de l'or, construire des armées, écraser les ennemis, gagner des prix, et mettre à jour votre carrière dans notre tournoi $ 40,000 Greed! Découvrez les détails"
    tournament_blurb_criss_cross: "Gagnez des offres, construisez des chemins, déjouez les adversaires, emparez-vous des gemmes, et améliorez votre carrière dans notre tournoi Criss-Cross! Découvrez les détails"
    tournament_blurb_zero_sum: "Libérez votre créativité en programmation dans l'accumulation d'or et de tactiques de combat dans ce combat épique entre le sorcier rouge et bleu. Le tournoi a commencé vendredi le 27 mars et se déroulera jusqu'à lundi le 6 avril à 5PM PDT. Battez-vous pour le plaisir et l'honneur! Aller voir les détails."
#    tournament_blurb_ace_of_coders: "Battle it out in the frozen glacier in this domination-style mirror match! The tournament began on Wednesday, September 16 and will run until Wednesday, October 14 at 5PM PDT. Check out the details"
    tournament_blurb_blog: "Sur notre blog"
    rules: "Règles"
    winners: "Gagnants"
    league: "Ligue"
    red_ai: "Rouge IA" # "Red AI Wins", at end of multiplayer match playback
    blue_ai: "Bleue IA" # {change}
    wins: "Victoires" # At end of multiplayer match playback
    humans: "Rouge" # Ladder page display team name
    ogres: "Bleue"

  user:
    stats: "Stats"
    singleplayer_title: "Niveaux solo"
    multiplayer_title: "Niveaux multijoueurs"
    achievements_title: "Succès"
    last_played: "Dernier niveau joué"
    status: "Statut"
    status_completed: "Terminé"
    status_unfinished: "Non terminé"
    no_singleplayer: "Aucune partie jouée pour le moment"
    no_multiplayer: "Aucune partie multijoueur pour le moment"
    no_achievements: "Aucun succès gagné pour le moment."
    favorite_prefix: "Langage favori : "
    favorite_postfix: "."
    not_member_of_clans: "Ne fais partie d'aucun clan pour l'instant."

  achievements:
    last_earned: "Dernièrement gagné"
    amount_achieved: "Quantité"
    achievement: "Succès"
    current_xp_prefix: ""
    current_xp_postfix: " au total"
    new_xp_prefix: ""
    new_xp_postfix: " gagné"
    left_xp_prefix: ""
    left_xp_infix: " jusqu'au niveau "
    left_xp_postfix: ""

  account:
    payments: "Paiements"
    prepaid_codes: "Codes prépayés"
    purchased: "Acheté"
    subscription: "Souscrit"
    invoices: "Factures"
    service_apple: "Apple"
    service_web: "Web"
    paid_on: "Payé"
    service: "Service"
    price: "Prix"
    gems: "Gemmes"
    active: "Actif"
    subscribed: "Inscrit"
    unsubscribed: "Désincrit"
    active_until: "Actif jusqu'à"
    cost: "Coût"
    next_payment: "Prochain paiement"
    card: "Carte"
    status_unsubscribed_active: "Vous n'êtes pas inscrit et ne serez pas facturé, mais votre compte est toujours actif."
    status_unsubscribed: "Obtenez l'accès à de nouveaux niveaux, héros, objets et gemmes en bonus avec une inscription à CodeCombat !"
#    not_yet_verified: "Not yet verified."
#    resend_email: "Resend email"
#    email_sent: "Email sent! Check your inbox."
#    verifying_email: "Verifying your email address..."
#    successfully_verified: "You've successfully verified your email address!"
#    back_to_student_page: "Go back to student things"
#    back_to_teacher_page: "Go to My Classes"
#    back_to_game: "Go play some more levels!"
#    verify_error: "Something went wrong when verifying your email :("

  account_invoices:
    amount: "Montant (Dollars US)"
    declined: "Votre carte a été refusée"
    invalid_amount: "Entrez un montant en dollars US."
    not_logged_in: "Connectez-vous ou créez un compte pour accéder aux factures."
    pay: "Paiement de facture"
    purchasing: "Achat..."
    retrying: "Erreur interne, réessayez"
    success: "Paiement accepté, merci !"

  account_prepaid:
    purchase_code: "Acheter un code d'abonnement"
    purchase_code1: "Les codes d'abonnement peuvent seulement être racheter pour ajouter des comptes prenium à un ou plusieurs comptes de CodeCombat"
#    purchase_code2: "Each CodeCombat account can only redeem a particular Subscription Code once."
#    purchase_code3: "Subscription Code months will be added to the end of any existing subscription on the account."
    users: "Utilisateurs"
    months: "Mois"
    purchase_total: "Total"
#    purchase_button: "Submit Purchase"
    your_codes: "Vos codes"
#    redeem_codes: "Redeem a Subscription Code"
#    prepaid_code: "Prepaid Code"
#    lookup_code: "Lookup prepaid code"
#    apply_account: "Apply to your account"
#    copy_link: "You can copy the code's link and send it to someone."
    quantity: "Quantité"
#    redeemed: "Redeemed"
    no_codes: "Pas de code soumis"
    you_can1: "Vous pouvez"
    you_can2: "achetez un code pré-payé"
    you_can3: "qui pourra être appliqué à votre compte ou donné à un autre."

#  coppa_deny:
#    text1: "Can’t wait to learn programming?"
#    text2: "Your parents will need to create an account for you to use! Email team@codecombat.com if you have any questions."
#    close: "Close Window"

  loading_error:
    could_not_load: "Erreur de chargement du serveur"
    connection_failure: "La connexion a échoué."
#    connection_failure_desc: "It doesn’t look like you’re connected to the internet! Check your network connection and then reload this page."
#    login_required: "Login Required"
#    login_required_desc: "You need to be logged in to access this page."
    unauthorized: "Vous devez être identifié pour faire cela. Avez-vous désactivé les cookies ?"
    forbidden: "Vous n'avez pas la permission."
#    forbidden_desc: "Oh no, there’s nothing we can show you here! Make sure you’re logged into the correct account, or visit one of the links below to get back to programming!"
    not_found: "Introuvable."
#    not_found_desc: "Hm, there’s nothing here. Visit one of the following links to get back to programming!"
    not_allowed: "Méthode non autorisée."
    timeout: "Délai de connexion au serveur écoulé." # {change}
    conflict: "Conflit de ressources."
    bad_input: "Données incorrectes ."
    server_error: "Erreur serveur."
    unknown: "Erreur inconnue." # {change}
    error: "ERREUR"
#    general_desc: "Something went wrong, and it’s probably our fault. Try waiting a bit and then refreshing the page, or visit one of the following links to get back to programming!"

  resources:
    level: "Niveau"
    patch: "Patch"
    patches: "Patchs"
    system: "Système"
    systems: "Systèmes"
    component: "Composant"
    components: "Composants"
    hero: "Héros"
    campaigns: "Campagnes"

  concepts:
    advanced_strings: "Chaînes de caractères avancés"
    algorithms: "Algorithmes"
    arguments: "Paramètres"
    arithmetic: "Arithmétique"
    arrays: "Tableaux"
    basic_syntax: "Syntaxe basique"
    boolean_logic: "Logique Booléenne"
    break_statements: "Déclarations de sortie"
    classes: "Classes"
    continue_statements: "Instructions Continuer"
    for_loops: "Boucles Pour"
    functions: "Fonctions"
    graphics: "Graphiques"
    if_statements: "Déclarations conditionnelles Si"
    input_handling: "Manipulation des entrées"
    math_operations: "Opérations mathématiques"
    object_literals: "Objets littéraux"
    parameters: "Paramètres"
    strings: "Chaînes de caractères"
    variables: "Variables"
    vectors: "Vecteurs"
    while_loops: "Boucles Tant que" # {change}
    recursion: "Récursivité"
#    basic_html: "Basic HTML" # TODO: these web-dev concepts will change, don't need to translate
#    basic_css: "Basic CSS"
#    basic_web_scripting: "Basic Web Scripting"
#    intermediate_html: "Intermediate HTML"
#    intermediate_css: "Intermediate CSS"
#    intermediate_web_scripting: "Intermediate Web Scripting"
#    advanced_html: "Advanced HTML"
#    advanced_css: "Advanced CSS"
#    advanced_web_scripting: "Advanced Web Scripting"
#    jquery: "jQuery"
#    bootstrap: "Bootstrap"

  delta:
    added: "Ajouté"
    modified: "Modifié"
    not_modified: "Non modifié"
    deleted: "Supprimé"
    moved_index: "Index changé"
    text_diff: "Différence de texte"
    merge_conflict_with: "Fusionner les conflits avec"
    no_changes: "Aucuns changements"

  legal:
    page_title: "Mentions légales"
    opensource_intro: "CodeCombat est complètement gratuit et open source."
    opensource_description_prefix: "Regardez "
    github_url: "notre GitHub"
    opensource_description_center: "et aidez nous si vous voulez ! CodeCombat est construit sur plusieurs projets open source, et nous les aimons. Regardez "
    archmage_wiki_url: "notre wiki des Archimages"
    opensource_description_suffix: "pour trouver la liste des logiciels qui rendent ce jeu possible."
    practices_title: "Bonnes pratiques"
    practices_description: "Ce sont les promesses que nous vous faisons à vous, les joueurs, en jargon un peu juridique."
    privacy_title: "Vie privée"
    privacy_description: "Nous ne vendons aucune de vos informations personnelles."
    security_title: "Sécurité"
    security_description: "Nous faisons tout notre possible pour conserver la confidentialité de vos informations personnelles. En tant que projet open source, notre site est ouvert à tous ceux qui souhaitent examiner et améliorer nos systèmes de sécurité."
    email_title: "E-mail"
    email_description_prefix: "Nous ne vous innonderons pas d'e-mail. Grâce à"
    email_settings_url: "vos paramètres d'e-mail "
    email_description_suffix: "ou avec des liens disponibles dans nos e-mails, vous pouvez changer vos préférences ou vous désinscrire à tout moment."
    cost_title: "Coût"
#    cost_description: "CodeCombat is free to play for all of its core levels, with a ${{price}} USD/mo subscription for access to extra level branches and {{gems}} bonus gems per month. You can cancel with a click, and we offer a 100% money-back guarantee."
    copyrights_title: "Copyrights et Licences"
    contributor_title: "Contributor License Agreement"
    contributor_description_prefix: "Toute contribution, sur le site et sur le répertoire GitHub, est sujette à nos"
    cla_url: "CLA"
    contributor_description_suffix: "auxquelles vous devez vous soumettre avant de contribuer."
    code_title: "Code - MIT"
    code_description_prefix: "Tout code siglé CodeCombat ou hébergé sur codecombat.com, sur le répertoire GitHub ou dans la base de données de codecombat.com, est sous la licence"
    mit_license_url: "MIT"
    code_description_suffix: "Cela inclut le code dans Systèmes et Composants qui est rendu disponible par CodeCombat dans le but de créer des niveaux."
    art_title: "Art/Musique - Creative Commons "
    art_description_prefix: "Tout le contenu commun est sous licence"
    cc_license_url: "Creative Commons Attribution 4.0 International"
    art_description_suffix: "Le contenu commun est tout ce qui est rendu disponible par CodeCombat afin de créer des niveaux. Cela inclut :"
    art_music: "La musique"
    art_sound: "Le son"
    art_artwork: "Les artworks"
    art_sprites: "Les sprites"
    art_other: "Tout le reste du contenu non-code qui est rendu accessible lors de la création de niveaux."
    art_access: "Pour l'instant il n'y a aucun système universel et facile pour rassembler ces ressources. En général, accédez-y par les URL comme le fait le site, contactez-nous pour de l'aide, ou aidez-nous à agrandir le site pour rendre ces ressources plus facilement accessibles."
    art_paragraph_1: "Pour l'attribution, s'il vous plaît, nommez et référencez codecombat.com près de la source utilisée ou dans un endroit approprié. Par exemple:"
    use_list_1: "Si utilisé dans un film ou un autre jeu, incluez codecombat.com dans le générique."
    use_list_2: "Si utilisé sur un site web, incluez un lien près de l'utilisation, par exemple sous une image, ou sur une page d'attribution générale où vous pourrez aussi mentionner les autres travaux en Creative Commons et les logiciels open source utilisés sur votre site. Quelque chose qui fait clairement référence à CodeCombat, comme un article de blog mentionnant CodeCombat, n'a pas besoin d'attribution séparée."
    art_paragraph_2: "Si le contenu utilisé n'est pas créé par CodeCombat mais par un autre utilisateur de codecombat.com, attribuez-le à cet utilisateur, et suivez les recommandations fournies dans la ressource de la description s'il y en a."
    rights_title: "Droits réservés"
    rights_desc: "Tous les droits sont réservés pour les niveaux eux-mêmes. Cela inclut"
    rights_scripts: "Les scripts"
    rights_unit: "La configuration unitaire"
    rights_writings: "L'écriture"
    rights_media: "Les médias (sons, musiques) et tous les autres contenus créatifs créés spécialement pour ce niveau et non rendus généralement accessibles en créant des niveaux."
    rights_clarification: "Pour clarifier, tout ce qui est rendu accessible dans l'éditeur de niveaux dans le but de créer des niveaux est sous licence CC, tandis que le contenu créé avec l'éditeur de niveaux ou uploadé dans le but de créer un niveau ne l'est pas."
    nutshell_title: "En un mot"
    nutshell_description: "Chaque ressource que nous fournissons dans l'éditeur de niveau est libre d'utilisation pour créer des niveaux. Mais nous nous réservons le droit de restreindre la distribution des niveaux créés (qui sont créés sur codecombat.com) ils peuvent donc devenir payants dans le futur, si c'est ce qui doit arriver."
    canonical: "La version de ce document est la version définitive et canonique. En cas d'irrégularité dans les traductions, le document anglais fait foi."
    third_party_title: "Services tiers"
    third_party_description: "CodeCombat utilise les services tiers suivants, entre autres :"

  ladder_prizes:
    title: "Prix du tournoi" # This section was for an old tournament and doesn't need new translations now.
    blurb_1: "Ces prix seront décernés à"
    blurb_2: "Régles du tournoi"
    blurb_3: "aux meilleurs joueurs humains et ogre."
    blurb_4: "Deux équipes, les prix doubles !"
    blurb_5: "(Il y aura deux gagnants en première place, deux gagnants en deuxième place, etc.)"
    rank: "Rang"
    prizes: "Prix"
    total_value: "Valeur totale"
    in_cash: "en espèces"
    custom_wizard: "Magicien CodeCombat personnalisé"
    custom_avatar: "Avatar CodeCombat personnalisé"
#    heap: "for six months of \"Startup\" access"
    credits: "Crédits"
    one_month_coupon: "coupon: choisir entre Rails ou HTML"
    one_month_discount: "30% de réduction: choisir entre Rails ou HTML"
    license: "Licence"
    oreilly: "ebook de votre choix"

  calendar:
    year: "Année"
    day: "Jour"
    month: "Mois"
    january: "Janvier"
    february: "Février"
    march: "Mars"
    april: "Avril"
    may: "Mai"
    june: "Juin"
    july: "Juillet"
    august: "Août"
    september: "Septembre"
    october: "Octobre"
    november: "Novembre"
    december: "Décembre"
