module.exports = nativeDescription: "日本語", englishDescription: "Japanese", translation:
  new_home:
    slogan: "一番ステキなプログラミング学習ゲーム"
    classroom_edition: "教室版:"
    learn_to_code: "コードを学ぼう:"
    teacher: "先生"
    student: "学生"
    play_now: "今すぐプレイ"
    im_a_teacher: "私は先生です"
    im_a_student: "私は学生です"
    learn_more: "もっと知りたい"
    classroom_in_a_box: "コンピュータサイエンスが学べる箱の中の教室"
    codecombat_is: "CodeCombatは<strong>生徒のための</strong>実際にゲームを遊びながらコンピュータサイエンスを学べるプラットフォームです"
    our_courses: "私たちのコースはそれまでプログラミング経験がなかった先生でも<strong>教室ですばらしい</strong>プレイテストをされています。"
    top_screenshots_hint: "生徒がコードを書くとリアルタイムでその変更による変化を見れます"
    designed_with: "先生のための設計"
    real_code: "実際に,コードをタイピング"
    from_the_first_level: "それもはじめから"
    getting_students: "生徒にできるだけ早くコードを書かせることがプログラミングの文法や正しい構造を学ぶのに重要です。"
    educator_resources: "教育資源"
    course_guides: "とコースガイド"
    teaching_computer_science: "コンピュータサイエンスを教えるのに高い学位はいりません、私たちがすべての背景を持つ教育者にサポートするツールを提供します。"
    accessible_to: "みんなが"
    everyone: "アクセスできる"
    democratizing: "すべての人へのコーディング学習が私たちの哲学の中心です。みんながコードを学べるようになりましょう。"
#    forgot_learning: "I think they actually forgot that they were actually learning something."
#    wanted_to_do: " Coding is something I've always wanted to do, and I never thought I would be able to learn it in school."
#    why_games: "Why is learning through games important?"
#    games_reward: "Games reward the productive struggle."
#    encourage: "Gaming is a medium that encourages interaction, discovery, and trial-and-error. A good game challenges the player to master skills over time, which is the same critical process students go through as they learn."
#    excel: "Games excel at rewarding"
#    struggle: "productive struggle"
#    kind_of_struggle: "the kind of struggle that results in learning that’s engaging and"
#    motivating: "motivating"
#    not_tedious: "not tedious."
#    gaming_is_good: "Studies suggest gaming is good for children’s brains. (it’s true!)"
#    game_based: "When game-based learning systems are"
#    compared: "compared"
#    conventional: "against conventional assessment methods, the difference is clear: games are better at helping students retain knowledge, concentrate and"
#    perform_at_higher_level: "perform at a higher level of achievement"
#    feedback: "Games also provide real-time feedback that allows students to adjust their solution path and understand concepts more holistically, instead of being limited to just “correct” or “incorrect” answers."
#    real_game: "A real game, played with real coding."
#    great_game: "A great game is more than just badges and achievements - it’s about a player’s journey, well-designed puzzles, and the ability to tackle challenges with agency and confidence."
#    agency: "CodeCombat is a game that gives players that agency and confidence with our robust typed code engine, which helps beginner and advanced students alike write proper, valid code."
#    request_demo_title: "Get your students started today!"
#    request_demo_subtitle: "Request a demo and get your students started in less than an hour."
#    get_started_title: "Set up your class today"
#    get_started_subtitle: "Set up a class, add your students, and monitor their progress as they learn computer science."
#    request_demo: "Request a Demo"
#    setup_a_class: "Set Up a Class"
#    have_an_account: "Have an account?"
#    logged_in_as: "You are currently logged in as"
#    computer_science: "Computer science courses for all ages"
#    show_me_lesson_time: "Show me lesson time estimates for:"
#    curriculum: "Total curriculum hours:"
#    ffa: "Free for all students"
#    lesson_time: "Lesson time:"
#    coming_soon: "More coming soon!"
#    courses_available_in: "Courses are available in JavaScript and Python. Web Development courses utilize HTML, CSS, jQuery, and Bootstrap."
#    boast: "Boasts riddles that are complex enough to fascinate gamers and coders alike."
#    winning: "A winning combination of RPG gameplay and programming homework that pulls off making kid-friendly education legitimately enjoyable."
#    run_class: "Everything you need to run a computer science class in your school today, no CS background required."
#    goto_classes: "Go to My Classes"
#    view_profile: "View My Profile"
#    view_progress: "View Progress"
#    go_to_courses: "Go to My Courses"
#    want_coco: "Want CodeCombat at your school?"

  nav:
    play: "ゲームマップへ" # The top nav bar entry where players choose which levels to play
    community: "コミュニティー"
    courses: "コース"
    blog: "ブログ"
    forum: "掲示板"
    account: "アカウント"
    my_account: "マイアカウント"
    profile: "プロフィール"
    home: "ホーム"
    contribute: "コントリビュート"
    legal: "規約"
#    privacy: "Privacy"
    about: "CoCoについて"
    contact: "お問い合わせ"
    twitter_follow: "フォロー"
    teachers: "教育関係者"
    students: "生徒"
    careers: "経歴"
    facebook: "Facebook"
    twitter: "Twitter"
    create_a_class: "クラスを作る"
    other: "その他"
    learn_to_code: "コードを学ぶ!"
    toggle_nav: "ナビゲーションを下す"
    jobs: "職業"
    schools: "学校"
    get_involved: "参加しましょう"
    open_source: "オープンソース(GitHub)"
    support: "サポート"
    faqs: "FAQ"
    help_pref: "ヘルプが必要ですか? Email"
    help_suff: "をくれれば協力します！"
#    resource_hub: "Resource Hub"

  modal:
    close: "閉じる"
    okay: "OK"

  not_found:
    page_not_found: "ページが見つかりません"

  diplomat_suggestion:
    title: "CodeCombatを翻訳しましょう！" # This shows up when a player switches to a non-English language using the language selector.
    sub_heading: "あなたの言語力が必要です。"
    pitch_body: "CodeCombatは英語で開発されています。日本語でプレイしたい方がたくさんいますが、ゲームの多くはまだ英語のままです。もし、あなたが英語が得意であれば、外交官（翻訳者）として登録し、CodeCombatのレベルやサイトの翻訳にご協力ください。"
    missing_translations: "翻訳が完了していない部分は、英語で表示されます。"
    learn_more: "外交官について情報"
    subscribe_as_diplomat: "外交官登録"

  play:
    play_as: "プレイモード" # Ladder page
    compete: "コンプリート!" # Course details page
    spectate: "観戦" # Ladder page
    players: "プレイヤー" # Hover over a level on /play
    hours_played: "プレイ時間" # Hover over a level on /play
    items: "アイテム" # Tooltip on item shop button from /play
    unlock: "アンロック" # For purchasing items and heroes
    confirm: "ロックを解除？"
    owned: "所有品" # For items you own
    locked: "ロック"
    purchasable: "購入可能" # For a hero you unlocked but haven't purchased
    available: "使用可能"
    skills_granted: "追加されるスキル" # Property documentation details
    heroes: "ヒーロー" # Tooltip on hero shop button from /play
    achievements: "実績" # Tooltip on achievement list button from /play
    settings: "設定" # Tooltip on settings button from /play
    poll: "投票" # Tooltip on poll button from /play
    next: "次へ" # Go from choose hero to choose inventory before playing a level
    change_hero: "ヒーローの選択" # Go back from choose inventory to choose hero
    buy_gems: "ジェムを購入"
    subscription_required: "サブスクリプション必須"
    anonymous: "名無しのプレイヤー"
    level_difficulty: "難易度: "
    play_classroom_version: "教室版を遊ぶ" # Choose a level in campaign version that you also can play in one of your courses
    campaign_beginner: "初心者のキャンペーン"
    awaiting_levels_adventurer_prefix: "私たちは毎週新しいレベルをリリースします"
    awaiting_levels_adventurer: "冒険者として登録すると、"
    awaiting_levels_adventurer_suffix: "新たなレベルを最初に遊ぶ事ができます"
    adjust_volume: "音量を調整する"
    campaign_multiplayer: "マルチプレイ・アリーナ"
    campaign_multiplayer_description: "コーディングで他のプレイヤーに対して格闘しましょう"

  code:
    if: "もし" # Keywords--these translations show up on hover, so please translate them all, even if it's kind of long. (In the code editor, they will still be in English.)
    else: "でなければ"
    elif: "でなければ もし"
    while: "まで繰り返す"
    loop: "ずっと"
    for: "まで繰り返す"
    break: "繰り返しを終わる"
    continue: "次の繰り返しに続ける"
    pass: "パス"
    return: "返す"
    then: "なら"
    do: "実行する"
    end: "終わり"
    function: "関数"
    def: "宣言"
    var: "変数"
    self: "自分自身"
    hero: "ヒーロー"
    this: "この"
    or: "または"
    "||": "または"
    and: "かつ"
    "&&": "かつ"
    not: "ではなく"
    "!": "ではなく"
    "=": "代入"
    "==": "等しい"
    "===": "完全に等しい"
    "!=": "等しくない"
    "!==": "完全には等しくない"
    ">": "より大きい"
    ">=": "以上"
    "<": "より小さい"
    "<=": "以下"
    "*": "掛ける"
    "/": "割る"
    "+": "足す"
    "-": "引く"
    "+=": "足して代入"
    "-=": "引いて代入"
    True: "真"
    true: "真"
    False: "偽"
    false: "偽"
    undefined: "定義されていない"
    null: "空"
    nil: "空"
    None: "空"

  share_progress_modal:
    blurb: "あなたは進歩している！ CodeCombatでどんなに学んだかについて、誰かに伝えてください。"
    email_invalid: "メールアドレスが無効です"
    form_blurb: "下にメールアドレスを入力してください"
    form_label: "メールアドレス"
    placeholder: "メールアドレス"
    title: "良くやった、弟子よ"

  login:
    sign_up: "アカウント登録"
    email_or_username: "Eメールまたはユーザー名"
    log_in: "ログイン"
    logging_in: "ログイン中"
    log_out: "ログアウト"
    forgot_password: "パスワードをお忘れですか？"
    authenticate_gplus: "Google+を認証する"
    load_profile: "Google+プロフィールをロード"
    finishing: "仕上げ中"
    sign_in_with_facebook: "Facebookでログイン"
    sign_in_with_gplus: "Google+でログイン"
    signup_switch: "アカウントを作成しますか？"

  signup:
    create_student_header: "学生用アカウントを作成"
    create_teacher_header: "先生用アカウントを作成"
    create_individual_header: "個人用アカウントを作成"
    email_announcements: "新しいCodeCombatのレベルと機能についてのお知らせをメールで受け取る"
    creating: "アカウントを作成しています..."
    sign_up: "アカウント登録"
    log_in: "パスワードでログイン"
    required: "ログインする必要があります"
    login_switch: "すでにアカウントをお持ちですか？"
    school_name: "学校名と市名"
    optional: "オプション"
    school_name_placeholder: "ほにゃらら高校, なんとか市, 日本"
#    connect_with: "Connect with:"
#    connected_gplus_header: "You've successfully connected with Google+!"
#    connected_gplus_p: "Finish signing up so you can log in with your Google+ account."
#    gplus_exists: "You already have an account associated with Google+!"
#    connected_facebook_header: "You've successfully connected with Facebook!"
#    connected_facebook_p: "Finish signing up so you can log in with your Facebook account."
#    facebook_exists: "You already have an account associated with Facebook!"
#    hey_students: "Students, enter the class code from your teacher."
#    birthday: "Birthday"
#    parent_email_blurb: "We know you can't wait to learn programming &mdash; we're excited too! Your parents will receive an email with further instructions on how to create an account for you. Email {{email_link}} if you have any questions."
#    classroom_not_found: "No classes exist with this Class Code. Check your spelling or ask your teacher for help."
#    checking: "Checking..."
#    account_exists: "This email is already in use:"
#    sign_in: "Sign in"
#    email_good: "Email looks good!"
#    name_taken: "Username already taken! Try {{suggestedName}}?"
#    name_available: "Username available!"
#    name_is_email: "Username may not be an email"
#    choose_type: "Choose your account type:"
#    teacher_type_1: "Teach programming using CodeCombat!"
#    teacher_type_2: "Set up your class"
#    teacher_type_3: "Access Course Guides"
#    teacher_type_4: "View student progress"
#    signup_as_teacher: "Sign up as a Teacher"
#    student_type_1: "Learn to program while playing an engaging game!"
#    student_type_2: "Play with your class"
#    student_type_3: "Compete in arenas"
#    student_type_4: "Choose your hero!"
#    student_type_5: "Have your Class Code ready!"
#    signup_as_student: "Sign up as a Student"
#    individuals_or_parents: "Individuals & Parents"
#    individual_type: "For players learning to code outside of a class. Parents should sign up for an account here."
#    signup_as_individual: "Sign up as an Individual"
#    enter_class_code: "Enter your Class Code"
#    enter_birthdate: "Enter your birthdate:"
#    parent_use_birthdate: "Parents, use your own birthdate."
#    ask_teacher_1: "Ask your teacher for your Class Code."
#    ask_teacher_2: "Not part of a class? Create an "
#    ask_teacher_3: "Individual Account"
#    ask_teacher_4: " instead."
#    about_to_join: "You're about to join:"
#    enter_parent_email: "Enter your parent’s email address:"
#    parent_email_error: "Something went wrong when trying to send the email. Check the email address and try again."
#    parent_email_sent: "We’ve sent an email with further instructions on how to create an account. Ask your parent to check their inbox."
#    account_created: "Account Created!"
#    confirm_student_blurb: "Write down your information so that you don't forget it. Your teacher can also help you reset your password at any time."
#    confirm_individual_blurb: "Write down your login information in case you need it later. Verify your email so you can recover your account if you ever forget your password - check your inbox!"
#    write_this_down: "Write this down:"
#    start_playing: "Start Playing!"
#    sso_connected: "Successfully connected with:"
#    select_your_starting_hero: "Select Your Starting Hero:"
#    you_can_always_change_your_hero_later: "You can always change your hero later."

  recover:
    recover_account_title: "パスワードを忘れた場合"
    send_password: "パスワードを送信する"
    recovery_sent: "復旧メールが送信されました"

  items:
    primary: "武器"
    secondary: "防具"
    armor: "鎧"
    accessories: "アクセサリー"
    misc: "その他"
    books: "書物"

  common:
    back: "戻る" # When used as an action verb, like "Navigate backward"
    coming_soon: "近日公開!"
    continue: "次へ" # When used as an action verb, like "Continue forward"
    default_code: "元のコード"
    loading: "ロード中"
    overview: "あらすじ"
    solution: "回答"
    intro: "はじめに"
    saving: "セーブ中..."
    sending: "送信中..."
    send: "送信"
    sent: "送信済"
    cancel: "キャンセル"
    save: "セーブ"
    publish: "発行"
    create: "作成"
    fork: "分かれ"
    play: "ゲームスタート" # When used as an action verb, like "Play next level"
    retry: "リトライ"
    actions: "アクション"
    info: "情報"
    help: "ヘルプ"
    watch: "見る"
    unwatch: "見ない"
    submit_patch: "パッチを送信"
    submit_changes: "変更を送信"
    save_changes: "変更を保存"
    required_field: "記入漏れ" # {change}

  general:
    and: "と"
    name: "名前"
    date: "日付"
    body: "体"
    version: "バージョン"
    pending: "ペンディング"
    accepted: "容認済み"
    rejected: "拒否済み"
    withdrawn: "取り下げ済み"
    accept: "容認"
    reject: "拒否"
    withdraw: "取り下げ"
    submitter: "提出者"
    submitted: "提出されました"
    commit_msg: "コミットメッセージ"
    version_history: "バージョン履歴"
    version_history_for: "バージョン履歴："
    select_changes: "違いを見るには以下の二つの変更を選んで下さい"
    undo_prefix: "取り消す"
    undo_shortcut: "(Ctrl+Z)"
    redo_prefix: "やり直す"
    redo_shortcut: "(Ctrl+Shift+Z)"
    play_preview: "現在のレベルのプレビューを再生"
    result: "結果"
    results: "結果"
    description: "説明"
    or: "又は"
    subject: "件名"
    email: "メール"
    password: "パスワード"
    confirm_password: "パスワードの確認"
    message: "メッセージ"
    code: "コード"
    ladder: "ラダー"
    when: "いつ"
    opponent: "対戦者"
    rank: "ランク"
    score: "スコア"
    win: "勝ち"
    loss: "負け"
    tie: "引分"
    easy: "イージー"
    medium: "ミディアム"
    hard: "ハード"
    player: "プレイヤー"
    player_level: "プレイヤーレベル" # Like player level 5, not like level: Dungeons of Kithgard
    warrior: "戦士"
    ranger: "レンジャー"
    wizard: "ウィザード"
    first_name: "First Name(名)"
    last_name: "Last Name(姓)"
    last_initial: "イニシヤル"
    username: "ユーザー名"

  units:
    second: "秒"
    seconds: "秒"
    minute: "分"
    minutes: "分"
    hour: "時"
    hours: "時"
    day: "日"
    days: "日"
    week: "週"
    weeks: "週"
    month: "月"
    months: "月"
    year: "年"
    years: "年"

  play_level:
    level_complete: "レベルコンプリート"
    completed_level: "コンプリートレベル:"
    course: "コース:"
    done: "完了"
    next_level: "次のレベル"
    next_game: "次のゲーム"
    language: "言語"
    languages: "言語"
    programming_language: "プログラミング言語"
    show_menu: "ゲームメニューを見る"
    home: "ホーム" # Not used any more, will be removed soon.
    level: "ゲームレベル" # Like "Level: Dungeons of Kithgard"
    skip: "スキップ"
    game_menu: "ゲームメニュー"
    guide: "ガイド"
    restart: "再始動"
    goals: "目標"
    goal: "目標"
    running: "コンパイル中..."
    success: "成功！"
    incomplete: "不完全"
    timed_out: "時間切れ"
    failing: "失敗中"
    reload: "リロード"
    reload_title: "コードを再読み込ますか？"
    reload_really: "レベルをリセットします。よろしいですか？"
    reload_confirm: "リセットする"
    victory: "勝利"
    victory_title_prefix: ""
    victory_title_suffix: "クリア"
    victory_sign_up: "進行状況をセーブするにはアカウント登録をしてください"
    victory_sign_up_poke: "あなたのコードをセーブしてみませんか? 無料アカウント登録!"
    victory_rate_the_level: "このレベルは楽しめましたか?"
    victory_return_to_ladder: "ラダーに戻る"
    victory_saving_progress: "セーブ中"
    victory_go_home: "ホームに戻る"
    victory_review: "フィードバック"
    victory_review_placeholder: "どのレベルでしたか?"
    victory_hour_of_code_done: "完了してよろしいですか?"
    victory_hour_of_code_done_yes: "はい、構いません"
    victory_experience_gained: "XP獲得"
    victory_gems_gained: "ジェム獲得"
    victory_new_item: "ニューアイテム"
    victory_new_hero: "ニューヒーロー"
    victory_viking_code_school: "あなたはハードレベルのホーリー・スモークを打ち破りました! もしあなたが既にソフトウェア開発者でないなら, ぜひやってみましょう. あなたはちょうどViking Code Scoolで受け入れられるための出世街道にいます,そこでは次のレベルへのスキルを取得でき、14週間でプロのWeb開発者になれます。"
    victory_become_a_viking: "バイキングになる"
    victory_no_progress_for_teachers: "教師用の進捗は保存されません。しかし自分の教室に学生アカウントを加えることができます."
    guide_title: "ガイド"
    tome_cast_button_run: "実行"
    tome_cast_button_running: "実行中"
    tome_cast_button_ran: "実行済み"
    tome_submit_button: "送信"
    tome_reload_method: "このメソッドの元のコードをリロードする" # {change}
    tome_available_spells: "利用できる呪文"
    tome_your_skills: "あなたのスキル"
    tome_current_method: "現在のメソッド"
    hints: "ヒント"
    hints_title: "ヒント {{number}}"
    code_saved: "コードがセーブされました"
    skip_tutorial: "スキップ (esc)"
    keyboard_shortcuts: "キーショートカット"
    loading_ready: "準備完了！"
    loading_start: "レベルスタート"
    problem_alert_title: "コードを修正して下さい"
    time_current: "今："
    time_total: "最大："
    time_goto: "行く："
    non_user_code_problem_title: "レベルをロードできません"
    infinite_loop_title: "無限ループが見つかりました"
    infinite_loop_description: "最初のワールドを作るコードが終わりません。単に遅いか、無限ループになっているかでしょう。バグがあるのかもしれません。再試行してみたり、リセットしてデフォルトに戻すこともできます。もし直せないなら私たちに報告してください。"
    check_dev_console: "開発者コンソールをみてなにが間違っているか見ることもできます。"
    check_dev_console_link: "(説明書)"
    infinite_loop_try_again: "再試行する"
    infinite_loop_reset_level: "レベルをリセット"
    infinite_loop_comment_out: "マイコードをコメントアウト"
    tip_toggle_play: "Ctrl+Pで、プレイ／ポーズをトグルする"
    tip_scrub_shortcut: "Ctrl+[ と Ctrl+] で早戻し、早送りする"
    tip_guide_exists: "ゲームメニュー内のガイド（ページの上部）をクリックし、便利な情報 を見よう。"
    tip_open_source: "CodeCombatは、100％オープンソースです！"
    tip_tell_friends: "コードコンバットを楽しんでますか？このことを友達にも伝えましょう！"
    tip_beta_launch: "CodeCombatは、2013年10月にベータ版を開始しました。"
    tip_think_solution: "問題より、解決策を考えろ。"
    tip_theory_practice: "理論的には、理論と実践の間には違いはない。でも実際には、ある。- ヨギ・ベラ"
    tip_error_free: "エラーのないプログラムを書くためには二つの方法がある：第三の方法だけ働く。-アラン・パリス"
    tip_debugging_program: "デバッグがバグを除去するプロセスならば、プログラミングはバグを書き入れるプロセスだ。- エドガー•ダイクストラ"
    tip_forums: "フォーラムで、あなたのご意見をお聞かせください！"
    tip_baby_coders: "将来的には、赤ちゃんでもアークメイジになれる。"
    tip_morale_improves: "士気が向上するまで、ローディングは続く。"
    tip_all_species: "我々は、全ての種族が機会均等のもとでプログラミングを学べることを信じている。"
    tip_reticulating: "スプラインを網状にしています..."
    tip_harry: "君はウィザードだ"
    tip_great_responsibility: "偉大なコーディングスキルを持つと、偉大なデバッグ責任も付属してきます。"
    tip_munchkin: "野菜を食べなければ、眠ってる間にマンチキンに襲われるぞ。"
    tip_binary: "世界には10種類の人がいる：バイナリーを理解する人と、そうでない人。"
    tip_commitment_yoda: "プログラマーは、最も深いコミットメントを持つ必要がある, 最も深刻な心。- ヨーダ"
    tip_no_try: "やるか、やらないかだ。試すことはない。- ヨーダ"
    tip_patience: "忍耐を持つ必要がある、若きパダワンよ。- ヨーダ"
    tip_documented_bug: "文書化されたバグはバグではありません。それは仕様です。"
    tip_impossible: "何かをやり遂げるまでは、常にそれが不可能に思える。- ネルソン・マンデラ"
    tip_talk_is_cheap: "話はもう良い、コードを見せろ。- リーナス・トーバルズ"
    tip_first_language: "最初のプログラミング言語を学ぶ時が、最も悲惨な事を学ぶ時だ。- アラン・ケイ"
    tip_hardware_problem: "Q：電球を変更するのにプログラマが何人必要ですか？ A：一人もいらない、それはハードウェアの問題だ。"
    tip_hofstadters_law: "ホフスタッターの法則：いつでも予測以上の時間がかかるものである。ホフスタッターの法則を計算に入れても。"
    tip_premature_optimization: "早すぎる最適化は諸悪の根源である。-ドナルド・クヌース"
    tip_brute_force: "疑わしい時は、暴力を使え。- ケン・トンプソン"
    tip_extrapolation: "人間は二種類に分けることができる。不完全なデータを挿入する者と、しない者だ。"
    tip_superpower: "プログラミングは、私達のスーパーパワーに最も近い物"
    tip_control_destiny: "本当のオープンソースでは、自分自身の運命をコントロールする権利を持っている。- リーナス・トーバルズ"
    tip_no_code: "コードがないプログラムが一番高速である。"
    tip_code_never_lies: "コードは決して嘘をつかない、コメントは時々嘘をつく。- ロン・ジェフリーズ"
    tip_reusable_software: "ソフトウェアを再利用できる前には、最初に使用可能である事が必要である。"
    tip_optimization_operator: "すべての言語は、最適化演算子を持っている。殆どの言語では、その演算子は '//' である。"
    tip_lines_of_code: "コードを行数でプログラミングの進捗状況を測定するのは、重量で航空機の設計の進捗状況を測定するみたいな事だ。- ビル・ゲイツ"
    tip_source_code: "私は世界を変えたい、でも彼らは私にソースコードを与えてはくれない。"
    tip_javascript_java: "カー(Car, 車)は'カー'ペット(Carpet)にあるように Java は「Java」Script にもある。- クリス・ハイルマン"
    tip_move_forward: "何をするにしても、前進し続けること。- マーティン・ルーサー・キング・ジュニア"
    tip_google: "解決できない問題があるだって？ググっちゃえ！"
    tip_adding_evil: "悪を少々加える。"
    tip_hate_computers: "コンピュータを憎む人が本当に嫌いなのは下手なプログラマーだ。- ラリー・ニーヴン"
    tip_open_source_contribute: "あなたは CodeCombat をより良くすることができます！"
    tip_recurse: "繰り返しは人間、再帰は神。 - L・ピーター・ドイツ"
    tip_free_your_mind: "全ての雑念を捨てろ、恐怖、疑いも不信も 心を解き放つんだ - モーフィアス"
    tip_strong_opponents: "どんな強者にも弱点というものはあるんだ… - うちは　イタチ"
    tip_paper_and_pen: "コーディングを始める前に、 必ず紙とペンを用意して計画を立てましょう。"
    tip_solve_then_write: "まず、問題を解決しよう。それから、コードを書こう。 - ジョン・ジョンソン"
    tip_compiler_ignores_comments: "時々コンパイラは僕のコメントを無視してるんじゃないかと思う。"
    tip_understand_recursion: "再帰を理解するための唯一の方法は再帰を理解することだ。"
    tip_life_and_polymorphism: "オープンソースとは多相型異種構造のようなもの:どんなタイプの人もウェルカムです。"
    tip_mistakes_proof_of_trying: "コードのミスはあなたがやろうとしていることの証明しているだけだ。"
    tip_adding_orgres: "オーガを狩れ。"
    tip_sharpening_swords: "剣を研ぎ澄ませ。"
    tip_ratatouille: "どこで生まれ育とうが他人に限界を決めさせてはいけない あきらめなければなんでもできるのです。- グストー, レミーのおいしいレストラン"
    tip_nemo: "人生にがっくりきたとき、何をすべきか知りたくない? 泳ぎましょ、 泳ぎましょ。 - ドリー、 ファインディング・ニモ"
    tip_internet_weather: "インターネットに引っ越したけど、ここはすごい。中に住んでると天気がやばい。 - ジョン・グリーン"
    tip_nerds: "オタクにはモノを愛することが許されています。こんな風に 上・下・上・下・椅子の・下で・愛・制御・不能。 - ジョン・グリーン"
    tip_self_taught: "私は私自身に学んだことの90%を教えました。それが当然です！ - ハンク・グリーン"
    tip_luna_lovegood: "心配ないよ。あなたは私と同じくらい正気だよ。 - ルーナ・ラブグッド"
    tip_good_idea: "優れたアイディアを得る最善の方法は、多くのアイディアを得ることだ。 - ライナス・ポーリング"
    tip_programming_not_about_computers: "天文学が望遠鏡に関する学問でないのと同様に、計算機科学はコンピュータに関する学問ではない。 - エドガー・ダイクストラ"
    tip_mulan: "できると信じていれば、できる。 - ムーラン"

  play_game_dev_level:
    created_by: "作成者：{{name}}"
    how_to_play_title: "遊び方:"
    how_to_play_1: "マウスでヒーローを操作しましょう!"
    how_to_play_2: "マップの動きたい場所をどこでもクリックしましょう."
    how_to_play_3: "オーガをクリックして攻撃しましょう."
    restart: "レベルをリセット"
    play: "プレイレベル"
    play_more_codecombat: "もっとCodeCombatで遊ぶ"
    default_student_instructions: "ヒーローをクリックしてゲームに勝ちましょう!"
    back_to_coding: "コーディングに戻る"

  game_menu:
    inventory_tab: "インベントリー"
    save_load_tab: "セーブ//ロード"
    options_tab: "設定"
    guide_tab: "ガイド"
    guide_video_tutorial: "チュートリアル動画"
    guide_tips: "ヒント"
    multiplayer_tab: "マルチプレイ"
    auth_tab: "登録する"
    inventory_caption: "ヒーローの装備を選ぶ"
    choose_hero_caption: "ヒーロー、言語と"
    save_load_caption: "...視聴履歴を選択する"
    options_caption: "設定を行う"
    guide_caption: "ガイドとヒント"
    multiplayer_caption: "友達とプレイ！"
    auth_caption: "進行状況をセーブする"

  leaderboard:
    view_other_solutions: "リーダーボードを見る"
    scores: "スコア"
    top_players: "上位プレイヤー順"
    day: "今日"
    week: "今週"
    all: "オールタイム"
    time: "時間"
    damage_taken: "受けたダメージ"
    damage_dealt: "与えたダメージ"
    difficulty: "難易度"
    gold_collected: "集めたゴールド"

  inventory:
    equipped_item: "装備済み"
    required_purchase_title: "必須品"
    available_item: "使用可能"
    restricted_title: "制限品"
    should_equip: "(ダブルクリックで装備)"
    equipped: "(装備済み)"
    locked: "(ロック)"
    restricted: "(このレベルでは制限品)"
    equip: "装備する"
    unequip: "装備を外す"

  buy_gems:
    few_gems: "少し購入"
    pile_gems: "多く購入"
    chest_gems: "宝箱を購入"
    purchasing: "購入中..."
    declined: "カードが拒否されました。"
    retrying: "サーバーエラー、再試行中。"
    prompt_title: "ジェムが不足"
    prompt_body: "もっと購入しますか？"
    prompt_button: "ショップに入る"
    recovered: "前のジェム購入をリカバリーしました。ページを更新してください。"
    price: "x{{gems}} / 月"

  subscribe:
    comparison_blurb: "CodeCombatへ課金してスキルを磨きましょう！"
    feature1: "__levelsCount__以上の基本レベルが__worldsCount__つの世界に"
    feature2: "__heroesCount__人のパワフルな <strong>ニューヒーロー</strong> とユニークなスキル!"
    feature3: "__bonusLevelsCount__以上のボーナスレベル"
    feature4: "<strong>{{gems}}のジェム</strong>が毎月ボーナス!"
    feature6: "プレミアムメールサポート"
    feature7: "プライベート<strong>クラン</strong>"
    feature8: "<strong>広告非表示!</strong>"
    free: "無料"
    month: "月"
    must_be_logged: "まずログインしてください。 アカウントを作るかメニューの上からログインをお願いします。"
    subscribe_title: "課金"
    unsubscribe: "無課金"
    confirm_unsubscribe: "課金の解約確認"
    never_mind: "気にしないでください, それでもあなたが好きです"
    thank_you_months_prefix: "私達を "
    thank_you_months_suffix: "ヶ月サポートしてくださりありがとうございます。"
    thank_you: "CodeCombatをサポートして下さりありがとうございます。"
#    sorry_to_see_you_go: "Sorry to see you go! Please let us know what we could have done better."
#    unsubscribe_feedback_placeholder: "O, what have we done?"
#    parent_button: "Ask your parent"
#    parent_email_description: "We'll email them so they can buy you a CodeCombat subscription."
#    parent_email_input_invalid: "Email address invalid."
#    parent_email_input_label: "Parent email address"
#    parent_email_input_placeholder: "Enter parent email"
#    parent_email_send: "Send Email"
#    parent_email_sent: "Email sent!"
#    parent_email_title: "What's your parent's email?"
#    parents: "For Parents"
#    parents_title: "Dear Parent: Your child is learning to code. Will you help them continue?"
#    parents_blurb1: "Your child has played __nLevels__ levels and learned programming basics. Help cultivate their interest and buy them a subscription so they can keep playing."
#    parents_blurb1a: "Computer programming is an essential skill that your child will undoubtedly use as an adult. By 2020, basic software skills will be needed by 77% of jobs, and software engineers are in high demand across the world. Did you know that Computer Science is the highest-paid university degree?"
#    parents_blurb2: "For ${{price}} USD/mo, your child will get new challenges every week and personal email support from professional programmers."
#    parents_blurb3: "No Risk: 100% money back guarantee, easy 1-click unsubscribe."
#    payment_methods: "Payment Methods"
#    payment_methods_title: "Accepted Payment Methods"
#    payment_methods_blurb1: "We currently accept credit cards and Alipay. You can also PayPal {{three_month_price}} USD to nick@codecombat.com with your account email in the memo to purchase three months' subscription and gems, or ${{year_price}} for a year."
#    payment_methods_blurb2: "If you require an alternate form of payment, please contact"
#    sale_button: "Sale!"
#    sale_button_title: "Save $21 when you purchase a 1 year subscription"
#    stripe_description: "Monthly Subscription"
#    stripe_description_year_sale: "1 Year Subscription (${{discount}} discount)"
#    subscription_required_to_play: "You'll need a subscription to play this level."
#    unlock_help_videos: "Subscribe to unlock all video tutorials."
#    personal_sub: "Personal Subscription" # Accounts Subscription View below
#    loading_info: "Loading subscription information..."
#    managed_by: "Managed by"
#    will_be_cancelled: "Will be cancelled on"
#    currently_free: "You currently have a free subscription"
#    currently_free_until: "You currently have a subscription until"
#    was_free_until: "You had a free subscription until"
#    managed_subs: "Managed Subscriptions"
#    subscribing: "Subscribing..."
#    current_recipients: "Current Recipients"
#    unsubscribing: "Unsubscribing"
#    subscribe_prepaid: "Click Subscribe to use prepaid code"
#    using_prepaid: "Using prepaid code for monthly subscription"

  choose_hero:
    choose_hero: "ヒーロー選択"
    programming_language: "プログラミング言語"
    programming_language_description: "どのプログラミング言語を使いますか？"
    default: "デフォルト"
    experimental: "実験的"
    python_blurb: "シンプルで強力、初心者や専門家でも使える。"
    javascript_blurb: "ウェブの言語。(Java と同じではありません)"
    coffeescript_blurb: "より良い JavaScript の構文が使えます。"
    lua_blurb: "ゲーム専用のスクリプト言語。"
    java_blurb: "(サブスクリプション限定) Androidや企業."
    status: "ステータス"
    weapons: "武器"
    weapons_warrior: "剣 - 攻撃範囲:短い- 魔法使用不可"
    weapons_ranger: "クロスボウ, 銃 - 攻撃範囲:長い- 魔法使用不可"
    weapons_wizard: "ワンド、杖- 攻撃範囲:長い- 魔法使用可能"
    attack: "攻撃力" # Can also translate as "Attack"
    health: "体力"
    speed: "移動速度"
    regeneration: "自動回復度"
    range: "攻撃範囲" # As in "attack or visual range"
    blocks: "ブロックパワー" # As in "this shield blocks this much damage"
    backstab: "バックスタブ" # As in "this dagger does this much backstab damage"
    skills: "スキル"
    attack_1: "取引"
    attack_2: "リスト"
    attack_3: "武器攻撃力"
    health_1: "収益"
    health_2: "リスト"
    health_3: "防具防御力"
    speed_1: "移動速度"
    speed_2: "メートル/秒"
    available_for_purchase: "購入可能" # Shows up when you have unlocked, but not purchased, a hero in the hero store
    level_to_unlock: "アンロックレベル：" # Label for which level you have to beat to unlock a particular hero (click a locked hero in the store to see)
    restricted_to_certain_heroes: "特定のヒーローのみ、このレベルをプレイする事が出来ます。"

  skill_docs:
    function: "function(関数)" # skill types
    method: "method(メソッド)"
    snippet: "スニペット"
    number: "数値"
    array: "配列"
    object: "オブジェクト"
    string: "文字列"
    writable: "書き込み可能な" # Hover over "attack" in Your Skills while playing a level to see most of this
    read_only: "読み込み限定"
    action: "アクション"
    spell: "呪文"
    action_name: "アクション名"
    action_cooldown: "テイク"
    action_specific_cooldown: "クールダウン"
    action_damage: "ダメージ"
    action_range: "レンジ"
    action_radius: "ラジウス"
    action_duration: "デュレーション"
    example: "例"
    ex: "例" # Abbreviation of "example"
    current_value: "現在値"
    default_value: "デフォルト値"
    parameters: "パラメータ"
    required_parameters: "必須パラメーター"
    optional_parameters: "任意パラメーター"
    returns: "リターン"
    granted_by: "スキルを与えてくれるアイテム："

  save_load:
    granularity_saved_games: "セーブされました"
    granularity_change_history: "履歴"

  options:
    general_options: "一般設定" # Check out the Options tab in the Game Menu while playing a level
    volume_label: "音量"
    music_label: "音楽"
    music_description: "BGM をオン/オフ"
    editor_config_title: "エディターの設定"
    editor_config_livecompletion_label: "ライブオートコンプリート"
    editor_config_livecompletion_description: "コード入力中、オートコンプリートの提案を表示する。"
    editor_config_invisibles_label: "編集記号の表示"
    editor_config_invisibles_description: "スペースやタブなどの編集記号を表示する。"
    editor_config_indentguides_label: "インデントガイドの表示"
    editor_config_indentguides_description: "より良いインデントを見るために垂直線を表示する。"
    editor_config_behaviors_label: "スマートビヘイビア"
    editor_config_behaviors_description: "カッコ、中括弧、および引用符をオートコンプリートする。"

  about:
    main_title: "もしプログラムを学びたいなら、（たくさん）コードを書きましょう。"
    main_description: "CodeCombatでの私たちの仕事はあなたが笑顔でプレイするのを確かめることです。"
    mission_link: "ミッション"
    team_link: "チーム"
    story_link: "ストーリー"
    press_link: "記事"
#    mission_title: "Our mission: make programming accessible to every student on Earth."
#    mission_description_1: "<strong>Programming is magic</strong>. It's the ability to create things from pure imagination. We started CodeCombat to give learners the feeling of wizardly power at their fingertips by using <strong>typed code</strong>."
#    mission_description_2: "As it turns out, that enables them to learn faster too. WAY faster. It's like having a conversation instead of reading a manual. We want to bring that conversation to every school and to <strong>every student</strong>, because everyone should have the chance to learn the magic of programming."
#    team_title: "Meet the CodeCombat team"
#    team_values: "We value open and respectful dialog, where the best idea wins. Our decisions are grounded in customer research and our process is focused on delivering tangible results for them. Everyone is hands-on, from our CEO to our GitHub contributors, because we value growth and learning in our team."
    nick_title: "創設者, CEO"
    nick_blurb: "モチベーションの達人"
    matt_title: "創設者, CTO"
    cat_title: "ゲームデザイナー"
    cat_blurb: "エアベンダー"
    scott_title: "創設者, ソフトウェアエンジニア"
    scott_blurb: "リーズナブルな奴"
    maka_title: "顧客主義"
    maka_blurb: "ストーリーテラー"
    rob_title: "ソフトウェアエンジニア"
    rob_blurb: "コードの道具と材料"
    josh_c_title: "ゲームデザイナー"
    josh_c_blurb: "ゲームのデザイン"
    robin_title: "デザイン＆研究"
    robin_blurb: "土台作り"
    josh_title: "ゲームデザイナー"
    josh_blurb: "床は溶岩"
    phoenix_title: "ソフトウェアエンジニア"
    nolan_title: "地区担当マネージャー"
    elliot_title: "パートナーシップマネージャー"
    elliot_blurb: "読心術者"
    lisa_title: "市場開発代表" # {change}
#    lisa_blurb: "A gritty one"
    sean_title: "地域部長"
    retrostyle_title: "イラスト"
    retrostyle_blurb: "レトロスタイルのゲーム"
    jose_title: "ミュージック"
    jose_blurb: "テークオフ"
#    community_title: "...and our open-source community"
#    community_subtitle: "Over 450 contributors have helped build CodeCombat, with more joining every week!"
#    community_description_3: "CodeCombat is a"
#    community_description_link_2: "community project"
#    community_description_1: "with hundreds of players volunteering to create levels, contribute to our code to add features, fix bugs, playtest, and even translate the game into 50 languages so far. Employees, contributors and the site gain by sharing ideas and pooling effort, as does the open source community in general. The site is built on numerous open source projects, and we are open sourced to give back to the community and provide code-curious players a familiar project to explore and experiment with. Anyone can join the CodeCombat community! Check out our"
#    community_description_link: "contribute page"
#    community_description_2: "for more info."
#    number_contributors: "Over 450 contributors have lent their support and time to this project."
#    story_title: "Our story so far"
#    story_subtitle: "Since 2013, CodeCombat has grown from a mere set of sketches to a living, thriving game."
#    story_statistic_1a: "5,000,000+"
#    story_statistic_1b: "total players"
#    story_statistic_1c: "have started their programming journey through CodeCombat"
#    story_statistic_2a: "We’ve been translated into over 50 languages — our players hail from"
#    story_statistic_2b: "200+ countries"
#    story_statistic_3a: "Together, they have written"
#    story_statistic_3b: "1 billion lines of code and counting"
#    story_statistic_3c: "across many different programming languages"
#    story_long_way_1: "Though we've come a long way..."
#    story_sketch_caption: "Nick's very first sketch depicting a programming game in action."
#    story_long_way_2: "we still have much to do before we complete our quest, so..."
#    jobs_title: "Come work with us and help write CodeCombat history!"
#    jobs_subtitle: "Don't see a good fit but interested in keeping in touch? See our \"Create Your Own\" listing."
#    jobs_benefits: "Employee Benefits"
#    jobs_benefit_4: "Unlimited vacation"
#    jobs_benefit_5: "Professional development and continuing education support – free books and games!"
#    jobs_benefit_6: "Medical (gold), dental, vision"
#    jobs_benefit_7: "Sit-stand desks for all"
#    jobs_benefit_9: "10-year option exercise window"
#    jobs_benefit_10: "Maternity leave: 10 weeks paid, next 6 @ 55% salary"
#    jobs_benefit_11: "Paternity leave: 10 weeks paid"
#    learn_more: "Learn More"
#    jobs_custom_title: "Create Your Own"
#    jobs_custom_description: "Are you passionate about CodeCombat but don't see a job listed that matches your qualifications? Write us and show how you think you can contribute to our team. We'd love to hear from you!"
#    jobs_custom_contact_1: "Send us a note at"
#    jobs_custom_contact_2: "introducing yourself and we might get in touch in the future!"
#    contact_title: "Press & Contact"
#    contact_subtitle: "Need more information? Get in touch with us at"
#    screenshots_title: "Game Screenshots"
#    screenshots_hint: "(click to view full size)"
#    downloads_title: "Download Assets & Information"
#    about_codecombat: "About CodeCombat"
#    logo: "Logo"
#    screenshots: "Screenshots"
#    character_art: "Character Art"
#    download_all: "Download All"
#    previous: "Previous"
#    location_title: "We're located in downtown SF:"

  teachers:
    who_for_title: "CodeCombat が必要なひと"
    who_for_1: "私たちは CodeCombat を9歳以上の生徒にオススメしています。プログラミングの経験は必要ありません。男の子も女の子も遊べるように CodeCombat をデザインしました。"
    who_for_2: "私たちのコースシステムでは先生方は教室, 進捗の追跡, 生徒への追加コンテンツの割り当てを専用のインターフェースを通して割り当てることができます。"
    more_info_title: "もっと情報がほしい人"
    more_info_1: "私たちの"
    more_info_2: "ティーチャーフォーラム"
    more_info_3: "でCodeCombatを使っている教育者の仲間とつながりましょう。"
#    licenses_needed: "Licenses needed"

#  teachers_quote:
#    name: "Demo Form"
#    subtitle: "Get your students started in less than an hour. You'll be able to <strong>create a class, add students, and monitor their progress</strong> as they learn computer science."
#    email_exists: "User exists with this email."
#    phone_number: "Phone number"
#    phone_number_help: "Where can we reach you during the workday?"
#    primary_role_label: "Your Primary Role"
#    role_default: "Select Role"
#    primary_role_default: "Select Primary Role"
#    purchaser_role_default: "Select Purchaser Role"
#    tech_coordinator: "Technology coordinator"
#    advisor: "Advisor"
#    principal: "Principal"
#    superintendent: "Superintendent"
#    parent: "Parent"
#    purchaser_role_label: "Your Purchaser Role"
#    influence_advocate: "Influence/Advocate"
#    evaluate_recommend: "Evaluate/Recommend"
#    approve_funds: "Approve Funds"
#    no_purchaser_role: "No role in purchase decisions"
#    district_label: "District"
#    district_na: "Enter N/A if not applicable"
#    organization_label: "School"
#    city: "City"
#    state: "State"
#    country: "Country"
#    num_students_help: "How many do you anticipate enrolling in CodeCombat?"
#    num_students_default: "Select Range"
#    education_level_label: "Education Level of Students"
#    education_level_help: "Choose as many as apply."
#    elementary_school: "Elementary School"
#    high_school: "High School"
#    please_explain: "(please explain)"
#    middle_school: "Middle School"
#    college_plus: "College or higher"
#    anything_else: "Anything else we should know?"
#    thanks_header: "Request Received!"
#    thanks_sub_header: "Thanks for expressing interest in CodeCombat for your school."
#    thanks_p: "We'll be in touch soon! If you need to get in contact, you can reach us at:"
#    back_to_classes: "Back to Classes"
#    finish_signup: "Finish creating your teacher account:"
#    finish_signup_p: "Create an account to set up a class, add your students, and monitor their progress as they learn computer science."
#    signup_with: "Sign up with:"
#    connect_with: "Connect with:"
#    conversion_warning: "WARNING: Your current account is a <em>Student Account</em>. Once you submit this form, your account will be updated to a Teacher Account."
#    learn_more_modal: "Teacher accounts on CodeCombat have the ability to monitor student progress, assign licenses and manage classrooms. Teacher accounts cannot be a part of a classroom - if you are currently enrolled in a class using this account, you will no longer be able to access it once you update to a Teacher Account."
#    create_account: "Create a Teacher Account"
#    create_account_subtitle: "Get access to teacher-only tools for using CodeCombat in the classroom.  <strong>Set up a class</strong>, add your students, and <strong>monitor their progress</strong>!"
#    convert_account_title: "Update to Teacher Account"
#    not: "Not"

  versions:
    save_version_title: "新しいバージョンをセーブ"
    new_major_version: "メジャーバージョンを新しくする"
    submitting_patch: "パッチを送信中..."
    cla_prefix: "変更を適用するには, 私達のCLAに同意する必要があります。"
    cla_url: "CLA"
    cla_suffix: "。"
    cla_agree: "同意する"
    owner_approve: "ユーザーは変更が実際に表示される前に同意する必要があります。"

  contact:
    contact_us: "お問い合わせ"
    welcome: "あなたからの連絡に感謝します。私達にメールを送信するには、このフォームを使ってください。"
    forum_prefix: "公開で様々な人と議論したい場合は "
    forum_page: "こちらのフォーラム"
    forum_suffix: " でお願いします。"
    faq_prefix: "他のサポートもあります："
    faq: "よくある質問(FAQ)"
    subscribe_prefix: "レベルをクリアする情報が必要ならば、"
    subscribe: "CodeCombatのサブスクリプション"
    subscribe_suffix: "を購入頂けると喜んであなたのコードを手伝います。"
    subscriber_support: "あなたはCodeCombatにすでに加入しているので、メールは優先サポートされます。"
    screenshot_included: "スクリーンショットが含まれています。"
    where_reply: "何処へ返信すれば宜しいですか？"
    send: "フィードバックを送信"

  account_settings:
    title: "アカウント設定"
    not_logged_in: "設定を変更するにはログインまたはアカウント登録してください"
    autosave: "変更は自動的にセーブします"
    me_tab: "自分"
    picture_tab: "画像"
    delete_account_tab: "アカウントの削除"
    wrong_email: "間違ったメールアドレス"
    wrong_password: "間違ったパスワード"
    upload_picture: "画像をアップロード"
    delete_this_account: "アカウントを完全削除する"
    reset_progress_tab: "すべての進捗をリセットする"
    reset_your_progress: "すべての進捗をリセットしやり直す"
    god_mode: "ゴッドモード"
    emails_tab: "メール"
    admin: "管理者"
    manage_subscription: "購読を管理するにはここをクリックしてください。"
    new_password: "新パスワード"
    new_password_verify: "新パスワードを再入力"
    type_in_email: "アカウントの削除を確認するために、メールアドレスを入力して下さい。" # {change}
    type_in_email_progress: "進捗を消すために、メールアドレスを入力してください。"
    type_in_password: "そして、パスワードを入力してください。"
    email_subscriptions: "ニュースレターの購読"
    email_subscriptions_none: "ニュースレターの購読はありません。"
    email_announcements: "お知らせ"
    email_announcements_description: "CodeCombatの最新のニュースや進展をメールで受け取る"
    email_notifications: "通知"
    email_notifications_summary: "CodeCombatアクティビティに関する自動電子メール通知の管理。"
    email_any_notes: "すべての通知"
    email_any_notes_description: "アクティビティすべての通知メールを停止することを無効にします。"
    email_news: "ニュース"
    email_recruit_notes: "求人"
    email_recruit_notes_description: "上手にプレイしてくれる場合、（更に良い）仕事を紹介するためにこちらから連絡を差し上げる場合があります。"
    contributor_emails: "開発を手伝ってくれる人向けのメール"
    contribute_prefix: "私達は開発を手伝ってくれる人を探しています。 詳しくは "
    contribute_page: "こちらのページ"
    contribute_suffix: " を確認して下さい。"
    email_toggle: "すべて"
    error_saving: "セーブ中にエラーが発生しました"
    saved: "変更しました"
    password_mismatch: "パスワードが違います"
    password_repeat: "もう一度パスワードを入力してください"

  keyboard_shortcuts:
    keyboard_shortcuts: "キーボードショートカット"
    space: "スペース"
    enter: "エンター"
    press_enter: "エンターを押す"
    escape: "エスケープ"
    shift: "シフト"
    run_code: "現在のコードを実行"
    run_real_time: "リアルタイムで実行"
    continue_script: "以前のスクリプトを続ける。"
    skip_scripts: "過去のスキップできるスクリプトをスキップする。"
    toggle_playback: "トグル:プレイ/ポーズ"
    scrub_playback: "早戻し・早送り."
    single_scrub_playback: "１フレームごとに早戻し・早送りをする。"
    scrub_execution: "現在のスペルの実行まで早戻し・早送り。"
    toggle_debug: "トグル：ディスプレイのデバッグ"
    toggle_grid: "トグル：オーバーレイをグリッド"
    toggle_pathfinding: "トグル：オーバーレイの経路探索"
    beautify: "フォーマットを標準化してコードを美しくする。"
    maximize_editor: "コードエディターの最大化/最小化。"

  community:
    main_title: "CodeCombatコミュニティー"
    introduction: "あなたが最も楽しいと思う方法で私たちを手伝ってください。私たちはあなたと働くことを楽しみにしています！"
    level_editor_prefix: "CodeCombat の"
    level_editor_suffix: "を使ってレベルを作成したり編集しましょう。ユーザはクラスのひとや、友人、ハッカソン仲間、学生、兄弟姉妹のためにレベルを作成しています。素晴らしいレベルを作るためにフォークすることから始めましょう。"
    thang_editor_prefix: "私たちはゲーム中のユニットを「サング」と呼んでいます。"
    thang_editor_suffix: "を使って CodeCombat のアートワークを加工しましょう。ユニットが投射物を投げることを許可したり、アニメーションの方向を変えたり、ユニットのヒットポイントを変えたり、あなたのベクタースプライトをアップロードすることもできます。"
    article_editor_prefix: "私たちのドキュメントにミスを見つけましたか？自分の作品のチュートリアルを作りたいですか？"
    article_editor_suffix: "を使って CodeCombat のプレイヤーを助けて彼らのプレイタイムを最大限に活用できるようにしましょう。"
    find_us: "各サイトで私たちを見る"
    social_github: "GitHubで私達のコードをチェックする"
    social_blog: "Sett の CodeCombat ブログを読む"
    social_discource: "Discourse のフォーラムで議論しよう"
    social_facebook: "Facebook で CodeCombat にいいね！する"
    social_twitter: "Twitter の CodeCombat をフォローする"
    social_gplus: "Google+ の CodeCombat に参加する"
    social_slack: "公開CodeCombat Slackチャンネルで私たちと話す"
    contribute_to_the_project: "プロジェクトに貢献する"

  clans:
    clan: "クラン"
    clans: "クラン"
    new_name: "新規クラン名"
    new_description: "新規クラン紹介文"
    make_private: "クランをプライベートにする"
    subs_only: "課金者限定"
    create_clan: "新規クラン作成"
    private_preview: "プレビュー"
    private_clans: "非公開クランmptクラン"
    public_clans: "公開クラン"
    my_clans: "マイ・クラン"
    clan_name: "クラン名"
    name: "名前"
    chieftain: "リーダー"
    edit_clan_name: "クラン名の編集"
    edit_clan_description: "クランの紹介文の編集"
    edit_name: "名前の編集"
    edit_description: "紹介文の編集"
    private: "(プライベート)"
    summary: "概要"
    average_level: "平均レベル"
    average_achievements: "平均業績"
    delete_clan: "クランの削除"
    leave_clan: "クランの脱退"
    join_clan: "クランの参加"
    invite_1: "招待:"
    invite_2: "*このリンクを送信してクランに招待してください。"
    members: "メンバー"
    progress: "進捗"
    not_started_1: "未着手"
    started_1: "進行中"
    complete_1: "完了"
    exp_levels: "レベルの拡大"
    rem_hero: "ヒーローの削除"
    status: "状態"
    complete_2: "完了"
    started_2: "進行中"
    not_started_2: "未着手"
    view_solution: "ソリューションを見る。"
    view_attempt: "アテンプトを見る."
    latest_achievement: "最新業績"
    playtime: "プレイ時間"
    last_played: "最終プレイ"
    leagues_explanation: "リーグで他のマルチアリーナインスタンス内の他のクランメンバーとプレイ"
#    track_concepts1: "Track concepts"
#    track_concepts2a: "learned by each student"
#    track_concepts2b: "learned by each member"
#    track_concepts3a: "Track levels completed for each student"
#    track_concepts3b: "Track levels completed for each member"
#    track_concepts4a: "See your students'"
#    track_concepts4b: "See your members'"
#    track_concepts5: "solutions"
#    track_concepts6a: "Sort students by name or progress"
#    track_concepts6b: "Sort members by name or progress"
#    track_concepts7: "Requires invitation"
#    track_concepts8: "to join"
#    private_require_sub: "Private clans require a subscription to create or join."

#  courses:
#    course: "Course"
#    courses: "courses"
#    create_new_class: "Create New Class"
#    not_enrolled: "You are not enrolled in this course."
#    visit_pref: "Please visit the"
#    visit_suf: "page to enroll."
#    select_class: "Select one of your classes"
#    unnamed: "*unnamed*"
#    select: "Select"
#    unnamed_class: "Unnamed Class"
#    edit_settings: "edit class settings"
#    edit_settings1: "Edit Class Settings"
#    progress: "Class Progress"
#    add_students: "Add Students"
#    stats: "Statistics"
#    total_students: "Total students:"
#    average_time: "Average level play time:"
#    total_time: "Total play time:"
#    average_levels: "Average levels completed:"
#    total_levels: "Total levels completed:"
#    furthest_level: "Furthest level completed:"
#    students: "Students"
#    students1: "students"
#    concepts: "Concepts"
#    levels: "levels"
#    played: "Played"
#    play_time: "Play time:"
#    completed: "Completed:"
#    invite_students: "Invite students to join this class."
#    invite_link_header: "Link to join course"
#    invite_link_p_1: "Give this link to students you would like to have join the course."
#    invite_link_p_2: "Or have us email them directly:"
#    capacity_used: "Course slots used:"
#    enter_emails: "Separate each email address by a line break or commas"
#    send_invites: "Invite Students"
#    creating_class: "Creating class..."
#    purchasing_course: "Purchasing course..."
#    buy_course: "Buy Course"
#    buy_course1: "Buy this course"
#    select_all_courses: "Select 'All Courses' for a 50% discount!"
#    all_courses: "All Courses"
#    number_programming_students: "Number of Programming Students"
#    number_total_students: "Total Students in School/District"
#    enter_number_students: "Enter the number of students you need for this class."
#    name_class: "Name your class"
#    displayed_course_page: "This will be displayed on the course page for you and your students. It can be changed later."
#    buy: "Buy"
#    purchasing_for: "You are purchasing a license for"
#    creating_for: "You are creating a class for"
#    for: "for" # Like in 'for 30 students'
#    receive_code: "Afterwards you will receive an unlock code to distribute to your students, which they can use to enroll in your class."
#    free_trial: "Free trial for teachers!"
#    get_access: "to get individual access to all courses for evalutaion purposes."
#    questions: "Questions?"
#    teachers_click: "Teachers Click Here"
#    students_click: "Students Click Here"
#    courses_on_coco: "Courses on CodeCombat"
#    designed_to: "Courses are designed to introduce computer science concepts using CodeCombat's fun and engaging environment. CodeCombat levels are organized around key topics to encourage progressive learning, over the course of 5 hours."
#    more_in_less: "Learn more in less time"
#    no_experience: "No coding experience necesssary"
#    easy_monitor: "Easily monitor student progress"
#    purchase_for_class: "Purchase a course for your entire class. It's easy to sign up your students!"
#    see_the: "See the"
#    more_info: "for more information."
#    choose_course: "Choose Your Course:"
#    enter_code: "Enter an unlock code to join an existing class"
#    enter_code1: "Enter unlock code"
#    enroll: "Enroll"
#    pick_from_classes: "Pick from your current classes"
#    enter: "Enter"
#    or: "Or"
#    topics: "Topics"
#    hours_content: "Hours of content:"
#    get_free: "Get FREE course"
#    enroll_paid: "Enroll Students in Paid Courses"
#    you_have1: "You have"
#    you_have2: "unused student licenses"
#    use_one: "Use 1 student license for"
#    use_multiple: "Use licenses for the following students:"
#    already_enrolled: "already enrolled"
#    licenses_remaining: "licenses remaining:"
#    insufficient_enrollments: "insufficient student licenses"
#    get_enrollments: "Get More Licenses"
#    change_language: "Change Course Language"
#    keep_using: "Keep Using"
#    switch_to: "Switch To"
#    greetings: "Greetings!"
#    back_classrooms: "Back to my classrooms"
#    back_courses: "Back to my courses"
#    edit_details: "Edit class details"
#    enrolled_courses: "enrolled in paid courses:"
#    purchase_enrollments: "Purchase Student Licenses"
#    remove_student: "remove student"
#    assign: "Assign"
#    to_assign: "to assign paid courses."
#    student: "Student"
#    teacher: "Teacher"
#    complete: "Complete"
#    none: "None"
#    play_campaign_title: "Play the Campaign"
#    play_campaign_description: "You’re ready to take the next step! Explore hundreds of challenging levels, learn advanced programming skills, and compete in multiplayer arenas!"
#    create_account_title: "Create an Account"
#    create_account_description: "Sign up for a FREE CodeCombat account and gain access to more levels, more programming skills, and more fun!"
#    preview_campaign_title: "Preview Campaign"
#    preview_campaign_description: "Take a sneak peek at all that CodeCombat has to offer before signing up for your FREE account."
#    arena: "Arena"
#    arena_soon_title: "Arena Coming Soon"
#    arena_soon_description: "We are working on a multiplayer arena for classrooms at the end of"
#    not_enrolled1: "Not enrolled"
#    not_enrolled2: "Ask your teacher to enroll you in the next course."
#    next_course: "Next Course"
#    coming_soon1: "Coming soon"
#    coming_soon2: "We are hard at work making more courses for you!"
#    available_levels: "Available Levels"
#    welcome_to_courses: "Adventurers, welcome to Courses!"
#    ready_to_play: "Ready to play?"
#    start_new_game: "Start New Game"
#    play_now_learn_header: "Play now to learn"
#    play_now_learn_1: "basic syntax to control your character"
#    play_now_learn_2: "while loops to solve pesky puzzles"
#    play_now_learn_3: "strings & variables to customize actions"
#    play_now_learn_4: "how to defeat an ogre (important life skills!)"
#    welcome_to_page: "My Student Dashboard"
#    completed_hoc: "Amazing! You've completed the Hour of Code course!"
#    ready_for_more_header: "Ready for more? Play the campaign mode!"
#    ready_for_more_1: "Use gems to unlock new items!"
#    ready_for_more_2: "Play through brand new worlds and challenges"
#    ready_for_more_3: "Learn even more programming!"
#    saved_games: "Saved Games"
#    hoc: "Hour of Code"
#    my_classes: "Current Classes"
#    class_added: "Class successfully added!"
#    view_levels: "view all levels in course"
#    join_class: "Join A Class"
#    join_class_2: "Join class"
#    ask_teacher_for_code: "Ask your teacher if you have a CodeCombat class code! If so, enter it below:"
#    enter_c_code: "<Enter Class Code>"
#    join: "Join"
#    joining: "Joining class"
#    course_complete: "Course Complete"
#    play_arena: "Play Arena"
#    view_project: "View Project"
#    start: "Start"
#    last_level: "Last level played"
#    welcome_to_hoc: "Adventurers, welcome to our Hour of Code!"
#    logged_in_as: "Logged in as:"
#    not_you: "Not you?"
#    welcome_back: "Hi adventurer, welcome back!"
#    continue_playing: "Continue Playing"
#    more_options: "More options:"
#    option1_header: "Invite Students by Email"
#    option1_body: "Note: If your students do not have email addresses, they can enter your unique Class Code when creating a Student Account to make email addresses optional."
#    thank_you_pref: "Thank you for your purchase! You can now assign"
#    thank_you_suff: "more students to paid courses."
#    return_to_class: "Return to classroom"
#    return_to_course_man: "Return to course management."
#    students_not_enrolled: "students not enrolled"
#    total_all_classes: "Total Across All Classes"
#    how_many_enrollments: "How many additional student licenses do you need?"
#    each_student_access: "Each student in a class will get access to Courses 2-4 once they are enrolled in paid courses. You may assign each course to each student individually."
#    purchase_now: "Purchase Now"
#    enrollments: "licenses"
#    remove_student1: "Remove Student"
#    are_you_sure: "Are you sure you want to remove this student from this class?"
#    remove_description1: "Student will lose access to this classroom and assigned classes. Progress and gameplay is NOT lost, and the student can be added back to the classroom at any time."
#    remove_description2: "The activated paid license will not be returned."
#    keep_student: "Keep Student"
#    removing_user: "Removing user"
#    to_join_ask: "To join a class, ask your teacher for an unlock code."
#    join_this_class: "Join Class"
#    enter_here: "<enter unlock code here>"
#    successfully_joined: "Successfully joined"
#    click_to_start: "Click here to start taking"
#    my_courses: "My Courses"
#    classroom: "Classroom"
#    use_school_email: "use your school email if you have one"
#    unique_name: "a unique name no one has chosen"
#    pick_something: "pick something you can remember"
#    class_code: "Class Code"
#    optional_ask: "optional - ask your teacher to give you one!"
#    optional_school: "optional - what school do you go to?"
#    start_playing: "Start Playing"
#    skip_this: "Skip this, I'll create an account later!"
#    welcome: "Welcome"
#    getting_started: "Getting Started with Courses"
#    download_getting_started: "Download Getting Started Guide [PDF]"
#    getting_started_1: "Create a new class by clicking the green 'Create New Class' button below."
#    getting_started_2: "Once you've created a class, click the blue 'Add Students' button."
#    getting_started_3: "You'll see student's progress below as they sign up and join your class."
#    educator_wiki_pref: "Or check out our new"
#    educator_wiki_mid: "educator wiki"
#    educator_wiki_suff: "to browse the guide online."
#    your_classes: "Your Classes"
#    no_classes: "No classes yet!"
#    create_new_class1: "create new class"
#    available_courses: "Available Courses"
#    unused_enrollments: "Unused licenses available:"
#    students_access: "All students get access to Introduction to Computer Science for free. One license per student is required to assign them to paid CodeCombat courses. A single student does not need multiple licenses to access all paid courses."
#    active_courses: "active courses"
#    no_students: "No students yet!"
#    add_students1: "add students"
#    view_edit: "view/edit"
#    students_enrolled: "students enrolled"
#    students_assigned: "students assigned"
#    length: "Length:"
#    subtitle: "Review course overviews and levels" # Flat style redesign
#    changelog: "View latest changes to course levels."
#    select_language: "Select language"
#    select_level: "Select level"
#    play_level: "Play Level"
#    concepts_covered: "Concepts covered"
#    print_guide: "Print Guide (PDF)"
#    view_guide_online: "Level Overviews and Solutions"
#    grants_lifetime_access: "Grants access to all Courses."
#    enrollment_credits_available: "Licenses Available:"
#    language_select: "Select a language" # ClassroomSettingsModal
#    language_cannot_change: "Language cannot be changed once students join a class."
#    learn_p: "Learn Python"
#    learn_j: "Learn JavaScript"
#    avg_student_exp_label: "Average Student Programming Experience"
#    avg_student_exp_desc: "This will help us understand how to pace courses better."
#    avg_student_exp_select: "Select the best option"
#    avg_student_exp_none: "No Experience - little to no experience"
#    avg_student_exp_beginner: "Beginner - some exposure or block-based"
#    avg_student_exp_intermediate: "Intermediate - some experience with typed code"
#    avg_student_exp_advanced: "Advanced - extensive experience with typed code"
#    avg_student_exp_varied: "Varied Levels of Experience"
#    student_age_range_label: "Student Age Range"
#    student_age_range_younger: "Younger than 6"
#    student_age_range_older: "Older than 18"
#    student_age_range_to: "to"
#    create_class: "Create Class"
#    class_name: "Class Name"
#    teacher_account_restricted: "Your account is a teacher account and cannot access student content."
#    account_restricted: "A student account is required to access this page."
#    update_account_login_title: "Log in to update your account"
#    update_account_title: "Your account needs attention!"
#    update_account_blurb: "Before you can access your classes, choose how you want to use this account."
#    update_account_current_type: "Current Account Type:"
#    update_account_account_email: "Account Email/Username:"
#    update_account_am_teacher: "I am a teacher"
#    update_account_keep_access: "Keep access to classes I've created"
#    update_account_teachers_can: "Teacher accounts can:"
#    update_account_teachers_can1: "Create/manage/add classes"
#    update_account_teachers_can2: "Assign/enroll students in courses"
#    update_account_teachers_can3: "Unlock all course levels to try out"
#    update_account_teachers_can4: "Access new teacher-only features as we release them"
#    update_account_teachers_warning: "Warning: You will be removed from all classes that you have previously joined and will not be able to play as a student."
#    update_account_remain_teacher: "Remain a Teacher"
#    update_account_update_teacher: "Update to Teacher"
#    update_account_am_student: "I am a student"
#    update_account_remove_access: "Remove access to classes I have created"
#    update_account_students_can: "Student accounts can:"
#    update_account_students_can1: "Join classes"
#    update_account_students_can2: "Play through courses as a student and track your own progress"
#    update_account_students_can3: "Compete against classmates in arenas"
#    update_account_students_can4: "Access new student-only features as we release them"
#    update_account_students_warning: "Warning: You will not be able to manage any classes that you have previously created or create new classes."
#    update_account_remain_student: "Remain a Student"
#    update_account_update_student: "Update to Student"
#    need_a_class_code: "You'll need a Class Code for the class you're joining:"
#    update_account_not_sure: "Not sure which one to choose? Email"
#    update_account_confirm_update_student: "Are you sure you want to update your account to a Student experience?"
#    update_account_confirm_update_student2: "You will not be able to manage any classes that you have previously created or create new classes. Your previously created classes will be removed from CodeCombat and cannot be restored."
#    instructor: "Instructor: "
#    youve_been_invited_1: "You've been invited to join "
#    youve_been_invited_2: ", where you'll learn "
#    youve_been_invited_3: " with your classmates in CodeCombat."
#    by_joining_1: "By joining "
#    by_joining_2: "will be able to help reset your password if you forget or lose it. You can also verify your email address so that you can reset the password yourself!"
#    sent_verification: "We've sent a verification email to:"
#    you_can_edit: "You can edit your email address in "
#    account_settings: "Account Settings"
#    select_your_hero: "Select Your Hero"
#    select_your_hero_description: "You can always change your hero by going to your Courses page and clicking \"Change Hero\""
#    select_this_hero: "Select this Hero"
#    current_hero: "Current Hero:"
#    change_hero: "Change Hero"
#    web_dev_language_transition: "All classes program in HTML / JavaScript for this course.  Classes that have been using Python will start with extra JavaScript intro levels to ease the transition.  Classes that are already using JavaScript will skip the intro levels."

#  teacher:
#    course_solution: "Course Solution"
#    level_overview_solutions: "Level Overview and Solutions"
#    teacher_dashboard: "Teacher Dashboard" # Navbar
#    my_classes: "My Classes"
#    courses: "Course Guides"
#    enrollments: "Student Licenses"
#    resources: "Resources"
#    help: "Help"
#    students: "Students" # Shared
#    language: "Language"
#    edit_class_settings: "edit class settings"
#    complete: "Complete"
#    access_restricted: "Account Update Required"
#    teacher_account_required: "A teacher account is required to access this content."
#    create_teacher_account: "Create Teacher Account"
#    what_is_a_teacher_account: "What's a Teacher Account?"
#    teacher_account_explanation: "A CodeCombat Teacher account allows you to set up classrooms, monitor students’ progress as they work through courses, manage licenses and access resources to aid in your curriculum-building."
#    current_classes: "Current Classes"
#    archived_classes: "Archived Classes"
#    archived_classes_blurb: "Classes can be archived for future reference. Unarchive a class to view it in the Current Classes list again."
#    view_class: "view class"
#    archive_class: "archive class"
#    unarchive_class: "unarchive class"
#    unarchive_this_class: "Unarchive this class"
#    no_students_yet: "This class has no students yet."
#    no_students_yet_view_class: "View class to add students."
#    try_refreshing: "(You may need to refresh the page)"
#    add_students: "Add Students"
#    create_new_class: "Create a New Class"
#    class_overview: "Class Overview" # View Class page
#    avg_playtime: "Average level playtime"
#    total_playtime: "Total play time"
#    avg_completed: "Average levels completed"
#    total_completed: "Total levels completed"
#    created: "Created"
#    concepts_covered: "Concepts covered"
#    earliest_incomplete: "Earliest incomplete level"
#    latest_complete: "Latest completed level"
#    enroll_student: "Enroll student"
#    apply_license: "Apply License"
#    course_progress: "Course Progress"
#    not_applicable: "N/A"
#    edit: "edit"
#    edit_2: "Edit"
#    remove: "remove"
#    latest_completed: "Latest completed:"
#    sort_by: "Sort by"
#    progress: "Progress"
#    completed: "Completed"
#    started: "Started"
#    click_to_view_progress: "click to view progress"
#    no_progress: "No progress"
#    select_course: "Select course to view"
#    students_not_assigned: "Students who have not been assigned {{courseName}}"
#    course_overview: "Course Overview"
#    copy_class_code: "Copy Class Code"
#    class_code_blurb: "Students can join your class using this Class Code. No email address is required when creating a Student account with this Class Code."
#    copy_class_url: "Copy Class URL"
#    class_join_url_blurb: "You can also post this unique class URL to a shared webpage."
#    add_students_manually: "Invite Students by Email"
#    bulk_assign: "Bulk-assign"
#    assigned_msg_1: "{{numberAssigned}} students were assigned {{courseName}}."
#    assigned_msg_2: "{{numberEnrolled}} licenses were applied."
#    assigned_msg_3: "You now have {{remainingSpots}} available licenses remaining."
#    assign_course: "Assign Course"
#    not_assigned_modal_title: "Courses were not assigned"
#    not_assigned_modal_body_1: "You do not have enough licenses available to assign additional Courses to all {{selected}} selected students."
#    not_assigned_modal_body_2: "You only have {{totalSpotsAvailable}} licenses available ({{unenrolledStudents}} students did not have an active license)."
#    not_assigned_modal_body_3: "Please select fewer students, or reach out to {{email}} for assistance."
#    assign_to_selected_students: "Assign to Selected Students"
#    assigned: "Assigned"
#    enroll_selected_students: "Enroll Selected Students"
#    no_students_selected: "No students were selected."
#    guides_coming_soon: "Guides coming soon!" # Courses
#    show_students_from: "Show students from" # Enroll students modal
#    apply_licenses_to_the_following_students: "Apply Licenses to the Following Students"
#    students_have_licenses: "The following students already have licenses applied:"
#    all_students: "All Students"
#    apply_licenses: "Apply Licenses"
#    not_enough_enrollments: "Not enough licenses available."
#    enrollments_blurb: "Students are required to have a license to access any content after the first course."
#    credits_available: "Licenses Available"
#    total_unique_students: "Total Students"
#    total_enrolled_students: "Enrolled Students"
#    unenrolled_students: "Unenrolled Students"
#    add_enrollment_credits: "Add Licenses"
#    purchasing: "Purchasing..."
#    purchased: "Purchased!"
#    purchase_now: "Purchase Now"
#    how_to_enroll: "How to Enroll Students"
#    how_to_apply_licenses: "How to Apply Licenses"
#    bulk_pricing_blurb: "Purchasing for more than 25 students? Contact us to discuss next steps."
#    total_unenrolled: "Total unenrolled"
#    export_student_progress: "Export Student Progress (CSV)"
#    send_email_to: "Send Recover Password Email to:"
#    email_sent: "Email sent"
#    send_recovery_email: "Send recovery email"
#    enter_new_password_below: "Enter new password below:"
#    change_password: "Change Password"
#    changed: "Changed"
#    available_credits: "Available Licenses"
#    pending_credits: "Pending Licenses"
#    credits: "licenses"
#    start_date: "start date:"
#    end_date: "end date:"
#    get_enrollments_blurb: " We'll help you build a solution that meets the needs of your class, school or district."
#    how_to_apply_licenses_blurb_1: "When a teacher assigns a course to a student for the first time, we’ll automatically apply a license. Use the bulk-assign dropdown in your classroom to assign a course to selected students:"
#    how_to_apply_licenses_blurb_2: "Can I still apply a license without assigning a course?"
#    how_to_apply_licenses_blurb_3: "Yes — go to the License Status tab in your classroom and click \"Apply License\" to any student who does not have an active license."
#    request_sent: "Request Sent!"
#    enrollment_status: "Enrollment Status"
#    license_status: "License Status"
#    status_expired: "Expired on {{date}}"
#    status_not_enrolled: "Not Enrolled"
#    status_enrolled: "Expires on {{date}}"
#    select_all: "Select All"
#    projects: "Projects"
#    project: "Project"
#    view_student_project: "View Student Project"
#    view_arena_ladder: "View Arena Ladder"
#    resource_hub: "Resource Hub"
#    getting_started: "Getting Started"
#    educator_faq: "Educator FAQ"
#    educator_faq_desc: "Frequently asked questions about using CodeCombat in your classroom or school."
#    teacher_getting_started: "Teacher Getting Started Guide"
#    teacher_getting_started_desc: "New to CodeCombat? Download this Teacher Getting Started Guide to set up your account, create your first class, and invite students to the first course."
#    student_getting_started: "Student Quick Start Guide"
#    student_getting_started_desc: "You can distribute this guide to your students before starting CodeCombat so that they can familiarize themselves with the code editor. This guide can be used for both Python and JavaScript classrooms."
#    cs1: "Introduction to Computer Science"
#    cs2: "Computer Science 2"
#    cs3: "Computer Science 3"
#    cs1_syntax_python: "Course 1 Python Syntax Guide"
#    cs1_syntax_python_desc: "Cheatsheet with references to common Python syntax that students will learn in Introduction to Computer Science."
#    cs1_syntax_javascript: "Course 1 JavaScript Syntax Guide"
#    cs1_syntax_javascript_desc: "Cheatsheet with references to common JavaScript syntax that students will learn in Introduction to Computer Science."
#    coming_soon: "Additional guides coming soon!"
#    engineering_cycle_worksheet: "Engineering Cycle Worksheet"
#    engineering_cycle_worksheet_desc: "Use this worksheet to teach students the basics of the engineering cycle: Assess, Design, Implement and Debug. Refer to the completed example worksheet as a guide."
#    engineering_cycle_worksheet_link: "View example"
#    progress_journal: "Progress Journal"
#    progress_journal_desc: "Encourage students to keep track of their progress via a progress journal."
#    cs1_curriculum: "Introduction to Computer Science - Curriculum Guide"
#    cs1_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 1."
#    cs2_curriculum: "Computer Science 2 - Curriculum Guide"
#    cs2_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 2."
#    cs3_curriculum: "Computer Science 3 - Curriculum Guide"
#    cs3_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 3."
#    cs1_pairprogramming: "Pair Programming Activity"
#    cs1_pairprogramming_desc: "Introduce students to a pair programming exercise that will help them become better listeners and communicators."
#    unlock_resources: "Unlock more resources!"
#    unlock_resources_desc: "Gain access to additional guides by adding student licenses to your account. Request a demo today to get started."
#    request_demo: "Request Demo"
#    student_overview: "Overview"
#    student_email: "Student Email"
#    no_email: "Student has no email address set."
#    student_profile: "Student Profile"
#    playtime_detail: "Playtime Detail"
#    student_completed: "Student Completed"
#    student_in_progress: "Student in Progress"
#    class_average: "Class Average"
#    not_assigned: "has not been assigned the following courses"
#    playtime_axis: "Playtime in Seconds"
#    levels_axis: "Levels in"
#    student_state: "How is"
#    student_state_2: "doing?"
#    student_good: "is doing well in"
#    student_good_detail: "This student is keeping pace with the class."
#    student_warn: "might need some help in"
#    student_warn_detail: "This student might need some help with new concepts that have been introduced in this course."
#    student_great: "is doing great in"
#    student_great_detail: "This student might be a good candidate to help other students working through this course."

#  sharing:
#    game: "Game"
#    webpage: "Webpage"
#    your_students_preview: "Your students will click here to see their finished projects! Unavailable in teacher preview."
#    unavailable: "Link sharing not available in teacher preview."
#    share_game: "Share This Game"
#    share_web: "Share This Webpage"
#    victory_share_prefix: "Share this link to invite your friends & family to"
#    victory_share_game: "play your game level"
#    victory_share_web: "view your webpage"
#    victory_share_suffix: "."
#    victory_course_share_prefix: "This link will let your friends & family"
#    victory_course_share_game: "play the game"
#    victory_course_share_web: "view the webpage"
#    victory_course_share_suffix: "you just created."
#    copy_url: "Copy URL"

#  game_dev:
#    creator: "Creator"

#  web_dev:
#    image_gallery_title: "Image Gallery"
#    select_an_image: "Select an image you want to use"
#    scroll_down_for_more_images: "(Scroll down for more images)"
#    copy_the_url: "Copy the URL below"
#    copy_the_url_description: "Useful if you want to replace an existing image."
#    copy_the_img_tag: "Copy the <img> tag"
#    copy_the_img_tag_description: "Useful if you want to insert a new image."
#    copy_url: "Copy URL"
#    copy_img: "Copy <img>"
#    how_to_copy_paste: "How to Copy/Paste"
#    copy: "Copy"
#    paste: "Paste"
#    back_to_editing: "Back to Editing"

  classes:
    archmage_title: "アークメイジ"
    archmage_title_description: "(プログラマ)"
    archmage_summary: "もしあなたが教育的なゲームに興味のあるデベロッパーであれば、CodeCombat を作るアーキメイジになれます！"
    artisan_title: "アーチザン"
    artisan_title_description: "(レベルデザイナー)"
    artisan_summary: "レベルを作成し、友達にプレイしてもらおう。アーチザンになって他の人にプログラムを教える術を学ぼう！"
    adventurer_title: "冒険者"
    adventurer_title_description: "(レベルのテストプレイヤー)"
    adventurer_summary: "我々の新しいレベル(我々のサブスクライバーコンテンツ)を1週間早くゲットして、パブリックリリースの前にバグを見つける手伝いをするのが冒険者です。"
    scribe_title: "代書人"
    scribe_title_description: "(記事の編集者)"
    scribe_summary: "良いコードは良いドキュメントが必要です。書いて、編集して数百万人が読むドキュメントを改善しよう。"
    diplomat_title: "外交官"
    diplomat_title_description: "(翻訳者)"
    diplomat_summary: "CodeCombat は私たちの外交官により45ヶ国語以上の言語にローカライズされています。翻訳に貢献し、私たちを手伝ってください。"
    ambassador_title: "大使"
    ambassador_title_description: "(サポート)"
    ambassador_summary: "フォーラムのユーザが投稿する質問に答えます。私たちの大使が CodeCombat を世界に表現します。"
    teacher_title: "先生"

  editor:
    main_title: "CodeCombatエディター"
    article_title: "アーティクル エディター"
    thang_title: "サングエディター"
    level_title: "レベルエディター"
    course_title: "コースエディター"
    achievement_title: "実績エディター"
    poll_title: "投票エディター"
    back: "バック"
    revert: "戻す"
    revert_models: "モデルを戻す"
    pick_a_terrain: "地形を選択してください"
    dungeon: "ダンジョン"
    indoor: "屋内"
    desert: "砂漠"
    grassy: "草原"
    mountain: "山岳"
    glacier: "氷河"
    small: "小さい"
    large: "大きい"
    fork_title: "新しいバージョンをフォークする"
    fork_creating: "フォークを作成中"
    generate_terrain: "地形を生成"
    more: "さらに見る"
    wiki: "ウィキ"
    live_chat: "ライブチャット"
    thang_main: "メイン"
    thang_spritesheets: "スプライトシート"
    thang_colors: "色"
    level_some_options: "オプションを付けますか?"
    level_tab_thangs: "サング"
    level_tab_scripts: "スクリプト"
    level_tab_components: "コンポーネント"
    level_tab_systems: "システム"
    level_tab_docs: "文章"
    level_tab_thangs_title: "現在のサング"
    level_tab_thangs_all: "すべて"
    level_tab_thangs_conditions: "コンディションの開始"
    level_tab_thangs_add: "サングの追加"
    level_tab_thangs_search: "サングの検索"
    add_components: "コンポーネントの追加"
    component_configs: "コンポーネントの設定"
    config_thang: "ダブルクリックでサングの設定"
    delete: "削除"
    duplicate: "重複"
    stop_duplicate: "重複をやめる"
    rotate: "回転"
    level_component_tab_title: "現在の部品"
    level_component_btn_new: "新しい部品を作る"
    level_systems_tab_title: "現在のシステム"
    level_systems_btn_new: "新しいシステムを作る"
    level_systems_btn_add: "システムの追加"
    level_components_title: "全てびサングに戻る"
    level_components_type: "タイプ"
    level_component_edit_title: "部品の編集"
    level_component_config_schema: "スキーマの設定"
    level_system_edit_title: "システムの編集"
    create_system_title: "新しいシステムの作成"
    new_component_title: "新しい部品の作成"
    new_component_field_system: "システム"
    new_article_title: "新しい記事の作成"
    new_thang_title: "新しいサングの型の作成"
    new_level_title: "新しいレベルの作成"
    new_article_title_login: "ログインして新しい記事の作成"
    new_thang_title_login: "ログインして新しいサングの型の作成"
    new_level_title_login: "ログインして新しいレベルの作成"
    new_achievement_title: "新しい実績の作成"
    new_achievement_title_login: "ログインして新しい実績の作成"
#    new_poll_title: "Create a New Poll"
#    new_poll_title_login: "Log In to Create a New Poll"
#    article_search_title: "Search Articles Here"
#    thang_search_title: "Search Thang Types Here"
#    level_search_title: "Search Levels Here"
#    achievement_search_title: "Search Achievements"
#    poll_search_title: "Search Polls"
#    read_only_warning2: "Note: you can't save any edits here, because you're not logged in."
#    no_achievements: "No achievements have been added for this level yet."
#    achievement_query_misc: "Key achievement off of miscellanea"
#    achievement_query_goals: "Key achievement off of level goals"
#    level_completion: "Level Completion"
#    pop_i18n: "Populate I18N"
#    tasks: "Tasks"
#    clear_storage: "Clear your local changes"
#    add_system_title: "Add Systems to Level"
#    done_adding: "Done Adding"

  article:
    edit_btn_preview: "プレビュー"
    edit_article_title: "アーティクルの設定"

  polls:
    priority: "プライオリティ"

  contribute:
    page_title: "コントリビュート"
    intro_blurb: "CodeCombat は100%オープンソースです！何百もの熱心なプレイヤーが私たちがゲームを作るのを手伝っています。私たちと一緒に CodeCombat の次のチャプターを作って世界中のプレイヤーにプログラミングを教えましょう！"
    alert_account_message_intro: "やあ、こんにちは!"
    alert_account_message: "クラスのメールを購読するには,まずログインが必要です。"
    archmage_introduction: "ゲームを作る上で一番重要なのは、たくさんの要素を合成することです。グラフィック、サウンド、リアルタイムネットワーキング、ソーシャルネットワーキング、一般的なプログラミング、ローレベルのデータベースマネジメント、管理画面のデザインやインターフェイスなど多岐に渡ります。やらなくてはいけないことはたくさんあります。もしあなたが経験豊富なプログラマであればアーキメイジになって CodeCombat のコアにコミットしましょう。ぜひとも私たちの最高のプログラミングゲームを手伝ってください。"
    class_attributes: "クラスの属性"
    archmage_attribute_1_pref: ""
    archmage_attribute_1_suf: " の知識か、それを学ぶ欲求。ほとんどの私たちのコードはこの言語で書かれています。もしあなたが Ruby や Python のファンなら親しく感じるでしょう。JavaScript ですが、より素敵なシンタックスです。"
    archmage_attribute_2: "プログラミングの経験や、自ら率先して行動すること。私たちは慣れるのをお手伝いしますが、あなたをトレーニングする時間はありません。"
    how_to_join: "参加の方法"
    join_desc_1: "誰でも"
    join_desc_2: "からはじめることができます。また、下のチェックボックをオンにするとアークメイジと CodeCombat の最新情報がメールで届きます。さらに深く一翼を担いたいですか？"
    join_desc_3: "をするか、私たちの"
    join_desc_4: "で私たちに連絡してください！"
    join_url_email: "メール"
    join_url_slack: "公開Slackチャンネル"
    archmage_subscribe_desc: "コーディングの機会やアナウンスをメールで受け取る"
    artisan_introduction_pref: "私たちは、追加のレベルを建設しなければなりません！皆さんはもっとコンテンツを、と叫んでいますが、私達がつくれるのは自分たちの分だけです。今、あなたのワークステーションはレベル１です。私達のレベルエディタをつかえばそんなクリエイターでもギリギリ使えます、そう警戒しないで。あなたがfor-loopにまたがるキャンペーンのビジョンを"
    artisan_introduction_suf: "にもっているなら、このクラスはあなたにピッタリです。"
    artisan_attribute_1: "Blizzardのレベルエディタなどの構築経験は歓迎しますが、必須ではありません!"
    artisan_attribute_2: "全体のテストを何度もすることを願ってます。 よいレベルを作るには 他の人のを真似て見てプレイしてみることが必要です。そしてそこから修正のための多くのものを見つけて準備しましょう。"
    artisan_attribute_3: "時間がかかることで, 冒険者と並ぶくらい我慢しなければなりません。 私達のレベルエディターは予備動作が長く使っているとイライラするかもしれません。気をつけてくださいね!"
    artisan_join_desc: "レベルエディタを使うために以下のステップを利用してください。"
    artisan_join_step1: "ドキュメントを読む"
    artisan_join_step2: "新しいレベルを作成し、すでにあるレベルか探す"
    artisan_join_step3: "ヘルプが必要なとき公開Slackルームで私達を探す"
    artisan_join_step4: "フィードバックのためフォーラムにあなたのレベルを投稿する"
    artisan_subscribe_desc: "レベルエディタアップデートやアナウンスをメールで受け取る"
    adventurer_introduction: "あなたの役割をはっきりしましょう。あなたは戦車です。あなたには大きなダメージを負ってもらいます。私たちには新しいレベルを試し、どう改善するか見分けるの役立つ人が必要です。その苦痛は大きなものです。よいゲームを作ることは長い道のりで、最初から正しく動くものなどないのです。もしあなたが耐えることができ、高い生命力を持っているならこのクラスはあなたにピッタリでしょう。"
    adventurer_attribute_1: "学習することへの渇き。あなたがコーディングのやり方を学びたいなら私たちはコーディングの方法を教えたいと思っています。おそらくこの授業のほとんどを受けているでしょうけど。"
    adventurer_attribute_2: "カリスマ。紳士的であり、改善に必要なことをはっきり表し、改善する方法について提案をします。"
    adventurer_join_pref: "アーチザンを獲得（新会員に）し彼らと働き、テストをし新しいレベルがあるときにメールを受信するには以下のチェックボックスをオンにしてください。また、私達はレベルのレビューの投稿をを私達のネットワーク"
    adventurer_forum_url: "フォーラム"
    adventurer_join_suf: "などで通知する場合はそこでもサインアップをしてください。"
    adventurer_subscribe_desc: "新しいレベルをテストするためのメールを受け取る。"
#    scribe_introduction_pref: "CodeCombat isn't just going to be a bunch of levels. It will also include a resource for knowledge, a wiki of programming concepts that levels can hook into. That way rather than each Artisan having to describe in detail what a comparison operator is, they can simply link their level to the Article describing them that is already written for the player's edification. Something along the lines of what the "
#    scribe_introduction_url_mozilla: "Mozilla Developer Network"
#    scribe_introduction_suf: " has built. If your idea of fun is articulating the concepts of programming in Markdown form, then this class might be for you."
#    scribe_attribute_1: "Skill in words is pretty much all you need. Not only grammar and spelling, but able to convey complicated ideas to others."
#    contact_us_url: "Contact Us"
#    scribe_join_description: "tell us a little about yourself, your experience with programming and what sort of things you'd like to write about. We'll go from there!"
#    scribe_subscribe_desc: "Get emails about article writing announcements."
#    diplomat_introduction_pref: "So, if there's one thing we learned from the "
#    diplomat_launch_url: "launch in October"
#    diplomat_introduction_suf: "it's that there is sizeable interest in CodeCombat in other countries! We're building a corps of translators eager to turn one set of words into another set of words to get CodeCombat as accessible across the world as possible. If you like getting sneak peeks at upcoming content and getting these levels to your fellow nationals ASAP, then this class might be for you."
#    diplomat_attribute_1: "Fluency in English and the language you would like to translate to. When conveying complicated ideas, it's important to have a strong grasp in both!"
#    diplomat_i18n_page_prefix: "You can start translating our levels by going to our"
#    diplomat_i18n_page: "translations page"
#    diplomat_i18n_page_suffix: ", or our interface and website on GitHub."
#    diplomat_join_pref_github: "Find your language locale file "
#    diplomat_github_url: "on GitHub"
#    diplomat_join_suf_github: ", edit it online, and submit a pull request. Also, check this box below to keep up-to-date on new internationalization developments!"
#    diplomat_subscribe_desc: "Get emails about i18n developments and levels to translate."
#    ambassador_introduction: "This is a community we're building, and you are the connections. We've got forums, emails, and social networks with lots of people to talk with and help get acquainted with the game and learn from. If you want to help people get involved and have fun, and get a good feel of the pulse of CodeCombat and where we're going, then this class might be for you."
#    ambassador_attribute_1: "Communication skills. Be able to identify the problems players are having and help them solve them. Also, keep the rest of us informed about what players are saying, what they like and don't like and want more of!"
#    ambassador_join_desc: "tell us a little about yourself, what you've done and what you'd be interested in doing. We'll go from there!"
#    ambassador_join_note_strong: "Note"
#    ambassador_join_note_desc: "One of our top priorities is to build multiplayer where players having difficulty solving levels can summon higher level wizards to help them. This will be a great way for ambassadors to do their thing. We'll keep you posted!"
#    ambassador_subscribe_desc: "Get emails on support updates and multiplayer developments."
#    teacher_subscribe_desc: "Get emails on updates and announcements for teachers."
#    changes_auto_save: "Changes are saved automatically when you toggle checkboxes."
#    diligent_scribes: "Our Diligent Scribes:"
    powerful_archmages: "私たちの強力なアークメイジたち:"
    creative_artisans: "私たちのクリエイティブなアーチザンたち:"
    brave_adventurers: "私たちの勇敢な冒険者たち:"
    translating_diplomats: "私たちの翻訳をしてくれる外交官たち:"
    helpful_ambassadors: "私たちの有能な大使たち:"

  ladder:
    please_login: "ラダーゲームのプレイ前にログインしてください。"
    my_matches: "勝負"
    simulate: "シミュレート"
    simulation_explanation: "試合のシミュレートはより早くランク付けすることができます!"
    simulation_explanation_leagues: "同盟を組んだクランやコースのプレイヤーの試合のシミュレーションを助ける。"
    simulate_games: "試合をシミュレート!"
    games_simulated_by: "あなたからシミュレートした試合:"
    games_simulated_for: "あなたへシミュレートされた試合:"
    games_in_queue: "試合は現在列待ちです:"
    games_simulated: "試合のシミュレーション完了"
    games_played: "試合開始完了"
    ratio: "比率  "
    leaderboard: "リーダーボード"
    battle_as: "対戦  "
    summary_your: "あなたの "
    summary_matches: "戦闘数 - "
    summary_wins: " 勝利数, "
    summary_losses: " 敗北数"
    rank_no_code: "新しいコードがランクにありません"
    rank_my_game: "試合をランキングに送信!"
    rank_submitting: "送信中..."
    rank_submitted: "ランキングに送信されました。"
    rank_failed: "ランキングに送信できませんでした。"
    rank_being_ranked: "ランキングにのっています"
    rank_last_submitted: "送信"
    help_simulate: "試合のシミュレートのヘルプ?"
#    code_being_simulated: "Your new code is being simulated by other players for ranking. This will refresh as new matches come in."
#    no_ranked_matches_pre: "No ranked matches for the "
#    no_ranked_matches_post: " team! Play against some competitors and then come back here to get your game ranked."
    choose_opponent: "相手を選んでください"
    select_your_language: "使う言語を選んでください！"
    tutorial_play: "チュートリアルで遊ぶ"
    tutorial_recommended: "はじめて遊ぶ人におすすめ"
    tutorial_skip: "チュートリアルをスキップする"
    tutorial_not_sure: "なにが起きているのかわかりませんか？"
    tutorial_play_first: "はじめからチュートリアルを遊ぶ"
    simple_ai: "単純なCPU"
    warmup: "ウォームアップ"
    friends_playing: "友達と遊ぶ"
    log_in_for_friends: "ログインして友達と遊ぼう"
#    social_connect_blurb: "Connect and play against your friends!"
#    invite_friends_to_battle: "Invite your friends to join you in battle!"
#    fight: "Fight!"
#    watch_victory: "Watch your victory"
#    defeat_the: "Defeat the"
#    watch_battle: "Watch the battle"
#    tournament_started: ", started"
#    tournament_ends: "Tournament ends"
#    tournament_ended: "Tournament ended"
#    tournament_rules: "Tournament Rules"
#    tournament_blurb: "Write code, collect gold, build armies, crush foes, win prizes, and upgrade your career in our $40,000 Greed tournament! Check out the details"
#    tournament_blurb_criss_cross: "Win bids, construct paths, outwit opponents, grab gems, and upgrade your career in our Criss-Cross tournament! Check out the details"
#    tournament_blurb_zero_sum: "Unleash your coding creativity in both gold gathering and battle tactics in this alpine mirror match between red sorcerer and blue sorcerer. The tournament began on Friday, March 27 and will run until Monday, April 6 at 5PM PDT. Compete for fun and glory! Check out the details"
#    tournament_blurb_ace_of_coders: "Battle it out in the frozen glacier in this domination-style mirror match! The tournament began on Wednesday, September 16 and will run until Wednesday, October 14 at 5PM PDT. Check out the details"
#    tournament_blurb_blog: "on our blog"
    rules: "ルール"
    winners: "勝者"
    league: "リーグ"
    red_ai: "レッドCPU" # "Red AI Wins", at end of multiplayer match playback
    blue_ai: "ブルーCPU"
    wins: "勝利" # At end of multiplayer match playback
    humans: "レッド" # Ladder page display team name
    ogres: "ブルー"

  user:
    stats: "ステータス"
    singleplayer_title: "シングルプレイヤーレベル"
    multiplayer_title: "マルチプレイヤーレベル"
    achievements_title: "アーカイブ"
    last_played: "最終プレイ"
    status: "ステータス"
    status_completed: "コンプリート"
    status_unfinished: "未完了"
    no_singleplayer: "まだシングルプレイヤーのゲームをプレイしていません。"
    no_multiplayer: "まだマルチプレイヤーのゲームをプレイしていません。"
    no_achievements: "まだアーカイブはありません。"
    favorite_prefix: "お気に入りの言語は "
    favorite_postfix: "。"
    not_member_of_clans: "まだどのクランにも所属していません。"

#  achievements:
#    last_earned: "Last Earned"
#    amount_achieved: "Amount"
#    achievement: "Achievement"
#    current_xp_prefix: ""
#    current_xp_postfix: " in total"
#    new_xp_prefix: ""
#    new_xp_postfix: " earned"
#    left_xp_prefix: ""
#    left_xp_infix: " until level "
#    left_xp_postfix: ""

#  account:
#    payments: "Payments"
#    prepaid_codes: "Prepaid Codes"
#    purchased: "Purchased"
#    subscription: "Subscription"
#    invoices: "Invoices"
#    service_apple: "Apple"
#    service_web: "Web"
#    paid_on: "Paid On"
#    service: "Service"
#    price: "Price"
#    gems: "Gems"
#    active: "Active"
#    subscribed: "Subscribed"
#    unsubscribed: "Unsubscribed"
#    active_until: "Active Until"
#    cost: "Cost"
#    next_payment: "Next Payment"
#    card: "Card"
#    status_unsubscribed_active: "You're not subscribed and won't be billed, but your account is still active for now."
#    status_unsubscribed: "Get access to new levels, heroes, items, and bonus gems with a CodeCombat subscription!"
#    not_yet_verified: "Not yet verified."
#    resend_email: "Resend email"
#    email_sent: "Email sent! Check your inbox."
#    verifying_email: "Verifying your email address..."
#    successfully_verified: "You've successfully verified your email address!"
#    back_to_student_page: "Go back to student things"
#    back_to_teacher_page: "Go to My Classes"
#    back_to_game: "Go play some more levels!"
#    verify_error: "Something went wrong when verifying your email :("

#  account_invoices:
#    amount: "Amount in US dollars"
#    declined: "Your card was declined"
#    invalid_amount: "Please enter a US dollar amount."
#    not_logged_in: "Log in or create an account to access invoices."
#    pay: "Pay Invoice"
#    purchasing: "Purchasing..."
#    retrying: "Server error, retrying."
#    success: "Successfully paid. Thanks!"

#  account_prepaid:
#    purchase_code: "Purchase a Subscription Code"
#    purchase_code1: "Subscription Codes can be redeemed to add premium subscription time to one or more CodeCombat accounts."
#    purchase_code2: "Each CodeCombat account can only redeem a particular Subscription Code once."
#    purchase_code3: "Subscription Code months will be added to the end of any existing subscription on the account."
#    users: "Users"
#    months: "Months"
#    purchase_total: "Total"
#    purchase_button: "Submit Purchase"
#    your_codes: "Your Codes"
#    redeem_codes: "Redeem a Subscription Code"
#    prepaid_code: "Prepaid Code"
#    lookup_code: "Lookup prepaid code"
#    apply_account: "Apply to your account"
#    copy_link: "You can copy the code's link and send it to someone."
#    quantity: "Quantity"
#    redeemed: "Redeemed"
#    no_codes: "No codes yet!"
#    you_can1: "You can"
#    you_can2: "purchase a prepaid code"
#    you_can3: "that can be applied to your own account or given to others."

#  coppa_deny:
#    text1: "Can’t wait to learn programming?"
#    text2: "Your parents will need to create an account for you to use! Email team@codecombat.com if you have any questions."
#    close: "Close Window"

#  loading_error:
#    could_not_load: "Error loading from server"
#    connection_failure: "Connection Failed"
#    connection_failure_desc: "It doesn’t look like you’re connected to the internet! Check your network connection and then reload this page."
#    login_required: "Login Required"
#    login_required_desc: "You need to be logged in to access this page."
#    unauthorized: "You need to be signed in. Do you have cookies disabled?"
#    forbidden: "Forbidden"
#    forbidden_desc: "Oh no, there’s nothing we can show you here! Make sure you’re logged into the correct account, or visit one of the links below to get back to programming!"
#    not_found: "Not Found"
#    not_found_desc: "Hm, there’s nothing here. Visit one of the following links to get back to programming!"
#    not_allowed: "Method not allowed."
#    timeout: "Server Timeout"
#    conflict: "Resource conflict."
#    bad_input: "Bad input."
#    server_error: "Server error."
#    unknown: "Unknown Error"
#    error: "ERROR"
#    general_desc: "Something went wrong, and it’s probably our fault. Try waiting a bit and then refreshing the page, or visit one of the following links to get back to programming!"

#  resources:
#    level: "Level"
#    patch: "Patch"
#    patches: "Patches"
#    system: "System"
#    systems: "Systems"
#    component: "Component"
#    components: "Components"
#    hero: "Hero"
#    campaigns: "Campaigns"

#  concepts:
#    advanced_strings: "Advanced Strings"
#    algorithms: "Algorithms"
#    arguments: "Arguments"
#    arithmetic: "Arithmetic"
#    arrays: "Arrays"
#    basic_syntax: "Basic Syntax"
#    boolean_logic: "Boolean Logic"
#    break_statements: "Break Statements"
#    classes: "Classes"
#    continue_statements: "Continue Statements"
#    for_loops: "For Loops"
#    functions: "Functions"
#    graphics: "Graphics"
#    if_statements: "If Statements"
#    input_handling: "Input Handling"
#    math_operations: "Math Operations"
#    object_literals: "Object Literals"
#    parameters: "Parameters"
#    strings: "Strings"
#    variables: "Variables"
#    vectors: "Vectors"
#    while_loops: "While Loops"
#    recursion: "Recursion"
#    basic_html: "Basic HTML" # TODO: these web-dev concepts will change, don't need to translate
#    basic_css: "Basic CSS"
#    basic_web_scripting: "Basic Web Scripting"
#    intermediate_html: "Intermediate HTML"
#    intermediate_css: "Intermediate CSS"
#    intermediate_web_scripting: "Intermediate Web Scripting"
#    advanced_html: "Advanced HTML"
#    advanced_css: "Advanced CSS"
#    advanced_web_scripting: "Advanced Web Scripting"
#    jquery: "jQuery"
#    bootstrap: "Bootstrap"

#  delta:
#    added: "Added"
#    modified: "Modified"
#    not_modified: "Not Modified"
#    deleted: "Deleted"
#    moved_index: "Moved Index"
#    text_diff: "Text Diff"
#    merge_conflict_with: "MERGE CONFLICT WITH"
#    no_changes: "No Changes"

  legal:
#    page_title: "Legal"
#    opensource_intro: "CodeCombat is completely open source."
#    opensource_description_prefix: "Check out "
#    github_url: "our GitHub"
#    opensource_description_center: "and help out if you like! CodeCombat is built on dozens of open source projects, and we love them. See "
#    archmage_wiki_url: "our Archmage wiki"
#    opensource_description_suffix: "for a list of the software that makes this game possible."
#    practices_title: "Respectful Best Practices"
#    practices_description: "These are our promises to you, the player, in slightly less legalese."
#    privacy_title: "Privacy"
#    privacy_description: "We will not sell any of your personal information."
#    security_title: "Security"
#    security_description: "We strive to keep your personal information safe. As an open source project, our site is freely open to anyone to review and improve our security systems."
    email_title: "メール"
#    email_description_prefix: "We will not inundate you with spam. Through"
#    email_settings_url: "your email settings"
#    email_description_suffix: "or through links in the emails we send, you can change your preferences and easily unsubscribe at any time."
#    cost_title: "Cost"
#    cost_description: "CodeCombat is free to play for all of its core levels, with a ${{price}} USD/mo subscription for access to extra level branches and {{gems}} bonus gems per month. You can cancel with a click, and we offer a 100% money-back guarantee."
#    copyrights_title: "Copyrights and Licenses"
#    contributor_title: "Contributor License Agreement"
#    contributor_description_prefix: "All contributions, both on the site and on our GitHub repository, are subject to our"
#    cla_url: "CLA"
#    contributor_description_suffix: "to which you should agree before contributing."
#    code_title: "Code - MIT"
#    code_description_prefix: "All code owned by CodeCombat or hosted on codecombat.com, both in the GitHub repository or in the codecombat.com database, is licensed under the"
#    mit_license_url: "MIT license"
#    code_description_suffix: "This includes all code in Systems and Components that are made available by CodeCombat for the purpose of creating levels."
#    art_title: "Art/Music - Creative Commons "
#    art_description_prefix: "All common content is available under the"
#    cc_license_url: "Creative Commons Attribution 4.0 International License"
#    art_description_suffix: "Common content is anything made generally available by CodeCombat for the purpose of creating Levels. This includes:"
    art_music: "音楽"
    art_sound: "音"
#    art_artwork: "Artwork"
#    art_sprites: "Sprites"
#    art_other: "Any and all other non-code creative works that are made available when creating Levels."
#    art_access: "Currently there is no universal, easy system for fetching these assets. In general, fetch them from the URLs as used by the site, contact us for assistance, or help us in extending the site to make these assets more easily accessible."
#    art_paragraph_1: "For attribution, please name and link to codecombat.com near where the source is used or where appropriate for the medium. For example:"
#    use_list_1: "If used in a movie or another game, include codecombat.com in the credits."
#    use_list_2: "If used on a website, include a link near the usage, for example underneath an image, or in a general attributions page where you might also mention other Creative Commons works and open source software being used on the site. Something that's already clearly referencing CodeCombat, such as a blog post mentioning CodeCombat, does not need some separate attribution."
#    art_paragraph_2: "If the content being used is created not by CodeCombat but instead by a user of codecombat.com, attribute them instead, and follow attribution directions provided in that resource's description if there are any."
#    rights_title: "Rights Reserved"
#    rights_desc: "All rights are reserved for Levels themselves. This includes"
#    rights_scripts: "Scripts"
#    rights_unit: "Unit configuration"
#    rights_writings: "Writings"
#    rights_media: "Media (sounds, music) and any other creative content made specifically for that Level and not made generally available when creating Levels."
#    rights_clarification: "To clarify, anything that is made available in the Level Editor for the purpose of making levels is under CC, whereas the content created with the Level Editor or uploaded in the course of creation of Levels is not."
#    nutshell_title: "In a Nutshell"
#    nutshell_description: "Any resources we provide in the Level Editor are free to use as you like for creating Levels. But we reserve the right to restrict distribution of the Levels themselves (that are created on codecombat.com) so that they may be charged for."
#    canonical: "The English version of this document is the definitive, canonical version. If there are any discrepancies between translations, the English document takes precedence."
#    third_party_title: "Third Party Services"
#    third_party_description: "CodeCombat uses the following third party services (among others):"

#  ladder_prizes:
#    title: "Tournament Prizes" # This section was for an old tournament and doesn't need new translations now.
#    blurb_1: "These prizes will be awarded according to"
#    blurb_2: "the tournament rules"
#    blurb_3: "to the top human and ogre players."
#    blurb_4: "Two teams means double the prizes!"
#    blurb_5: "(There will be two first place winners, two second-place winners, etc.)"
#    rank: "Rank"
#    prizes: "Prizes"
#    total_value: "Total Value"
#    in_cash: "in cash"
#    custom_wizard: "Custom CodeCombat Wizard"
#    custom_avatar: "Custom CodeCombat avatar"
#    heap: "for six months of \"Startup\" access"
#    credits: "credits"
#    one_month_coupon: "coupon: choose either Rails or HTML"
#    one_month_discount: "discount, 30% off: choose either Rails or HTML"
#    license: "license"
#    oreilly: "ebook of your choice"

  calendar:
    year: "年"
    day: "日"
    month: "月"
    january: "１月"
    february: "２月"
    march: "３月"
    april: "４月"
    may: "５月"
    june: "６月"
    july: "７月"
    august: "８月"
    september: "９月"
    october: "１０月"
    november: "１１月"
    december: "１２月"
