module.exports = nativeDescription: "简体中文", englishDescription: "Chinese (Simplified)", translation:
  new_home:
    slogan: "最引人入胜的编程游戏。"
    classroom_edition: "教育版："
    learn_to_code: "学习编程："
    teacher: "教师"
    student: "学生"
    play_now: "开始游戏"
    im_a_teacher: "我是教师"
    im_a_student: "我是学生"
    learn_more: "了解更多"
    classroom_in_a_box: "教授计算机科学的一站式课堂。"
    codecombat_is: "CodeCombat是一个让<strong>学生</strong>通过玩游戏学习计算机科学的平台。"
    our_courses: "我们的课程已通过特别测试，足够<strong>满足教学需求</strong>。无编程经验的教师也可掌控。"
    top_screenshots_hint: "学生编写代码后可即时查看改动。"
    designed_with: "从教育者角度设计"
    real_code: "真实可行的代码"
    from_the_first_level: "从第一关起"
    getting_students: "让学生尽快动手写代码来学习程序语法和合适的结构是至关重要的。"
    educator_resources: "教育资源"
    course_guides: "和课程指导"
    teaching_computer_science: "教授计算机科学不需要昂贵的学位，因为我们给不同背景的教育者予以支持。"
    accessible_to: "提供给"
    everyone: "每个人"
    democratizing: "我们的核心理念是普及编程学习。每个人都应该有机会学习编程。"
    forgot_learning: "我觉得他们甚至忘了自己在学东西。"
    wanted_to_do: "写代码是我一直想做的事情。我从没想过我能在学校学习它。"
    why_games: "为什么通过游戏来学习编程很重要？"
    games_reward: "游戏能获得高效的奋斗。"
    encourage: "游戏是鼓励交流、发现、试错的媒介。好的游戏能够让玩家学习到技能，正如学生在学习过程中所做的那样。"
    excel: "游戏能提供奖励"
    struggle: "高效的奋斗"
    kind_of_struggle: "这种奋斗能为学习提供动力并"
    motivating: "富有激励性"
    not_tedious: "而不单调乏味。"
    gaming_is_good: "研究表明游戏有益儿童大脑。（这是真的！）"
    game_based: "当将基于游戏的学习方式与传统教学方式"
    compared: "比较"
    conventional: "时，区别毋庸置疑：游戏能帮助学生记住知识，集中精力，以及"
    perform_at_higher_level: "取得更高成就"
    feedback: "游戏同时提供实时反馈，使得学生调整他们的解决方法，并且从整体理解概念，而不局限于“正确”或者“错误”的答案。"
    real_game: "一个真正的游戏，用真正的代码来玩耍。"
    great_game: "一个伟大的游戏不仅仅是勋章和成就。它包括了玩家的旅程，设计良好的关卡，以及用帮助和信心迎接挑战的能力。"
    agency: "CodeCombat是一款这样的游戏：它通过我们的完善的代码引擎，给玩家提供帮助和信心，使得初学者和高级学生都可以编写合适、有效的代码。"
    request_demo_title: "让你的学生今天就行动起来！"
    request_demo_subtitle: "申请试用版并在一小时内让你的学生开始使用。"
    get_started_title: "现在建立您的班级"
    get_started_subtitle: "配置班级，添加学生，观察他们学习计算机科学的进度。"
    request_demo: "申请试用版"
    setup_a_class: "配置班级"
    have_an_account: "已有帐号？"
    logged_in_as: "您现在的登录身份："
    computer_science: "适合全年龄段的计算机科学课程"
    show_me_lesson_time: "显示估计课程时间："
    curriculum: "总计课程时间"
    ffa: "对所有学生免费"
    lesson_time: "课程时间："
    coming_soon: "即将推出！" # {change}
    courses_available_in: "课程可用如下语言：JavaScript，Python，还有Java（即将推出！）" # {change}
    boast: "以难解的谜题为豪，它们复杂到可以吸引游戏玩家和程序员。"
    winning: "RPG游戏和编程作业的完美结合，使得教育充满乐趣。"
    run_class: "管理计算机科学课程的所有东西都在这里，无需相关背景。"
    goto_classes: "到达我的班级"
    view_profile: "查看我的资料"
    view_progress: "查看进度"
#    go_to_courses: "Go to My Courses"
    want_coco: "想把 CodeCombat 带到您的学校？"

  nav:
    play: "关卡选择" # The top nav bar entry where players choose which levels to play
    community: "社区"
    courses: "课程" # {change}
    blog: "博客"
    forum: "论坛"
    account: "账号"
    my_account: "我的账号"
    profile: "资料"
    home: "首页"
    contribute: "贡献"
    legal: "版权声明"
#    privacy: "Privacy"
    about: "关于"
    contact: "联系我们"
    twitter_follow: "关注"
    teachers: "教师"
    students: "学生"
    careers: "招聘"
    facebook: "Facebook"
    twitter: "Twitter"
    create_a_class: "创建一个班级"
    other: "其他"
    learn_to_code: "学会编程！"
    toggle_nav: "切换导航栏"
    jobs: "工作"
    schools: "学校"
    get_involved: "参与"
    open_source: "开放的源码 (GitHub)"
    support: "支持"
    faqs: "常见问题"
    help_pref: "需要帮助？请发邮件至："
    help_suff: " 我们会很快与您联系！"
#    resource_hub: "Resource Hub"

  modal:
    close: "关闭"
    okay: "好的"

  not_found:
    page_not_found: "找不到网页"

  diplomat_suggestion:
    title: "帮助我们翻译CodeCombat" # This shows up when a player switches to a non-English language using the language selector.
    sub_heading: "我们需要您的语言技能"
    pitch_body: "我们开发了英文版的CodeCombat，但是CodeCombat的玩家遍布全球。对于不熟悉英语的中文玩家，他们希望能玩简体中文版的CodeCombat，如果您中英文都很熟练，请考虑加入我们“外交官”行列并参与CodeCombat的翻译，帮忙把CodeCombat网站和所有关卡翻译成简体中文。感谢！"
    missing_translations: "没被翻译的文字将以英文显示。"
    learn_more: "了解更多成为翻译人员的说明"
    subscribe_as_diplomat: "提交翻译人员申请"

  play:
    play_as: "扮演" # Ladder page
    compete: "开战!" # Course details page
    spectate: "旁观他人的游戏" # Ladder page
    players: "玩家" # Hover over a level on /play
    hours_played: "游戏时长" # Hover over a level on /play
    items: "道具" # Tooltip on item shop button from /play
    unlock: "解锁" # For purchasing items and heroes
    confirm: "确认"
    owned: "已拥有" # For items you own
    locked: "需解锁"
    purchasable: "可购买" # For a hero you unlocked but haven't purchased
    available: "可用"
    skills_granted: "获得技能" # Property documentation details
    heroes: "英雄" # Tooltip on hero shop button from /play
    achievements: "成就" # Tooltip on achievement list button from /play
    settings: "设置" # Tooltip on settings button from /play
    poll: "投票" # Tooltip on poll button from /play
    next: "下一步" # Go from choose hero to choose inventory before playing a level
    change_hero: "重新选择英雄" # Go back from choose inventory to choose hero
    buy_gems: "购买宝石"
    subscription_required: "需订阅"
    anonymous: "匿名玩家"
    level_difficulty: "难度："
    play_classroom_version: "玩课堂模式" # Choose a level in campaign version that you also can play in one of your courses
    campaign_beginner: "新手作战"
    awaiting_levels_adventurer_prefix: "我们每周都会开放新关卡"
    awaiting_levels_adventurer: "注册成为冒险家"
    awaiting_levels_adventurer_suffix: "来优先尝试新关卡"
    adjust_volume: "音量调节"
    campaign_multiplayer: "多人竞技场"
    campaign_multiplayer_description: "……在这里您可以与其他玩家进行代码肉搏战。"

  code:
    if: "如果" # Keywords--these translations show up on hover, so please translate them all, even if it's kind of long. (In the code editor, they will still be in English.)
    else: "否则"
    elif: "否则如果"
    while: "成立时循环"
    loop: "永久循环"
    for: "范围内循环"
    break: "中断循环"
    continue: "跳到下一循环"
    pass: "占位符"
    return: "返回函数值"
    then: "那么"
    do: "语句块开始"
    end: "语句块结束"
    function: "函数"
    def: "定义函数"
    var: "变量"
    self: "自身" # {change}
    hero: "英雄"
    this: "自身" # {change}
    or: "或者"
    "||": "或者"
    and: "并且"
    "&&": "并且"
    not: "非"
    "!": "非"
    "=": "赋值"
    "==": "相等"
    "===": "完全相等"
    "!=": "不等"
    "!==": "不完全相等"
    ">": "大于"
    ">=": "大于等于"
    "<": "小于"
    "<=": "小于等于"
    "*": "乘以"
    "/": "除以"
    "+": "加上"
    "-": "减去"
    "+=": "加并赋值"
    "-=": "减并赋值"
    True: "真"
    true: "真"
    False: "假"
    false: "假"
    undefined: "未定义"
    null: "空值"
    nil: "空值"
    None: "空值"

  share_progress_modal:
    blurb: "您的进度真快！快告诉您的家长, 您从CodeCombat学到了什么！"
    email_invalid: "邮件地址不可用。"
    form_blurb: "输入他们的邮件地址，让他们了解CodeCombat的趣味"
    form_label: "您的邮件地址"
    placeholder: "邮件地址"
    title: "做的很好，学徒"

  login:
    sign_up: "注册"
    email_or_username: "邮箱或用户名"
    log_in: "登录"
    logging_in: "正在登录"
    log_out: "登出"
    forgot_password: "忘记密码?"
    authenticate_gplus: "使用 Google+ 授权"
    load_profile: "载入 Google+ 档案"
    finishing: "完成..."
    sign_in_with_facebook: "Facebook账号登录"
    sign_in_with_gplus: " Google+ 账号登录"
    signup_switch: "是否创建新账户?"

  signup:
    create_student_header: "创建学生账号"
    create_teacher_header: "创建教师账号"
    create_individual_header: "创建独立账号"
    email_announcements: "通过邮件接收新关卡和功能通知！"
    creating: "账户创建中……"
    sign_up: "注册"
    log_in: "登录"
    required: "在做这件事情之前您必须先注册。"
    login_switch: "已经注册过账户?"
    school_name: "就读学校及所在城市"
    optional: "选填"
    school_name_placeholder: "范例: XX中学, 上海"
    connect_with: "与下列账号连接："
    connected_gplus_header: "成功连接 Google+ ！"
    connected_gplus_p: "完成注册后即可使用您的 Google+ 账号登陆。"
    gplus_exists: "此 Google+ 账号已与其他账号绑定！"
    connected_facebook_header: "成功连接 Facebook ！"
    connected_facebook_p: "完成注册后即可使用您的 Facebook 账号登陆。"
    facebook_exists: "此 Facebook 账号已与其他账号绑定！"
    hey_students: "同学，请输入教师提供的班级码。"
    birthday: "生日"
    parent_email_blurb: "我知道你坐不住准备学编程啦！&mdash; 我们也很兴奋！你的家长会收到一封邮件，上面写着为你注册账号要注意的事情。如果有问题就发邮件到 {{email_link}} 吧。"
    classroom_not_found: "班级代码不正确。请检查是否打错或者寻求教师的帮助。"
    checking: "检查中..."
    account_exists: "这个邮箱已被使用："
    sign_in: "登陆"
    email_good: "邮箱可用！"
    name_taken: "用户名已被其他人使用。要不使用 {{suggestedName}} ？"
    name_available: "用户名可用！"
    name_is_email: "用户名不能是邮箱"
    choose_type: "选择账号类型："
    teacher_type_1: "用 CodeCombat 教编程！"
    teacher_type_2: "建立班级"
    teacher_type_3: "取得课程教案"
    teacher_type_4: "查看学生进度"
    signup_as_teacher: "注册教师账号"
    student_type_1: "玩好玩游戏，同时学编程！"
    student_type_2: "和班级同学一起玩"
    student_type_3: "与同学一决高下"
    student_type_4: "自行选择英雄！"
    student_type_5: "要准备班级码哦！"
    signup_as_student: "注册学生账号"
    individuals_or_parents: "独立者和家长"
    individual_type: "为课堂外学习编程设计。家长可在此注册账号。"
    signup_as_individual: "注册独立账号"
    enter_class_code: "输入班级码："
    enter_birthdate: "请选择生日："
    parent_use_birthdate: "尊敬的家长，请用您自己的生日。"
    ask_teacher_1: "向你的老师获取班级码。"
    ask_teacher_2: "不是班级成员？那就注册 "
    ask_teacher_3: "独立账号"
    ask_teacher_4: " 吧。"
    about_to_join: "你即将加入："
    enter_parent_email: "输入家长邮箱地址："
    parent_email_error: "发邮件时出了点问题。请检查邮箱地址并再试一次。"
    parent_email_sent: "我们已经向你的家长发邮件了哦。让你的家长检查一下收件箱吧。"
    account_created: "账号已创建！"
    confirm_student_blurb: "记下信息避免忘记。你的老师也可随时帮你重置密码。"
    confirm_individual_blurb: "记下这些信息，等会可能用得上。我们已在您的邮箱发送了验证邮件，验证后可用其重置密码！"
    write_this_down: "记下来："
    start_playing: "开玩！"
    sso_connected: "成功与以下账号连接："
    select_your_starting_hero: "选择你的起始英雄："
    you_can_always_change_your_hero_later: "之后你可以随时更换英雄。"

  recover:
    recover_account_title: "找回账户"
    send_password: "发送重置链接"
    recovery_sent: "找回账户邮件已发送。"

  items:
    primary: "主武器"
    secondary: "副武器"
    armor: "盔甲"
    accessories: "配饰"
    misc: "辅助道具"
    books: "书籍"

  common:
    back: "返回" # When used as an action verb, like "Navigate backward"
    coming_soon: "敬请期待！"
    continue: "继续" # When used as an action verb, like "Continue forward"
    default_code: "默认代码"
    loading: "读取中……"
    overview: "概览"
    solution: "解法"
    intro: "简介"
    saving: "保存中……"
    sending: "发送中……"
    send: "发送"
    sent: "已发送"
    cancel: "取消"
    save: "保存"
    publish: "发布"
    create: "创建"
    fork: "派生"
    play: "开始" # When used as an action verb, like "Play next level"
    retry: "重试"
    actions: "行为"
    info: "信息"
    help: "帮助"
    watch: "关注"
    unwatch: "取消关注"
    submit_patch: "提交补丁"
    submit_changes: "提交更新"
    save_changes: "保存更新"
    required_field: "必填" # {change}

  general:
    and: "与"
    name: "名字"
    date: "日期"
    body: "正文"
    version: "版本"
    pending: "处理中"
    accepted: "已接受"
    rejected: "未接受"
    withdrawn: "已撤回"
    accept: "接受"
    reject: "拒绝"
    withdraw: "撤回"
    submitter: "提交者"
    submitted: "已提交"
    commit_msg: "提交信息"
    version_history: "版本历史"
    version_history_for: "版本历史: "
    select_changes: "选择下面两项更新来查看其不同。"
    undo_prefix: "取消"
    undo_shortcut: "(Ctrl+Z)"
    redo_prefix: "重做"
    redo_shortcut: "(Ctrl+Shift+Z)"
    play_preview: "当前关卡预览"
    result: "结果"
    results: "结果"
    description: "描述"
    or: "或"
    subject: "主题"
    email: "邮件"
    password: "密码"
    confirm_password: "确认密码"
    message: "信息"
    code: "代码"
    ladder: "升级比赛"
    when: "时间"
    opponent: "对手"
    rank: "等级"
    score: "分数"
    win: "胜利"
    loss: "失败"
    tie: "平局"
    easy: "容易"
    medium: "中等"
    hard: "困难"
    player: "玩家"
    player_level: "等级" # Like player level 5, not like level: Dungeons of Kithgard
    warrior: "战士"
    ranger: "游骑兵"
    wizard: "巫师"
    first_name: "姓"
    last_name: "名"
#    last_initial: "Last Initial"
    username: "用户名"

  units:
    second: "秒"
    seconds: "秒"
    minute: "分钟"
    minutes: "分钟"
    hour: "小时"
    hours: "小时"
    day: "日"
    days: "日"
    week: "星期"
    weeks: "星期"
    month: "月"
    months: "月"
    year: "年"
    years: "年"

  play_level:
    level_complete: "关卡已完成"
    completed_level: "完成关卡:"
    course: "课程:"
    done: "完成"
    next_level: "下一个关卡"
    next_game: "下一场游戏"
    language: "语言"
    languages: "语言"
    programming_language: "编程语言"
    show_menu: "显示游戏菜单"
    home: "主页" # Not used any more, will be removed soon.
    level: "关卡" # Like "Level: Dungeons of Kithgard"
    skip: "跳过"
    game_menu: "游戏菜单"
    guide: "指南"
    restart: "重新开始"
    goals: "目标"
    goal: "目标"
    running: "运行中..."
    success: "成功!"
    incomplete: "未完成"
    timed_out: "运行超时"
    failing: "失败"
    reload: "重载"
    reload_title: "重载所有代码？"
    reload_really: "确定重载这一关，返回开始处吗？"
    reload_confirm: "重载所有"
    victory: "胜利"
    victory_title_prefix: ""
    victory_title_suffix: " 完成"
    victory_sign_up: "保存进度"
    victory_sign_up_poke: "想保存您的代码？创建一个免费账户吧！"
    victory_rate_the_level: "这个关卡有多好玩？"
    victory_return_to_ladder: "返回"
    victory_saving_progress: "保存进度"
    victory_go_home: "返回主页"
    victory_review: "给我们反馈！"
    victory_review_placeholder: "关卡如何?"
    victory_hour_of_code_done: "您完成了吗?"
    victory_hour_of_code_done_yes: "是的, 完成了!"
    victory_experience_gained: "获得经验"
    victory_gems_gained: "获得宝石"
    victory_new_item: "新的物品"
    victory_new_hero: "新的英雄"
    victory_viking_code_school: "这关真的超难! 如果您想成为一个软件开发人员，您就应该去试一下Viking Code School。在这里您可以把您的知识增长到另一个台阶。只需要14周您就能成为一个专业的网页开发人员。"
    victory_become_a_viking: "成为一个维京人吧"
    victory_no_progress_for_teachers: "教师不能保存进度。但您可在您的班级为自己添加一个学生账号。"
    guide_title: "指南"
    tome_cast_button_run: "运行"
    tome_cast_button_running: "正在运行"
    tome_cast_button_ran: "运行过"
    tome_submit_button: "提交"
    tome_reload_method: "恢复关卡初始代码"
    tome_available_spells: "可用的法术"
    tome_your_skills: "您的技能"
    tome_current_method: "当前方法"
    hints: "提示"
    hints_title: "提示 {{number}}"
    code_saved: "代码已保存"
    skip_tutorial: "跳过（esc）"
    keyboard_shortcuts: "快捷键"
    loading_ready: "载入完成!"
    loading_start: "开战"
    problem_alert_title: "修正您的代码"
    time_current: "现在:"
    time_total: "最大:"
    time_goto: "跳到:"
    non_user_code_problem_title: "不能读入关卡"
    infinite_loop_title: "有无限循环"
    infinite_loop_description: "建立世界的初始代码永远不会运行完毕。这代码可能非常慢或者陷入了死循环，也可能是个bug。您可以尝试再次运行该代码，或者将代码重置为默认状态。如果仍旧解决不了，请告诉我们。"
    check_dev_console: "您也可以打开开发者界面查看有什么东西出错了。"
    check_dev_console_link: "(说明)"
    infinite_loop_try_again: "重试"
    infinite_loop_reset_level: "重置关卡"
    infinite_loop_comment_out: "注释掉我的代码"
    tip_toggle_play: "用 Ctrl+P 来暂停或继续"
    tip_scrub_shortcut: "用 Ctrl+[ 和 Ctrl+] 来倒退和快进。"
    tip_guide_exists: "点击页面上方的指南, 可以获得更多有用信息。"
    tip_open_source: "「CodeCombat」是100%开源的！"
    tip_tell_friends: "喜欢Codecombat？那就赶快把它安利给朋友！"
    tip_beta_launch: "CodeCombat开始于2013的10月份。"
    tip_think_solution: "思考如何解决, 而不是思考问题。"
    tip_theory_practice: "在理论上，理论和实践之间是没有区别的。但在实践上，它们是有区别的。 - Yogi Berra"
    tip_error_free: "有两种方式可以写出没有错误的程序；但是只有第三种方式是有效的。 - Alan Perlis"
    tip_debugging_program: "如果说调试是清除错误的过程，那么编程就是放置错误的过程。- Edsger W. Dijkstra"
    tip_forums: "到论坛去告诉我们您的想法！"
    tip_baby_coders: "在未来，就算小孩都能成为大法师。"
    tip_morale_improves: "在士气提升之前会一直进行加载。"
    tip_all_species: "我们相信每一个人都有同等的机会学习编程"
    tip_reticulating: "网格状锯齿。(指Maxis开发的许多游戏，如《模拟城市》、《孢子》中，加载进程中跑动时出现的卡顿现象)"
    tip_harry: "你是一名巫师, "
    tip_great_responsibility: "更强的编程技巧也意味着有更高的责任来进行调试。"
    tip_munchkin: "如果您不吃掉您的蔬菜, 一个小矮人将在您睡着之后来找您。"
    tip_binary: "这个世界上只有10种人: 那些懂二进制的, 还有那些不懂二进制的。"
    tip_commitment_yoda: "一个程序员必须有高度的责任感和一颗认真的心。 ~ 尤达大师"
    tip_no_try: "做。 或是不做。 这世上不存在'尝试'这种东西。 - 尤达大师《星球大战》"
    tip_patience: "您必须要有耐心，年轻的学徒 - 尤达大师《星球大战》"
    tip_documented_bug: "一个写在文档里的漏洞不算漏洞, 那是个特色。"
    tip_impossible: "在事情未完成之前，一切都看似不可能。 - 纳尔逊·曼德拉"
    tip_talk_is_cheap: "多说无用, 放码过来。 - Linus Torvalds"
    tip_first_language: "您所经历过最可怕的事情是您的第一门编程语言。 - Alan Kay"
    tip_hardware_problem: "问：换一个电灯泡需要几位程序员参与？答：一个都不需要，因为这属于硬件问题。"
    tip_hofstadters_law: "侯世达定律：做事所花费的时间总是比您预期的要长，即使您的预期中考虑了侯世达定律。"
    tip_premature_optimization: "过早的优化是万恶之源。 - 高德纳"
    tip_brute_force: "拿不准时就用穷举法。 - Ken Thompson"
    tip_extrapolation: "世界上只有两类人：一类人能够根据不完整的数据进行推断……"
    tip_superpower: "编程是我们拥有的最接近超能力的技能"
    tip_control_destiny: "拥有控制自己命运的权利才是真正的开源。 - Linus Torvalds"
    tip_no_code: "没有什么比不写代码来的更快。"
    tip_code_never_lies: "代码从来不会说谎，但是注释有时候会。 — Ron Jeffries"
    tip_reusable_software: "软件能够重用的前提是，这货必须能用。"
    tip_optimization_operator: "每个编程语言都有注释符号，大多数语言采用的是‘//’"
    tip_lines_of_code: "以代码行数为标准管理程序开发的进度跟用重量为标准管理飞船建造的进度一样愚蠢。 — Bill Gates"
    tip_source_code: "我想改变世界，但是他们不给我源代码。"
    tip_javascript_java: "Java和JavaScript的关系就好比是马和马云。 - Chris Heilmann"
    tip_move_forward: "不管您做什么，前进就对了。 - Martin Luther King Jr."
    tip_google: "有问题不能解决？百(goo)度(gle)一下！"
    tip_adding_evil: "增加一个邪恶掐捏"
    tip_hate_computers: "那些认为他们讨厌电脑的人，其实他们讨厌的是垃圾程序编写员。- Larry Niven"
    tip_open_source_contribute: "您可以帮助「CodeCombat」进步！"
    tip_recurse: "迭代为人，递归为神 - L. Peter Deutsch"
    tip_free_your_mind: "丢掉一切私心杂念，丢掉害怕、疑问和拒信，解放您的思想。 - Morpheus《黑客帝国》"
    tip_strong_opponents: "即使是最强大的对手也是有弱点的。- 宇智波鼬《火影忍者》"
    tip_paper_and_pen: "在您开始编程之前，您可以随时用一张纸和一支笔提前规划。"
    tip_solve_then_write: "要先想清楚问题如何解决, 再进行编码的动作. - John Johnson"
    tip_compiler_ignores_comments: "有时我总觉得编译器忽视了我的注释。"
    tip_understand_recursion: "了解递归的唯一途径是了解递归。"
    tip_life_and_polymorphism: "开源就像是一个彻头彻尾的多边形结构：海纳百川。"
    tip_mistakes_proof_of_trying: "代码中的错误证明你尝试过了。"
    tip_adding_orgres: "包抄敌人。"
    tip_sharpening_swords: "宝剑锋从磨砺出。"
    tip_ratatouille: "不要因为出身低微就让别人决定你的未来。你的成败在于你的心。 - 厨神《美食总动员》"
    tip_nemo: "当你在生活遇到挫折时怎么办？一直游，一直游就对了。 - 多莉《海底总动员》"
    tip_internet_weather: "拥抱美好的因特网吧，我们早已习惯了这个晴朗的天空。 - 约翰·格林"
    tip_nerds: "没人反对疯子的爱好，比如“在椅子上蹿下跳不能自已”这样的。 - 约翰·格林"
    tip_self_taught: "我教会自己90%的知识，再正常不过了！ - Hank Green"
    tip_luna_lovegood: "别担心，你和我一样理智。 - 卢娜·洛夫古德《哈利波特》"
    tip_good_idea: "想到一个好主意的最佳方法是想到一堆主意。 - 莱纳斯·卡尔·鲍林"
    tip_programming_not_about_computers: "计算机科学就是有关计算机的，正如天文学就是有关望远镜的。 - 艾兹格·迪杰斯特拉"
    tip_mulan: "相信你能行，你就能做到。 - 迪士尼《花木兰》"

  play_game_dev_level:
    created_by: "由 {{name}} 创建"
    how_to_play_title: "游戏规则："
    how_to_play_1: "使用鼠标控制英雄！"
    how_to_play_2: "点击地图任意一处让英雄移动。"
    how_to_play_3: "点击食人魔开始攻击。"
    restart: "重新开始关卡"
    play: "开始关卡"
    play_more_codecombat: "玩更多 CodeCombat 关卡"
    default_student_instructions: "单击控制英雄，并取得胜利！"
    back_to_coding: "回到编程"

  game_menu:
    inventory_tab: "道具箱"
    save_load_tab: "保存/打开"
    options_tab: "设置"
    guide_tab: "使用向导"
    guide_video_tutorial: "视频教程"
    guide_tips: "小技巧"
    multiplayer_tab: "多人游戏"
    auth_tab: "注册"
    inventory_caption: "装备您的英雄"
    choose_hero_caption: "选择英雄和语言"
    save_load_caption: "... 观看历史"
    options_caption: "确认设置"
    guide_caption: "文档和提示"
    multiplayer_caption: "与您的朋友一起玩!"
    auth_caption: "保存进度"

  leaderboard:
    view_other_solutions: "查看排行榜"
    scores: "分数"
    top_players: "顶尖玩家是"
    day: "今天"
    week: "这个星期"
    all: "实时"
    time: "时间"
    damage_taken: "接收的伤害"
    damage_dealt: "造成的伤害"
    difficulty: "难度"
    gold_collected: "收集的金币"

  inventory:
    equipped_item: "已装备"
    required_purchase_title: "需要"
    available_item: "可用"
    restricted_title: "被限制"
    should_equip: "(双击装备此道具)"
    equipped: "(已装备)"
    locked: "(需解锁)"
    restricted: "(本关卡不得使用)"
    equip: "装备"
    unequip: "脱下"

  buy_gems:
    few_gems: "几个宝石"
    pile_gems: "一堆宝石"
    chest_gems: "一箱宝石"
    purchasing: "正在付款..."
    declined: "您的信用卡被拒绝"
    retrying: "服务器错误，请重试"
    prompt_title: "没有足够数量的宝石"
    prompt_body: "还需要更多吗？"
    prompt_button: "进入商店"
    recovered: "之前购买的宝石已恢复。请刷新页面。"
    price: "x{{gems}} / 月"

  subscribe:
    comparison_blurb: "亲，订阅CodeCombat，大力的提升您的技能！"
    feature1: "__levelsCount__+ 基本关卡（__worldsCount__个世界）"
    feature2: "__heroesCount__ 个强大 <strong>英雄</strong>以及各式非凡技能!"
    feature3: "__bonusLevelsCount__+ 奖励关卡"
    feature4: "每月享有{{gems}}额外宝石"
    feature6: "专业邮件支援"
    feature7: "私人 <strong>部落</strong>"
    feature8: "<strong>无广告！</strong>"
    free: "免费"
    month: "月"
    must_be_logged: "您需要先登入。请先注册或者在上方的目录中点击登入。"
    subscribe_title: "订阅"
    unsubscribe: "取消订阅"
    confirm_unsubscribe: "确认取消订阅"
    never_mind: "没关系，我们依然喜欢您"
    thank_you_months_prefix: "感谢您这"
    thank_you_months_suffix: "个月以来对我们的支持。"
    thank_you: "感谢您支持CodeCombat。"
    sorry_to_see_you_go: "真舍不得亲离开啊! 请一定要让我们知道哪里做的还不够好。"
    unsubscribe_feedback_placeholder: "噢, 我们做了神马?"
    parent_button: "请求您的父母"
    parent_email_description: "我们会发送邮件给您的父母让他们帮您订阅CodeCombat。"
    parent_email_input_invalid: "邮件地址不正确。"
    parent_email_input_label: "父母邮件地址"
    parent_email_input_placeholder: "输入父母邮件地址"
    parent_email_send: "发送邮件"
    parent_email_sent: "邮件已发送!"
    parent_email_title: "什么是您父母的邮件地址？"
    parents: "致家长"
    parents_title: "亲爱的家长: 您的孩子将要学习编程。您会支持孩子发展吗?"
    parents_blurb1: "您的孩子已经玩了 __nLevels__ 关，并且学习了编程基础。请您为了培养他们的兴趣而给他们订阅，他们能继续玩下去。"
    parents_blurb1a: "不用怀疑计算机编程能力将是您的孩子作为一个成年人的基本技能。到2020年，77%的工作将会需要编码能力，并且软件工程师将在世界各地成为高需求职业。您要知道计算机科学是收入最高的大学学位。"
    parents_blurb2: "每月支付{{price}}美元，他们每周都会有新的挑战，并且通过电子邮件获得专业程序员的指导。"
    parents_blurb3: "无风险承诺：100%退款，一键取消订阅。"
    payment_methods: "付费方式"
    payment_methods_title: "可接受的付款方式"
    payment_methods_blurb1: "我们现有的付费方式有信用卡和支付宝，您也可以用 PayPal 付款 {{three_month_price}} 美元（含三个月的订阅和宝石）到 nick@codecombat.com ，并在备注写上游戏账号的电子邮件，年费订阅只需 ${{year_price}} 美元哦。"
    payment_methods_blurb2: "如果您想用其他付费方式,请联系我们"
    sale_button: "促销"
    sale_button_title: "年费订阅能节省 ${{discount}} 的费用"
    stripe_description: "每月订阅"
    stripe_description_year_sale: "年费订阅 (优惠 ${{discount}})"
    subscription_required_to_play: "订阅后才可开始本关"
    unlock_help_videos: "订阅后才可以解锁视频教学哦！"
    personal_sub: "个人订阅" # Accounts Subscription View below
    loading_info: "正在读入订阅内容..."
    managed_by: "管理"
    will_be_cancelled: "将被取消"
    currently_free: "您目前有一个免费订阅"
    currently_free_until: "您目前有一个订阅，直到"
    was_free_until: "您有过一个免费订阅，直到"
    managed_subs: "管理订阅"
    subscribing: "订阅中..."
    current_recipients: "当前收件人"
    unsubscribing: "取消订阅中"
    subscribe_prepaid: "点击订阅来使用预付费代码"
    using_prepaid: "使用预付费代码进行每月订阅"

  choose_hero:
    choose_hero: "请选择您的英雄"
    programming_language: "编程语言"
    programming_language_description: "您希望使用哪门编程语言?"
    default: "默认"
    experimental: "实验性的"
    python_blurb: "简单而强大, Python是一个伟大的通用编程语言。"
    javascript_blurb: "为web开发而生的语言。"
    coffeescript_blurb: "一种更好的JavaScript语法。"
    lua_blurb: "一种游戏脚本语言。"
    java_blurb: "(仅订阅用户) Android 和企业的选择。"
    status: "状态"
    weapons: "武器"
    weapons_warrior: "刀剑 - 近程物理攻击"
    weapons_ranger: "弓弩，火枪 - 远程物理攻击"
    weapons_wizard: "魔棒，法杖 - 远程魔法攻击"
    attack: "攻击" # Can also translate as "Attack"
    health: "健康值"
    speed: "速度"
    regeneration: "恢复"
    range: "攻击范围" # As in "attack or visual range"
    blocks: "格挡" # As in "this shield blocks this much damage"
    backstab: "背刺" # As in "this dagger does this much backstab damage"
    skills: "技能"
    attack_1: "造成"
    attack_2: "的实际伤害(使用当前"
    attack_3: "时)。"
    health_1: "获得"
    health_2: "的装备血量(使用当前"
    health_3: "时)。"
    speed_1: "移动速度"
    speed_2: "米每秒。"
    available_for_purchase: "可以购买" # Shows up when you have unlocked, but not purchased, a hero in the hero store
    level_to_unlock: "未解锁关卡：" # Label for which level you have to beat to unlock a particular hero (click a locked hero in the store to see)
    restricted_to_certain_heroes: "只有特定的英雄可以进入本关。"

  skill_docs:
    function: "函数" # skill types
    method: "方法"
    snippet: "片段"
    number: "数字"
    array: "数组"
    object: "对象"
    string: "字符串"
    writable: "可写" # Hover over "attack" in Your Skills while playing a level to see most of this
    read_only: "只读"
    action: "命令"
    spell: "技能"
    action_name: "名称"
    action_cooldown: "释放时间"
    action_specific_cooldown: "冷却时间"
    action_damage: "攻击力"
    action_range: "范围"
    action_radius: "半径"
    action_duration: "持续时间"
    example: "例程"
    ex: "例如" # Abbreviation of "example"
    current_value: "当前值"
    default_value: "默认值"
    parameters: "参数"
#    required_parameters: "Required Parameters"
#    optional_parameters: "Optional Parameters"
    returns: "返回值"
    granted_by: "技能来自"

  save_load:
    granularity_saved_games: "保存"
    granularity_change_history: "历史记录"

  options:
    general_options: "一般设置" # Check out the Options tab in the Game Menu while playing a level
    volume_label: "音量"
    music_label: "音乐"
    music_description: "开/关背景音乐"
    editor_config_title: "编辑器配置"
    editor_config_livecompletion_label: "实时代码补全"
    editor_config_livecompletion_description: "当输入代码时显示代码自动补全建议。"
    editor_config_invisibles_label: "显示空白字符"
    editor_config_invisibles_description: "显示空格或TAB键等空白字符。"
    editor_config_indentguides_label: "显示缩进提示"
    editor_config_indentguides_description: "显示一条竖线以使缩进更明显。"
    editor_config_behaviors_label: "智能匹配符号"
    editor_config_behaviors_description: "自动匹配括号、大括号和引号。"

  about:
    main_title: "如果你想学习编程，你需要写（一大堆）代码。"
    main_description: "在CodeCombat里，我们的职责就是让你面带微笑完成这项任务。"
    mission_link: "任务"
    team_link: "团队"
    story_link: "历程"
    press_link: "联系方式"
    mission_title: "我们的任务：让世上每个学生都有机会接触编程。"
    mission_description_1: "<strong>编程是一种魔法</strong>。这是一种从想象中创造万物的能力。我们开始了 CodeCombat 这个项目，是为了让学习者通过<strong>编写代码</strong>感受到他们指尖上的魔力。"
    mission_description_2: "同时，他们也能迅速学习，因为学习的方式变快了。学习就像是对话而不是阅读枯燥的手册。我们想将这种对话带给每所学校和<strong>每个学生</strong>，因为每个人都应有机会学习编程的魔法。"
    team_title: "与CodeCombat团队见面"
    team_values: "我们期待开放的、互相尊敬的对话，好点子会得到采纳。我们决定深入市场调研，我们集中于提供实际性的结果。从我们的 CEO 到 Github 上的贡献者，每个人都亲历亲为，因为在团队中我们收获了成长与经验。"
    nick_title: "共同创始人，CEO"
    nick_blurb: "充满动力的大牛"
    matt_title: "共同创始人，CTO"
    cat_title: "关卡设计师"
    cat_blurb: "气宗"
    scott_title: "共同创始人，软件工程师"
    scott_blurb: "理性至上"
    maka_title: "客户律师"
    maka_blurb: "故事作者"
    rob_title: "软件工程师"
    rob_blurb: "编代码之类的"
    josh_c_title: "游戏设计师"
    josh_c_blurb: "设计游戏"
    robin_title: "用户体验设计和研究"
    robin_blurb: "基架"
    josh_title: "游戏设计师"
    josh_blurb: "地面是熔岩"
    phoenix_title: "软件工程师"
    nolan_title: "区域经理"
    elliot_title: "客户经理"
    elliot_blurb: "读心者"
    lisa_title: "市场开发代表" # {change}
#    lisa_blurb: "A gritty one"
    sean_title: "领土经理"
    retrostyle_title: "插画师"
    retrostyle_blurb: "复古风格的游戏"
    jose_title: "音乐"
    jose_blurb: "放轻松"
    community_title: "...以及我们的开源社区"
    community_subtitle: "超过 450 个志愿者帮助我们建设 CodeCombat，每周都有新成员加入！"
#    community_description_3: "CodeCombat is a"
#    community_description_link_2: "community project"
    community_description_1: "CodeCombat 是一个开放项目，上百名玩家创建了各种关卡，给我们的源代码添砖加瓦，添加新功能、修复Bug、测试、甚至是将其翻译为50种语言。职员、贡献者以及网站本身都在分享创意并奋斗中成长，这就是开源社区的力量。此网站在众多开源项目之上建立，我们为表感恩，也将网站开源奉献给社区，给好奇源码的玩家提供探索和实验的项目。每个人都能加入CodeCombat社区！看一下我们的" # {change}
    community_description_link: "贡献者页面"
    community_description_2: "了解更多信息。"
    number_contributors: "超过 450 个志愿者将他们的知识和时间投入到这个项目中。"
    story_title: "我们已走过的历程"
    story_subtitle: "从2013年至今，CodeCombat已经从一组小草图成长为一个生动的、蓬勃发展的游戏。"
    story_statistic_1a: "5,000,000+"
    story_statistic_1b: "总玩家"
    story_statistic_1c: "已经通过CodeCombat开始了他么的编程之旅"
    story_statistic_2a: "我们将这个游戏翻译为超过 50 种语言 —— 得益于来自"
    story_statistic_2b: "200+ 个国家"
    story_statistic_3a: "的玩家，他们总共写下了"
    story_statistic_3b: "10亿行代码和说明"
    story_statistic_3c: "，涵盖了多种编程语言。"
    story_long_way_1: "尽管我们已经走了很远……"
    story_sketch_caption: "Nick在非常早期时描绘即将制作的编程游戏的草图。"
    story_long_way_2: "我们仍需不断努力才能完成我们的使命，所以……"
    jobs_title: "和我们一起工作，一起书写 CodeCombat 的历史！"
    jobs_subtitle: "没看到适合的工作却想密切关注？查看我们的 \"创造你自己的工作\" 列表了解更多。"
    jobs_benefits: "职员福利"
    jobs_benefit_4: "无限制假期"
    jobs_benefit_5: "专业开发以及继续教育的支持 - 免费书籍/游戏！"
#    jobs_benefit_6: "Medical (gold), dental, vision"
#    jobs_benefit_7: "Sit-stand desks for all"
#    jobs_benefit_9: "10-year option exercise window"
#    jobs_benefit_10: "Maternity leave: 10 weeks paid, next 6 @ 55% salary"
#    jobs_benefit_11: "Paternity leave: 10 weeks paid"
    learn_more: "了解更多"
    jobs_custom_title: "创造你自己的工作"
    jobs_custom_description: "对 CodeCombat 充满激情却没找到适合自己的职业？给我们写信说明你该如何做出贡献。我们期待你的建议！"
    jobs_custom_contact_1: "向以下地址给我们发送简介："
    jobs_custom_contact_2: "，我们可能会和你联系！"
    contact_title: "联系方式"
    contact_subtitle: "想了解更多资讯？请通过以下方式联系我们："
    screenshots_title: "游戏截图"
    screenshots_hint: "(点击查看大图)"
    downloads_title: "下载更多信息"
    about_codecombat: "关于 CodeCombat"
    logo: "商标"
    screenshots: "截图"
    character_art: "人物形象"
    download_all: "全部下载"
    previous: "上一页"
    location_title: "我们在旧金山市区工作："

  teachers:
    who_for_title: "谁是CodeCombat的使用对象呢？"
    who_for_1: "我们建议让9岁及以上的学生使用CodeCombat。无需经验，无论男女，都能愉快学习编程。"
    who_for_2: "我们设计的 课程 系统允许老师在友好的界面上建立班级，跟踪进度，为学生添加额外内容。"
    more_info_title: "我可以在哪里找到更多信息？"
    more_info_1: "我们的"
    more_info_2: "教师论坛"
    more_info_3: "是个与其他使用CodeCombat的教育工作者联系的良好平台。"
    licenses_needed: "需要许可"

  teachers_quote:
    name: "试用申请表"
    subtitle: "将 CodeCombat 带到您的班级、俱乐部、学校甚至地区！"
    email_exists: "使用该账号的电子邮箱"
    phone_number: "电话号码"
    phone_number_help: "工作日时我们在哪可以找到您？"
    primary_role_label: "您的主要职业"
    role_default: "选择职业"
    primary_role_default: "（请选择）"
#    purchaser_role_default: "Select Purchaser Role"
    tech_coordinator: "技术负责人"
    advisor: "顾问"
    principal: "校长"
    superintendent: "主管"
    parent: "家长"
#    purchaser_role_label: "Your Purchaser Role"
#    influence_advocate: "Influence/Advocate"
#    evaluate_recommend: "Evaluate/Recommend"
#    approve_funds: "Approve Funds"
#    no_purchaser_role: "No role in purchase decisions"
    district_label: "地区"
    district_na: "不可用时请输入 N/A"
    organization_label: "学校："
    city: "城市"
    state: "州"
    country: "国家"
    num_students_help: "您估计有多少学生加入CodeCombat？"
    num_students_default: "选择数量范围"
    education_level_label: "学生的教育程度"
    education_level_help: "选择即将教导的程度"
    elementary_school: "小学"
    high_school: "高中"
    please_explain: "(请注明)"
    middle_school: "初中"
    college_plus: "大学以上"
    anything_else: "您还有什么建议？"
    thanks_header: "申请已发送！"
    thanks_sub_header: "感谢您为您的学校表达对 CodeCombat 的兴趣。"
    thanks_p: "我们不久会和你联系！如果想和我们取得联系，可以通过以下方式："
    back_to_classes: "返回班级"
    finish_signup: "即将创建您的教师账号："
    finish_signup_p: "创建教师账号可以建立班级、添加学生、观察他们学习计算机科学的进度。"
    signup_with: "通过以下方式创建账号："
    connect_with: "与已有账号连接："
    conversion_warning: "警告：您的当前账号为 <em>学生账号</em>。一旦提交表格，您的账号将会升级为教师账号。"
    learn_more_modal: "在 CodeCombat 中，教师账号可以观察学生进度、分配名额以及管理教室。教师账号不能加入班级 - 如果您使用当前账号加入了班级，升级后将不能访问所加入的班级。"
    create_account: "创建教师账号"
    create_account_subtitle: "在 CodeCombat 班级中使用教师专用工具。 <strong>创建班级</strong>添加学生、<strong>观察学生进度</strong>！"
    convert_account_title: "升级为教师账号"
    not: "不是"

  versions:
    save_version_title: "保存新版本"
    new_major_version: "新的重要版本"
    submitting_patch: "正在提交补丁..."
    cla_prefix: "要想保存更改，您必须先同意我们的"
    cla_url: "贡献者许可协议"
    cla_suffix: "。"
    cla_agree: "我同意"
    owner_approve: "您所做出的修改必须经拥有者确认才能生效。"

  contact:
    contact_us: "联系我们"
    welcome: "我们很乐意收到您的邮件！请用这个表单给我们发邮件。 "
    forum_prefix: "如果您想发布任何公开的东西, 可以试试"
    forum_page: "我们的论坛"
    forum_suffix: ""
    faq_prefix: "这里还有一个"
    faq: "FAQ"
    subscribe_prefix: "如果您需要帮助解决一个关卡，请"
    subscribe: "订阅CodeCombat"
    subscribe_suffix: "并且我们很乐意给您提供代码相关的帮助"
    subscriber_support: "既然您已经订阅了CodeCombat，我们将给您提供优先帮助"
    screenshot_included: "包含截屏"
    where_reply: "我们应该回复谁？"
    send: "反馈意见"

  account_settings:
    title: "账户设置"
    not_logged_in: "登录或创建一个账户来修改设置。"
    autosave: "自动保存修改"
    me_tab: "我"
    picture_tab: "图片"
    delete_account_tab: "删除账户"
    wrong_email: "邮箱地址错误"
    wrong_password: "密码错误"
    upload_picture: "上传一张图片"
    delete_this_account: "永久删除账户"
    reset_progress_tab: "重置所有进度"
    reset_your_progress: "清除记录并重新开始"
    god_mode: "上帝模式"
    emails_tab: "邮件"
    admin: "管理"
    manage_subscription: "点此管理您的订阅"
    new_password: "新密码"
    new_password_verify: "再次输入密码"
    type_in_email: "输入您的邮箱地址或用户名删除账号。"
    type_in_email_progress: "输入邮箱地址来确认重置游戏进度。"
    type_in_password: "同样的，输入您的密码。"
    email_subscriptions: "邮箱订阅"
    email_subscriptions_none: "取消订阅"
    email_announcements: "通知"
    email_announcements_description: "接收关于CodeCombat的邮件。"
    email_notifications: "通知"
    email_notifications_summary: "私人定制, 自动通知与您有关的CodeCombat活动。"
    email_any_notes: "任何通知"
    email_any_notes_description: "取消接收所有活动提醒邮件"
    email_news: "新消息"
    email_recruit_notes: "工作机会"
    email_recruit_notes_description: "如果您干的不错, 我们会联系并提供您更好的工作。"
    contributor_emails: "贡献者通知"
    contribute_prefix: "我们在寻找志同道合的人！请到"
    contribute_page: "贡献页面"
    contribute_suffix: "查看更多信息。"
    email_toggle: "切换所有"
    error_saving: "保存时出错"
    saved: "更改已保存"
    password_mismatch: "密码不匹配。"
    password_repeat: "请重新键入密码。"

  keyboard_shortcuts:
    keyboard_shortcuts: "快捷键"
    space: "空格"
    enter: "回车"
    press_enter: "按回车键"
    escape: "Esc"
    shift: "Shift"
    run_code: "运行当前代码"
    run_real_time: "实时运行"
    continue_script: "继续运行当前脚本。"
    skip_scripts: "跳过所有能跳过的脚本。"
    toggle_playback: "继续/暂停按钮"
    scrub_playback: "向前/向后移动一段时间"
    single_scrub_playback: "向前/向后移动一帧"
    scrub_execution: "向前/向后移动一句语句"
    toggle_debug: "显示/关闭调试信息"
    toggle_grid: "显示/关闭网格提示"
    toggle_pathfinding: "显示/关闭路径寻找提示"
    beautify: "利用标准编码格式美化您的代码。"
    maximize_editor: "最大化/最小化代码编辑器"

  community:
    main_title: "CodeCombat社区"
    introduction: "看看下面这些您可以参与的项目，如果有您喜欢的就加入进来吧。 我们期待着与您一起工作。"
    level_editor_prefix: "使用"
    level_editor_suffix: "来创建和编辑关卡。您可以通过这个工具来给您的同学，朋友，兄弟姐妹们设计谜题，或者用于教学或比赛。如果您觉得直接开始建立一个关卡可能非常困难，那么可以先从一个现成（但尚未完成）的关卡开始做起。"
    thang_editor_prefix: "我们管游戏中的单位叫 '物品'。 利用"
    thang_editor_suffix: "来改良CodeCombat中的原材料。让游戏中的东西可以被捡起来扔出去，改变游戏动画的指向，调整一些东西的生命值，或上传您自制的素材。"
    article_editor_prefix: "您在游戏中发现了错误了吗？想要自己设计一些指令吗？来看看我们的"
    article_editor_suffix: "来帮助玩家从游戏中学到更多的知识。"
    find_us: "通过这些站点联系我们"
    social_github: "在GitHub上查看我们的代码"
    social_blog: "阅读CodeCombat在Sett上面的博客"
    social_discource: "在我们的论坛参与讨论"
    social_facebook: "关注CodeCombat的Facebook主页"
    social_twitter: "关注CodeCombat的Twitter"
    social_gplus: "关注CodeCombat的Google+主页"
    social_slack: "在公共 CodeCombat Slack 聊天频道与我们交谈"
    contribute_to_the_project: "为项目做贡献"

  clans:
    clan: "部落"
    clans: "部落"
    new_name: "新部落的名字"
    new_description: "新部落的描述"
    make_private: "设定部落为私人部落"
    subs_only: "只限订阅"
    create_clan: "创建新的部落"
    private_preview: "预览"
    private_clans: "私人部落"
    public_clans: "公开部落"
    my_clans: "我的部落"
    clan_name: "部落名字"
    name: "名字"
    chieftain: "首领"
    edit_clan_name: "编辑部落的名字"
    edit_clan_description: "编辑部落的描述"
    edit_name: "编辑名字"
    edit_description: "编辑描述"
    private: "(私人)"
    summary: "综述"
    average_level: "平均等级"
    average_achievements: "平均成就"
    delete_clan: "删除部落"
    leave_clan: "离开部落"
    join_clan: "加入部落"
    invite_1: "邀请："
    invite_2: "*通过这个链接来邀请玩家加入部落。"
    members: "成员"
    progress: "进度"
    not_started_1: "还没开始"
    started_1: "已开始"
    complete_1: "完成"
    exp_levels: "展开关卡"
    rem_hero: "移除英雄"
    status: "状态"
    complete_2: "完成"
    started_2: "已开始"
    not_started_2: "还没开始"
    view_solution: "点击查阅答案。"
    view_attempt: "点击查阅解题的尝试"
    latest_achievement: "最新成就"
    playtime: "游戏时间"
    last_played: "最后玩了"
    leagues_explanation: "在部落里与其他成员组成联盟一起参加下面的多人竞技场。"
    track_concepts1: "跟踪概念"
    track_concepts2a: "由每位学生学习"
    track_concepts2b: "由每位成员学习"
    track_concepts3a: "查看每位同学达到的等级"
    track_concepts3b: "查看每位成员达到的等级"
    track_concepts4a: "查看你的学生"
    track_concepts4b: "查看你的成员"
    track_concepts5: "解决方案"
    track_concepts6a: "按姓名或进度排序学生"
    track_concepts6b: "按姓名或进度排序成员"
    track_concepts7: "需要邀请"
    track_concepts8: "来加入"
    private_require_sub: "创建或加入私人部落时需要具体描述。"

  courses:
    course: "课程"
    courses: "课程" # {change}
    create_new_class: "建立新的课堂"
    not_enrolled: "您还没有报名参加本课程。"
    visit_pref: "请到这个"
    visit_suf: "网页注册。"
    select_class: "请选其中一门班级"
    unnamed: "*未命名*"
    select: "选择"
    unnamed_class: "班级未命名"
    edit_settings: "编辑班级设定"
    edit_settings1: "编辑班级设定"
    progress: "班级进度"
    add_students: "添加学生"
    stats: "统计"
    total_students: "学生人数："
    average_time: "平均游戏时间："
    total_time: "总计游戏时间："
    average_levels: "平均完成关卡："
    total_levels: "总共完成关卡："
    furthest_level: "最高关卡完成："
    students: "学生"
    students1: "个学生"
    concepts: "课目"
    levels: "关卡"
    played: "已通关"
    play_time: "游戏时间："
    completed: "完成："
    invite_students: "邀请学生加入此班级。"
    invite_link_header: "参与班级的链接"
    invite_link_p_1: "分享给您想分享的其他人以加入课程。"
    invite_link_p_2: "或让我们代你直接发送电邮："
    capacity_used: "课程插槽已用："
    enter_emails: "输入学生电邮地​​址来邀请，每行一个" # {change}
    send_invites: "发送邀请" # {change}
    creating_class: "班级创建中..."
    purchasing_course: "购买课程中..."
    buy_course: "购买课程"
    buy_course1: "购买这个课程"
    select_all_courses: "可半价一次购买所有课程！"
    all_courses: "所有课程"
    number_programming_students: "掌握编程的学生数量"
    number_total_students: "学校/地区中学生总数"
    enter_number_students: "输入该班级的学生上限人数"
    name_class: "命名您的班级"
    displayed_course_page: "这将会在课程页面显示，可被修改。"
    buy: "购买"
    purchasing_for: "你正在购买许可证，课程为"
    creating_for: "您正在创建一个课程为"
    for: "人数上限为" # Like in 'for 30 students'
    receive_code: "然后您会收到一个解锁码，把它分发给你的学生用来注册你的班级。"
    free_trial: "老师可免费试用"
    get_access: "获得个人使用权在评估的目的下来使用所有课程。"
    questions: "有疑问？"
    teachers_click: "老师点击这里"
    students_click: "学生点击这里"
    courses_on_coco: "CodeCombat上的课程"
    designed_to: "在CodeCombat生动有趣的环境下，课程针对性地介绍计算机科学的概念。CodeCombat的关卡围绕着其中的重点展开，并激励学生们在5小时的课程中自主向上学习。"
    more_in_less: "以最少的时间学习最多的知识"
    no_experience: "无需编程经验"
    easy_monitor: "容易管理学生的进程"
    purchase_for_class: "为你的班级购买CodeCombat课程，让签到和管理变得更容易！"
    see_the: "详细资讯请看"
    more_info: "。"
    choose_course: "选择您的课程："
    enter_code: "输入一个解锁码来加入已存在的班级"
    enter_code1: "输入解锁码"
    enroll: "注册"
    pick_from_classes: "从目前的课程选择"
    enter: "输入"
    or: "或"
    topics: "题目"
    hours_content: "内容时间："
    get_free: "取得免费课程！"
    enroll_paid: "招收学生到已付费课程"
    you_have1: "你有"
    you_have2: "未使用的学生许可。"
    use_one: "使用一个学生许可于"
    use_multiple: "为下列学生使用许可："
    already_enrolled: "已注册"
    licenses_remaining: "证书剩余："
    insufficient_enrollments: "学生许可数不足"
    get_enrollments: "获取更多学生许可"
    change_language: "修改课程语言"
    keep_using: "继续使用"
    switch_to: "切换到"
    greetings: "欢迎!"
    back_classrooms: "回到我的教室"
    back_courses: "回到我的课程"
    edit_details: "编辑课程详情"
    enrolled_courses: "报名付费课程："
    purchase_enrollments: "购买学生许可"
    remove_student: "删除学生"
    assign: "分派"
    to_assign: "去分派付费课程。"
    student: "学生"
    teacher: "老师"
    complete: "完成"
    none: "无"
    play_campaign_title: "玩战役模式"
    play_campaign_description: "你已经准备开始下一步了！探索数以百计的挑战关卡、学习高级编程技巧，以及在多人竞技场中战斗！"
    create_account_title: "创建账号"
    create_account_description: "注册免费的CodeCombat账号以获取更多关卡、更多的编程技巧和更多乐趣！"
    preview_campaign_title: "试玩战役"
    preview_campaign_description: "在注册你的免费账号前，简单看一下CodeCombat将要提供的所有内容。"
    arena: "竞技场"
    arena_soon_title: "竞技场马上就来"
    arena_soon_description: "我们正在开发一个多人竞技场"
    not_enrolled1: "未报名"
    not_enrolled2: "通知你的老师把你加入下一课程。"
    next_course: "下个课程"
    coming_soon1: "马上就来"
    coming_soon2: "我们正在努力地为您准备更多课程！"
    available_levels: "可用关卡"
    welcome_to_courses: "探险者，欢迎来到课程中！"
    ready_to_play: "准备玩了吗？"
    start_new_game: "开始新游戏"
    play_now_learn_header: "开始学习"
    play_now_learn_1: "控制你角色的基本语法"
    play_now_learn_2: "解决麻烦谜题的while循环"
    play_now_learn_3: "自定义动作的字符串和变量"
    play_now_learn_4: "如何打败食人魔（重要生存技巧！）"
    welcome_to_page: "欢迎来到你的课程页面！" # {change}
    completed_hoc: "太棒了！你已经完成了编码之时课程！"
    ready_for_more_header: "准备玩更多东西了？玩竞技场模式！"
    ready_for_more_1: "使用宝石解锁更多物品！"
    ready_for_more_2: "玩品牌新世界和挑战"
    ready_for_more_3: "学习更多编程！"
    saved_games: "已保存游戏"
    hoc: "编码之时"
    my_classes: "我的课程" # {change}
    class_added: "成功添加课程！"
    view_levels: "浏览关卡" # {change}
    join_class: "加入课程"
    join_class_2: "加入班级"
    ask_teacher_for_code: "从你的老师领取CodeCombat课程码！领取后请在下方输入："
    enter_c_code: "<输入课程码>"
    join: "加入"
    joining: "加入课程中"
    course_complete: "课程完成"
    play_arena: "玩竞技场"
    view_project: "查看项目"
    start: "开始"
    last_level: "上一关卡" # {change}
    welcome_to_hoc: "探险者，欢迎来到我们的编码之时！"
    logged_in_as: "登录为："
    not_you: "不是你？"
    welcome_back: "探险者，欢迎回来！"
    continue_playing: "继续玩"
    more_options: "更多选项："
    option1_header: "选项1：通过电子邮件邀请学生" # {change}
    option1_body: "学生会被自动发送一个加入该课程的邀请，他们需要提供用户名和密码以创建账号。" # {change}
    thank_you_pref: "感谢你的购买！现在你可以分派"
    thank_you_suff: "更多学生到付费课程中。"
    return_to_class: "回到教室"
    return_to_course_man: "回到课程管理。"
    students_not_enrolled: "未注册的学生"
    total_all_classes: "所有课程总数"
    how_many_enrollments: "你需要多少额外的学生许可？"
    each_student_access: "课程中的学生可以访问课程2-4，一旦他们注册了付费课程。你可以为每个学生单独分配任何课程。"
    purchase_now: "现在购买"
    enrollments: "许可"
    remove_student1: "删除学生"
    are_you_sure: "你确定要从该课程中删除该学生吗？"
    remove_description1: "学生将失去访问该课堂和被分派课程的权利。游戏进度不会丢失，该学生可以在任何时间被添加回该教室。"
    remove_description2: "被激活的付费许可证将无法返还。"
    keep_student: "保留学生"
    removing_user: "删除用户"
    to_join_ask: "为了加入课程，问你的老师得到一个解锁码。"
    join_this_class: "加入课程"
    enter_here: "<在这里输入解锁码>"
    successfully_joined: "成功加入"
    click_to_start: "点击这里开始"
    my_courses: "我的课程"
    classroom: "教室"
    use_school_email: "用你学校的电子邮箱如果你有"
    unique_name: "没人使用的唯一名称"
    pick_something: "选用你能记住的某些东西"
    class_code: "课程码"
    optional_ask: "可选 - 让你的老师给你一个！"
    optional_school: "可选 - 你想去什么学校？"
    start_playing: "开始玩"
    skip_this: "跳过，以后我会创建一个账号！"
    welcome: "欢迎"
    getting_started: "开始课程"
    download_getting_started: "下载新手教程[PDF]"
    getting_started_1: "点击下面绿色的'创建新课程'按钮来创建新课程。"
    getting_started_2: "当你已经创建好了课程，点击蓝色的'添加学生'按钮。"
    getting_started_3: "你将会在下面看到学生的进度，当他们注册和加入你的课程。"
    educator_wiki_pref: "您也可阅读"
    educator_wiki_mid: "教育者wiki"
    educator_wiki_suff: "在线阅读指南。"
    your_classes: "你的课程"
    no_classes: "还没有任何课程！"
    create_new_class1: "创建新课程"
    available_courses: "可用课程"
    unused_enrollments: "可用许可："
    students_access: "所有的学生都可以免费访问 计算机科学入门。每个学生需要一个许可加入付费的CodeCombat课程。单个学生无需多个许可就能访问所有的付费课程。"
    active_courses: "已激活课程"
    no_students: "还没有学生！"
    add_students1: "添加学生"
    view_edit: "查看/编辑"
    students_enrolled: "已注册学生"
    students_assigned: "已分配学生"
    length: "长度："
    subtitle: "复习课程指导、解法和关卡" # Flat style redesign
    changelog: "查看课程关卡的最新改动。"
    select_language: "选择语言"
    select_level: "选择关卡"
    play_level: "开始关卡"
    concepts_covered: "课目覆盖"
    print_guide: "打印手册 (PDF)"
    view_guide_online: "关卡概览和解法"
    grants_lifetime_access: "取得所有关卡权限。"
    enrollment_credits_available: "可用许可："
    language_select: "选择语言" # ClassroomSettingsModal
    language_cannot_change: "一旦学生加入课程后则不可修改课程语言。"
    learn_p: "学习Python"
    learn_j: "学习JavaScript"
    avg_student_exp_label: "学生平均编程经验"
    avg_student_exp_desc: "这会帮助我们更好安排课程。"
    avg_student_exp_select: "选择最佳选项"
    avg_student_exp_none: "无经验 - 几乎没有任何经验"
    avg_student_exp_beginner: "初学者 - 展露过少许经验"
    avg_student_exp_intermediate: "中等水平 - 有动手写过代码的经历"
    avg_student_exp_advanced: "高水平 - 大量编程经验"
    avg_student_exp_varied: "不同编程经验"
    student_age_range_label: "学生年龄范围"
    student_age_range_younger: "小于 6 岁"
    student_age_range_older: "大于 18 岁"
    student_age_range_to: "到"
    create_class: "创建班级"
    class_name: "班级名称"
    teacher_account_restricted: "你的账号是教师账号，不能访问学生内容。"
    account_restricted: "此页面需要学生账号访问。"
    update_account_login_title: "登陆并升级账号"
    update_account_title: "请留意您的账号！"
    update_account_blurb: "在访问班级前，请选择您的账号的用途。"
    update_account_current_type: "当前账号类型："
    update_account_account_email: "账号邮箱/用户名："
    update_account_am_teacher: "我是教师"
    update_account_keep_access: "保持所创建班级的权限"
    update_account_teachers_can: "教师账号能："
    update_account_teachers_can1: "创建/管理/添加 班级"
    update_account_teachers_can2: "添加学生到课程中"
    update_account_teachers_can3: "解锁所有课程关卡以便测试"
    update_account_teachers_can4: "推出教师专用功能时获得使用权"
    update_account_teachers_warning: "警告：你将会退出以前加入的每个班级，并且也不能以学生身份游玩。"
    update_account_remain_teacher: "保持教师身份"
    update_account_update_teacher: "升级为教师账号"
    update_account_am_student: "我是学生"
    update_account_remove_access: "取消所创建班级的权限"
    update_account_students_can: "学生账号能："
    update_account_students_can1: "加入班级"
    update_account_students_can2: "以学生身份完成课程，查看自己的进度"
    update_account_students_can3: "与同学一决高下"
    update_account_students_can4: "推出学生专用功能时获得使用权"
    update_account_students_warning: "警告：你将不能再创建新班级或管理已创建的班级"
    update_account_remain_student: "保持学生身份"
    update_account_update_student: "升级为学生账号"
    need_a_class_code: "您需要拥有以下班级的班级码："
    update_account_not_sure: "不确定选择哪个？给以下邮箱发送邮件："
    update_account_confirm_update_student: "确定要将账号升级为学生账号吗？"
    update_account_confirm_update_student2: "你将不能再创建新班级或管理已创建的班级。你在 CodeCombat 创建的班级将会被删除且无法恢复！"
    instructor: "邀请人: "
    youve_been_invited_1: "您被邀请加入 "
    youve_been_invited_2: "，在 CodeCombat 中与您的同学一起学习 "
    youve_been_invited_3: " 。"
    by_joining_1: "加入 "
    by_joining_2: " 后您可以通过它重置密码。您也可以验证邮箱自行完成！"
    sent_verification: "我们已向以下邮箱发送验证邮件："
#    you_can_edit: "You can edit your email address in "
    account_settings: "账户设置"
    select_your_hero: "选择英雄"
    select_your_hero_description: "您可随时在课程页面更改英雄，只需点击 \"选择英雄\""
    select_this_hero: "选择英雄"
    current_hero: "当前英雄:"
    change_hero: "更改英雄"
#    web_dev_language_transition: "All classes program in HTML / JavaScript for this course.  Classes that have been using Python will start with extra JavaScript intro levels to ease the transition.  Classes that are already using JavaScript will skip the intro levels."

  teacher:
    course_solution: "关卡解法"
    level_overview_solutions: "关卡概览和解法"
    teacher_dashboard: "教师面板" # Navbar
    my_classes: "我的教室"
    courses: "课程指导"
    enrollments: "学生许可"
    resources: "资源"
    help: "帮助"
    students: "学生" # Shared
    language: "编程语言"
    edit_class_settings: "修改教室设置"
    complete: "已达成"
    access_restricted: "需要升级账号"
    teacher_account_required: "只有教师账号才能访问。"
    create_teacher_account: "创建教师账号"
    what_is_a_teacher_account: "什么是教师账号？"
    teacher_account_explanation: "教师账号可以创建教师、跟踪学生学习进展、管理注册许可，并且可以查看相应的帮助文档以辅助构建课堂。"
    current_classes: "当前课堂"
    archived_classes: "已归档的课堂"
    archived_classes_blurb: "您可以把课堂归档，便于后续查阅。课程可以解档课程，并在当前课程列表中再次查看。"
    view_class: "查看课堂"
    archive_class: "归档课堂"
    unarchive_class: "解档课堂"
    unarchive_this_class: "解档本课堂"
    no_students_yet: "该课堂尚未有学生加入。"
#    no_students_yet_view_class: "View class to add students."
    try_refreshing: "(您可能需要刷新页面)"
    add_students: "添加学生"
    create_new_class: "创建新课堂"
    class_overview: "课堂概览" # View Class page
    avg_playtime: "单关平均通关时间"
    total_playtime: "总时长"
    avg_completed: "平均完成关卡数"
    total_completed: "完成总关卡数"
    created: "创建"
    concepts_covered: "覆盖语法概念"
    earliest_incomplete: "最近未完成关卡"
    latest_complete: "最近通关关卡"
    enroll_student: "注册学生"
#    apply_license: "Apply License"
    course_progress: "课程进度"
    not_applicable: "N/A"
    edit: "修改"
    edit_2: "修改"
    remove: "移除"
    latest_completed: "最近通关" # {change}
    sort_by: "排列依据"
    progress: "进度"
    completed: "已完成"
    started: "已开始"
    click_to_view_progress: "点击查看进度"
    no_progress: "无进度"
    select_course: "选择查看"
#    students_not_assigned: "Students who have not been assigned {{courseName}}"
    course_overview: "课程概览"
    copy_class_code: "复制课堂编码"
    class_code_blurb: "未加入的学生可以在自己的功能页面输入该课堂编码，或者访问网址加入课堂。" # {change}
    copy_class_url: "复制课堂链接地址"
    class_join_url_blurb: "新学生可以在登录之后，访问该网址加入课堂。" # {change}
    add_students_manually: "手工添加学生" # {change}
    bulk_assign: "批量添加"
#    assigned_msg_1: "{{numberAssigned}} students were assigned {{courseName}}."
#    assigned_msg_2: "{{numberEnrolled}} licenses were applied."
#    assigned_msg_3: "You now have {{remainingSpots}} available licenses remaining."
#    assign_course: "Assign Course"
#    not_assigned_modal_title: "Courses were not assigned"
#    not_assigned_modal_body_1: "You do not have enough licenses available to assign additional Courses to all {{selected}} selected students."
#    not_assigned_modal_body_2: "You only have {{totalSpotsAvailable}} licenses available ({{unenrolledStudents}} students did not have an active license)."
#    not_assigned_modal_body_3: "Please select fewer students, or reach out to {{email}} for assistance."
    assign_to_selected_students: "添加课堂到选中的学生"
    assigned: "已添加"
    enroll_selected_students: "注册选中的学生"
    no_students_selected: "没有学生被选中。"
    guides_coming_soon: "参考指导很快会推出！" # Courses
    show_students_from: "展示这些学生" # Enroll students modal
#    apply_licenses_to_the_following_students: "Apply Licenses to the Following Students"
#    students_have_licenses: "The following students already have licenses applied:"
    all_students: "所有学生"
#    apply_licenses: "Apply Licenses"
    not_enough_enrollments: "没有足够许可注册。"
#    enrollments_blurb: "Students are required to have a license to access any content after the first course."
    credits_available: "可用许可数"
    total_unique_students: "总学生人数"
    total_enrolled_students: "总注册人次"
    unenrolled_students: "取消注册学生"
    add_enrollment_credits: "购买许可"
    purchasing: "正在购买……"
    purchased: "购买成功！"
    purchase_now: "现在购买"
    how_to_enroll: "如何注册学生？"
#    how_to_apply_licenses: "How to Apply Licenses"
    bulk_pricing_blurb: "需要购买超过25个学生名额？请联系我们获取建议。"
    total_unenrolled: "取消注册总数"
    export_student_progress: "导出学生进度 (CSV)"
    send_email_to: "将重置密码邮件发送到以下邮箱："
    email_sent: "邮件已发送"
    send_recovery_email: "发送重置密码邮件"
    enter_new_password_below: "在下面输入您的新密码："
    change_password: "更改密码"
    changed: "已更改"
    available_credits: "可用许可"
    pending_credits: "评估许可"
    credits: "许可"
    start_date: "起始日期："
    end_date: "结束日期："
    get_enrollments_blurb: " 我们会帮您解决您的班级、学校或地区的需求。"
#    how_to_apply_licenses_blurb_1: "When a teacher assigns a course to a student for the first time, we’ll automatically apply a license. Use the bulk-assign dropdown in your classroom to assign a course to selected students:"
#    how_to_apply_licenses_blurb_2: "Can I still apply a license without assigning a course?"
#    how_to_apply_licenses_blurb_3: "Yes — go to the License Status tab in your classroom and click \"Apply License\" to any student who does not have an active license."
    request_sent: "申请已发送！"
    enrollment_status: "名额状态"
#    license_status: "License Status"
    status_expired: "在 {{date}} 过期"
    status_not_enrolled: "未分配名额"
    status_enrolled: "在 {{date}} 过期"
    select_all: "全选"
    projects: "项目"
#    project: "Project"
#    view_student_project: "View Student Project"
#    view_arena_ladder: "View Arena Ladder"
#    resource_hub: "Resource Hub"
#    getting_started: "Getting Started"
#    educator_faq: "Educator FAQ"
#    educator_faq_desc: "Frequently asked questions about using CodeCombat in your classroom or school."
#    teacher_getting_started: "Teacher Getting Started Guide"
#    teacher_getting_started_desc: "New to CodeCombat? Download this Teacher Getting Started Guide to set up your account, create your first class, and invite students to the first course."
#    student_getting_started: "Student Quick Start Guide"
#    student_getting_started_desc: "You can distribute this guide to your students before starting CodeCombat so that they can familiarize themselves with the code editor. This guide can be used for both Python and JavaScript classrooms."
#    cs1: "Introduction to Computer Science"
#    cs2: "Computer Science 2"
#    cs3: "Computer Science 3"
#    cs1_syntax_python: "Course 1 Python Syntax Guide"
#    cs1_syntax_python_desc: "Cheatsheet with references to common Python syntax that students will learn in Introduction to Computer Science."
#    cs1_syntax_javascript: "Course 1 JavaScript Syntax Guide"
#    cs1_syntax_javascript_desc: "Cheatsheet with references to common JavaScript syntax that students will learn in Introduction to Computer Science."
#    coming_soon: "Additional guides coming soon!"
#    engineering_cycle_worksheet: "Engineering Cycle Worksheet"
#    engineering_cycle_worksheet_desc: "Use this worksheet to teach students the basics of the engineering cycle: Assess, Design, Implement and Debug. Refer to the completed example worksheet as a guide."
#    engineering_cycle_worksheet_link: "View example"
#    progress_journal: "Progress Journal"
#    progress_journal_desc: "Encourage students to keep track of their progress via a progress journal."
#    cs1_curriculum: "Introduction to Computer Science - Curriculum Guide"
#    cs1_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 1."
#    cs2_curriculum: "Computer Science 2 - Curriculum Guide"
#    cs2_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 2."
#    cs3_curriculum: "Computer Science 3 - Curriculum Guide"
#    cs3_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 3."
#    cs1_pairprogramming: "Pair Programming Activity"
#    cs1_pairprogramming_desc: "Introduce students to a pair programming exercise that will help them become better listeners and communicators."
#    unlock_resources: "Unlock more resources!"
#    unlock_resources_desc: "Gain access to additional guides by adding student licenses to your account. Request a demo today to get started."
#    request_demo: "Request Demo"
#    student_overview: "Overview"
#    student_email: "Student Email"
#    no_email: "Student has no email address set."
#    student_profile: "Student Profile"
#    playtime_detail: "Playtime Detail"
#    student_completed: "Student Completed"
#    student_in_progress: "Student in Progress"
#    class_average: "Class Average"
#    not_assigned: "has not been assigned the following courses"
#    playtime_axis: "Playtime in Seconds"
#    levels_axis: "Levels in"
#    student_state: "How is"
#    student_state_2: "doing?"
#    student_good: "is doing well in"
#    student_good_detail: "This student is keeping pace with the class."
#    student_warn: "might need some help in"
#    student_warn_detail: "This student might need some help with new concepts that have been introduced in this course."
#    student_great: "is doing great in"
#    student_great_detail: "This student might be a good candidate to help other students working through this course."

  sharing:
    game: "游戏"
    webpage: "网页"
#    your_students_preview: "Your students will click here to see their finished projects! Unavailable in teacher preview."
#    unavailable: "Link sharing not available in teacher preview."
    share_game: "分享此游戏"
    share_web: "分享此网页"
    victory_share_prefix: "将这个链接分享给亲朋好友，让他们"
    victory_share_game: "玩你的游戏关卡"
    victory_share_web: "看你制作的网页"
    victory_share_suffix: "吧。"
    victory_course_share_prefix: "此链接将你刚制作的"
    victory_course_share_game: "游戏"
    victory_course_share_web: "网页"
    victory_course_share_suffix: "分享给亲朋好友。"
    copy_url: "复制 URL"

  game_dev:
    creator: "创建者"

  web_dev:
    image_gallery_title: "图库"
#    select_an_image: "Select an image you want to use"
#    scroll_down_for_more_images: "(Scroll down for more images)"
#    copy_the_url: "Copy the URL below"
#    copy_the_url_description: "Useful if you want to replace an existing image."
#    copy_the_img_tag: "Copy the <img> tag"
#    copy_the_img_tag_description: "Useful if you want to insert a new image."
#    copy_url: "Copy URL"
#    copy_img: "Copy <img>"
#    how_to_copy_paste: "How to Copy/Paste"
#    copy: "Copy"
#    paste: "Paste"
#    back_to_editing: "Back to Editing"

  classes:
    archmage_title: "大法师"
    archmage_title_description: "(代码编写人员)"
    archmage_summary: "如果您是对教育类游戏感兴趣的程序开发者，那么就选择大法师来为CodeCombat编写代码吧！"
    artisan_title: "工匠师"
    artisan_title_description: "(关卡创造人员)"
    artisan_summary: "建立游戏关卡并分享给朋友们。那么就选择工匠来教其他人编程吧。"
    adventurer_title: "冒险家"
    adventurer_title_description: "(关卡测试人员)"
    adventurer_summary: "提前一周免费游玩我们最新发布的关卡，并帮助我们在发布之前寻找程序错误"
    scribe_title: "文书"
    scribe_title_description: "(文档编辑人员)"
    scribe_summary: "好代码需要好文档，来自全世界数百万的玩家一起编写，编辑以及提高文档的可读性"
    diplomat_title: "外交官"
    diplomat_title_description: "(翻译人员)"
    diplomat_summary: "CodeCombat已经被我们的外交官们翻译成45多种世界语言。在翻译的同时体验翻译的乐趣吧！"
    ambassador_title: "使节"
    ambassador_title_description: "(用户支持人员)"
    ambassador_summary: "指导我们亲爱的论坛用户并为他们的问题引出一个正确的方向。我们的使节将CodeCombat带到这个世界上。"
    teacher_title: "教师"

  editor:
    main_title: "CodeCombat编辑器"
    article_title: "指令编辑器"
    thang_title: "物品编辑器"
    level_title: "关卡编辑器"
    course_title: "课程编辑器"
    achievement_title: "目标编辑器"
    poll_title: "调查编辑器"
    back: "后退"
    revert: "还原"
    revert_models: "还原模式"
    pick_a_terrain: "选择地形"
    dungeon: "地牢"
    indoor: "室内"
    desert: "沙漠"
    grassy: "草地"
    mountain: "高山"
    glacier: "冰川"
    small: "小的"
    large: "大的"
    fork_title: "派生新版本"
    fork_creating: "正在执行派生..."
    generate_terrain: "生成地形"
    more: "更多"
    wiki: "维基"
    live_chat: "在线聊天"
    thang_main: "主菜单"
    thang_spritesheets: "贴图集"
    thang_colors: "颜色"
    level_some_options: "有哪些选项？"
    level_tab_thangs: "物体"
    level_tab_scripts: "脚本"
    level_tab_components: "组件"
    level_tab_systems: "系统"
    level_tab_docs: "文档"
    level_tab_thangs_title: "目前所有物体"
    level_tab_thangs_all: "所有"
    level_tab_thangs_conditions: "启动条件"
    level_tab_thangs_add: "增加物体"
    level_tab_thangs_search: "查找物体"
    add_components: "添加组件"
    component_configs: "组件配置"
    config_thang: "双击配置一个物体"
    delete: "删除"
    duplicate: "复制"
    stop_duplicate: "停止复制"
    rotate: "旋转"
    level_component_tab_title: "目前所有组件"
    level_component_btn_new: "创建新的组件"
    level_systems_tab_title: "目前所有系统"
    level_systems_btn_new: "创建新的系统"
    level_systems_btn_add: "增加系统"
    level_components_title: "返回到所有物体主页"
    level_components_type: "类型"
    level_component_edit_title: "编辑组件"
    level_component_config_schema: "配置模式"
    level_system_edit_title: "编辑系统"
    create_system_title: "创建新的系统"
    new_component_title: "创建新的组件"
    new_component_field_system: "系统"
    new_article_title: "创建一个新物品"
    new_thang_title: "创建一个新物品类型"
    new_level_title: "创建一个新关卡"
    new_article_title_login: "登录以创建新指令"
    new_thang_title_login: "登录以创建新物品"
    new_level_title_login: "登录以创建新关卡"
    new_achievement_title: "创建新目标"
    new_achievement_title_login: "登录以创建新目标"
    new_poll_title: "创建新调查"
    new_poll_title_login: "登陆以创建新调查"
    article_search_title: "在这里搜索物品"
    thang_search_title: "在这里搜索物品类型"
    level_search_title: "在这里搜索关卡"
    achievement_search_title: "搜索目标"
    poll_search_title: "搜寻投票"
    read_only_warning2: "提示：您不能保存任何编辑，因为您没有登陆"
    no_achievements: "这个关卡还没有被赋予任何目标。"
    achievement_query_misc: "关闭杂项的成就"
    achievement_query_goals: "关闭通关的成就"
    level_completion: "关卡完成"
    pop_i18n: "完善 I18N"
    tasks: "任务"
    clear_storage: "清除您本地的变更"
    add_system_title: "添加系统到关卡"
    done_adding: "添加完毕"

  article:
    edit_btn_preview: "预览"
    edit_article_title: "编辑提示"

  polls:
    priority: "优先次序"

  contribute:
    page_title: "贡献"
    intro_blurb: "CodeCombat是完全开源的软件！上千个玩家帮助了我们建设了这整个游戏，就是您今天看到的一样！快加入我们然后为CodeCombat打开新的章节，将世界带领进入编程世代前进吧！"
    alert_account_message_intro: "您好！"
    alert_account_message: "想要订阅邮件？ 您必须先登录"
    archmage_introduction: "制作游戏时，最令人激动的事莫过于整合诸多东西。图像、音响、实时网络交流、社交网络，从底层数据库管理到服务器运维，再到用户界面的设计和实现。制作游戏有很多事情要做，所以如果您有编程经验,  那么您应该选择这个职业。我们会很高兴在制作史上最好编程游戏的路上有您的陪伴。"
    class_attributes: "职业说明"
    archmage_attribute_1_pref: "了解 "
    archmage_attribute_1_suf: "，或者想要学习。我们的多数代码都是用它写成的。如果您喜欢 Ruby 或者 Python，那您肯定会感到非常熟悉。它就是 JavaScript，但它的语法更友好。"
    archmage_attribute_2: "编程经验和干劲。我们可以帮您走上正轨，但我们恐怕没多少时间培训您。"
    how_to_join: "如何加入"
    join_desc_1: "谁都可以加入！先看看我们的"
    join_desc_2: "，然后勾选下面的复选框，这样您就会作为勇敢的大法师收到我们的邮件。如果您想和开发人员聊天或者更深入地参与，可以"
    join_desc_3: " 或者去我们的"
    join_desc_4: "，然后我们有话好说！"
    join_url_email: "给我们发邮件"
    join_url_slack: "公共 Slack 频道"
    archmage_subscribe_desc: "通过电子邮件获得新的编码机会和公告。"
    artisan_introduction_pref: "我们必须设计更多的关卡! 大家为了更多的游戏内容在高声呐喊，但是我们靠自己只能创建这些。现在您的电脑就是第一关！我们的关卡编辑器刚刚完成了基本功能，所以创造关卡的时候请小心使用。只要您有制作关卡的灵感，不管是简单的for循环还是"
    artisan_introduction_suf: "这种东西，这个职业都很适合您。"
    artisan_attribute_1: "最好有创建地图的经历，比如使用暴雪的关卡编辑器，但这不是必须的条件。"
    artisan_attribute_2: "渴望完成全部的测试和迭代。要做一个优秀的关卡，您需要把它给别的玩家观察他们怎么玩，然后时刻准备着找到很多细节去打磨。"
    artisan_attribute_3: "探险家般的忍耐力。我们的关卡编辑器非常的初级，还会有很多不好用的地方。唔，我已经提前告诉您了~"
    artisan_join_desc: "如下步骤使用关卡编辑器:"
    artisan_join_step1: "阅读文档。"
    artisan_join_step2: "创建一个新关卡 以及探索已经存在的关卡。"
    artisan_join_step3: "来我们的Slack聊天室寻求帮助。"
    artisan_join_step4: "把您的关卡发到论坛让别人给您评价。"
    artisan_subscribe_desc: "通过电子邮件获得关卡编辑器更新和公告。"
    adventurer_introduction: "现在就来了解您的角色吧：您是一辆战车，并将要承担沉重的攻击。我们需要人来尝试下我们新开的关卡以了解怎么样才能使每一样东西更美好。一开始虽然会非常辛苦；可是制造出一个最好的游戏是一个很长的过程，在这个过程中，没有人可以第一次就成功。如果您挺过去了并且自我感觉良好，那么这个位置就是为您而准备的。"
    adventurer_attribute_1: "学习的渴望！您想要学好怎么编程，与此同时我们也想要教您怎么编程。虽然您可能会觉得大多数时间您都在教导别人。"
    adventurer_attribute_2: "魅力！温柔但懂得表达事态；了解并知道如何改进。"
    adventurer_join_pref: "无论是与工匠一起工作，或者只是在下面的格子打勾以获得新关卡测试的通知，我们都会发布关于对新关卡的看法。"
    adventurer_forum_url: "我们的论坛"
    adventurer_join_suf: "如果您更喜欢以这些方式被通知, 那就在这里注册吧!"
    adventurer_subscribe_desc: "通过电子邮件获得新关卡通知。"
    scribe_introduction_pref: "CodeCombat不只是拥有一堆等级或关卡。它也是个知识的源泉，一个编程的宝典，一个人人都可以参与的，有趣的游戏。比起每个工匠都要详细解释其中的奥秘，他们可以以更简单的方式将自己的东西连接到一篇已经准备好的文章给玩家阅读。 有些东西就像 "
    scribe_introduction_url_mozilla: "Mozilla开发者社区"
    scribe_introduction_suf: " 被建成。如果您那有趣的想法能把编程的理论简易的带出来，那么这里就是您的所属了。"
    scribe_attribute_1: "您需要具备在文字语言上的技能。不仅仅是语法和拼音，重要的是能传达各种各样想法给别人。"
    contact_us_url: "联系我们"
    scribe_join_description: "介绍下您自己, 比如您的编程经历和您喜欢的东西, 我们将会努力的去了解您！!"
    scribe_subscribe_desc: "通过电子邮件获得写作新文档的通知。"
    diplomat_introduction_pref: "如果说我们从"
    diplomat_launch_url: "十月的发布"
    diplomat_introduction_suf: "中得到了什么启发：那就是全世界的人都很喜欢CodeCombat。我们召集了一群翻译者，希望能尽快地把网站上的信息翻译成各国文字。如果您对CodeCombat的内容很感兴趣，想让世界上的每一个人都有机会一同体验，就快来成为外交官吧。"
    diplomat_attribute_1: "既会说流利的英语，也熟悉自己的语言。编程是一件很复杂的事情，而要翻译复杂的概念，您必须对两种语言都在行！"
    diplomat_i18n_page_prefix: "您可以在我们的"
    diplomat_i18n_page: "翻译页面"
    diplomat_i18n_page_suffix: "开始翻译游戏，或者在我们的GitHub页面上进行。"
    diplomat_join_pref_github: "在"
    diplomat_github_url: "GitHub"
    diplomat_join_suf_github: "找到中文语言文件 (简体中文的是:CodeCombat/app/locale/zh-HANS.coffee)，在线编辑它，完成后提交一个合并请求。您也可以勾上下面这个复选框来关注最新的国际化开发！"
    diplomat_subscribe_desc: "接受有关国际化开发和翻译任务的邮件"
    ambassador_introduction: "这是一个正在成长的社区，而您将成为我们与世界的联结点。大家可以通过各种即时聊天平台、邮件、或是参与者众多的社交网络来认识及讨论我们的游戏。如果您喜欢帮助大家，一起参与各类项目，一起获得乐趣。与我们同行，一起感受CodeCombat的脉搏，绝对是一个适合您的职业。"
    ambassador_attribute_1: "具备出色的沟通能力。能够分辨出玩家遇到的问题并帮助他们解决问题。与此同时，和我们保持联系，帮助反馈玩家们的喜怒哀乐！"
    ambassador_join_desc: "介绍一下您自己：您做过什么？您喜欢做什么？我们将从这里开始了解您！"
    ambassador_join_note_strong: "注意"
    ambassador_join_note_desc: "我们其中一个想法是要制造一个当玩家们在解决问题上有难度时可以要求其他比较强的玩家来协助他们的多人游戏。这将会是一个很好的办法让使节们可以更容易地协助玩家！如有任何更新，我们会在第一时间通知您！"
    ambassador_subscribe_desc: "通过电子邮件获得支持系统的现状，以及多人游戏方面的新进展。"
    teacher_subscribe_desc: "接收针对教师的更新和公告邮件。"
    changes_auto_save: "在您勾选复选框后，更改将自动保存。"
    diligent_scribes: "我们勤奋的文书:"
    powerful_archmages: "我们强力的大法师:"
    creative_artisans: "我们极具创意的工匠:"
    brave_adventurers: "我们勇敢的冒险家:"
    translating_diplomats: "我们遍及世界的外交官:"
    helpful_ambassadors: "我们亲切的使节:"

  ladder:
    please_login: "对战之前请先登录。"
    my_matches: "我的对手"
    simulate: "模拟"
    simulation_explanation: "通过模拟游戏，您可以让您的游戏更快的得到评分。"
    simulation_explanation_leagues: "你会主要给在你的部落或者课程的同伴帮忙模拟游戏。"
    simulate_games: "模拟游戏！"
    games_simulated_by: "由您模拟过的游戏数:"
    games_simulated_for: "为您模拟过的游戏数:"
    games_in_queue: "游戏正在列队中："
    games_simulated: "模拟次数"
    games_played: "被模拟次数"
    ratio: "比率"
    leaderboard: "排行榜"
    battle_as: "我要加入这一方 "
    summary_your: "您在 "
    summary_matches: "的比赛 - "
    summary_wins: " 胜利, "
    summary_losses: " 失败"
    rank_no_code: "没有新代码可供评分"
    rank_my_game: "为我的游戏评分！"
    rank_submitting: "正在提交..."
    rank_submitted: "提交评分"
    rank_failed: "评分失败"
    rank_being_ranked: "已评价"
    rank_last_submitted: "已提交"
    help_simulate: "模拟游戏需要帮助？"
    code_being_simulated: "您的新代码正在被其他玩家模拟评分。排名将会在新对战结束后刷新。"
    no_ranked_matches_pre: "没有排名对决给 "
    no_ranked_matches_post: " 啊哈哟！去和其他玩家打过再回来这里查看您游戏排名吧！"
    choose_opponent: "选择一个对手"
    select_your_language: "选择您使用的语言!"
    tutorial_play: "玩教程"
    tutorial_recommended: "如果您从未玩过的话,推荐先玩下教程"
    tutorial_skip: "跳过教材"
    tutorial_not_sure: "不知道怎么玩?"
    tutorial_play_first: "先玩一次教程。"
    simple_ai: "简单电脑"
    warmup: "热身"
    friends_playing: "联机"
    log_in_for_friends: "登陆然后跟朋友一起玩！"
    social_connect_blurb: "连接然后与朋友对战！"
    invite_friends_to_battle: "邀请您的朋友参加战斗！"
    fight: "战斗！"
    watch_victory: "观看您的胜利"
    defeat_the: "击败了"
    watch_battle: "观看战役"
    tournament_started: "，锦标赛已开始"
    tournament_ends: "锦标赛结束"
    tournament_ended: "锦标赛已结束"
    tournament_rules: "锦标赛规则"
    tournament_blurb: "写代码，收金币，建军队，碎敌军，赢奖品，以及在我们奖励多达$40,000的Greed tournament里升级您的事业！ 快去查阅详情！"
    tournament_blurb_criss_cross: "赢得竞拍，建造道路，智胜对手，夺取宝石，在纵横交错锦标赛中完成生涯晋级! 现在就查看详情！"
    tournament_blurb_zero_sum: "在红方法师和蓝方法师的山峰对决中, 同时在收集金币和战术上发挥你的代码创造力。竞赛在3月27日开始, 在4月6日(星期一)的下午5点(PDT 太平洋时区)结束。为乐趣和荣耀竞赛吧! 浏览了解更多"
    tournament_blurb_ace_of_coders: "我的主场我主宰，在天寒地冻的冰原上和自己的镜像大战一场吧！本次比赛将由9月16日星期三开办到10月14日下午5点PDT。详情请查看"
    tournament_blurb_blog: "关注我们的博客"
    rules: "规则"
    winners: "胜利者"
    league: "联盟"
    red_ai: "红方 AI" # "Red AI Wins", at end of multiplayer match playback
    blue_ai: "蓝方 AI"
    wins: "胜利" # At end of multiplayer match playback
    humans: "红方" # Ladder page display team name
    ogres: "蓝方"

  user:
    stats: "成就"
    singleplayer_title: "单人游戏关卡"
    multiplayer_title: "多人游戏关卡"
    achievements_title: "成就"
    last_played: "最近玩的时间"
    status: "状态"
    status_completed: "已完成"
    status_unfinished: "未完成"
    no_singleplayer: "还未玩过任何单人游戏关卡。"
    no_multiplayer: "还未玩过任何多人游戏关卡。"
    no_achievements: "还未得到任何成就。"
    favorite_prefix: "最喜爱的语言是 "
    favorite_postfix: "。"
    not_member_of_clans: "还不是任何一个部落里的成员。"

  achievements:
    last_earned: "最近取得的"
    amount_achieved: "数量"
    achievement: "成就"
    current_xp_prefix: ""
    current_xp_postfix: "当前总共"
    new_xp_prefix: ""
    new_xp_postfix: "取得的"
    left_xp_prefix: ""
    left_xp_infix: "直到等级"
    left_xp_postfix: ""

  account:
    payments: "支付方式"
    prepaid_codes: "预付费码"
    purchased: "已购买"
    subscription: "订阅"
    invoices: "票据"
    service_apple: "设备：苹果"
    service_web: "设备：网页"
    paid_on: "支付"
    service: "服务"
    price: "价格"
    gems: "宝石"
    active: "激活"
    subscribed: "已订阅"
    unsubscribed: "取消订阅"
    active_until: "已激活直到"
    cost: "花费"
    next_payment: "下次付款"
    card: "银行卡"
    status_unsubscribed_active: "您还没有订阅所以不会被收费，但您的帐号还可以正常使用"
    status_unsubscribed: "只要一个CodeCombat订阅，您就可以玩转全部新关卡，用遍全部英雄，物品，以及获得更多的宝石哦！"
    not_yet_verified: "尚未验证。"
    resend_email: "重发验证邮件"
    email_sent: "邮件已发送！检查您的收件箱"
    verifying_email: "验证邮箱地址中..."
    successfully_verified: "验证成功！"
    back_to_student_page: "回到学生页面"
    back_to_teacher_page: "访问我的班级"
    back_to_game: "探索更多关卡！"
    verify_error: "验证时出了点问题 :("

  account_invoices:
    amount: "金额（美元）"
    declined: "您的付款被拒"
    invalid_amount: "请输入美元金额。"
    not_logged_in: "登录或创建一个帐户来获得发票。"
    pay: "付费发票"
    purchasing: "购买中···"
    retrying: "服务器错误，重试中。"
    success: "支付成功。谢谢！"

  account_prepaid:
    purchase_code: "购买订阅码"
    purchase_code1: "订阅码可以为一个或多个CodeCombat账号兑换额外的订阅时间。"
    purchase_code2: "每个CodeCombat账号每次只能兑换一个订阅码。"
    purchase_code3: "订阅码时间会在账号现有的订阅时间基础上延长。"
    users: "玩家"
    months: "月份"
    purchase_total: "总共"
    purchase_button: "提交购买"
    your_codes: "你的订阅码"
    redeem_codes: "兑换订阅码"
    prepaid_code: "预购码"
    lookup_code: "查看预购码"
    apply_account: "使用到您的账户"
    copy_link: "您可以复制此代码链接发送给别人。"
    quantity: "数量"
    redeemed: "兑换"
    no_codes: "还没有兑换码！"
    you_can1: "您可以"
    you_can2: "购买一个预购码"
    you_can3: "使用在您的账户或者给其他人。"

  coppa_deny:
    text1: "迫不及待学习编程？"
    text2: "你的家长需要为你创建一个账号！若有疑问请发送邮件至 team@codecombat.com"
    close: "关闭窗口"

  loading_error:
    could_not_load: "载入失败"
    connection_failure: "连接失败"
    connection_failure_desc: "看起来你还没连接网络！检查网络连接后刷新此页面。"
    login_required: "需要登录"
    login_required_desc: "你需要登录才能访问此页面。"
    unauthorized: "您需要登录才行。您是不是禁用了cookie？"
    forbidden: "权限不足"
    forbidden_desc: "啊，这里没什么可看的。确保你登录了正确的账户，或者点击下面的链接继续编程！"
    not_found: "页面不存在"
    not_found_desc: "嗯，这里什么都没有。点击下面的链接继续编程！"
    not_allowed: "方法不允许。"
    timeout: "服务器超时"
    conflict: "资源冲突。"
    bad_input: "错误输入。"
    server_error: "服务器错误。"
    unknown: "未知错误"
    error: "错误"
    general_desc: "出了点问题，估计是我们的错。请您稍后刷新页面，或者点击下面的链接继续编程！"

  resources:
    level: "等级"
    patch: "补丁"
    patches: "补丁"
    system: "系统"
    systems: "系统"
    component: "组件"
    components: "组件"
    hero: "英雄"
    campaigns: "战役"

  concepts:
    advanced_strings: "高级字符串"
    algorithms: "算法"
    arguments: "参数"
    arithmetic: "四则运算"
    arrays: "数组"
    basic_syntax: "基本语法"
    boolean_logic: "布尔逻辑"
    break_statements: "Break语句"
    classes: "类"
    continue_statements: "Continue 语句"
    for_loops: "For循环"
    functions: "函数"
    graphics: "图形"
    if_statements: "If语句"
    input_handling: "输入处理"
    math_operations: "数学运算"
    object_literals: "对象常量"
    parameters: "参数"
    strings: "字符串"
    variables: "变量"
    vectors: "向量"
    while_loops: "While 循环"
    recursion: "递归"
#    basic_html: "Basic HTML" # TODO: these web-dev concepts will change, don't need to translate
#    basic_css: "Basic CSS"
#    basic_web_scripting: "Basic Web Scripting"
#    intermediate_html: "Intermediate HTML"
#    intermediate_css: "Intermediate CSS"
#    intermediate_web_scripting: "Intermediate Web Scripting"
#    advanced_html: "Advanced HTML"
#    advanced_css: "Advanced CSS"
#    advanced_web_scripting: "Advanced Web Scripting"
#    jquery: "jQuery"
#    bootstrap: "Bootstrap"

  delta:
    added: "被添加"
    modified: "被修改"
    not_modified: "未修改"
    deleted: "被删除"
    moved_index: "被移动的索引"
    text_diff: "文本变化"
    merge_conflict_with: "合并冲突发生在"
    no_changes: "没有变化"

  legal:
    page_title: "法律"
    opensource_intro: "CodeCombat是一个自由发挥，完全开源的项目。"
    opensource_description_prefix: "查看 "
    github_url: "我们的GitHub"
    opensource_description_center: "并做您想做的修改吧！CodeCombat是构筑在几十个开源项目之上的，然后我们都喜欢它们。看 "
    archmage_wiki_url: "我们大法师的维基页"
    opensource_description_suffix: " 看看是哪些人让这个游戏成为可能。"
    practices_title: "尊重最佳实践"
    practices_description: "这是我们对您的承诺，即玩家，尽管这在法律用语中略显不足。"
    privacy_title: "隐私"
    privacy_description: "我们不会泄露您的个人信息。"
    security_title: "安全"
    security_description: "我们竭力保证您的个人信息安全性。作为一个开源项目，任何人都可以检讨并改善我们自由开放的网站的安全性。"
    email_title: "电子邮件"
    email_description_prefix: "我们不会发给您垃圾邮件。通过"
    email_settings_url: "您的电子邮件设置"
    email_description_suffix: "或者我们发送的邮件中的链接，您可以随时更改您的偏好设置或者随时取消订阅。"
    cost_title: "花费"
    cost_description: "CodeCombat的所有核心关卡都是免费的，需要${{price}}美元/月的订阅费来访问额外关卡分支并获得{{gems}}宝石奖励每月。你可以通过勾选来取消，我们提供100%退款保证。"
    copyrights_title: "版权与许可"
    contributor_title: "贡献者许可协议"
    contributor_description_prefix: "所有对本网站或是GitHub代码库的贡献都依照我们的"
    cla_url: "贡献者许可协议（CLA）"
    contributor_description_suffix: "而这在您贡献之前就应该已经同意。"
    code_title: "代码 - MIT"
    code_description_prefix: "所有由CodeCombat拥有或是托管在CodeCombat.com的代码，在GitHub版本库或者CodeCombat.com数据库，以上许可协议都依照"
    mit_license_url: "MIT 许可证"
    code_description_suffix: "这包括所有CodeCombat公开的制作关卡用的系统和组件代码。"
    art_title: "美术和音乐 - Creative Commons"
    art_description_prefix: "所有共通的内容都在"
    cc_license_url: "Creative Commons Attribution 4.0 International License"
    art_description_suffix: "条款下公开。共通内容是指所有CodeCombat发布出来用于制作关卡的内容。这包括："
    art_music: "音乐"
    art_sound: "声效"
    art_artwork: "图画"
    art_sprites: "精灵"
    art_other: "所有制作关卡时公开的，不是代码的创造性产品。"
    art_access: "目前还没有简便通用的下载素材的方式。一般来讲，从网站上使用的URL下载，或者联系我们寻找帮助。当然您也可以帮我们扩展网站，让这些资源更容易下载。"
    art_paragraph_1: "关于署名，请说明并在使用处附近，或对媒体形式来说合适的地方提供一个CodeCombat.com 的链接。举例："
    use_list_1: "如果是用在电影里或者其他游戏里，请在制作人员表中加入CodeCombat.com。"
    use_list_2: "如果用在网站上，将链接在使用的地方附近，比如图片下面，或者一个您放置其他 Creative Commons 署名和开源软件协议的专门页面。如果您的内容明确提到关于CodeCombat，那您就不需要额外署名。"
    art_paragraph_2: "如果您使用的内容不是由CodeCombat制作，而是由CodeCombat.com 上其他的用户制作的，那您应该给他们署名。如果相应资源的页面上有署名指示，那您应该遵循那些指示。"
    rights_title: "版权所有"
    rights_desc: "所有关卡由他们自己版权所有。这包括"
    rights_scripts: "脚本"
    rights_unit: "单元配置"
    rights_writings: "作品"
    rights_media: "声音、音乐以及其他专门为某个关卡制作，而不对其他关卡开放的创造性内容"
    rights_clarification: "澄清：所有在关卡编辑器里公开用于制作关卡的资源都是在CC协议下发布的，而使用关卡编辑器制作，或者在关卡制作过程中上传的内容则不是。"
    nutshell_title: "简而言之"
    nutshell_description: "我们在关卡编辑器里公开的任何资源，您都可以在制作关卡时随意使用，但我们保留限制在CodeCombat.com 之上创建的关卡本身传播的权利，因为我们以后可能决定为它们收费。"
    canonical: "这篇说明的英文版本是权威版本。如果各个翻译版本之间有任何冲突，请以英文版为准。"
    third_party_title: "第三方服务"
    third_party_description: "CodeCombat使用了下列第三方服务（除了别的以外）："

  ladder_prizes:
    title: "竞标赛奖项" # This section was for an old tournament and doesn't need new translations now.
    blurb_1: "这些奖项将会奖励，依据"
    blurb_2: "锦标赛规则"
    blurb_3: ", 给顶尖的人类和怪物玩家。"
    blurb_4: "两队表示获得的奖励将会是两倍!"
    blurb_5: "(将有两个第一名, 两个第二名, 以此类推。)"
    rank: "排名"
    prizes: "奖项"
    total_value: "总价值"
    in_cash: "现金"
    custom_wizard: "定制CodeCombat巫师"
    custom_avatar: "定制CodeCombat头像"
    heap: "给六个月的\"Startup\"访问"
    credits: "信用卡"
    one_month_coupon: "优惠: 选择 Rails 或者 HTML"
    one_month_discount: "折扣 30% : 选择 Rails 或者 HTML"
    license: "许可证"
    oreilly: "您选择的电子书"

  calendar:
    year: "年"
    day: "日"
    month: "月"
    january: "一月"
    february: "二月"
    march: "三月"
    april: "四月"
    may: "五月"
    june: "六月"
    july: "七月"
    august: "八月"
    september: "九月"
    october: "十月"
    november: "十一月"
    december: "十二月"
