module.exports = nativeDescription: "繁體中文", englishDescription: "Chinese (Traditional)", translation:
  new_home:
    slogan: "最迷人的程式設計學習遊戲"
    classroom_edition: "課堂版本"
    learn_to_code: "學習寫程式碼"
    teacher: "老師"
    student: "學生"
    play_now: "馬上遊玩"
    im_a_teacher: "我是老師"
    im_a_student: "我是學生"
    learn_more: "了解更多"
    classroom_in_a_box: "在一個盒子中的電腦科學教室。"
    codecombat_is: "CodeCombat是一個讓<strong>學生</strong>透過進行遊戲來學習電腦科學的平台。"
    our_courses: "我們的課程經過特別的遊戲測試來<strong>超越教室教學</strong>，甚至是超越一些先前沒有編程經驗的老師。"
    top_screenshots_hint: "學生們寫程式碼並且隨時觀看他們的更新。"
    designed_with: "在心中與老師們一起設計"
    real_code: "真實的、鍵入的程式碼"
    from_the_first_level: "從最初的級別"
    getting_students: "讓學生們用最快的速度鍵入程式碼，這是學習程式設計語法和正確結構的關鍵。"
    educator_resources: "教學資源"
    course_guides: "和課程導引"
    teaching_computer_science: "教電腦科學不需要一個昂貴的學位，因為我們提供了工具來支援各種背景的教學者。"
    accessible_to: "提供給"
    everyone: "每一個人"
    democratizing: "使學習寫程式碼的過程普及化是我們的核心理念，每個人都應該有機會學習寫程式。"
    forgot_learning: "我認為他們甚至忘記了他們正在學東西。"
    wanted_to_do: "寫程式一直是我想要做的事情，而我從不認為我會在學校裡學到它們。"
    why_games: "為何從遊戲中學習是很重要的呢?"
    games_reward: "遊戲鼓勵我們良性競爭。"
    encourage: "遊戲是一個促進互動、發現及嘗試錯誤的媒介，一款好的遊戲可以試煉玩家並隨著時間精進技巧，這個過程與學生在學校學習中所經歷到的一樣重要。"
    excel: "遊戲在獎勵方面勝出"
    struggle: "良性競爭"
    kind_of_struggle: "那種競爭使學習引人入勝，並且"
    motivating: "有動力"
    not_tedious: "不乏味。"
    gaming_is_good: "研究指出玩遊戲對小孩的大腦是有幫助的。(這是真的!)"
    game_based: "在基於遊戲的學習系統中這是"
    compared: "相符的。"
    conventional: "與傳統評定方式比較有很明顯的不同，「遊戲在保存知識和保持專注上是有幫助的」。"
    perform_at_higher_level: "展現更高的成就水平"
    feedback: "遊戲中也提供了及時回饋，讓學生去調整他們的解決途徑，並且更完整的了解學習內容，而不是被解答的正確或是不正確限制住。"
    real_game: "這是一個真正的遊戲，利用真正寫入程式碼來遊玩。"
    great_game: "一個很棒的遊戲不只有徽章和成就--它更是玩家的旅程、設計優良的關卡，以及藉由信心和幫助完成挑戰的能力。"
    agency: "CodeCombat是一個能給予玩家協助以及信心的遊戲，藉由我們強大的程式碼鍵入引擎，可以幫助新手或是進階的學生寫出正確的、有效的程式碼。"
    request_demo_title: "讓您的學生從今天開始遊玩吧!"
    request_demo_subtitle: "申請一個demo示範版本，並且讓您的學生在一個小時之內就能上手。"
    get_started_title: "現在就設立您的班級。"
    get_started_subtitle: "設立一個班級、加入您的學生，並在他們學習電腦科學的過程中掌握他們的進度。"
    request_demo: "申請一個demo示範版本"
    setup_a_class: "設立一個班級"
    have_an_account: "您是否擁有一個帳號?"
    logged_in_as: "您現在登入的身分為"
    computer_science: "全年齡向的電腦科學課程"
    show_me_lesson_time: "顯示課程預估時間："
    curriculum: "課程總共時數："
    ffa: "學生免費"
    lesson_time: "課程時間："
    coming_soon: "敬請期待!"
    courses_available_in: "包含JavaScript, Python,和Java的課程(敬請期待!)" # {change}
    boast: "擁有足夠複雜的關卡，同時能吸引玩家以及程式撰寫者。"
    winning: "成功的結合RPG遊戲和程式設計作業，造就了對孩子有善且能樂在其中的教育環境。"
    run_class: "如今想要在學校進行一堂電腦科學的課程，您不再需要有電腦科學的背景。"
    goto_classes: "進入我的班級"
    view_profile: "瀏覽我的帳號"
    view_progress: "瀏覽進度"
#    go_to_courses: "Go to My Courses"
    want_coco: "想要在您的學校進行CodeCombat嗎?"

  nav:
    play: "返回地圖" # The top nav bar entry where players choose which levels to play
    community: "社群"
    courses: "課程"
    blog: "官方部落格"
    forum: "論壇"
    account: "帳號"
    my_account: "我的帳號"
    profile: "帳號資料"
    home: "首頁"
    contribute: "幫助我們"
    legal: "版權聲明"
#    privacy: "Privacy"
    about: "關於"
    contact: "聯繫我們"
    twitter_follow: "在 Twitter 關注"
    teachers: "教師"
    students: "學生"
    careers: "招聘"
    facebook: "Facebook臉書"
    twitter: "Twitter推特"
    create_a_class: "成立一個班級"
    other: "其他"
    learn_to_code: "學習寫程式碼!"
    toggle_nav: "切換導覽"
    jobs: "工作"
    schools: "學校"
    get_involved: "親身參與"
    open_source: "開源 (GitHub)"
    support: "取得幫助"
    faqs: "FAQs常見問題"
    help_pref: "需要協助嗎? 寫封Email給我們"
    help_suff: "然後我們會與您接觸!"
#    resource_hub: "Resource Hub"

  modal:
    close: "關閉"
    okay: "好"

  not_found:
    page_not_found: "找不到網頁"

  diplomat_suggestion:
    title: "幫助我們翻譯CodeCombat" # This shows up when a player switches to a non-English language using the language selector.
    sub_heading: "我們需要您的語言技能"
    pitch_body: "我們開發了CodeCombat的英文版，但是現在我們的玩家遍佈全球。很多人想玩中文版的，卻不會說英文，所以如果您中英文都會，請考慮一下參加我們的翻譯工作，幫忙把 CodeCombat 網站還有所有的關卡翻譯成中文（繁體）。"
    missing_translations: "直至所有正體中文的翻譯完畢，當無法提供正體中文時還會以英文顯示。"
    learn_more: "關於成為外交官"
    subscribe_as_diplomat: "註冊成為外交官"

  play:
    play_as: "扮演" # Ladder page
    compete: "競賽!" # Course details page
    spectate: "觀戰" # Ladder page
    players: "玩家" # Hover over a level on /play
    hours_played: "已玩時數" # Hover over a level on /play
    items: "物品" # Tooltip on item shop button from /play
    unlock: "解鎖" # For purchasing items and heroes
    confirm: "確認"
    owned: "擁有" # For items you own
    locked: "鎖定"
    purchasable: "可購買" # For a hero you unlocked but haven't purchased
    available: "可用"
    skills_granted: "將習得技能" # Property documentation details
    heroes: "英雄" # Tooltip on hero shop button from /play
    achievements: "成就" # Tooltip on achievement list button from /play
    settings: "設定" # Tooltip on settings button from /play
    poll: "投票" # Tooltip on poll button from /play
    next: "下一步" # Go from choose hero to choose inventory before playing a level
    change_hero: "更換英雄" # Go back from choose inventory to choose hero
    buy_gems: "購買寶石"
    subscription_required: "訂閱限定"
    anonymous: "匿名玩家"
    level_difficulty: "難度"
    play_classroom_version: "遊玩教室版本" # Choose a level in campaign version that you also can play in one of your courses
    campaign_beginner: "新手指南"
    awaiting_levels_adventurer_prefix: "我們每週將釋出新的關卡。" # {change}
    awaiting_levels_adventurer: "註冊成為冒險家"
    awaiting_levels_adventurer_suffix: "成為第一個挑戰新關卡的冒險家吧！"
    adjust_volume: "調整音量"
    campaign_multiplayer: "多人競技場"
    campaign_multiplayer_description: "…在這裡您可以和其他玩家進行對戰。"

  code:
    if: "若是" # Keywords--these translations show up on hover, so please translate them all, even if it's kind of long. (In the code editor, they will still be in English.)
    else: "否則"
    elif: "否則若是"
    while: "成立時循環"
    loop: "循環"
    for: "範圍內循環"
    break: "停止循環"
    continue: "繼續下個循環"
    pass: "跳過"
    return: "返回函數值"
    then: "那麼"
    do: "進行語句"
    end: "結束語句"
    function: "函數"
    def: "定義"
    var: "變數"
    self: "自身"
    hero: "英雄"
    this: "自身"
    or: "或者"
    "||": "或者"
    and: "並且"
    "&&": "並且"
    not: "不是"
    "!": "不是"
    "=": "指派"
    "==": "等於"
    "===": "完全等於"
    "!=": "不等於"
    "!==": "不完全等於"
    ">": "大於"
    ">=": "大於或等於"
    "<": "小於"
    "<=": "小於或等於"
    "*": "乘上"
    "/": "除以"
    "+": "加上"
    "-": "減掉"
    "+=": "加上並指派"
    "-=": "減掉並指派"
    True: "為真"
    true: "為真"
    False: "為假"
    false: "為假"
    undefined: "未定義"
    null: "空值"
    nil: "零值"
    None: "無值"

  share_progress_modal:
    blurb: "您正在創造偉大的旅程！告訴您的家長，您從CodeCombat學到了什麼！" # {change}
    email_invalid: "郵件地址無效"
    form_blurb: "在底下輸入家長的郵件，讓我們展示給他們！"
    form_label: "郵件地址"
    placeholder: "郵件地址"
    title: "出色的作品，學徒"

  login:
    sign_up: "註冊"
#    email_or_username: "Email or username"
    log_in: "登入"
    logging_in: "登入中"
    log_out: "登出"
    forgot_password: "忘記密碼？"
    authenticate_gplus: "以 Google+ 帳號登入"
    load_profile: "讀取 Google+ 個人簡介"
    finishing: "結束"
    sign_in_with_facebook: "使用 Facebook 登入"
    sign_in_with_gplus: "使用 Google+ 登入"
    signup_switch: "建立一個帳號"

  signup:
#    create_student_header: "Create Student Account"
#    create_teacher_header: "Create Teacher Account"
#    create_individual_header: "Create Individual Account"
    email_announcements: "通過郵件接收通知" # {change}
    creating: "帳號建立中…"
    sign_up: "註冊"
    log_in: "登入"
    required: "在這麼做之前必須先登入。"
    login_switch: "已經有申請帳號了嗎？"
    school_name: "就讀學校及所在城市"
    optional: "選填"
    school_name_placeholder: "範例：XX中學，台北"
#    connect_with: "Connect with:"
    connected_gplus_header: "您已經成功與Google+連結!"
    connected_gplus_p: "完成註冊以使用Google+帳號登入。"
    gplus_exists: "您已經有一個與Google+連結的帳號!"
    connected_facebook_header: "您已經成功與FB臉書連結!"
    connected_facebook_p: "完成註冊以使用FB臉書帳號登入"
    facebook_exists: "您已經有一個與FB臉書連結的帳號!"
    hey_students: "學生們，請輸入老師所公佈的班級代碼"
    birthday: "生日"
#    parent_email_blurb: "We know you can't wait to learn programming &mdash; we're excited too! Your parents will receive an email with further instructions on how to create an account for you. Email {{email_link}} if you have any questions."
#    classroom_not_found: "No classes exist with this Class Code. Check your spelling or ask your teacher for help."
#    checking: "Checking..."
#    account_exists: "This email is already in use:"
#    sign_in: "Sign in"
#    email_good: "Email looks good!"
#    name_taken: "Username already taken! Try {{suggestedName}}?"
#    name_available: "Username available!"
#    name_is_email: "Username may not be an email"
#    choose_type: "Choose your account type:"
#    teacher_type_1: "Teach programming using CodeCombat!"
#    teacher_type_2: "Set up your class"
#    teacher_type_3: "Access Course Guides"
#    teacher_type_4: "View student progress"
#    signup_as_teacher: "Sign up as a Teacher"
#    student_type_1: "Learn to program while playing an engaging game!"
#    student_type_2: "Play with your class"
#    student_type_3: "Compete in arenas"
#    student_type_4: "Choose your hero!"
#    student_type_5: "Have your Class Code ready!"
#    signup_as_student: "Sign up as a Student"
#    individuals_or_parents: "Individuals & Parents"
#    individual_type: "For players learning to code outside of a class. Parents should sign up for an account here."
#    signup_as_individual: "Sign up as an Individual"
#    enter_class_code: "Enter your Class Code"
#    enter_birthdate: "Enter your birthdate:"
#    parent_use_birthdate: "Parents, use your own birthdate."
#    ask_teacher_1: "Ask your teacher for your Class Code."
#    ask_teacher_2: "Not part of a class? Create an "
#    ask_teacher_3: "Individual Account"
#    ask_teacher_4: " instead."
#    about_to_join: "You're about to join:"
#    enter_parent_email: "Enter your parent’s email address:"
#    parent_email_error: "Something went wrong when trying to send the email. Check the email address and try again."
#    parent_email_sent: "We’ve sent an email with further instructions on how to create an account. Ask your parent to check their inbox."
#    account_created: "Account Created!"
#    confirm_student_blurb: "Write down your information so that you don't forget it. Your teacher can also help you reset your password at any time."
#    confirm_individual_blurb: "Write down your login information in case you need it later. Verify your email so you can recover your account if you ever forget your password - check your inbox!"
#    write_this_down: "Write this down:"
#    start_playing: "Start Playing!"
#    sso_connected: "Successfully connected with:"
#    select_your_starting_hero: "Select Your Starting Hero:"
#    you_can_always_change_your_hero_later: "You can always change your hero later."

  recover:
    recover_account_title: "復原帳號"
    send_password: "送出新密碼"
    recovery_sent: "密碼重置的信件已寄出"

  items:
    primary: "主手裝備"
    secondary: "副手裝備"
    armor: "裝甲"
    accessories: "飾品"
    misc: "輔助"
    books: "書籍"

  common:
    back: "向後瀏覽" # When used as an action verb, like "Navigate backward"
#    coming_soon: "Coming soon!"
    continue: "繼續前進" # When used as an action verb, like "Continue forward"
#    default_code: "Default Code"
    loading: "載入中…"
#    overview: "Overview"
#    solution: "Solution"
#    intro: "Intro"
    saving: "儲存中…"
    sending: "發送中…"
    send: "送出"
#    sent: "Sent"
    cancel: "取消"
    save: "存檔"
    publish: "發佈"
    create: "創造"
    fork: "分支"
    play: "進入戰役" # When used as an action verb, like "Play next level"
    retry: "重試"
    actions: "行為"
    info: "介紹"
    help: "求助"
    watch: "關注"
    unwatch: "取消關注"
    submit_patch: "送出修補"
    submit_changes: "送出修改"
    save_changes: "保存更改"
    required_field: "需要的部分" # {change}

  general:
    and: "和"
    name: "名字"
    date: "日期"
    body: "正文"
    version: "版本"
    pending: "處理中"
    accepted: "已接受"
    rejected: "未接受"
    withdrawn: "已撤回"
    accept: "接受"
    reject: "拒絕"
    withdraw: "撤回"
    submitter: "提交者"
    submitted: "已提交"
    commit_msg: "送出訊息"
    version_history: "版本歷史"
    version_history_for: "版本歷史: "
    select_changes: "選擇下面兩項修改來觀察不同"
    undo_prefix: "取消"
    undo_shortcut: "(Ctrl+Z)"
    redo_prefix: "重做"
    redo_shortcut: "(Ctrl+Shift+Z)"
    play_preview: "播放預覽本關卡"
    result: "結果"
    results: "結果"
    description: "描述"
    or: "或"
    subject: "主題"
    email: "郵件"
    password: "密碼"
    confirm_password: "確認密碼"
    message: "訊息"
    code: "程式碼"
    ladder: "天梯"
    when: "何時"
    opponent: "對手"
    rank: "排名"
    score: "分數"
    win: "獲勝"
    loss: "失敗"
    tie: "平手"
    easy: "簡單"
    medium: "中等"
    hard: "困難"
    player: "玩家"
    player_level: "等級" # Like player level 5, not like level: Dungeons of Kithgard
    warrior: "武士"
    ranger: "搜索兵"
    wizard: "巫師"
    first_name: "名"
    last_name: "姓"
#    last_initial: "Last Initial"
    username: "使用者名稱"

  units:
    second: "秒"
    seconds: "秒"
    minute: "分鐘"
    minutes: "分鐘"
    hour: "小時"
    hours: "小時"
    day: "日"
    days: "日"
    week: "週"
    weeks: "週"
    month: "個月"
    months: "個月"
    year: "年"
    years: "年"

  play_level:
    level_complete: "關卡完成"
    completed_level: "完成關卡："
    course: "課程："
    done: "完成"
    next_level: "下一個關卡："
    next_game: "下一個遊戲"
#    language: "Language"
#    languages: "Languages"
#    programming_language: "Programming language"
    show_menu: "顯示遊戲選單"
    home: "首頁" # Not used any more, will be removed soon.
    level: "關卡" # Like "Level: Dungeons of Kithgard"
    skip: "跳過"
    game_menu: "遊戲選單"
    guide: "指南"
    restart: "重新開始"
    goals: "目標"
    goal: "目標"
    running: "執行中…"
    success: "成功！"
    incomplete: "未完成"
    timed_out: "時間用盡"
    failing: "失敗"
    reload: "重新載入"
    reload_title: "重新載入程式碼？"
    reload_really: "確定重設所有的程式碼？"
    reload_confirm: "重設所有程式碼"
    victory: "勝利"
    victory_title_prefix: ""
    victory_title_suffix: "完成"
    victory_sign_up: "保存進度"
    victory_sign_up_poke: "想保存您的程式碼？建立一個免費帳號吧！"
    victory_rate_the_level: "評估關卡：" # {change}
    victory_return_to_ladder: "返回升級比賽模式"
    victory_saving_progress: "儲存進度"
    victory_go_home: "返回首頁"
    victory_review: "給我們回饋！"
    victory_review_placeholder: "關卡如何？"
    victory_hour_of_code_done: "您完成了嗎？"
    victory_hour_of_code_done_yes: "是的，我完成了我的程式碼！"
    victory_experience_gained: "取得經驗值"
    victory_gems_gained: "取得寶石"
    victory_new_item: "新的物品"
#    victory_new_hero: "New Hero"
    victory_viking_code_school: "太厲害了，您剛完成了非常困難的關卡！如果您想成為一個軟體開發人員，您就應該去試一下Viking Code School。在這裡您可以把您的知識增長到另一個台階。只需要14個星期您就能成為一個專業的網頁開發人員。"
    victory_become_a_viking: "成為一個維京人。"
    victory_no_progress_for_teachers: "老師們不能保存進度，但是您可以將自己的帳號加入班級作為學生來保存進度。"
    guide_title: "指南"
    tome_cast_button_run: "運行"
    tome_cast_button_running: "運行中"
    tome_cast_button_ran: "已運行"
    tome_submit_button: "送出"
    tome_reload_method: "重新載入該方法的原程式碼" # {change}
    tome_available_spells: "可用的法術"
    tome_your_skills: "您的技能"
    tome_current_method: "現在的方法"
#    hints: "Hints"
#    hints_title: "Hint {{number}}"
    code_saved: "程式碼已保存"
    skip_tutorial: "跳過 (esc)"
    keyboard_shortcuts: "快捷鍵"
    loading_ready: "準備！"
    loading_start: "開始戰役"
    problem_alert_title: "修正您的程式碼"
    time_current: "現在："
    time_total: "最大值："
    time_goto: "前往："
    non_user_code_problem_title: "無法加載關卡"
    infinite_loop_title: "檢測到無限迴圈"
    infinite_loop_description: "建立世界的初始程式碼還沒有運行完畢。這可能是真的很慢或出現無限迴圈，或者存在一個bug。您可以嘗試再次運行這段程式碼，或重置程式碼為默認狀態。如果還是解決不了問題，請聯繫我們。"
    check_dev_console: "您也可以打開開發者界面看一下有什麼可能出錯了。"
    check_dev_console_link: "(說明)"
    infinite_loop_try_again: "再試一次"
    infinite_loop_reset_level: "重置關卡"
    infinite_loop_comment_out: "在我的程式碼中加入注解"
    tip_toggle_play: "使用 Ctrl+P 切換 播放/暫停。"
    tip_scrub_shortcut: "Ctrl+[ 快退；Ctrl+] 快進。"
    tip_guide_exists: "點擊頁面上方的指南，可獲得更多有用的訊息。"
    tip_open_source: "「CodeCombat」100% 開源！"
    tip_tell_friends: "喜歡Codecombat？那就把它介紹給朋友！"
    tip_beta_launch: "「CodeCombat」在2013年10月進入 BETA 測試。"
    tip_think_solution: "思考解決方法而不是問題。"
    tip_theory_practice: "理論上，理論和實作之間是沒有區別。但是實作上，這兩者是有區別的。 - Yogi Berra"
    tip_error_free: "有兩種方式可以寫出沒有錯誤的程式；但只有第三種可以達到預期效果。 - Alan Perlis"
    tip_debugging_program: "如果除錯是一種清除錯誤的過程，那麼編寫程式就是一種製造錯誤的過程。 - Edsger W. Dijkstra"
    tip_forums: "前往論壇並且告訴我們您所思考的！"
    tip_baby_coders: "在未來，就算小孩也能成為大法師。"
    tip_morale_improves: "直到士氣提升之前，載入的動作將持續。"
    tip_all_species: "我們相信所有民族都有平等的機會學習編寫程式。"
    tip_reticulating: "網格狀鋸齒(指卡頓現象)"
    tip_harry: "巫師，"
    tip_great_responsibility: "隨著擁有強大的編程技巧，除錯的責任將越大。"
    tip_munchkin: "如果您不吃掉您的蔬菜，那些矮人將在您睡覺時找到您。"
    tip_binary: "只有2種人在這世上：那些懂2進位的，和那些不懂的。"
    tip_commitment_yoda: "一個程式員必須擁有強烈的責任感和一顆認真的心。 ~ Yoda《星際大戰》"
    tip_no_try: "做，或者不做。這邊不存在嘗試的選項。 - Yoda《星際大戰》"
    tip_patience: "年輕的學徒，您必須擁有耐心。 - Yoda《星際大戰》"
    tip_documented_bug: "一個寫在文件裡的錯誤不是錯誤；它是功能。"
    tip_impossible: "事情總是看起來不可能直到它成真那刻。 - Nelson Mandela"
    tip_talk_is_cheap: "多說無益，放「碼」過來。 - Linus Torvalds"
    tip_first_language: "您經歷的第一門程式語言是最慘痛的事情。 - Alan Kay"
    tip_hardware_problem: "Q: 換一顆燈泡需要多少位程式員？  A: 一位也不用，它是個硬體問題。"
    tip_hofstadters_law: "Hofstadter 定律：完成一件複雜的事花費的時間總是超乎預期，甚至您早已知道這個現象( Hofstadter 定律)。"
    tip_premature_optimization: "過早的優化是萬惡之源。 - Donald Knuth"
    tip_brute_force: "當您游移不定時，就是用暴力解。 - Ken Thompson"
    tip_extrapolation: "只有 2 種人在這世上：一種人是能夠根據不完整資訊去推斷…"
    tip_superpower: "編程讓我們最接近擁有超能力。"
    tip_control_destiny: "在真正的開源，您有權利控制自己的命運。 - Linus Torvalds"
    tip_no_code: "在速度上，沒有任何程式碼可以超過沒有程式碼。"
    tip_code_never_lies: "程式碼從不說謊，但註釋偶爾會。 — Ron Jeffries"
    tip_reusable_software: "在軟體被重複利用之前，它必須能夠使用。"
    tip_optimization_operator: "每種語言都有一個優化的運算符號。對大部份而言，那符號是‘//’。"
    tip_lines_of_code: "使用程式碼行數來管理開發進度就好像使用秤重器來管理建造飛機。 — Bill Gates"
    tip_source_code: "我想改變世界，但他們不給我原始碼。"
    tip_javascript_java: "Java 和 JavaScript 的關係就好比馬和馬雲。 - Chris Heilmann"
    tip_move_forward: "不論做什麼，保持前進。 - Martin Luther King Jr."
    tip_google: "發現一個您不能解決的問題？Google它！"
    tip_adding_evil: "增加一個邪惡掐揑。"
    tip_hate_computers: "對於覺得自己恨透了電腦的那群人。其實他們真正應該恨的是糟糕的程式員。 - Larry Niven"
    tip_open_source_contribute: "您可以幫助「CodeCombat」變得更好！"
    tip_recurse: "迭代者人也，遞歸者神也 - L. Peter Deutsch"
    tip_free_your_mind: "放下一切私心雜念，丟棄害怕、疑問和拒信，解放您的思維。 - 莫菲斯《駭客任務》"
    tip_strong_opponents: "即使是最强大的對手也有弱點的。 - 宇智波鼬《火影忍者》"
    tip_paper_and_pen: "在您開始編碼之前，您可以隨時用一張紙和一支筆作計劃。"
    tip_solve_then_write: "要先想清楚問題如何解決，再進行編碼的動作。 - John Johnson"
    tip_compiler_ignores_comments: "我常常覺得編譯器忽視了我的註釋。"
    tip_understand_recursion: "了解遞歸的唯一方法是了解遞歸。"
    tip_life_and_polymorphism: "開放源碼就像是一個完全多樣異質的結構：海納百川。"
    tip_mistakes_proof_of_trying: "程式碼中的錯誤證明了你曾經嘗試過。"
    tip_adding_orgres: "包圍敵人!"
    tip_sharpening_swords: "磨利劍鋒。"
    tip_ratatouille: "你不需要讓任何人以你的出身決定你的極限，你唯一的限制就是你的心靈。廚神Gusteau《料理鼠王》 "
    tip_nemo: "想知道當生活使你消沉時，你必須做甚麼嗎？一直游，一直游就對了。多莉《海底總動員》"
    tip_internet_weather: "搬來網路世界吧，這裡十分不錯。我們住的地方天氣總是很好。 - John Green"
    tip_nerds: "呆子可以被愛填滿，像在椅子上跳上跳下不能控制自己般的去愛。 - John Green"
    tip_self_taught: "我自學了90%我學過的東西，這是很正常的! - Hank Green"
    tip_luna_lovegood: "別擔心，你只是跟我一樣理智。 - 露娜·羅古德《哈利波特》"
    tip_good_idea: "找到好點子最好的方法是先找到一大堆點子。 - Linus Pauling"
    tip_programming_not_about_computers: "電腦科學之於電腦不外乎於望遠鏡之於天文學。 - Edsger Dijkstra"
    tip_mulan: "相信你可以做到，然後你就會做到。 - Mulan"

#  play_game_dev_level:
#    created_by: "Created by {{name}}"
#    how_to_play_title: "How to play:"
#    how_to_play_1: "Use the mouse to control the hero!"
#    how_to_play_2: "Click anywhere on the map to move to that location."
#    how_to_play_3: "Click on the ogres to attack them."
#    restart: "Restart Level"
#    play: "Play Level"
#    play_more_codecombat: "Play More CodeCombat"
#    default_student_instructions: "Click to control your hero and win your game!"
#    back_to_coding: "Back to Coding"

  game_menu:
    inventory_tab: "道具欄"
    save_load_tab: "保存/載入"
    options_tab: "選項"
    guide_tab: "導引"
    guide_video_tutorial: "影片教學"
    guide_tips: "提示"
    multiplayer_tab: "多人遊戲"
    auth_tab: "註冊"
    inventory_caption: "裝備您的英雄"
    choose_hero_caption: "選擇英雄，語言"
    save_load_caption: "…觀看歷史紀錄"
    options_caption: "設置設定"
    guide_caption: "文件與小撇步"
    multiplayer_caption: "跟朋友一起玩！"
    auth_caption: "儲存進度"

  leaderboard:
    view_other_solutions: "查看其他解法"
    scores: "分數"
    top_players: "頂級玩家由"
    day: "今天"
    week: "這週"
    all: "長期以來"
    time: "時間"
    damage_taken: "遭受的傷害"
    damage_dealt: "造成的傷害"
    difficulty: "困難度"
    gold_collected: "收集的黃金"

  inventory:
    equipped_item: "已裝備"
    required_purchase_title: "必要的"
    available_item: "可使用的"
    restricted_title: "被限制的"
    should_equip: "連點物品兩下可裝備"
    equipped: "(已裝備)"
    locked: "(需解鎖)"
    restricted: "(受本關卡限制)"
    equip: "裝備"
    unequip: "脫下"

  buy_gems:
    few_gems: "一些寶石"
    pile_gems: "一堆寶石"
    chest_gems: "一箱寶石"
    purchasing: "購買中…"
    declined: "您的信用卡被拒絕"
    retrying: "伺服器錯誤，正在重試。"
    prompt_title: "寶石不足"
    prompt_body: "想要取得更多？"
    prompt_button: "進入商店"
    recovered: "先前購買的寶石已回復，請重新載入頁面。"
    price: "x{{gems}} / 月"

  subscribe:
    comparison_blurb: "訂閱 CodeCombat 來磨練您的技巧！"
    feature1: "__levelsCount__ 個以上的基本關卡分佈在__worldsCount__張地圖中" # {change}
    feature2: "__heroesCount__ 個強力的<strong>新英雄</strong>並且每位都有不同技能！" # {change}
    feature3: "__bonusLevelsCount__ 個以上的額外關卡" # {change}
    feature4: "每個月<strong>{{gems}}顆額外寶石</strong>！"
    feature6: "高級郵件幫助"
    feature7: "私密<strong>部落</strong>"
    feature8: "<strong>沒有廣告!</strong>"
    free: "免費"
    month: "月"
    must_be_logged: "您需要先登入。請先註冊或者在上方的目錄中點擊登入。"
    subscribe_title: "訂閱"
    unsubscribe: "取消訂閱"
    confirm_unsubscribe: "確認訂閱"
    never_mind: "沒關係，我們依然喜歡您"
    thank_you_months_prefix: "感謝您這幾個"
    thank_you_months_suffix: "月來的支持"
    thank_you: "感謝您支持CodeCombat"
    sorry_to_see_you_go: "真捨不得您離開阿！請讓我們知道我們如何做得更好。"
    unsubscribe_feedback_placeholder: "我們做錯了哪些呢？"
    parent_button: "請詢問您的父母"
    parent_email_description: "我們將寄信向他們說明，所以他們能放心幫您訂閱 CodeCombat。"
    parent_email_input_invalid: "信箱位址無效"
    parent_email_input_label: "父母的信箱位址"
    parent_email_input_placeholder: "輸入父母的信箱"
    parent_email_send: "發送信件"
    parent_email_sent: "已寄出信件！"
    parent_email_title: "您父母的信箱是？"
    parents: "致家長"
    parents_title: "親愛的家長：您的孩子將會學習編程。您會支持孩子發展嗎？"
    parents_blurb1: "您的孩子已經玩了 __nLevels__ 關，並且學習了編程基礎。請您為了培養他們的興趣而給他們訂閱，他們能繼續玩下去。"
    parents_blurb1a: "不要懷疑計算機編程能力將是您的孩子未來作為一個成年人的基本技能。到2020年，77%的工作將會需要編碼能力，並且軟體工程師將在世界各地成為高需求職業。您要知道計算機科學是收入最高的大學學歷。"
    parents_blurb2: "每月支付 ${{price}} 美金，他們每週將獲得新的挑戰以及可以透過信件取得專業程式員的幫助。"
    parents_blurb3: "沒有風險：保證 100% 退費，一步驟取消訂閱。"
    payment_methods: "付費方法"
    payment_methods_title: "可接受的付款方式"
    payment_methods_blurb1: "我們現有的付費方式有信用卡和支付寶" # {change}
    payment_methods_blurb2: "如果您想用其他付費方式，請聯繫我們"
    sale_button: "促銷！"
    sale_button_title: "年費訂閱能節省 ${{discount}} 的費用"
    stripe_description: "每月訂閱"
    stripe_description_year_sale: "年費訂閱 (${{discount}} 優惠)" # {change}
    subscription_required_to_play: "您將需要訂閱來開啟這關。"
    unlock_help_videos: "訂閱後才可以解鎖教學影片喔！。"
    personal_sub: "個人訂閱" # Accounts Subscription View below
    loading_info: "正在加載訂閱內容…"
    managed_by: "管理"
    will_be_cancelled: "將被取消"
    currently_free: "您目前有一個免費訂閱"
    currently_free_until: "您目前有一個訂閱，直到"
    was_free_until: "您有過一個免費訂閱，直到"
    managed_subs: "管理訂閱"
    subscribing: "訂閱中…"
    current_recipients: "當前收件人"
    unsubscribing: "取消訂閱中…" # {change}
    subscribe_prepaid: "點擊訂閱來使用預付代碼"
    using_prepaid: "使用預付費代碼進行每月訂閱"

  choose_hero:
    choose_hero: "選擇您的英雄"
    programming_language: "程式語言"
    programming_language_description: "您要使用哪個程式語言？"
    default: "預設"
    experimental: "測試中"
    python_blurb: "簡單且強大，適合新手跟專家。"
    javascript_blurb: "網頁程式語言。(不是 Java 喔)"
    coffeescript_blurb: "懶人版的 Javascript。"
    lua_blurb: "許多遊戲引擎支援的程式語言。"
    java_blurb: "(訂閱者限定)Android和企業"
    status: "狀態"
    weapons: "武器"
    weapons_warrior: "刀劍 - 短距離、非魔法"
    weapons_ranger: "十字弓、槍砲 - 長距離、非魔法"
    weapons_wizard: "魔杖、法杖 - 長距離、魔法"
    attack: "傷害" # Can also translate as "Attack"
    health: "血量"
    speed: "速度"
    regeneration: "恢復"
    range: "距離" # As in "attack or visual range"
    blocks: "格擋" # As in "this shield blocks this much damage"
    backstab: "背刺" # As in "this dagger does this much backstab damage"
    skills: "技能"
    attack_1: "造成"
    attack_2: "例表"
    attack_3: "武器傷害。"
    health_1: "收穫"
    health_2: "例表"
    health_3: "裝備血量。"
    speed_1: "移動速度"
    speed_2: "公尺每秒。"
    available_for_purchase: "可以購買" # Shows up when you have unlocked, but not purchased, a hero in the hero store
    level_to_unlock: "解鎖關卡：" # Label for which level you have to beat to unlock a particular hero (click a locked hero in the store to see)
    restricted_to_certain_heroes: "特定英雄才可遊玩此關卡。"

  skill_docs:
    function: "功能" # skill types
    method: "方法"
    snippet: "片段"
    number: "數字"
    array: "陣列"
    object: "物件"
    string: "串連"
    writable: "可編輯" # Hover over "attack" in Your Skills while playing a level to see most of this
    read_only: "唯讀"
    action: "命令"
    spell: "技能"
    action_name: "名稱"
    action_cooldown: "釋放時間"
    action_specific_cooldown: "冷卻時間"
    action_damage: "傷害"
    action_range: "距離"
    action_radius: "範圍"
    action_duration: "持續"
    example: "範例"
    ex: "ex" # Abbreviation of "example"
    current_value: "現在數值"
    default_value: "預設數值"
    parameters: "參數"
#    required_parameters: "Required Parameters"
#    optional_parameters: "Optional Parameters"
    returns: "回傳"
    granted_by: "賦予"

  save_load:
    granularity_saved_games: "已儲存"
    granularity_change_history: "歷史紀錄"

  options:
    general_options: "一般設定" # Check out the Options tab in the Game Menu while playing a level
    volume_label: "音量"
    music_label: "音樂"
    music_description: "開關背景音樂。"
    editor_config_title: "編輯器設定值"
    editor_config_livecompletion_label: "語法自動校正"
    editor_config_livecompletion_description: "當編寫語法的時候自動提示。"
    editor_config_invisibles_label: "顯示隱藏字元"
    editor_config_invisibles_description: "顯示如空白鍵或TAB鍵等隱藏字元。"
    editor_config_indentguides_label: "顯示縮排導引"
    editor_config_indentguides_description: "顯示縮排行數以便閱讀。"
    editor_config_behaviors_label: "智慧校正"
    editor_config_behaviors_description: "自動填入小括號、大括號以及引號。"

  about:
    main_title: "如果您想要學編程，你需要寫(一大堆)程式碼。"
    main_description: "在CodeCombat中，我們的職責是確保您笑著玩遊戲。"
    mission_link: "任務"
    team_link: "隊伍"
    story_link: "故事"
    press_link: "按"
    mission_title: "我們的任務為：讓世上每個學生都有機會能學會編程。"
    mission_description_1: "<strong>編程是一種魔法</strong>。它是一種從純粹的想像中創造東西的能力。我們營運CodeCombat來讓學習者可以透過<strong>鍵入程式碼</strong>在指尖感覺到巫師般的力量。"
    mission_description_2: "它的出現也讓使用者學得更快，就像是與它對話而不是閱讀手冊一般。我們想將這種對話帶給每一個學校以及<strong>每一位學生</strong>，因為每個人都應該要有機會體會編程的魔力。 "
    team_title: "認識CodeCombat團隊。"
    team_values: "我們重視開放且互相尊重的對話，好的想法才會勝出。我們的抉擇建立於客戶調查上，且過程注重於將具體的結果交給客戶。從我們的CEO到我們的Github貢獻者，每一個人都會動手參與，因為我們傾向在團隊中學習成長。"
    nick_title: "程式員" # {change}
    nick_blurb: "亢奮的咕嚕"
    matt_title: "共同創辦人" # {change}
    cat_title: "首席開卡設計師" # {change}
    cat_blurb: "氣宗"
    scott_title: "共同創辦人" # {change}
    scott_blurb: "理性至上"
    maka_title: "客戶代言人"
    maka_blurb: "說書人"
    rob_title: "編譯工程師" # {change}
    rob_blurb: "編寫一些的程式碼"
    josh_c_title: "遊戲設計師"
    josh_c_blurb: "設計遊戲"
    robin_title: "使用者體驗研究與設計"
    robin_blurb: "鷹架"
    josh_title: "遊戲設計師"
    josh_blurb: "地面是熔岩"
    phoenix_title: "軟體工程師"
    nolan_title: "區域經理"
    elliot_title: "合作經裡"
#    elliot_blurb: "Mindreader"
#    lisa_title: "School Specialist"
#    lisa_blurb: "A gritty one"
#    sean_title: "Territory Manager"
    retrostyle_title: "插畫師"
    retrostyle_blurb: "復古風格的遊戲"
    jose_title: "音樂"
    jose_blurb: "放輕鬆"
    community_title: "...以及我們的開放原始碼社群"
    community_subtitle: "超過 450 位貢獻者協助建立 CodeCombat , 而且每週持續增加中！"
#    community_description_3: "CodeCombat is a"
#    community_description_link_2: "community project"
    community_description_1: "CodeCombat 是一個社群專案，由有數以百計的玩家志願來建立遊戲關卡，建構我們的程式碼來添加功能、修正 Bugs、執行測試、甚至翻譯此遊戲至超過 50 種語言。如同多數的開源社群一般，所有的員工、貢獻者們及 CodeCombat 都獲益於持續的互相分享靈感和彙整努力。CodeCombat 是建立於無數的開源專案之上，因此我們開源回饋給社群朋友，提供一個友善專案給對於原始碼有興趣的玩家來探索和實驗。任何人都可以加入 CodeCombat 社群！請查看我們的" # {change}
    community_description_link: "貢獻者頁"
    community_description_2: "來獲得更多資訊。"
    number_contributors: "超過 450 位貢獻者奉獻他們的時間來協助本專案。"
    story_title: "我們的故事..."
    story_subtitle: "從 2013 年起，CodeCombat 從簡單的草圖成長為一個有生命且生氣蓬勃的遊戲。"
    story_statistic_1a: "總計超過 5,000,000+ "
    story_statistic_1b: "位玩家"
    story_statistic_1c: "藉由 CodeCombat 開啟他們的程式之旅"
    story_statistic_2a: "我們已翻譯至超過 50 種語言，我們的玩家來自"
    story_statistic_2b: "超過 200+ 個國家"
    story_statistic_3a: "他們一起撰寫完成"
    story_statistic_3b: "一百萬行程式及計算"
    story_statistic_3c: "跨越數種不同的程式語言"
    story_long_way_1: "雖然我們已經走過很長的一段路..."
    story_sketch_caption: "Nick 著手完成了一個初版的藍圖，描述一個撰寫程式的遊戲。"
    story_long_way_2: "然而在完成任務之前，我們仍然還有許多事情要做。所以..."
    jobs_title: "與我們一同工作，來協助撰寫 CodeCombat 的歷史吧！"
    jobs_subtitle: "找不到符合的位置，但有興趣與我們保持連繫？查看『建立我的』清單吧。"
    jobs_benefits: "員工福利"
#    jobs_benefit_4: "Unlimited vacation"
#    jobs_benefit_5: "Professional development and continuing education support – free books and games!"
#    jobs_benefit_6: "Medical (gold), dental, vision"
#    jobs_benefit_7: "Sit-stand desks for all"
#    jobs_benefit_9: "10-year option exercise window"
#    jobs_benefit_10: "Maternity leave: 10 weeks paid, next 6 @ 55% salary"
#    jobs_benefit_11: "Paternity leave: 10 weeks paid"
    learn_more: "了解更多"
    jobs_custom_title: "建立我的"
#    jobs_custom_description: "Are you passionate about CodeCombat but don't see a job listed that matches your qualifications? Write us and show how you think you can contribute to our team. We'd love to hear from you!"
#    jobs_custom_contact_1: "Send us a note at"
#    jobs_custom_contact_2: "introducing yourself and we might get in touch in the future!"
    contact_title: "點擊 & 連繫"
    contact_subtitle: "需要更多資訊？透過以下與我們連繫"
    screenshots_title: "遊戲螢幕截圖"
    screenshots_hint: "(點擊查看完整尺寸)"
    downloads_title: "下載資源 & 資訊"
    about_codecombat: "關於 CodeCombat"
#    logo: "Logo"
    screenshots: "螢幕截圖"
    character_art: "角色美術作品"
    download_all: "下載全部"
    previous: "上一個"
    location_title: "我們位於城鎮 SF："

  teachers:
    who_for_title: "誰是 CodeCombat 的使用對象呢？"
    who_for_1: "我們建議讓 9 歲及以上的學生使用 CodeCombat ，無需任何程式撰寫經驗。我們設計 CodeCombat 來吸引不分男女老幼的孩子們。"
    who_for_2: "我們的課程系統允許教師們藉由專屬的介面來設定課堂，追蹤學習進度及指派額外的內容給學生們"
    more_info_title: "我可以在哪裡找到更多訊息？"
    more_info_1: "我們的"
    more_info_2: "教師論壇"
    more_info_3: "是個與其他使用CodeCombat的教育工作者聯繫的良好平台。"
#    licenses_needed: "Licenses needed"

#  teachers_quote:
#    name: "Demo Form"
#    subtitle: "Get your students started in less than an hour. You'll be able to <strong>create a class, add students, and monitor their progress</strong> as they learn computer science."
#    email_exists: "User exists with this email."
#    phone_number: "Phone number"
#    phone_number_help: "Where can we reach you during the workday?"
#    primary_role_label: "Your Primary Role"
#    role_default: "Select Role"
#    primary_role_default: "Select Primary Role"
#    purchaser_role_default: "Select Purchaser Role"
#    tech_coordinator: "Technology coordinator"
#    advisor: "Advisor"
#    principal: "Principal"
#    superintendent: "Superintendent"
#    parent: "Parent"
#    purchaser_role_label: "Your Purchaser Role"
#    influence_advocate: "Influence/Advocate"
#    evaluate_recommend: "Evaluate/Recommend"
#    approve_funds: "Approve Funds"
#    no_purchaser_role: "No role in purchase decisions"
#    district_label: "District"
#    district_na: "Enter N/A if not applicable"
#    organization_label: "School"
#    city: "City"
#    state: "State"
#    country: "Country"
#    num_students_help: "How many do you anticipate enrolling in CodeCombat?"
#    num_students_default: "Select Range"
#    education_level_label: "Education Level of Students"
#    education_level_help: "Choose as many as apply."
#    elementary_school: "Elementary School"
#    high_school: "High School"
#    please_explain: "(please explain)"
#    middle_school: "Middle School"
#    college_plus: "College or higher"
#    anything_else: "Anything else we should know?"
#    thanks_header: "Request Received!"
#    thanks_sub_header: "Thanks for expressing interest in CodeCombat for your school."
#    thanks_p: "We'll be in touch soon! If you need to get in contact, you can reach us at:"
#    back_to_classes: "Back to Classes"
#    finish_signup: "Finish creating your teacher account:"
#    finish_signup_p: "Create an account to set up a class, add your students, and monitor their progress as they learn computer science."
#    signup_with: "Sign up with:"
#    connect_with: "Connect with:"
#    conversion_warning: "WARNING: Your current account is a <em>Student Account</em>. Once you submit this form, your account will be updated to a Teacher Account."
#    learn_more_modal: "Teacher accounts on CodeCombat have the ability to monitor student progress, assign licenses and manage classrooms. Teacher accounts cannot be a part of a classroom - if you are currently enrolled in a class using this account, you will no longer be able to access it once you update to a Teacher Account."
#    create_account: "Create a Teacher Account"
#    create_account_subtitle: "Get access to teacher-only tools for using CodeCombat in the classroom.  <strong>Set up a class</strong>, add your students, and <strong>monitor their progress</strong>!"
#    convert_account_title: "Update to Teacher Account"
#    not: "Not"

  versions:
    save_version_title: "保存新版本"
    new_major_version: "新的重要版本"
    submitting_patch: "正在提交修補…"
    cla_prefix: "想保存修改，您必須先保存我們的"
    cla_url: "貢獻者許可協議"
    cla_suffix: "。"
    cla_agree: "我同意"
    owner_approve: "您所做出的修改必須經擁有者確認才能生效。"

  contact:
    contact_us: "聯繫我們"
    welcome: "很高興收到您的信！用這個表格給我們發電郵。"
    forum_prefix: "如果有任何問題，請至"
    forum_page: "論壇"
    forum_suffix: "討論。"
    faq_prefix: "這裡還有一個"
    faq: "FAQ"
    subscribe_prefix: "如果您需要幫助來解決關卡，請"
    subscribe: "訂閱CodeCombat"
    subscribe_suffix: "並且我們樂意提供程式碼相關的協助。"
    subscriber_support: "您已經是個CodeCombat訂閱者，我們將提供優先的協助。"
    screenshot_included: "包含螢幕截圖。"
    where_reply: "我們回覆到？"
    send: "意見反饋"

  account_settings:
    title: "帳號設定"
    not_logged_in: "登錄或建立一個帳號來修改設置。"
    autosave: "自動保存修改"
    me_tab: "我"
    picture_tab: "頭像"
    delete_account_tab: "刪除您的帳戶"
    wrong_email: "錯誤的Email"
    wrong_password: "密碼錯誤"
    upload_picture: "上傳圖片"
    delete_this_account: "永久性的刪除帳戶"
    reset_progress_tab: "重置所有進度"
    reset_your_progress: "清除您的所有進度並重新開始"
    god_mode: "上帝模式"
    emails_tab: "郵件"
    admin: "管理員"
    manage_subscription: "點此管理您的訂閱"
    new_password: "新密碼"
    new_password_verify: "確認密碼"
    type_in_email: "輸入您的Email來確認刪除" # {change}
    type_in_email_progress: "輸入您的Email，確認您真的要刪除進度"
    type_in_password: "還有輸入您的密碼。"
    email_subscriptions: "訂閱"
    email_subscriptions_none: "無Email訂閱"
    email_announcements: "通知"
    email_announcements_description: "接收關於CodeCombat的新聞和開發消息。"
    email_notifications: "通知"
    email_notifications_summary: "您在CodeCombat的活動，會透過Email自動通知，您可選擇開啟或關閉。"
    email_any_notes: "任何通知"
    email_any_notes_description: "停用後您將不會收到來自CodeCombat的任何通知。"
    email_news: "新聞"
    email_recruit_notes: "工作機會"
    email_recruit_notes_description: "如果您玩得不錯，我們或許會考慮給您一份工作。"
    contributor_emails: "貢獻者電郵"
    contribute_prefix: "我們在尋找志同道合的人！請到 "
    contribute_page: "貢獻頁面"
    contribute_suffix: " 查看更多訊息。"
    email_toggle: "全選"
    error_saving: "保存時發生錯誤"
    saved: "修改已儲存"
    password_mismatch: "密碼不正確。"
    password_repeat: "請重複輸入您的密碼。"

  keyboard_shortcuts:
    keyboard_shortcuts: "鍵盤快捷鍵"
    space: "Space"
    enter: "Enter"
    press_enter: "按Enter"
    escape: "Esc"
    shift: "Shift"
    run_code: "執行當前腳本"
    run_real_time: "立即執行"
    continue_script: "使用最後一次使用的腳本"
    skip_scripts: "略過之前所有腳本"
    toggle_playback: "執行/暫停開關"
    scrub_playback: "向前/向後移動一段時間"
    single_scrub_playback: "向前/向後移動一個畫面"
    scrub_execution: "向前/向後移動一句語句"
    toggle_debug: "顯示/關閉除錯訊息"
    toggle_grid: "顯示/關閉網格提示"
    toggle_pathfinding: "顯示/關閉路徑尋找提示"
    beautify: "利用標準格式來美化您的程式碼"
    maximize_editor: "最大化/最小化程式碼編輯器"

  community:
    main_title: "CodeCombat社群"
    introduction: "查看您可能可以參與的項目以及選擇最吸引您的項目。我們期待與您一起工作！"
    level_editor_prefix: "使用CodeCombat"
    level_editor_suffix: "來創造和編輯關卡。許多人已經創造關卡用在課堂或黑客松，或者給予朋友或兄弟姊妹。如果您覺得創建一個全新的關卡非常困難，您可以先從現成的開始做起！"
    thang_editor_prefix: "我們稱呼遊戲中的單位叫'thangs'。使用"
    thang_editor_suffix: "來修改CodeCombat的原材料。讓遊戲中的東西可以扔砲彈，修改遊戲動畫的方向，調整單位的生命值，或者上傳自製的素材。"
    article_editor_prefix: "看到有錯誤在我們的文件中嗎？想要自己設計指令嗎？查看我們的"
    article_editor_suffix: "以及幫助CodeCombat玩家在遊戲中獲得更多知識。"
    find_us: "透過這些網站連繫我們"
    social_github: "在GitHub上查看我們的程式碼"
    social_blog: "閱讀CodeCombat在Sett上的部落格"
    social_discource: "加入我們在Discourse論壇上的討論"
    social_facebook: "關注CodeCombat的Facebook"
    social_twitter: "關注CodeCombat的Twitter"
    social_gplus: "關注CodeCombat的Google+"
    social_slack: "與我們在CodeCombat公共休閒頻道中聊天"
    contribute_to_the_project: "貢獻這專案"

  clans:
    clan: "部落"
    clans: "部落"
    new_name: "新部落的名字"
    new_description: "新部落的描述"
    make_private: "設定部落為私密"
    subs_only: "只限訂閱"
    create_clan: "建立新的部落"
    private_preview: "預覽"
    private_clans: "私密部落"
    public_clans: "公共部落"
    my_clans: "我的部落"
    clan_name: "部落名字"
    name: "名字"
    chieftain: "首領"
    edit_clan_name: "編輯部落的名稱"
    edit_clan_description: "編輯部落的描述"
    edit_name: "編輯名稱"
    edit_description: "編輯描述"
    private: "私密"
    summary: "綜述"
    average_level: "平均等級"
    average_achievements: "平均成就"
    delete_clan: "刪除部落"
    leave_clan: "離開部落"
    join_clan: "加入部落"
    invite_1: "邀請："
    invite_2: "*透過這個鏈接來邀請玩家加入部落。"
    members: "成員"
    progress: "進度"
    not_started_1: "尚未開始"
    started_1: "已開始"
    complete_1: "完成"
    exp_levels: "展開關卡"
    rem_hero: "移除英雄"
    status: "狀態"
    complete_2: "完成"
    started_2: "已開始"
    not_started_2: "尚未開始"
    view_solution: "點擊查閱答案。"
    view_attempt: "點擊查閱解題的嘗試"
    latest_achievement: "最新成就"
    playtime: "遊戲時間"
    last_played: "最後玩了"
    leagues_explanation: "在部落裡與其他成員組成聯盟一起參加下面的多人競技場。"
    track_concepts1: "追蹤慨念"
    track_concepts2a: "由每位學生學習"
    track_concepts2b: "由每位成員學習"
    track_concepts3a: "查看每位同學達到的等級"
    track_concepts3b: "查看每位成員達到的等級"
    track_concepts4a: "查看你的學生"
    track_concepts4b: "查看你的成員"
    track_concepts5: "解決方案"
    track_concepts6a: "按姓名或進度排序學生"
    track_concepts6b: "按姓名或進度排序成員"
    track_concepts7: "需要邀請"
    track_concepts8: "來加入"
    private_require_sub: "需要訂閱才可以建立或加入私密部落"

  courses:
    course: "課程"
    courses: "課程"
    create_new_class: "建立新的課堂"
    not_enrolled: "您没有註冊這一節課。"
    visit_pref: "請到這個"
    visit_suf: "網頁註冊。"
    select_class: "請選其中一門課堂"
    unnamed: "*未命名*"
    select: "選擇"
    unnamed_class: "課堂未命名"
    edit_settings: "編輯課堂設定"
    edit_settings1: "編輯課堂設定"
    progress: "課堂進度"
    add_students: "添加學生"
    stats: "統計"
    total_students: "學生人數："
    average_time: "平均遊戲時間："
    total_time: "總計遊戲時間："
    average_levels: "平均完成關卡："
    total_levels: "總共完成關卡："
    furthest_level: "最高關卡完成："
    students: "學生"
    students1: "個學生。"
    concepts: "課目"
    levels: "關卡"
    played: "已通關"
    play_time: "遊戲時間："
    completed: "完成："
    invite_students: "邀請學生加入此課堂。"
    invite_link_header: "參與課堂的縺結"
    invite_link_p_1: "把這個參與課堂的連結發給你的學生。"
    invite_link_p_2: "或讓我們代你直接發送電郵："
    capacity_used: "課堂插槽己用："
    enter_emails: "輸入學生電郵地址來邀請，每行一個" # {change}
    send_invites: "發送邀請" # {change}
    creating_class: "課堂創建中…"
    purchasing_course: "購買課程中…"
    buy_course: "購買課程"
    buy_course1: "購買這個課程"
    select_all_courses: "可半價一次購買所有課程！"
    all_courses: "所有課程"
#    number_programming_students: "Number of Programming Students"
#    number_total_students: "Total Students in School/District"
    enter_number_students: "輸入該課堂的學生上限人數"
    name_class: "命名您的課堂"
    displayed_course_page: "這將會在課程頁面顯示，可被修改。"
    buy: "購買"
    purchasing_for: "你正在購買許可證，課程為"
    creating_for: "您正在創建一個課程為"
    for: "，人數上限為" # Like in 'for 30 students'
    receive_code: "然後您會收到一個解鎖碼，把它分發給你的學生用來註冊你的課堂。"
    free_trial: "老師可免費試用！"
    get_access: "獲得個人使用權在評估目的下來使用所有課程。"
    questions: "有疑問？"
    teachers_click: "老師點擊這裡"
    students_click: "學生點擊這裡"
    courses_on_coco: "CodeCombat上的課程"
    designed_to: "CodeCombat課程的宗旨是在使用CodeCombat生動有趣的環境下教授計算機科學的課目。整個CodeCombat的關卡是圍繞著計算機科學的重點，並激勵學生們在5小時的過程內自主向上學習。"
    more_in_less: "以最少的時間學習最多的知識"
    no_experience: "無需編程經驗"
    easy_monitor: "容易管理學生的進程"
    purchase_for_class: "為你的班級購買CodeCombat課程，讓簽到和管理變得更容易！"
    see_the: "詳細資訊請看"
    more_info: "。"
    choose_course: "選擇您的課程："
    enter_code: "輸入一個解鎖碼來加入已存在的課堂"
    enter_code1: "輸入解鎖碼"
    enroll: "註冊"
    pick_from_classes: "從目前的課程選擇"
    enter: "輸入"
    or: "或"
    topics: "題目"
    hours_content: "內容時間："
    get_free: "取得免費課程！"
#    enroll_paid: "Enroll Students in Paid Courses"
#    you_have1: "You have"
#    you_have2: "unused student licenses"
#    use_one: "Use 1 student license for"
#    use_multiple: "Use licenses for the following students:"
#    already_enrolled: "already enrolled"
#    licenses_remaining: "licenses remaining:"
#    insufficient_enrollments: "insufficient student licenses"
#    get_enrollments: "Get More Licenses"
#    change_language: "Change Course Language"
#    keep_using: "Keep Using"
#    switch_to: "Switch To"
#    greetings: "Greetings!"
#    back_classrooms: "Back to my classrooms"
#    back_courses: "Back to my courses"
#    edit_details: "Edit class details"
#    enrolled_courses: "enrolled in paid courses:"
#    purchase_enrollments: "Purchase Student Licenses"
#    remove_student: "remove student"
#    assign: "Assign"
#    to_assign: "to assign paid courses."
#    student: "Student"
#    teacher: "Teacher"
#    complete: "Complete"
#    none: "None"
#    play_campaign_title: "Play the Campaign"
#    play_campaign_description: "You’re ready to take the next step! Explore hundreds of challenging levels, learn advanced programming skills, and compete in multiplayer arenas!"
#    create_account_title: "Create an Account"
#    create_account_description: "Sign up for a FREE CodeCombat account and gain access to more levels, more programming skills, and more fun!"
#    preview_campaign_title: "Preview Campaign"
#    preview_campaign_description: "Take a sneak peek at all that CodeCombat has to offer before signing up for your FREE account."
#    arena: "Arena"
#    arena_soon_title: "Arena Coming Soon"
#    arena_soon_description: "We are working on a multiplayer arena for classrooms at the end of"
#    not_enrolled1: "Not enrolled"
#    not_enrolled2: "Ask your teacher to enroll you in the next course."
#    next_course: "Next Course"
#    coming_soon1: "Coming soon"
#    coming_soon2: "We are hard at work making more courses for you!"
#    available_levels: "Available Levels"
#    welcome_to_courses: "Adventurers, welcome to Courses!"
#    ready_to_play: "Ready to play?"
#    start_new_game: "Start New Game"
#    play_now_learn_header: "Play now to learn"
#    play_now_learn_1: "basic syntax to control your character"
#    play_now_learn_2: "while loops to solve pesky puzzles"
#    play_now_learn_3: "strings & variables to customize actions"
#    play_now_learn_4: "how to defeat an ogre (important life skills!)"
#    welcome_to_page: "My Student Dashboard"
#    completed_hoc: "Amazing! You've completed the Hour of Code course!"
#    ready_for_more_header: "Ready for more? Play the campaign mode!"
#    ready_for_more_1: "Use gems to unlock new items!"
#    ready_for_more_2: "Play through brand new worlds and challenges"
#    ready_for_more_3: "Learn even more programming!"
#    saved_games: "Saved Games"
#    hoc: "Hour of Code"
#    my_classes: "Current Classes"
#    class_added: "Class successfully added!"
#    view_levels: "view all levels in course"
#    join_class: "Join A Class"
#    join_class_2: "Join class"
#    ask_teacher_for_code: "Ask your teacher if you have a CodeCombat class code! If so, enter it below:"
#    enter_c_code: "<Enter Class Code>"
#    join: "Join"
#    joining: "Joining class"
#    course_complete: "Course Complete"
#    play_arena: "Play Arena"
#    view_project: "View Project"
#    start: "Start"
#    last_level: "Last level played"
#    welcome_to_hoc: "Adventurers, welcome to our Hour of Code!"
#    logged_in_as: "Logged in as:"
    not_you: "不是您嗎?"
#    welcome_back: "Hi adventurer, welcome back!"
    continue_playing: "繼續進行遊戲"
#    more_options: "More options:"
#    option1_header: "Invite Students by Email"
#    option1_body: "Note: If your students do not have email addresses, they can enter your unique Class Code when creating a Student Account to make email addresses optional."
#    thank_you_pref: "Thank you for your purchase! You can now assign"
#    thank_you_suff: "more students to paid courses."
#    return_to_class: "Return to classroom"
#    return_to_course_man: "Return to course management."
#    students_not_enrolled: "students not enrolled"
#    total_all_classes: "Total Across All Classes"
#    how_many_enrollments: "How many additional student licenses do you need?"
#    each_student_access: "Each student in a class will get access to Courses 2-4 once they are enrolled in paid courses. You may assign each course to each student individually."
#    purchase_now: "Purchase Now"
#    enrollments: "licenses"
#    remove_student1: "Remove Student"
#    are_you_sure: "Are you sure you want to remove this student from this class?"
#    remove_description1: "Student will lose access to this classroom and assigned classes. Progress and gameplay is NOT lost, and the student can be added back to the classroom at any time."
#    remove_description2: "The activated paid license will not be returned."
#    keep_student: "Keep Student"
#    removing_user: "Removing user"
#    to_join_ask: "To join a class, ask your teacher for an unlock code."
#    join_this_class: "Join Class"
#    enter_here: "<enter unlock code here>"
#    successfully_joined: "Successfully joined"
#    click_to_start: "Click here to start taking"
#    my_courses: "My Courses"
#    classroom: "Classroom"
#    use_school_email: "use your school email if you have one"
#    unique_name: "a unique name no one has chosen"
#    pick_something: "pick something you can remember"
#    class_code: "Class Code"
#    optional_ask: "optional - ask your teacher to give you one!"
#    optional_school: "optional - what school do you go to?"
    start_playing: "開始遊戲"
#    skip_this: "Skip this, I'll create an account later!"
#    welcome: "Welcome"
#    getting_started: "Getting Started with Courses"
#    download_getting_started: "Download Getting Started Guide [PDF]"
#    getting_started_1: "Create a new class by clicking the green 'Create New Class' button below."
#    getting_started_2: "Once you've created a class, click the blue 'Add Students' button."
#    getting_started_3: "You'll see student's progress below as they sign up and join your class."
#    educator_wiki_pref: "Or check out our new"
#    educator_wiki_mid: "educator wiki"
#    educator_wiki_suff: "to browse the guide online."
#    your_classes: "Your Classes"
#    no_classes: "No classes yet!"
#    create_new_class1: "create new class"
#    available_courses: "Available Courses"
#    unused_enrollments: "Unused licenses available:"
#    students_access: "All students get access to Introduction to Computer Science for free. One license per student is required to assign them to paid CodeCombat courses. A single student does not need multiple licenses to access all paid courses."
#    active_courses: "active courses"
#    no_students: "No students yet!"
#    add_students1: "add students"
#    view_edit: "view/edit"
#    students_enrolled: "students enrolled"
#    students_assigned: "students assigned"
#    length: "Length:"
#    subtitle: "Review course overviews and levels" # Flat style redesign
#    changelog: "View latest changes to course levels."
#    select_language: "Select language"
#    select_level: "Select level"
#    play_level: "Play Level"
    concepts_covered: "課目覆蓋"
#    print_guide: "Print Guide (PDF)"
#    view_guide_online: "Level Overviews and Solutions"
#    grants_lifetime_access: "Grants access to all Courses."
#    enrollment_credits_available: "Licenses Available:"
#    language_select: "Select a language" # ClassroomSettingsModal
#    language_cannot_change: "Language cannot be changed once students join a class."
#    learn_p: "Learn Python"
#    learn_j: "Learn JavaScript"
#    avg_student_exp_label: "Average Student Programming Experience"
#    avg_student_exp_desc: "This will help us understand how to pace courses better."
#    avg_student_exp_select: "Select the best option"
#    avg_student_exp_none: "No Experience - little to no experience"
#    avg_student_exp_beginner: "Beginner - some exposure or block-based"
#    avg_student_exp_intermediate: "Intermediate - some experience with typed code"
#    avg_student_exp_advanced: "Advanced - extensive experience with typed code"
#    avg_student_exp_varied: "Varied Levels of Experience"
#    student_age_range_label: "Student Age Range"
#    student_age_range_younger: "Younger than 6"
#    student_age_range_older: "Older than 18"
#    student_age_range_to: "to"
    create_class: "創建課堂"
#    class_name: "Class Name"
#    teacher_account_restricted: "Your account is a teacher account and cannot access student content."
#    account_restricted: "A student account is required to access this page."
#    update_account_login_title: "Log in to update your account"
#    update_account_title: "Your account needs attention!"
#    update_account_blurb: "Before you can access your classes, choose how you want to use this account."
#    update_account_current_type: "Current Account Type:"
#    update_account_account_email: "Account Email/Username:"
#    update_account_am_teacher: "I am a teacher"
#    update_account_keep_access: "Keep access to classes I've created"
#    update_account_teachers_can: "Teacher accounts can:"
#    update_account_teachers_can1: "Create/manage/add classes"
#    update_account_teachers_can2: "Assign/enroll students in courses"
#    update_account_teachers_can3: "Unlock all course levels to try out"
#    update_account_teachers_can4: "Access new teacher-only features as we release them"
#    update_account_teachers_warning: "Warning: You will be removed from all classes that you have previously joined and will not be able to play as a student."
#    update_account_remain_teacher: "Remain a Teacher"
#    update_account_update_teacher: "Update to Teacher"
#    update_account_am_student: "I am a student"
#    update_account_remove_access: "Remove access to classes I have created"
#    update_account_students_can: "Student accounts can:"
#    update_account_students_can1: "Join classes"
#    update_account_students_can2: "Play through courses as a student and track your own progress"
#    update_account_students_can3: "Compete against classmates in arenas"
#    update_account_students_can4: "Access new student-only features as we release them"
#    update_account_students_warning: "Warning: You will not be able to manage any classes that you have previously created or create new classes."
#    update_account_remain_student: "Remain a Student"
#    update_account_update_student: "Update to Student"
#    need_a_class_code: "You'll need a Class Code for the class you're joining:"
#    update_account_not_sure: "Not sure which one to choose? Email"
#    update_account_confirm_update_student: "Are you sure you want to update your account to a Student experience?"
#    update_account_confirm_update_student2: "You will not be able to manage any classes that you have previously created or create new classes. Your previously created classes will be removed from CodeCombat and cannot be restored."
#    instructor: "Instructor: "
#    youve_been_invited_1: "You've been invited to join "
#    youve_been_invited_2: ", where you'll learn "
#    youve_been_invited_3: " with your classmates in CodeCombat."
#    by_joining_1: "By joining "
#    by_joining_2: "will be able to help reset your password if you forget or lose it. You can also verify your email address so that you can reset the password yourself!"
#    sent_verification: "We've sent a verification email to:"
#    you_can_edit: "You can edit your email address in "
#    account_settings: "Account Settings"
#    select_your_hero: "Select Your Hero"
#    select_your_hero_description: "You can always change your hero by going to your Courses page and clicking \"Change Hero\""
#    select_this_hero: "Select this Hero"
#    current_hero: "Current Hero:"
#    change_hero: "Change Hero"
#    web_dev_language_transition: "All classes program in HTML / JavaScript for this course.  Classes that have been using Python will start with extra JavaScript intro levels to ease the transition.  Classes that are already using JavaScript will skip the intro levels."

#  teacher:
#    course_solution: "Course Solution"
#    level_overview_solutions: "Level Overview and Solutions"
#    teacher_dashboard: "Teacher Dashboard" # Navbar
#    my_classes: "My Classes"
#    courses: "Course Guides"
#    enrollments: "Student Licenses"
#    resources: "Resources"
#    help: "Help"
#    students: "Students" # Shared
#    language: "Language"
#    edit_class_settings: "edit class settings"
#    complete: "Complete"
#    access_restricted: "Account Update Required"
#    teacher_account_required: "A teacher account is required to access this content."
#    create_teacher_account: "Create Teacher Account"
#    what_is_a_teacher_account: "What's a Teacher Account?"
#    teacher_account_explanation: "A CodeCombat Teacher account allows you to set up classrooms, monitor students’ progress as they work through courses, manage licenses and access resources to aid in your curriculum-building."
#    current_classes: "Current Classes"
#    archived_classes: "Archived Classes"
#    archived_classes_blurb: "Classes can be archived for future reference. Unarchive a class to view it in the Current Classes list again."
#    view_class: "view class"
#    archive_class: "archive class"
#    unarchive_class: "unarchive class"
#    unarchive_this_class: "Unarchive this class"
#    no_students_yet: "This class has no students yet."
#    no_students_yet_view_class: "View class to add students."
#    try_refreshing: "(You may need to refresh the page)"
#    add_students: "Add Students"
#    create_new_class: "Create a New Class"
#    class_overview: "Class Overview" # View Class page
#    avg_playtime: "Average level playtime"
#    total_playtime: "Total play time"
#    avg_completed: "Average levels completed"
#    total_completed: "Total levels completed"
#    created: "Created"
#    concepts_covered: "Concepts covered"
#    earliest_incomplete: "Earliest incomplete level"
#    latest_complete: "Latest completed level"
#    enroll_student: "Enroll student"
#    apply_license: "Apply License"
#    course_progress: "Course Progress"
#    not_applicable: "N/A"
#    edit: "edit"
#    edit_2: "Edit"
#    remove: "remove"
#    latest_completed: "Latest completed:"
#    sort_by: "Sort by"
#    progress: "Progress"
#    completed: "Completed"
#    started: "Started"
#    click_to_view_progress: "click to view progress"
#    no_progress: "No progress"
#    select_course: "Select course to view"
#    students_not_assigned: "Students who have not been assigned {{courseName}}"
#    course_overview: "Course Overview"
#    copy_class_code: "Copy Class Code"
#    class_code_blurb: "Students can join your class using this Class Code. No email address is required when creating a Student account with this Class Code."
#    copy_class_url: "Copy Class URL"
#    class_join_url_blurb: "You can also post this unique class URL to a shared webpage."
#    add_students_manually: "Invite Students by Email"
#    bulk_assign: "Bulk-assign"
#    assigned_msg_1: "{{numberAssigned}} students were assigned {{courseName}}."
#    assigned_msg_2: "{{numberEnrolled}} licenses were applied."
#    assigned_msg_3: "You now have {{remainingSpots}} available licenses remaining."
#    assign_course: "Assign Course"
#    not_assigned_modal_title: "Courses were not assigned"
#    not_assigned_modal_body_1: "You do not have enough licenses available to assign additional Courses to all {{selected}} selected students."
#    not_assigned_modal_body_2: "You only have {{totalSpotsAvailable}} licenses available ({{unenrolledStudents}} students did not have an active license)."
#    not_assigned_modal_body_3: "Please select fewer students, or reach out to {{email}} for assistance."
#    assign_to_selected_students: "Assign to Selected Students"
#    assigned: "Assigned"
#    enroll_selected_students: "Enroll Selected Students"
#    no_students_selected: "No students were selected."
#    guides_coming_soon: "Guides coming soon!" # Courses
#    show_students_from: "Show students from" # Enroll students modal
#    apply_licenses_to_the_following_students: "Apply Licenses to the Following Students"
#    students_have_licenses: "The following students already have licenses applied:"
#    all_students: "All Students"
#    apply_licenses: "Apply Licenses"
#    not_enough_enrollments: "Not enough licenses available."
#    enrollments_blurb: "Students are required to have a license to access any content after the first course."
#    credits_available: "Licenses Available"
#    total_unique_students: "Total Students"
#    total_enrolled_students: "Enrolled Students"
#    unenrolled_students: "Unenrolled Students"
#    add_enrollment_credits: "Add Licenses"
#    purchasing: "Purchasing..."
#    purchased: "Purchased!"
#    purchase_now: "Purchase Now"
#    how_to_enroll: "How to Enroll Students"
#    how_to_apply_licenses: "How to Apply Licenses"
#    bulk_pricing_blurb: "Purchasing for more than 25 students? Contact us to discuss next steps."
#    total_unenrolled: "Total unenrolled"
#    export_student_progress: "Export Student Progress (CSV)"
#    send_email_to: "Send Recover Password Email to:"
#    email_sent: "Email sent"
#    send_recovery_email: "Send recovery email"
#    enter_new_password_below: "Enter new password below:"
#    change_password: "Change Password"
#    changed: "Changed"
#    available_credits: "Available Licenses"
#    pending_credits: "Pending Licenses"
#    credits: "licenses"
#    start_date: "start date:"
#    end_date: "end date:"
#    get_enrollments_blurb: " We'll help you build a solution that meets the needs of your class, school or district."
#    how_to_apply_licenses_blurb_1: "When a teacher assigns a course to a student for the first time, we’ll automatically apply a license. Use the bulk-assign dropdown in your classroom to assign a course to selected students:"
#    how_to_apply_licenses_blurb_2: "Can I still apply a license without assigning a course?"
#    how_to_apply_licenses_blurb_3: "Yes — go to the License Status tab in your classroom and click \"Apply License\" to any student who does not have an active license."
#    request_sent: "Request Sent!"
#    enrollment_status: "Enrollment Status"
#    license_status: "License Status"
#    status_expired: "Expired on {{date}}"
#    status_not_enrolled: "Not Enrolled"
#    status_enrolled: "Expires on {{date}}"
#    select_all: "Select All"
#    projects: "Projects"
#    project: "Project"
#    view_student_project: "View Student Project"
#    view_arena_ladder: "View Arena Ladder"
#    resource_hub: "Resource Hub"
#    getting_started: "Getting Started"
#    educator_faq: "Educator FAQ"
#    educator_faq_desc: "Frequently asked questions about using CodeCombat in your classroom or school."
#    teacher_getting_started: "Teacher Getting Started Guide"
#    teacher_getting_started_desc: "New to CodeCombat? Download this Teacher Getting Started Guide to set up your account, create your first class, and invite students to the first course."
#    student_getting_started: "Student Quick Start Guide"
#    student_getting_started_desc: "You can distribute this guide to your students before starting CodeCombat so that they can familiarize themselves with the code editor. This guide can be used for both Python and JavaScript classrooms."
#    cs1: "Introduction to Computer Science"
#    cs2: "Computer Science 2"
#    cs3: "Computer Science 3"
#    cs1_syntax_python: "Course 1 Python Syntax Guide"
#    cs1_syntax_python_desc: "Cheatsheet with references to common Python syntax that students will learn in Introduction to Computer Science."
#    cs1_syntax_javascript: "Course 1 JavaScript Syntax Guide"
#    cs1_syntax_javascript_desc: "Cheatsheet with references to common JavaScript syntax that students will learn in Introduction to Computer Science."
#    coming_soon: "Additional guides coming soon!"
#    engineering_cycle_worksheet: "Engineering Cycle Worksheet"
#    engineering_cycle_worksheet_desc: "Use this worksheet to teach students the basics of the engineering cycle: Assess, Design, Implement and Debug. Refer to the completed example worksheet as a guide."
#    engineering_cycle_worksheet_link: "View example"
#    progress_journal: "Progress Journal"
#    progress_journal_desc: "Encourage students to keep track of their progress via a progress journal."
#    cs1_curriculum: "Introduction to Computer Science - Curriculum Guide"
#    cs1_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 1."
#    cs2_curriculum: "Computer Science 2 - Curriculum Guide"
#    cs2_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 2."
#    cs3_curriculum: "Computer Science 3 - Curriculum Guide"
#    cs3_curriculum_desc: "Scope and sequence, lesson plans, activities and more for Course 3."
#    cs1_pairprogramming: "Pair Programming Activity"
#    cs1_pairprogramming_desc: "Introduce students to a pair programming exercise that will help them become better listeners and communicators."
#    unlock_resources: "Unlock more resources!"
#    unlock_resources_desc: "Gain access to additional guides by adding student licenses to your account. Request a demo today to get started."
#    request_demo: "Request Demo"
#    student_overview: "Overview"
#    student_email: "Student Email"
#    no_email: "Student has no email address set."
#    student_profile: "Student Profile"
#    playtime_detail: "Playtime Detail"
#    student_completed: "Student Completed"
#    student_in_progress: "Student in Progress"
#    class_average: "Class Average"
#    not_assigned: "has not been assigned the following courses"
#    playtime_axis: "Playtime in Seconds"
#    levels_axis: "Levels in"
#    student_state: "How is"
#    student_state_2: "doing?"
#    student_good: "is doing well in"
#    student_good_detail: "This student is keeping pace with the class."
#    student_warn: "might need some help in"
#    student_warn_detail: "This student might need some help with new concepts that have been introduced in this course."
#    student_great: "is doing great in"
#    student_great_detail: "This student might be a good candidate to help other students working through this course."

#  sharing:
#    game: "Game"
#    webpage: "Webpage"
#    your_students_preview: "Your students will click here to see their finished projects! Unavailable in teacher preview."
#    unavailable: "Link sharing not available in teacher preview."
#    share_game: "Share This Game"
#    share_web: "Share This Webpage"
#    victory_share_prefix: "Share this link to invite your friends & family to"
#    victory_share_game: "play your game level"
#    victory_share_web: "view your webpage"
#    victory_share_suffix: "."
#    victory_course_share_prefix: "This link will let your friends & family"
#    victory_course_share_game: "play the game"
#    victory_course_share_web: "view the webpage"
#    victory_course_share_suffix: "you just created."
#    copy_url: "Copy URL"

#  game_dev:
#    creator: "Creator"

#  web_dev:
#    image_gallery_title: "Image Gallery"
#    select_an_image: "Select an image you want to use"
#    scroll_down_for_more_images: "(Scroll down for more images)"
#    copy_the_url: "Copy the URL below"
#    copy_the_url_description: "Useful if you want to replace an existing image."
#    copy_the_img_tag: "Copy the <img> tag"
#    copy_the_img_tag_description: "Useful if you want to insert a new image."
#    copy_url: "Copy URL"
#    copy_img: "Copy <img>"
#    how_to_copy_paste: "How to Copy/Paste"
#    copy: "Copy"
#    paste: "Paste"
#    back_to_editing: "Back to Editing"

  classes:
    archmage_title: "大法師"
    archmage_title_description: "(Coder)"
    archmage_summary: "如果您是個在coding教育遊戲有興趣的開發者，成為大法師來幫助我們建立CodeCombat！"
    artisan_title: "工匠"
    artisan_title_description: "(Level Builder)"
    artisan_summary: "建造遊戲關卡並且分享給您的朋友們。成為工匠來幫助其他人學習編程。"
    adventurer_title: "冒險家"
    adventurer_title_description: "(Level Playtester)"
    adventurer_summary: "提前一週免費取得我們新的關卡(甚至是訂閱的內容)並且提前在釋出前幫助我們找出錯誤。"
    scribe_title: "文書"
    scribe_title_description: "(Article Editor)"
    scribe_summary: "好的程式需要好的文件。來自全世界數百萬的玩家一起編寫，編輯和提升文件的可讀性。"
    diplomat_title: "外交官"
    diplomat_title_description: "(Translator)"
    diplomat_summary: "藉由我們的外交官，CodeCombat已翻譯到45種以上的語言。幫助我們並且貢獻翻譯。"
    ambassador_title: "使節"
    ambassador_title_description: "(Support)"
    ambassador_summary: "安撫我們論壇的用戶並且提供發問者適當的方向。我們的使節代表CodeCombat面對全世界。"
    teacher_title: "教師"

  editor:
    main_title: "CodeCombat編輯器"
    article_title: "文章編輯器"
    thang_title: "物品編輯器"
    level_title: "關卡編輯器"
    course_title: "課程編輯器"
    achievement_title: "目標編輯器"
    poll_title: "投票編輯器"
    back: "返回"
    revert: "還原"
    revert_models: "還原模式"
    pick_a_terrain: "選擇地形"
    dungeon: "地牢"
    indoor: "室內"
    desert: "沙漠"
    grassy: "草地"
    mountain: "高山"
    glacier: "冰川"
    small: "小的"
    large: "大的"
    fork_title: "產生新分支"
    fork_creating: "產生分支中…"
    generate_terrain: "產生地形"
    more: "更多"
    wiki: "維基"
    live_chat: "線上聊天"
    thang_main: "主要"
    thang_spritesheets: "圖集"
    thang_colors: "顏色"
    level_some_options: "有哪些選項？"
    level_tab_thangs: "物體"
    level_tab_scripts: "腳本"
    level_tab_components: "組件"
    level_tab_systems: "系統"
    level_tab_docs: "文件"
    level_tab_thangs_title: "目前物體"
    level_tab_thangs_all: "所有的"
    level_tab_thangs_conditions: "啟動條件"
    level_tab_thangs_add: "增加物體"
    level_tab_thangs_search: "搜索物體"
    add_components: "增加組件"
    component_configs: "組件組態"
    config_thang: "雙擊來構建物體"
    delete: "刪除"
    duplicate: "複製"
    stop_duplicate: "停止複製"
    rotate: "旋轉"
    level_component_tab_title: "現在組件"
    level_component_btn_new: "建立新組件"
    level_systems_tab_title: "目前系統"
    level_systems_btn_new: "建立新系統"
    level_systems_btn_add: "增加系統"
    level_components_title: "回到所有物體"
    level_components_type: "類型"
    level_component_edit_title: "編輯組件"
    level_component_config_schema: "配置模式"
    level_system_edit_title: "編輯系統"
    create_system_title: "Create New System"
    new_component_title: "建立新系統"
    new_component_field_system: "系統"
    new_article_title: "建立新文件"
    new_thang_title: "建立新物體類型"
    new_level_title: "建立新關卡"
    new_article_title_login: "登錄以建立新文件"
    new_thang_title_login: "登錄以建立新物體類型"
    new_level_title_login: "登錄以建立新關卡"
    new_achievement_title: "建立新成就"
    new_achievement_title_login: "登錄以建立新成就"
    new_poll_title: "創建一個新的投票"
    new_poll_title_login: "登入去創建一個新的投票"
    article_search_title: "在這搜尋文件"
    thang_search_title: "在這搜尋物體類型"
    level_search_title: "在這搜尋關卡"
    achievement_search_title: "搜尋成就"
    poll_search_title: "搜尋投票"
    read_only_warning2: "注意：您不能在這儲存任何編輯，因為您尚未登入。"
    no_achievements: "尚未有任何成就加入到這關卡中。"
    achievement_query_misc: "關閉成就欄的雜項"
    achievement_query_goals: "關閉成就欄的關卡目標"
    level_completion: "關卡完成"
    pop_i18n: "填寫 I18N"
    tasks: "任務"
    clear_storage: "清除您本機端的變更"
    add_system_title: "添加系統到關卡"
    done_adding: "添加完成"

  article:
    edit_btn_preview: "預覽"
    edit_article_title: "編輯文章"

  polls:
    priority: "優先順序"

  contribute:
    page_title: "貢獻"
    intro_blurb: "CodeCombat 是 100% 開源！上百位專注的玩家已經幫助我們建造到今天的程度。加入我們並完成下一章 CodeCombat 的冒險給全世界參與！"
    alert_account_message_intro: "您好！"
    alert_account_message: "為了訂閱課程信件，您將必須先登入。"
    archmage_introduction: "在建造遊戲中，其中一個最美好的事情是需要整合許多不同東西：圖像、 聲音、及時網路和社群網路。以及許多不同層面的編程，從底層數據庫管理，到用戶界面的設計和實現。這裡有許多事情需要完成，如果您是個有經驗的程式員並且熱衷於深入處理 CodeCombat 的本質，那麼這職業就是為您打造的。我們將很高興擁有您的幫助來打造有史以來最優質的編程遊戲。"
    class_attributes: "職業說明"
    archmage_attribute_1_pref: "熟悉於"
    archmage_attribute_1_suf: "，或者渴望去學習。我們大部份的程式以這個語言寫成。如果您是個 Ruby 或 Python 的粉絲，您將感覺到歸屬感。它是個JavaScript，但是擁有更佳的文法。"
    archmage_attribute_2: "一些程式經驗和個人的衝勁。我們將幫助您找到方向，但是我們不會花費太多時間訓練您。"
    how_to_join: "如何加入"
    join_desc_1: "任何人都可加入我們！只需確認我們的"
    join_desc_2: "來開始，並且勾選底下的條件來宣告您成為勇敢的大法師和藉由郵件獲得我們最新的消息。想要討論可做的事或者更加深入地參與？"
    join_desc_3: "，或者找到我們在"
    join_desc_4: "讓我們從這開始！"
    join_url_email: "發信給我們"
    join_url_slack: "公共休閒頻道"
    archmage_subscribe_desc: "取得郵件關於新的編程機會和公告。"
    artisan_introduction_pref: "我們必須建造更多的關卡！大家為了更多的內容在高聲吶喊，但只靠我們只能建造這麼多。現在您的工作場所就是一關；我們的關卡編輯器是勉強可用的，所以請小心。只要您有新的靈感，不論從簡單的 for-loops 到"
    artisan_introduction_suf: "，那個這職業會適合您。"
    artisan_attribute_1: "任何的創建內容經驗都是加分的，例如使用過Blizzard的關卡編輯器。但不是必須的！"
    artisan_attribute_2: "渴望去完成許多測試和迭代。為了製作好關卡，您需要把它交給別人去玩並且觀察他們如何玩，之後準備找到一堆東西去修改。"
    artisan_attribute_3: "暫且擁有探險者般的忍耐力。我們的關卡編輯器非常的陽春，有些地方非常不易使用。我們已經提前告知囉！"
    artisan_join_desc: "按照以下步驟使用關卡編輯器："
    artisan_join_step1: "閱讀文擋。"
    artisan_join_step2: "創建新的關卡並且探索已存在的關卡。"
    artisan_join_step3: "在公共的Slack房間裡找到我們尋求幫助。"
    artisan_join_step4: "公佈您的關卡到論壇中尋求回饋。"
    artisan_subscribe_desc: "取得郵件關於關卡編輯器更新和公告。"
    adventurer_introduction: "讓我們清楚的定義您的角色：您是部坦克。您將遭受許多傷害。我們需要玩家來嘗試我們全新的關卡並且幫助我們找出如何讓事情變得更好。那痛苦將是巨大的；製作優秀的遊戲是個長遠的過程並且沒有人可以第一次就把事情做對。如果您可以忍受並且抵抗力高，那麼這職業也許適合您。"
    adventurer_attribute_1: "渴望學習。您想要學習如何編程並且我們想要教導您如何編程。儘管您將可能在這情況中獨自完成大部分教學。"
    adventurer_attribute_2: "魅力十足的。直率但如紳士般的指出需要改進的地方，並且提供如何改進的建議。"
    adventurer_join_pref: "無論是與其餘工匠們一起共事，或者勾選底下的條件來藉由郵件獲得我們最新需要測試的關卡。我們也將公佈需要評估的關卡在我們的網站上，例如："
    adventurer_forum_url: "我們的論壇"
    adventurer_join_suf: "所以如果您更加喜歡藉由這方式被通知，在那些網站上登錄吧！"
    adventurer_subscribe_desc: "當有新關卡需要測試時取得郵件。"
    scribe_introduction_pref: "CodeCombat不只是將擁有一堆關卡。它將也包含知識資源，一種充滿編程概念的wiki並且每道關卡都將蘊含著這樣的概念。在這概念下，不只每位工匠必須描述針對每個細節提出講解，他們製作的關卡還可以簡單地和wiki中的編程概念產生連結。某些東西已經在"
    scribe_introduction_url_mozilla: "Mozilla 開發者社群"
    scribe_introduction_suf: "完成。如果您的有趣意見是可以在 Markdown 形式下闡述編程概念，那麼這職業也許適合您。"
    scribe_attribute_1: "文字的技巧幾乎是您全部所需要的。不只是文法和拼字，但還需傳達複雜概念給閱讀的人。"
    contact_us_url: "聯繫我們" # {change}
    scribe_join_description: "告訴我們更多關於您的資訊，您的編程經驗和一些您喜歡寫下的東西。我們將從這些地方開始！"
    scribe_subscribe_desc: "取得公告關於寫作文章的郵件。"
    diplomat_introduction_pref: "所以，如果說我們從"
    diplomat_launch_url: " 十月的那次上線 "
    diplomat_introduction_suf: "中得到了怎樣的啟發：那就是在許多國家有許多人對CodeCombat產生興趣！我們正在建立一群翻譯者，急於將一組組的英文翻譯成各國語言讓CodeCombat可以讓全世界更多人都可以接觸。如果您喜歡搶先閱讀新內容並且讓您的國人都可以儘速的擁有，那麼這職業也許適合您。"
    diplomat_attribute_1: "擁有流利的英文並且精通欲翻譯的語言。當傳遞複雜想法時，您必須融會貫通這兩種語言！"
    diplomat_i18n_page_prefix: "您可以從我們的"
    diplomat_i18n_page: " 翻譯頁面 "
    diplomat_i18n_page_suffix: "開始翻譯我們的關卡，或者在 GitHub 翻譯我們的介面及網站。"
    diplomat_join_pref_github: "在"
    diplomat_github_url: " GitHub "
    diplomat_join_suf_github: "找到您的語言文件 (繁體中文的是：codecombat/app/locale/zh-HANT.coffee)，在線編輯它，並且上傳一個 pull 請求。另外，勾選底下的方框以藉由郵件獲得及時的國際化開發！"
    diplomat_subscribe_desc: "取得國際化開發和待翻譯關卡的郵件。"
    ambassador_introduction: "這是個我們正在建立的社群，您將是我們與世界的連接點。我們在論壇、郵件、社群網路上和許多人交談並且幫助彼此熟悉遊戲以及互相學習。如果您想要幫助其他人參與並且從中獲得許多樂趣，以及樂於感受CodeCombat的脈搏和我們將前往的地方，那麼這職業也許適合您。"
    ambassador_attribute_1: "溝通技巧。可以找到玩家正面臨的問題並且幫助他們解決。另外，保持與我們聯繫玩家們討論的、喜愛的、厭惡的以及想要的！"
    ambassador_join_desc: "告訴我們更多關於您的資訊，您已完成的事情和您喜歡做的事情。我們將從這些地方開始！"
    ambassador_join_note_strong: "注意"
    ambassador_join_note_desc: "其中一件我們優先要做的事情是建立多人連線，玩家將面臨難以獨自解決的關卡而且可以招喚更高等級的法師來幫助。這將對於使節是一個很棒的方式來完成自己的責任。我們會及時地向大家公佈！"
    ambassador_subscribe_desc: "取得更新和多人連線開發的郵件。"
    teacher_subscribe_desc: "取得給教師的更新以及消息。"
    changes_auto_save: "當您勾選後，改變將自動儲存。"
    diligent_scribes: "我們勤奮的文書："
    powerful_archmages: "我們強勁的大法師："
    creative_artisans: "我們創意的工匠："
    brave_adventurers: "我們勇敢的冒險家："
    translating_diplomats: "我們翻譯中的外交官："
    helpful_ambassadors: "我們善於幫助的使節："

  ladder:
    please_login: "在參與對戰前請先登入。"
    my_matches: "我的對戰"
    simulate: "模擬"
    simulation_explanation: "通過模擬遊戲，您可以使您的遊戲更快得到評定排名！"
    simulation_explanation_leagues: "你主要會為你的部落或者課程的同伴幫忙模擬遊戲。"
    simulate_games: "模擬遊戲！"
    games_simulated_by: "您模擬過的次數："
    games_simulated_for: "替您模擬的次數："
    games_in_queue: "遊戲正在列隊中："
    games_simulated: "遊戲模擬次數"
    games_played: "玩過的遊戲"
    ratio: "比率"
    leaderboard: "排行榜"
    battle_as: "我要扮演 "
    summary_your: "您的 "
    summary_matches: "對手 - "
    summary_wins: " 勝利，"
    summary_losses: " 失敗"
    rank_no_code: "沒有新程式碼可評定排名"
    rank_my_game: "對我的遊戲評定排名！"
    rank_submitting: "上傳中…"
    rank_submitted: "已上傳以求評定排名"
    rank_failed: "評定失敗"
    rank_being_ranked: "已評定"
    rank_last_submitted: "已上傳 "
    help_simulate: "幫我們模擬遊戲？"
    code_being_simulated: "您的新程式碼正在被其他人模擬評定中。分數將隨每次新的配對而更新。"
    no_ranked_matches_pre: "對這個隊伍尚未有評分過的配對！"
    no_ranked_matches_post: " 在別人的戰場上扮演對手並且回到這使您的程式碼接受評定排名。"
    choose_opponent: "選擇對手"
    select_your_language: "選擇您的語言！"
    tutorial_play: "教學"
    tutorial_recommended: "如果您尚未玩過，建議先嘗試教學"
    tutorial_skip: "略過教學"
    tutorial_not_sure: "不確定發生啥事？"
    tutorial_play_first: "先試試教學"
    simple_ai: "簡單人工智慧" # {change}
    warmup: "熱身"
    friends_playing: "與朋友連線"
    log_in_for_friends: "登入與朋友一起玩！"
    social_connect_blurb: "連線並擊敗您的朋友！"
    invite_friends_to_battle: "邀請您的朋友加入此戰鬥！"
    fight: "戰鬥！"
    watch_victory: "觀看您的勝利"
    defeat_the: "敗於"
    watch_battle: "觀看戰役"
    tournament_started: "，錦標賽已開始"
    tournament_ends: "錦標賽結束"
    tournament_ended: "錦標賽已結束"
    tournament_rules: "錦標賽規則"
    tournament_blurb: "寫下程式碼，收集金幣，建立軍隊，粉碎敵人，贏得獎項，在我們價值$40,000的Greed錦標賽中升級您的職業！查看"
    tournament_blurb_criss_cross: "贏得競賽，建造道路，智勝對手，收集寶石，在我們的Criss-Crossand錦標賽中升級您的職業！查看"
    tournament_blurb_zero_sum: "在紅方法師和藍方法師的山峰對決中，同時在收集金幣和戰術上發揮你的程式碼創造力。競賽在3月27日開始，在4月6日（星期一）的下午5點（PDT太平洋時區）結束。為樂趣和榮耀競賽吧！瀏覽了解更多"
    tournament_blurb_ace_of_coders: "我的主場我主宰，在寒天雪地的冰原上和自己鏡像大戰一場吧！本次比賽將由9月16日星期三開辦到10月14日下午5點PDT。詳情請查看"
    tournament_blurb_blog: "我們的部落格"
    rules: "規則"
    winners: "贏家"
    league: "聯盟"
    red_ai: "紅隊 AI" # "Red AI Wins", at end of multiplayer match playback
    blue_ai: "藍隊 AI" # {change}
    wins: "勝利" # At end of multiplayer match playback
    humans: "紅隊" # Ladder page display team name
    ogres: "藍隊"

  user:
    stats: "統計"
    singleplayer_title: "單人遊戲等級"
    multiplayer_title: "多人遊戲等級"
    achievements_title: "成就"
    last_played: "最後遊玩"
    status: "狀態"
    status_completed: "已完成"
    status_unfinished: "未完成"
    no_singleplayer: "還沒有玩過單人遊戲"
    no_multiplayer: "還沒有玩過多人遊戲"
    no_achievements: "還沒有取得成就"
    favorite_prefix: "語言喜好為"
    favorite_postfix: "."
    not_member_of_clans: "還不是任何一個部落裡的成員。"

  achievements:
    last_earned: "最近一次"
    amount_achieved: "數量"
    achievement: "成就"
    current_xp_prefix: "當前總共"
    current_xp_postfix: "經驗值"
    new_xp_prefix: "獲得"
    new_xp_postfix: "經驗值"
    left_xp_prefix: "還需要"
    left_xp_infix: "經驗值"
    left_xp_postfix: "到下一個等級"

  account:
    payments: "付款"
    prepaid_codes: "儲值碼"
    purchased: "已購買"
    subscription: "訂閱"
    invoices: "收據"
    service_apple: "設備：Apple"
    service_web: "設備：Web"
    paid_on: "支付"
    service: "服務"
    price: "價格"
    gems: "寶石"
    active: "有效"
    subscribed: "已訂閱"
    unsubscribed: "取消訂閱"
    active_until: "有效直到"
    cost: "花費"
    next_payment: "下次付款"
    card: "信用卡"
    status_unsubscribed_active: "您尚未訂閱並且將不會收到賬單，但是您的帳號現在仍然是有效的。"
    status_unsubscribed: "藉由訂閱CodeCombat，取得存取新關卡、新英雄、新物品和額外寶石的資格！"
#    not_yet_verified: "Not yet verified."
#    resend_email: "Resend email"
#    email_sent: "Email sent! Check your inbox."
#    verifying_email: "Verifying your email address..."
#    successfully_verified: "You've successfully verified your email address!"
#    back_to_student_page: "Go back to student things"
#    back_to_teacher_page: "Go to My Classes"
#    back_to_game: "Go play some more levels!"
#    verify_error: "Something went wrong when verifying your email :("

  account_invoices:
    amount: "金額（美元）"
    declined: "您的付款被拒"
    invalid_amount: "請輸入美元金額。"
    not_logged_in: "登錄或創建一個帳戶來獲取發票。"
    pay: "付費發票"
    purchasing: "購買中…"
    retrying: "服務器錯誤，重試中。"
    success: "支付成功。謝謝！"

  account_prepaid:
    purchase_code: "購買訂閱碼"
#    purchase_code1: "Subscription Codes can be redeemed to add premium subscription time to one or more CodeCombat accounts."
#    purchase_code2: "Each CodeCombat account can only redeem a particular Subscription Code once."
#    purchase_code3: "Subscription Code months will be added to the end of any existing subscription on the account."
    users: "使用者"
    months: "月數"
    purchase_total: "總共"
    purchase_button: "提交購買"
    your_codes: "你的訂閱碼：" # {change}
    redeem_codes: "兌換訂閱碼"
    prepaid_code: "預付代碼"
#    lookup_code: "Lookup prepaid code"
#    apply_account: "Apply to your account"
#    copy_link: "You can copy the code's link and send it to someone."
#    quantity: "Quantity"
#    redeemed: "Redeemed"
#    no_codes: "No codes yet!"
#    you_can1: "You can"
#    you_can2: "purchase a prepaid code"
#    you_can3: "that can be applied to your own account or given to others."

#  coppa_deny:
#    text1: "Can’t wait to learn programming?"
#    text2: "Your parents will need to create an account for you to use! Email team@codecombat.com if you have any questions."
#    close: "Close Window"

  loading_error:
    could_not_load: "從伺服器載入失敗"
    connection_failure: "連線失敗。"
#    connection_failure_desc: "It doesn’t look like you’re connected to the internet! Check your network connection and then reload this page."
#    login_required: "Login Required"
#    login_required_desc: "You need to be logged in to access this page."
    unauthorized: "您需要先登錄。您把cookies禁用了嗎？"
    forbidden: "您沒有權限。"
#    forbidden_desc: "Oh no, there’s nothing we can show you here! Make sure you’re logged into the correct account, or visit one of the links below to get back to programming!"
    not_found: "沒找到。"
#    not_found_desc: "Hm, there’s nothing here. Visit one of the following links to get back to programming!"
    not_allowed: "方法不被允許。"
    timeout: "伺服器超時。" # {change}
    conflict: "資源衝突。"
    bad_input: "錯誤輸入。"
    server_error: "伺服器錯誤。"
    unknown: "未知錯誤。" # {change}
    error: "錯誤"
#    general_desc: "Something went wrong, and it’s probably our fault. Try waiting a bit and then refreshing the page, or visit one of the following links to get back to programming!"

  resources:
    level: "等級"
    patch: "修補"
    patches: "修補"
    system: "系統"
    systems: "系統"
    component: "組建"
    components: "組建"
    hero: "英雄"
    campaigns: "征戰"

  concepts:
    advanced_strings: "進階字串"
    algorithms: "算法"
    arguments: "引數"
    arithmetic: "四則運算"
    arrays: "陣列"
    basic_syntax: "基本語法"
    boolean_logic: "布林邏輯"
    break_statements: "break敘述"
    classes: "類"
    continue_statements: "continue敘述"
    for_loops: "for迴圈"
    functions: "函數"
    graphics: "圖形"
    if_statements: "if敘述"
    input_handling: "輸入處理"
    math_operations: "數學運算"
    object_literals: "對象常量"
    parameters: "參數"
    strings: "字串"
    variables: "變數"
    vectors: "向量"
    while_loops: "while迴圈" # {change}
    recursion: "遞歸"
#    basic_html: "Basic HTML" # TODO: these web-dev concepts will change, don't need to translate
#    basic_css: "Basic CSS"
#    basic_web_scripting: "Basic Web Scripting"
#    intermediate_html: "Intermediate HTML"
#    intermediate_css: "Intermediate CSS"
#    intermediate_web_scripting: "Intermediate Web Scripting"
#    advanced_html: "Advanced HTML"
#    advanced_css: "Advanced CSS"
#    advanced_web_scripting: "Advanced Web Scripting"
#    jquery: "jQuery"
#    bootstrap: "Bootstrap"

  delta:
    added: "已填加"
    modified: "已修改"
    not_modified: "未修改"
    deleted: "已刪除"
    moved_index: "已移動的索引"
    text_diff: "文本變化"
    merge_conflict_with: "合併衝突出現在"
    no_changes: "沒有改變"

  legal:
    page_title: "條文"
    opensource_intro: "CodeCombat是完全的開源。"
    opensource_description_prefix: "查看"
    github_url: "我們的 GitHub"
    opensource_description_center: "並且如果有興趣也歡迎您的幫助！ CodeCombat是建立在許多的開源專案上，並且我們深愛它們。查看"
    archmage_wiki_url: "我們的大法師wiki"
    opensource_description_suffix: "尋求創造這款遊戲的相關軟體列表。"
    practices_title: "值得尊敬的最佳實踐"
    practices_description: "這些是我們給您，給玩家的承諾，儘管這在法律上略顯不足。"
    privacy_title: "隱私"
    privacy_description: "我們將不會賣出任何關於您個人的資訊。"
    security_title: "安全"
    security_description: "我們渴望保持您的個人資訊是安全的。身為一個開源的專案，我們的網站是開放給任何人來檢視並且提升我們的安全系統。"
    email_title: "郵件"
    email_description_prefix: "我們將不會使您的信箱氾濫的收到垃圾信。不論"
    email_settings_url: "在您的郵件設定"
    email_description_suffix: "或在我們送出的信件上都有留著我們的聯結，您可以更改您的喜好並且輕易的隨時取消訂閱。"
    cost_title: "花費"
    cost_description: "CodeCombat在核心的關卡是全部免費，但只要花費一個月${{price}}美金來訂閱，您將在每個月取得額外的關卡和{{gems}}顆寶石。您可以輕易地取消訂閱並且保證取得100%的退費。"
    copyrights_title: "版權和許可"
    contributor_title: "貢獻者許可協議"
    contributor_description_prefix: "所有在本網站或是 GitHub 程式碼庫上的貢獻都依照我們的"
    cla_url: "貢獻者許可協議"
    contributor_description_suffix: "而這在您貢獻之前就應該已經同意。"
    code_title: "Code - MIT"
    code_description_prefix: "所有由 CodeCombat 擁有或是托管在 codecombat.com 的程式碼，在 GitHub 程式碼庫或者 codecombat.com 數據庫，以上許可協議都依照"
    mit_license_url: "MIT license"
    code_description_suffix: "這包括所有 CodeCombat 公開製作關卡用的系统和組件程式碼。"
    art_title: "藝術/音樂 - Creative Commons "
    art_description_prefix: "所有共通的内容都在"
    cc_license_url: "Creative Commons Attribution 4.0 International License"
    art_description_suffix: "共通内容是指所有 CodeCombat 發佈出來用於製作關卡的内容。包括："
    art_music: "音樂"
    art_sound: "聲音"
    art_artwork: "藝術作品"
    art_sprites: "貼圖"
    art_other: "所有製作關卡時公開的，不是程式碼的創造性產品。"
    art_access: "目前還没有簡便通用的下載素材方式。一般來說，從網站上使用的URL下載，或者聯繫我們尋求幫助。當然您也可以幫助我們拓展網站，使這些資源更容易下載。"
    art_paragraph_1: "為了歸屬，請在使用處或適當的地方說明，或者留下一個聯結至codecombat.com。例如："
    use_list_1: "如果使用在電影或者另一款遊戲中，請在製作人員表中加入codecombat.com"
    use_list_2: "如果使用在網站上，請在使用處留下codecombat.com，例如在圖片下面或一個您專門放置Creative Commons和開源專案的地方。如果您的内容明確提到關於 CodeCombat，那您就不需要額外署名。"
    art_paragraph_2: "如果您使用的內容非由CodeCombat製作但由一位codecombat.com中的使用者，那您應該署名他。並且如果相對應的頁面上有標記署名指示，那您應該遵照其指示。"
    rights_title: "保留權利"
    rights_desc: "所有版權由關卡本身擁有，這包含："
    rights_scripts: "腳本"
    rights_unit: "單元配置"
    rights_writings: "寫作"
    rights_media: "聲音、音樂以及其他專門為某道關卡製作，而不對其他關卡開放的創造性内容。"
    rights_clarification: "澄清一下，所有在關卡編輯器裡公開用於製作關卡的資源都是在CC協議下發佈的，然而使用關卡編輯器製作，或者在關卡製作過程中上傳的内容則不是。"
    nutshell_title: "簡而言之"
    nutshell_description: "我們在關卡編輯器裡公開的任何資源，您都可以在製作關卡時隨意使用，但我們保留在 codecombat.com 之上創建的關卡本身傳播的權利，因為我們往後可能決定以它們收費。"
    canonical: "我們宣告這篇說明的英文版本是權威版本。如果各個翻譯版本之間有任何衝突，以英文版為準。"
    third_party_title: "第三方服務"
    third_party_description: "CodeCombat使用下列的第三方服務"

  ladder_prizes:
    title: "錦標賽獎項" # This section was for an old tournament and doesn't need new translations now.
    blurb_1: "依據"
    blurb_2: "錦標賽規則"
    blurb_3: "，這些獎項將被頒發給頂尖的人類和怪物玩家。"
    blurb_4: "兩隊意指獎項是兩倍！"
    blurb_5: "(將有兩個第一名、兩個第二名，以此類推。)"
    rank: "排名"
    prizes: "獎項"
    total_value: "總價值"
    in_cash: "現金"
    custom_wizard: "定制 CodeCombat 巫師"
    custom_avatar: "定制 CodeCombat 頭像"
    heap: "給六個月的\"Startup\"訪問"
    credits: "信譽"
    one_month_coupon: "優惠：選擇 Rails 或者 HTML"
    one_month_discount: "折扣 30%：選擇 Rails 或者 HTML"
    license: "許可證"
    oreilly: "您選擇的電子書"

  calendar:
    year: "年"
    day: "日"
    month: "月"
    january: "一月"
    february: "二月"
    march: "三月"
    april: "四月"
    may: "五月"
    june: "六月"
    july: "七月"
    august: "八月"
    september: "九月"
    october: "十月"
    november: "十一月"
    december: "十二月"
