filePrefix = 'https://s3.amazonaws.com/ace-of-coders-simulation-results/'
files = [
  '1445213331501451880.json'
  '1445213333962624756.json'
  '1445213336952262072.json'
  '1445213340108350108.json'
  '1445213343518140279.json'
  '1445213347272483737.json'
  '1445213351108262273.json'
  '1445213354532639917.json'
  '1445213357911513320.json'
  '1445213361197631052.json'
  '1445213364294940845.json'
  '1445213368224989716.json'
  '1445213372340479451.json'
  '1445213375994169440.json'
  '1445213379655103566.json'
  '1445213383878314932.json'
  '1445213387576330718.json'
  '1445213391319951764.json'
  '1445213395297284000.json'
  '1445213398793484459.json'
  '1445213403418993676.json'
  '1445213407644707083.json'
  '1445213410735647885.json'
  '1445213414261150207.json'
  '1445213417601033684.json'
  '1445213421225330915.json'
  '1445213425505538665.json'
  '1445213429189103401.json'
  '1445213433364370512.json'
  '1445213436961513794.json'
  '1445213439998252285.json'
  '1445213445045520520.json'
  '1445213449514608844.json'
  '1445213453116282525.json'
  '1445213457095637020.json'
  '1445213460704753277.json'
  '1445213464286547013.json'
  '1445213468520080180.json'
  '1445213472106072387.json'
  '1445213475820365779.json'
  '1445213480580483030.json'
  '1445213483578157536.json'
  '1445213487510887752.json'
  '1445213491558872807.json'
  '1445213499351461770.json'
  '1445213502056807146.json'
  '1445213505127336236.json'
  '1445213508557502702.json'
  '1445213511896396212.json'
  '1445213515853887904.json'
  '1445213519294758676.json'
  '1445213523374005620.json'
  '1445213527496735584.json'
  '1445213531143063123.json'
  '1445213535511651949.json'
  '1445213539690176930.json'
  '1445213543065367025.json'
  '1445213546810986010.json'
  '1445213550501273173.json'
  '1445213554189924874.json'
  '1445213565085119935.json'
  '1445213568793830161.json'
  '1445213572104047422.json'
  '1445213577145506271.json'
  '1445213581528093563.json'
  '1445213584895451031.json'
  '1445213588650931726.json'
  '1445213592177781823.json'
  '1445213594397225133.json'
  '1445221277361358834.json'
  '1445221279698497496.json'
  '1445221282315153388.json'
  '1445221285394137604.json'
  '1445221288550371312.json'
  '1445221291830712255.json'
  '1445221295617755173.json'
  '1445221299055851329.json'
  '1445221302667030249.json'
  '1445221306924823599.json'
  '1445221310544601607.json'
  '1445221314153960734.json'
  '1445221317487106931.json'
  '1445221320530978932.json'
  '1445221324301371325.json'
  '1445221327649700997.json'
  '1445221331374603621.json'
  '1445221335264382014.json'
  '1445221338855628920.json'
  '1445221342321774765.json'
  '1445221346170926762.json'
  '1445221349294564500.json'
  '1445221352675532474.json'
  '1445221356123574608.json'
  '1445221359799314313.json'
  '1445221363414713316.json'
  '1445221367642102253.json'
  '1445221371845170779.json'
  '1445221375641841704.json'
  '1445221379533766000.json'
  '1445221383130035077.json'
  '1445221386448295330.json'
  '1445221390256020947.json'
  '1445221393909487800.json'
  '1445221397412673003.json'
  '1445221401217854685.json'
  '1445221404679522730.json'
  '1445221408191448392.json'
  '1445221411888158269.json'
  '1445221415264332233.json'
  '1445221419271950364.json'
  '1445221423107421701.json'
  '1445221454202101214.json'
  '1445221474185597968.json'
  '1445230073430754517.json'
  '1445230075829988193.json'
  '1445230078380093476.json'
  '1445230080916882830.json'
  '1445230084070294552.json'
  '1445230087655859195.json'
  '1445230091230254125.json'
  '1445230094958575254.json'
  '1445230102042734819.json'
  '1445230105583567102.json'
  '1445230110098843063.json'
  '1445230113969801967.json'
  '1445230117841812597.json'
  '1445230122016639650.json'
  '1445230126024689010.json'
  '1445230129401404124.json'
  '1445230132995295000.json'
  '1445230136363195000.json'
  '1445230139829326559.json'
  '1445230143133819179.json'
  '1445230146494641982.json'
  '1445230149891696294.json'
  '1445230153496417929.json'
  '1445230157420298551.json'
  '1445230161146744249.json'
  '1445230164540033734.json'
  '1445230168998013060.json'
  '1445230172276532046.json'
  '1445230175968137164.json'
  '1445230179403344385.json'
  '1445230182841026516.json'
  '1445230186681159479.json'
  '1445230190432845401.json'
  '1445230194900203984.json'
  '1445230198345037383.json'
  '1445230202459027705.json'
  '1445230205900628657.json'
  '1445230209224723942.json'
  '1445230213367015311.json'
  '1445230220444856604.json'
  '1445230223646143199.json'
  '1445230227051947244.json'
  '1445230230605632712.json'
  '1445230234132435840.json'
  '1445230237966858392.json'
  '1445230241997606689.json'
  '1445230245378549461.json'
  '1445230248791558064.json'
  '1445230252242695234.json'
  '1445230255924413167.json'
  '1445230259930682818.json'
  '1445230263564875800.json'
  '1445230267601339066.json'
  '1445230271397215053.json'
  '1445230275230599755.json'
  '1445230278557392386.json'
  '1445230282300585592.json'
  '1445230285806493395.json'
  '1445230289296758798.json'
  '1445230292932839638.json'
  '1445230296834477367.json'
  '1445230300429749446.json'
  '1445230304505276137.json'
  '1445230307932189005.json'
  '1445230311810878110.json'
  '1445230315521992848.json'
  '1445230318874365773.json'
  '1445230322501494654.json'
  '1445230326357408114.json'
  '1445230330375479959.json'
  '1445230334162974388.json'
  '1445230337876792548.json'
  '1445230341199978481.json'
  '1445230344790949698.json'
  '1445230348202193367.json'
  '1445230351464998190.json'
  '1445230355501490291.json'
  '1445230359281495971.json'
  '1445230363228852324.json'
  '1445230366952366378.json'
  '1445230370639190487.json'
  '1445230374325745381.json'
  '1445230377345716000.json'
  '1445230380547954192.json'
  '1445230384009635808.json'
  '1445230387619920999.json'
  '1445230391249215619.json'
  '1445230395050707005.json'
  '1445230398729998271.json'
  '1445230402574142636.json'
  '1445230406134099482.json'
  '1445230409763088472.json'
  '1445230413980744826.json'
  '1445230427755574837.json'
  '1445230430530442943.json'
  '1445230433698560888.json'
  '1445230437098330832.json'
  '1445230440508211654.json'
  '1445230444603413823.json'
  '1445230448464331046.json'
  '1445230451905017875.json'
  '1445230455330580775.json'
  '1445230459159341642.json'
  '1445230463274827425.json'
  '1445230467631616726.json'
  '1445230471380124991.json'
  '1445230475001827687.json'
  '1445230478421377779.json'
  '1445230482501165731.json'
  '1445230489169162067.json'
  '1445230492655384286.json'
  '1445230496133865127.json'
  '1445230499740257000.json'
  '1445230503651978021.json'
  '1445230507713678144.json'
  '1445230511095700007.json'
  '1445230513519495119.json'
  '1445268620016907631.json'
  '1445268622122827559.json'
  '1445268624140776755.json'
  '1445268626246517429.json'
  '1445268628577795578.json'
  '1445268630768718013.json'
  '1445268632895287713.json'
  '1445268635070637388.json'
  '1445268637363693700.json'
  '1445268639421901763.json'
  '1445268641731929243.json'
  '1445268644190182245.json'
  '1445268646249862525.json'
  '1445268648428272556.json'
  '1445268650914877177.json'
  '1445268653098586788.json'
  '1445268655348101903.json'
  '1445268657510578000.json'
  '1445268659754499998.json'
  '1445268662045588316.json'
  '1445268664277727860.json'
  '1445268666452725794.json'
  '1445268668805764606.json'
  '1445268670997451288.json'
  '1445268673114680160.json'
  '1445268675329202192.json'
  '1445268677513490711.json'
  '1445268679783287172.json'
  '1445268682036031414.json'
  '1445268684129371531.json'
  '1445268686425970598.json'
  '1445268688720167258.json'
  '1445268691192558105.json'
  '1445268693591401980.json'
  '1445268695781357250.json'
  '1445268698045096075.json'
  '1445268700150717503.json'
  '1445268702398420842.json'
  '1445268704720775279.json'
  '1445268707063564355.json'
  '1445268709338713945.json'
  '1445268711632755548.json'
  '1445268713768604227.json'
  '1445268716174246278.json'
  '1445268718396569875.json'
  '1445268720560126457.json'
  '1445268722729210983.json'
  '1445268724924585705.json'
  '1445268727102603087.json'
  '1445268729116745670.json'
  '1445268731363535604.json'
  '1445268733669265741.json'
  '1445268735955645041.json'
  '1445268738219628792.json'
  '1445268740422156492.json'
  '1445268742575678088.json'
  '1445268744783311234.json'
  '1445268746965546913.json'
  '1445268749160417454.json'
  '1445268751560320842.json'
  '1445268753823934772.json'
  '1445268756018962812.json'
  '1445268758417436266.json'
  '1445268760592037000.json'
  '1445268762650074634.json'
  '1445268764724292438.json'
  '1445268766920232465.json'
  '1445268769106959357.json'
  '1445268771359267849.json'
  '1445268773629836795.json'
  '1445268775790855329.json'
  '1445268777998775005.json'
  '1445268780377269826.json'
  '1445268782636835024.json'
  '1445268785105088940.json'
  '1445268787394903774.json'
  '1445268789625324163.json'
  '1445268791928562868.json'
  '1445268794097570133.json'
  '1445268796336624399.json'
  '1445268798631516823.json'
  '1445268801543146203.json'
  '1445268803720916221.json'
  '1445268806117659719.json'
  '1445268808328143702.json'
  '1445268810583045236.json'
  '1445268812868210294.json'
  '1445268815044910115.json'
  '1445268817371573566.json'
  '1445268819837082598.json'
  '1445268822186030265.json'
  '1445268824529238254.json'
  '1445268826698333397.json'
  '1445268829048336564.json'
  '1445268831119849897.json'
  '1445268833179695745.json'
  '1445268835355203152.json'
  '1445268837405461490.json'
  '1445268839507117921.json'
  '1445268841769599236.json'
  '1445268843884382755.json'
  '1445268846071503011.json'
  '1445268848349572818.json'
  '1445268850524364412.json'
  '1445268852776213937.json'
  '1445268854920734373.json'
  '1445268857126237087.json'
  '1445268859310201176.json'
  '1445268861561857965.json'
  '1445268864105148024.json'
  '1445268866197882910.json'
  '1445268868353326182.json'
  '1445268870516655449.json'
  '1445268872673508915.json'
  '1445268874762479150.json'
  '1445268877164751364.json'
  '1445268879286935114.json'
  '1445268881328685986.json'
  '1445268883445195315.json'
  '1445268885647373744.json'
  '1445268887906137602.json'
  '1445268890210873534.json'
  '1445268892285821181.json'
  '1445268894477987144.json'
  '1445268896586339497.json'
  '1445268898783556149.json'
  '1445268901026137511.json'
  '1445268903288629511.json'
  '1445268905632999958.json'
  '1445268907769137075.json'
  '1445268910210199749.json'
  '1445268912487917439.json'
  '1445268914699519986.json'
  '1445268916872093395.json'
  '1445268919162358705.json'
  '1445268921364723116.json'
  '1445268923529045633.json'
  '1445268925634767250.json'
  '1445268927773354402.json'
  '1445268930024845244.json'
  '1445268932347541598.json'
  '1445268934554593819.json'
  '1445268936774699728.json'
  '1445268939055730840.json'
  '1445268941103213627.json'
  '1445268943288510342.json'
  '1445268945472849529.json'
  '1445268947571262875.json'
  '1445268949842113619.json'
  '1445268953053002587.json'
  '1445268955705618031.json'
  '1445268957931907119.json'
  '1445268960079462662.json'
  '1445268962482269944.json'
  '1445268964595501883.json'
  '1445268966774301554.json'
  '1445268969043544169.json'
  '1445268971228990112.json'
  '1445268973718788263.json'
  '1445268975915972005.json'
  '1445268978092369714.json'
  '1445268980221048405.json'
  '1445268982462277288.json'
  '1445268984704104467.json'
  '1445268986851463154.json'
  '1445268988870702929.json'
  '1445268991174718359.json'
  '1445268993166842169.json'
  '1445268995482530004.json'
  '1445268997698069030.json'
  '1445268999856627198.json'
  '1445269001963981298.json'
  '1445269005128881832.json'
  '1445269007631174328.json'
  '1445269010567701718.json'
  '1445269012840178714.json'
  '1445269015063741658.json'
  '1445269017242828233.json'
  '1445269019421232891.json'
  '1445269021824220288.json'
  '1445269023938605981.json'
  '1445269026409208695.json'
  '1445269028509058790.json'
  '1445269030524896000.json'
  '1445269032756824238.json'
  '1445269035159289304.json'
  '1445269037366243450.json'
  '1445269039465047380.json'
  '1445269041701586560.json'
  '1445269043788403673.json'
  '1445269046045728613.json'
  '1445269048151202850.json'
  '1445269050459992316.json'
  '1445269053004557688.json'
  '1445269055349225134.json'
  '1445269057525643140.json'
  '1445269059934835285.json'
  '1445269062110045209.json'
  '1445269064274679000.json'
  '1445269066451272607.json'
  '1445269068728772237.json'
  '1445269070877790585.json'
  '1445269073109715995.json'
  '1445269075306781702.json'
  '1445269077338016409.json'
  '1445269079599082477.json'
  '1445269081901931619.json'
  '1445269083937350893.json'
  '1445269086606168066.json'
  '1445269089749719526.json'
  '1445269092912378322.json'
  '1445269095068300466.json'
  '1445269097105610715.json'
  '1445269099340915790.json'
  '1445269101634711008.json'
  '1445269103883171321.json'
  '1445269105915454000.json'
  '1445269108167686595.json'
  '1445269110361203248.json'
  '1445269112791210489.json'
  '1445269119000963903.json'
  '1445269122719487762.json'
  '1445269125411006548.json'
  '1445269127762964020.json'
  '1445269129836155861.json'
  '1445269132111575135.json'
  '1445269134217570416.json'
  '1445269136543021559.json'
  '1445269138695139898.json'
  '1445269140914567682.json'
  '1445269142942098025.json'
  '1445269145044930788.json'
  '1445269147248686797.json'
  '1445269149522984507.json'
  '1445269152161285087.json'
  '1445269155322986789.json'
  '1445269157818898906.json'
  '1445269160044484047.json'
  '1445269162266085471.json'
  '1445269164442888373.json'
  '1445269166529441082.json'
  '1445269168855231051.json'
  '1445269171132400258.json'
  '1445269173209510973.json'
  '1445269175360974881.json'
  '1445269177391806404.json'
  '1445269179564059457.json'
  '1445269181918334941.json'
  '1445269184183064047.json'
  '1445269186482660799.json'
  '1445269188582405643.json'
  '1445269190635432324.json'
  '1445269192856263789.json'
  '1445269195038404565.json'
  '1445269197102021853.json'
  '1445269199482726135.json'
  '1445269201660257229.json'
  '1445269203942103478.json'
  '1445269206237893322.json'
  '1445269208456870810.json'
  '1445269210788885279.json'
  '1445269213239724034.json'
  '1445269215451086036.json'
  '1445269217647945453.json'
  '1445269220046288284.json'
  '1445269222236265440.json'
  '1445269224505994866.json'
  '1445269226825172010.json'
  '1445269229116949026.json'
  '1445269231489543733.json'
  '1445269233755357471.json'
  '1445269235911648747.json'
  '1445269237999553699.json'
  '1445269240508365024.json'
  '1445269242722009927.json'
  '1445269244934195076.json'
  '1445269247162195032.json'
  '1445269249236953713.json'
  '1445269251458578943.json'
  '1445269253487689604.json'
  '1445269255696323064.json'
  '1445269257949099645.json'
  '1445269260191632330.json'
  '1445269262355329886.json'
  '1445269264566769605.json'
  '1445269266964329940.json'
  '1445269269227593807.json'
  '1445269271514201936.json'
  '1445269273612398920.json'
  '1445269275884684268.json'
  '1445269278076892764.json'
  '1445269280310865878.json'
  '1445269282424623299.json'
  '1445269284715336825.json'
  '1445269286688556553.json'
  '1445269288887242319.json'
  '1445269291073998385.json'
  '1445269293108399667.json'
  '1445269295212448901.json'
  '1445269297426394018.json'
  '1445269299599447234.json'
  '1445269301729933144.json'
  '1445269303996496226.json'
  '1445269306270930877.json'
  '1445269308476918049.json'
  '1445269310582680614.json'
  '1445269312690229962.json'
  '1445269314892409324.json'
  '1445269316980608523.json'
  '1445269319006449029.json'
  '1445269321185755416.json'
  '1445269323341804973.json'
  '1445269325664755068.json'
  '1445269327834759470.json'
  '1445269330069526259.json'
  '1445269332287771312.json'
  '1445269334385516439.json'
  '1445269336657750533.json'
  '1445269338838256481.json'
  '1445269340977045479.json'
  '1445269343278893069.json'
  '1445269345423148790.json'
  '1445269347428235854.json'
  '1445269349635316570.json'
  '1445269351688263000.json'
  '1445269354011647956.json'
  '1445269356113719565.json'
  '1445269358229515145.json'
  '1445269360612105490.json'
  '1445269362922818774.json'
  '1445269365222636184.json'
  '1445269367513280151.json'
  '1445269370028699953.json'
  '1445269372414990361.json'
  '1445269374641788750.json'
  '1445269377029996590.json'
  '1445269379312073874.json'
  '1445269381603113183.json'
  '1445269383813588267.json'
  '1445269386078574000.json'
  '1445269388353640395.json'
  '1445269390574915000.json'
  '1445269392800924652.json'
  '1445269395085481942.json'
  '1445269397341246657.json'
  '1445269399473830151.json'
  '1445269401846739679.json'
  '1445269404175824085.json'
  '1445269406294316012.json'
  '1445269408513123706.json'
  '1445269410750656000.json'
  '1445269413028587778.json'
  '1445269415145683723.json'
  '1445269417477899634.json'
  '1445269419689952826.json'
  '1445269421916883311.json'
  '1445269424069113886.json'
  '1445269426389494628.json'
  '1445269427373333034.json'
  '1445269898973248759.json'
  '1445269901101787379.json'
  '1445269902613155311.json'
]

request = require '../../node_modules/request'

allSessionIDs = {}
usernamesBySessionID = {}
userIDsBySessionID = {}
codeLanguagesByUserID = {}
teamNames = ['humans', 'ogres']
matchesByTeam = {humans: {}, ogres: {}}
# Each object's first keys are first team session IDs, second are alternate teams' session IDs.
# values are 1 for win, 0 for loss for first team.
# We do this so that if there are duplicates in the results, we don't double-count them.

done = 0
getFile = (file) ->
  request filePrefix + file, (err, resp, body) ->
    if err
      console.log '\nGot err downloading', file, err, '-- retrying...'
      return getFile file
    else
      process.stdout.write "#{resp.statusCode}: downloaded #{file}, #{done + 1} / #{files.length}\r"
    try
      matches = JSON.parse body
    catch err
      console.log '\nGot err parsing', file, err, '-- retrying...'
      return getFile file
    for match in matches
      for team in teamNames
        session = match[{humans: 'HumansSession', ogres: 'OgresSession'}[team]]
        otherSession = match[{humans: 'OgresSession', ogres: 'HumansSession'}[team]]
        allSessionIDs[session] = session
        allSessionIDs[otherSession] = otherSession
        matchesByTeam[team][session] ?= {}
        matchesByTeam[team][session][otherSession] = if match.Winner is session then 1 else 0
    if ++done is files.length
      console.log ""
      getNames()

for file in files
  getFile file

[sessionsDone, needed] = [0, 0]
getName = (sessionID) ->
  ++needed
  request "http://localhost:3000/db/level.session/#{sessionID}?project=creatorName,creator,submittedCodeLanguage", (err, resp, body) ->
    if err
      console.log '\nGot err fetching session', sessionID, err, '-- retrying...'
      --needed
      return getName sessionID
    else
      process.stdout.write "#{resp.statusCode}: fetched session #{sessionID}, #{sessionsDone + 1} / #{needed}\r"
    try
      session = JSON.parse(body)
    catch err
      console.log '\nGot err parsing', session, err, '-- retrying...'
      return getName sessionID
    usernamesBySessionID[sessionID] = session.creatorName or session.creator
    userIDsBySessionID[sessionID] = session.creator
    codeLanguagesByUserID[session.creator] = session.submittedCodeLanguage
    if ++sessionsDone is needed
      console.log ""
      finish()

getNames = ->
  for sessionID of allSessionIDs
    getName sessionID

finish = ->
  findLosses = ['55df8c9207d920b7e4262f33', '55e1d23686c019bc47b640fe', '55fa69c0d1754b86056db36e', '55fa68056e01178605aff259', '55f9d3ffd1754b86056d5faa', '55f9d40066d6808505035c4a']

  teamRankings = {}
  for team in teamNames
    teamRankings[team] = {}
    for session, matches of matchesByTeam[team]
      for otherSession, result of matches
        sessionCreatorName = usernamesBySessionID[session]
        otherSessionCreatorName = usernamesBySessionID[otherSession]
        continue if sessionCreatorName is otherSessionCreatorName
        teamRankings[team][sessionCreatorName] ?= {wins: 0, losses: 0, sessionID: session}
        if result is 1
          ++teamRankings[team][sessionCreatorName].wins
        else
          if session in findLosses
            sessionOne = if team is 'humans' then session else otherSession
            sessionTwo = if team is 'humans' then otherSession else session
            console.log "#{sessionCreatorName} #{team} lost to #{otherSessionCreatorName}: http://codecombat.com/play/spectate/ace-of-coders?session-one=#{sessionOne}&session-two=#{sessionTwo}"
          ++teamRankings[team][sessionCreatorName].losses

  #console.log teamRankings

  fs = require 'fs'
  topPlayers = []
  playersSeenOnlyOnce = {}
  for team, players of teamRankings
    for playerName, teamScore of players
      player = playersSeenOnlyOnce[playerName]
      if player
        player.wins += teamScore.wins
        player.losses += teamScore.losses
        delete playersSeenOnlyOnce[playerName]
      else
        userID = userIDsBySessionID[teamScore.sessionID]
        topPlayers.push {name: playerName, userID: userID, sessionID: teamScore.sessionID, wins: teamScore.wins, losses: teamScore.losses, codeLanguage: codeLanguagesByUserID[userID], team: team}
        playersSeenOnlyOnce[playerName] = topPlayers[topPlayers.length - 1]

  teamCounts = humans: Object.keys(teamRankings.humans).length, ogres: Object.keys(teamRankings.ogres).length
  console.log '\nPlayers per team:', teamCounts.humans, 'humans,', teamCounts.ogres, 'ogres'

  topPlayers.sort (a, b) ->
    aScore = 1000 * a.wins - a.losses
    bScore = 1000 * b.wins - b.losses
    aScore *= 0.999 + (if a.team is 'ogres' then (teamCounts.ogres / teamCounts.humans) else (teamCounts.humans / teamCounts.ogres)) if a.name of playersSeenOnlyOnce
    bScore *= 0.999 + (if b.team is 'ogres' then (teamCounts.ogres / teamCounts.humans) else (teamCounts.humans / teamCounts.ogres)) if b.name of playersSeenOnlyOnce
    return bScore - aScore

  topPlayers = (JSON.stringify(p, null, 0) for p in topPlayers)

  #console.log "Players seen only once:", playersSeenOnlyOnce

  fs.writeFile 'tournament_results.tsv', topPlayers.join('\n') + '\n', {flags: 'w'}, (err) ->
    console.log 'Error writing tournament results:', err if err
    console.log '\nWrote tournament results!' unless err
    process.exit()
