﻿import flash.filters.GlowFilter;

import AS2_4399_API.Delegate;
import AS2_4399_API.PayMoneyVar;
import AS2_4399_API.JSON;

import System.security;

/**
 * ...
 * @author lqs
 */
class AS2_4399_API.Bridge
{
	
	/**
	 * 获取API实例
	 */
	public static function getInstance() : Bridge
	{
		eb7560c4326bb0e1 = true;	
		if (_instance == null)
			_instance = new Bridge();
		eb7560c4326bb0e1 = false;	
		return _instance;
	}
	
	/**
	 *用户退出登录
	**/
	public function userLogOut(callBackContext:Object,callBackFunc:Function):Void{
		_logOutCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([117,115,101,114,76,111,103,79,117,116]), param:null});
	}
	
	//获取服务器时间
	public function getServerTime(callBackContext:Object,callBackFunc:Function):Void{
		_getServerTimeCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([103,101,116,83,101,114,118,101,114,84,105,109,101]), param:null});
	}
	
	//侦听用户退出登录
	public function  noticeUserLogOut(callBackContext:Object,callBackFunc:Function):Void{
		_logOutCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	/**author orange
	 * 商城接口
	 */
	 //显示商城UI
	 public function showShopUi():Void{
		 this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([115,104,111,119,83,104,111,112,85,105]), param:null});
	}
	
	//删除消耗道具
	public function consumeItemFun(proId:String,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		_delItemCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([99,111,110,115,117,109,101,73,116,101,109,70,117,110]), param:[proId]});
	}
	
	//根据扩展字段及道具类型（收费，免费或者收费+免费）清空道具
	public function clearItemsByExTypeFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,type:String,exFlag:Array,sn:String):Void{
		_clearItemsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([99,108,101,97,114,73,116,101,109,115,66,121,69,120,84,121,112,101,70,117,110]), param:[type,exFlag,sn]});
	}
	
	//获取背包的列表
	public function getPackageInfoFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,pageNum:Number,curPage:Number,typeId:String,exFlag:Array,sn:String):Void{
		_getPackageCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(isNaN(pageNum) || pageNum == undefined){
			pageNum = 10;
		}
		
		if(isNaN(curPage) || curPage == undefined){
			curPage = 1;
		}
		
		if(typeId == undefined || typeId == ""){
			typeId = "0";
		}
		
		if(exFlag == undefined){
			exFlag = null;
		}
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([103,101,116,80,97,99,107,97,103,101,73,110,102,111,70,117,110]), param:[pageNum,curPage,typeId,exFlag,sn]});
	}
	
	//根据物品ID列表获取数据
	public function getShopItemsFun(idsAry:Array,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,sn:String):Void{
		_getPackageCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([103,101,116,83,104,111,112,73,116,101,109,115,70,117,110]), param:[idsAry,sn]});
	}
	
	//获取商城公告及分类信息
	public function getNoticeTypeFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		_noticeTypeCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
	}
	
	//获取收费道具的商城数据
	public function getPayPacInfoFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,pageNum:Number,curPage:Number,typeId:String):Void{
		_getPayPacCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(isNaN(pageNum) || pageNum == undefined){
			pageNum = 8;
		}
		
		if(isNaN(curPage) || curPage == undefined){
			curPage = 1;
		}
		
		if(typeId == undefined || typeId == ""){
			typeId = "0";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([103,101,116,80,97,121,80,97,99,73,110,102,111,70,117,110]), param:[pageNum,curPage,typeId]});
	}
	
	//购买收费物品
	public function buyProFun(proId:String,count:Number,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,sn:String):Void{
		_buyCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([98,117,121,80,114,111,70,117,110]), param:[proId,count,sn]});
	}
	
	//获取免费的物品商城数据
	public function getFreePacInfoFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,pageNum:Number,curPage:Number,typeId:String):Void{
		_getFreePacCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(isNaN(pageNum) || pageNum == undefined){
			pageNum = 0;
		}
		
		if(isNaN(curPage) || curPage == undefined){
			curPage = 1;
		}
		
		if(typeId == undefined || typeId == ""){
			typeId = "0";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([103,101,116,70,114,101,101,80,97,99,73,110,102,111,70,117,110]), param:[pageNum,curPage,typeId]});
	}
	
	//删除多种多个道具,免费与收费
	public function removeItemsFun(dataAry:Array,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,sn:String):Void{
		_delItemCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([114,101,109,111,118,101,73,116,101,109,115,70,117,110]), param:[dataAry,sn]});
	}
	
	//增加多种多个道具及设置相应的属性(设置属性只针对不可累加的物品)
	public function addItemsFun(dataAry:Array,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,sn:String):Void{
		_addItemsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([97,100,100,73,116,101,109,115,70,117,110]), param:[dataAry,sn]});
	}
	
	//修改某个道具的属性,只对不可累加物品
	public function updateItemProFun(dataObj:Object,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,sn:String):Void{
		_updateItemCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([117,112,100,97,116,101,73,116,101,109,80,114,111,70,117,110]), param:[dataObj,sn]});
	}
	
	//根据背包ID修改扩展字段
	public function modifyExFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function,pId:String,exAry:Array,sn:String):Void{
		_modifyExCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		_packageErrorCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		
		if(sn == undefined){
			sn = "";
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([109,111,100,105,102,121,69,120,70,117,110]), param:[pId,exAry,sn]});
	}
	
	//设置扩展字段
	public function setExFlagFun(dataAry:Array):Void
	{
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([115,101,116,69,120,70,108,97,103,70,117,110]), param:dataAry});
	}
	
	//通知修改扩展字段
	public function noticeSetExFlagFun(callBackContext:Object,callBackFunc:Function):Void{
		_noticeSetExFlagCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	//用于购买道具成功或者充值成功返回余额
	public function getShopBalance(callBackContext:Object,callBackFunc:Function):Void{
		_getBalanceCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	/**
	 * 游戏列表
	 */
	public function showGameList():Void
	{
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([115,104,111,119,71,97,109,101,76,105,115,116]), param:null});
	}

	/**
	 * 提交积分
	 *  @param score 要提交的分数
	 */
	public function showRefer(score : Number) : Void
	{
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({ func:Bridge.a5ce41e255a608030c([111,112,101,110,73,110,116,101,103,114,97,108,87,105,110]), param:[score] });
	}

	/**
	 * 显示排行榜
	 */
	public function showSort() : Void
	{
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([111,112,101,110,83,111,114,116,87,105,110]), param:null});
	}

	/**author orange
	 * 支付接口
	 */
	
	//增加游戏币
	 public function incMoney(payMoneyVar:PayMoneyVar,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		 var ec083aa56dc0449a:Number;
		 if(payMoneyVar == null || payMoneyVar.money == undefined || isNaN(Number(payMoneyVar.money)))
		{
			ec083aa56dc0449a = 0
		}else{
			ec083aa56dc0449a = Number(payMoneyVar.money);
		}
		 _incMoneyInsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([105,110,99,77,111,110,101,121]), param:[ec083aa56dc0449a]});
	 }
	 
	 //减少游戏币
	 public function decMoney(payMoneyVar:PayMoneyVar,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		var ec083aa56dc0449a:Number;
		 if(payMoneyVar == null || payMoneyVar.money == undefined || isNaN(Number(payMoneyVar.money)))
		{
			ec083aa56dc0449a = 0
		}else{
			ec083aa56dc0449a = Number(payMoneyVar.money);
		}
		 _decMoneyInsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([100,101,99,77,111,110,101,121]), param:[ec083aa56dc0449a]});
	 }
	 
	 //获取游戏币余额
	 public function getBalance(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		 _getBalanceInsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([103,101,116,66,97,108,97,110,99,101]), param:null});
	 }
	 
	 //兑换游戏币
	 public function payMoney(payMoneyVar:PayMoneyVar,callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		 var ec083aa56dc0449a:Number;
		 if(payMoneyVar == null || payMoneyVar.money == undefined || isNaN(Number(payMoneyVar.money)))
		{
			ec083aa56dc0449a = 0
		}else{
			ec083aa56dc0449a = Number(payMoneyVar.money);
		}
		 _payMoneyInsCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		 this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([112,97,121,77,111,110,101,121]), param:[ec083aa56dc0449a]});
	 }
	 
	 //获取某用户在某游戏中累计消费的游戏币数量
	 public function getTotalPaiedFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		 _getPaiedMoneyCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		 this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([112,97,105,101,100,77,111,110,101,121]), param:null});
	 }
	 
	 //获取某用户在某游戏中累计充值的游戏币数量
	 public function getTotalRechargedFun(callBackContext:Object,callBackFunc:Function,errorBackFunc:Function):Void{
		 _getRechargedMoneyCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		 _payErrorInsCallBackFunc = Delegate.create(callBackContext, errorBackFunc);
		 this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([114,101,99,104,97,114,103,101,100,77,111,110,101,121]), param:null});
	 }
	 
	/**
	 * 存储游戏 
	 * 共有三个存档
	 * data 存贮内容 长度限制（0-1024）
	 * @param index  存放在对应的位置  0-2 代表三个存贮空间
	 * @param data    要存放的数据(0-1024)
	 */
	public function saveData(title:String,data:Object,callBackContext:Object,callBackFunc:Function,ui:Boolean,index:Number) : Void
	{
		if(ui == null || ui == undefined)
		{
			ui = true;
		}
		if(isNaN(index) ||index == null || index == undefined)
		{
			index = 0
		}
		_saveDataCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		
		//对data进行转换成字符串
		var strData:String = "";
		try{
			strData = JSON.stringify(data);
		}catch(ex){
			strData = "";
		}
		//保证30k----------以中文字为计算单位，1个汉字2个字节，所以为15000字节   sendMsg({func:"joinDataFun", param:[title,tmpStr,ui,index,tmpBln]});
		if(strData.length > 15000){
			var tmpBln:Boolean = false;
			var len:Number = Math.ceil(strData.length/15000);
			for(var i:Number=0;i<len;i++){
				var tmpStr:String = strData.substr(i*15000,15000);
				if(i == len -1){
					tmpBln = true;
				}
				this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([106,111,105,110,68,97,116,97,70,117,110]), param:[title,tmpStr,ui,index,tmpBln]});
			}
			return;
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([115,97,118,101,68,97,116,97]), param:[title,data,ui,index]});
	}

	/**
	 * 获得对应位置中的数据
	 * @param index 要获取数据的位置
	 */
	public function getData(callBackContext:Object,callBackFunc:Function,ui:Boolean,index : Number) : Void
	{
		if(ui == null || ui == undefined)
		{
			ui = true;
		}
		if(isNaN(index) ||index == null || index == undefined)
		{
			index = 0
		}
		_getDataCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([103,101,116,68,97,116,97]), param:[ui,index]});
	}

	/**
	 * 获得所存放的存档列表(0-2)中的信息
	 */
	public function openSaveUI(title:String,data:Object,saveContext:Object,saveFunc:Function,getContext:Object,getFunc:Function) : Void
	{
		_getDataCallBackFunc = Delegate.create(getContext, getFunc);
		_saveDataCallBackFunc = Delegate.create(saveContext, saveFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([103,101,116,76,105,115,116]), param:[title,data]});
	}
    
	
	/*-------网络存单失败------*/
	public function netSaveErrorCallBack(callBackContext:Object,callBackFunc:Function):Void{
		_netSaveErrorCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	/*-------网络取档失败------*/
	public function netGetErrorCallBack(callBackContext:Object,callBackFunc:Function):Void{
		_netGetErrorCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	//获取存档列表的数据
	public function getListData(callBackContext:Object,callBackFunc:Function):Void{
		_getListCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([103,101,116,76,105,115,116,68,97,116,97]), param:null});
	}
	
    /**
     * 登录后回调
     * @param	callBackContext
     * @param	callBackFunc
     */
    public function setLogInCallBack(callBackContext:Object,callBackFunc:Function):Void
	{
		_loginCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
    
	/**
	 * 检测控制层是否合法
	 */
	public function testCtrl() : Void
	{	
	}
	/**
	 * 打开登录面板
	 */
	public function showLogPanel():Void
	{
		c75362407e1d1b80 = true;
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([115,104,111,119,76,111,103,80,97,110,101,108]), param:null});
	}
	/**
	 * 获取是否登录
	 * @param	callBackContext
	 * @param	callBackFunc
	 */
	public function getIsLog(callBackContext:Object,callBackFunc:Function):Void
	{
		_getIsLogCallBackFunc = Delegate.create(callBackContext, callBackFunc);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([105,115,76,111,103]), param:null});
	}
	
	/**
	 * 发送给控制层 鼠标是否可见
	 * @param	bol
	 * true 可见
	 * false 不可见
	 */
	public function setMouseVisible(bol:Boolean):Void
	{
		this[Bridge.a5ce41e255a608030c([98, 51, 99, 51, 100, 50, 57, 102, 49, 57, 100, 97, 101, 53, 56, 56])] = bol;
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([115,101,116,77,111,117,115,101,86,105,115,105,98,108,101]), param:bol});
	}

	private function d64237efc16b5087(_this):Void
	{
		if(this[Bridge.a5ce41e255a608030c([101,52,100,51,99,56,100,97,101,51,48,97,102,53,53,57])])
			return;
		
		if (_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](this[Bridge.a5ce41e255a608030c([100,48,102,97,98,51,55,51,50,97,53,99,98,99,100,49])]))
		{
			var num : Number = int(Math.random() * (this[Bridge.a5ce41e255a608030c([101,98,49,98,52,54,99,56,48,49,48,97,97,53,97,100])].length - 1));
			this[Bridge.a5ce41e255a608030c([100,48,102,97,98,51,55,51,50,97,53,99,98,99,100,49])] = _global[Bridge.a5ce41e255a608030c([115,101,116,73,110,116,101,114,118,97,108])](this[Bridge.a5ce41e255a608030c([101,98,54,101,49,50,102,102,54,52,53,56,51,51,99,55])], 10000, this);
			this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([116,101,115,116,67,116,114,108]), param:num});
		}
	}
	
	private function fed9cd2755d7cec4(_this):Void
	{
		if(_this[Bridge.a5ce41e255a608030c([97,49,50,98,49,51,51,98,56,102,98,101,49,55,53,100])])
			return;
		_this[Bridge.a5ce41e255a608030c([102,98,100,55,100,97,55,54,57,99,57,50,98,97,49,48])](_this);
	}

	private function testReturn(ab608cc046f2a6e6) : Void
	{
		
	}
	
	private function f8f09b15319aa987():Void
	{
		
	}

	private function eb6e12ff645833c7(_this) : Void
	{			
		this[Bridge.a5ce41e255a608030c([101,52,100,51,99,56,100,97,101,51,48,97,102,53,53,57])] = true;
		_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](_this[Bridge.a5ce41e255a608030c([100,48,102,97,98,51,55,51,50,97,53,99,98,99,100,49])]);
		this[Bridge.a5ce41e255a608030c([100,48,102,97,98,51,55,51,50,97,53,99,98,99,100,49])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](_this.e6da1a6af0171de);
		_this.e6da1a6af0171de = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		_this[Bridge.a5ce41e255a608030c([102,98,100,55,100,97,55,54,57,99,57,50,98,97,49,48])] = _this[Bridge.a5ce41e255a608030c([102,56,102,48,57,98,49,53,51,49,57,97,97,57,56,55])];
		_this[Bridge.a5ce41e255a608030c([100,98,102,53,48,51,55,51,57,53,98,99,54,48,54,101])](_this);
	}
	
	private function dbf5037395bc606e(_this):Void
	{
		if(!_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])]))
		{
			return;
		}
		if(!_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](_this[Bridge.a5ce41e255a608030c([98,49,56,55,99,48,50,100,98,53,52,52,98,54,52,100])]))
		{
			_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](_this[Bridge.a5ce41e255a608030c([98,49,56,55,99,48,50,100,98,53,52,52,98,54,52,100])]);
			_this[Bridge.a5ce41e255a608030c([98,49,56,55,99,48,50,100,98,53,52,52,98,54,52,100])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		}
		if(_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])]))
		{
			_global[Bridge.a5ce41e255a608030c([115,100,97,115,100,102,97])][Bridge.a5ce41e255a608030c([95,118,105,115,105,98,108,101])] = false;
			_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])] = _global[Bridge.a5ce41e255a608030c([115,101,116,73,110,116,101,114,118,97,108])](_this[Bridge.a5ce41e255a608030c([101,50,50,99,48,51,101,48,48,54,54,99,50,101,55,50])],120000,_this);
		}
	}
	private function e22c03e0066c2e72(_this):Void
	{
		if(!_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])]))
		{
			_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])]);
			_this[Bridge.a5ce41e255a608030c([99,52,99,55,97,57,54,100,99,102,98,56,102,101,99,97])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		}
		_this[Bridge.a5ce41e255a608030c([99,97,101,52,54,50,99,48,101,98,99,98,55,49,101,101])] = false;
		_this[Bridge.a5ce41e255a608030c([98,51,97,50,55,54,49,100,53,97,52,102,55,97,100,98])](_this);
		_this[Bridge.a5ce41e255a608030c([98,49,56,55,99,48,50,100,98,53,52,52,98,54,52,100])] = _global[Bridge.a5ce41e255a608030c([115,101,116,73,110,116,101,114,118,97,108])](_this[Bridge.a5ce41e255a608030c([100,98,102,53,48,51,55,51,57,53,98,99,54,48,54,101])], 10000,_this);
	}

	public function Bridge() 
	{
		if (!eb7560c4326bb0e1)
		{
			throw(new Error("创建出错,请使用getInstance()方法创建!!!!"));
			return;
		}
		_4399_ad_id = "92d6cef76cd06829e088932fe9fd819b";
		_root.focusManager.enabled = false;
		b3c3d29f19dae588 = true;
		this[Bridge.a5ce41e255a608030c([101,98,49,98,52,54,99,56,48,49,48,97,97,53,97,100])] = _root[Bridge.a5ce41e255a608030c([95,117,114,108])];
		 _global[Bridge.a5ce41e255a608030c([97,57,56,100,50,102,100,57,57,99,48,50,101,56,53,54])] = Bridge.a5ce41e255a608030c([115,97,118,101,80,114,111,99,101,115,115,70,117,110,99]);
		this[Bridge.a5ce41e255a608030c([102,98,100,55,100,97,55,54,57,99,57,50,98,97,49,48])] = this[Bridge.a5ce41e255a608030c([100,54,52,50,51,55,101,102,99,49,54,98,53,48,56,55])];
		this[Bridge.a5ce41e255a608030c([100,48,102,97,98,51,55,51,50,97,53,99,98,99,100,49])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		_root[Bridge.a5ce41e255a608030c([95,108,111,99,107,114,111,111,116])] = true;
		movieClipTest();
		security[Bridge.a5ce41e255a608030c([97,108,108,111,119,68,111,109,97,105,110])]('*');
		security[Bridge.a5ce41e255a608030c([97,108,108,111,119,73,110,115,101,99,117,114,101,68,111,109,97,105,110])]('*');
		this[Bridge.a5ce41e255a608030c([97,97,51,102,102,97,102,49,52,57,98,51,53,49,102,54])]();
	}
	
	private function movieClipTest():Void
	{
		if (_level0 === undefined && MovieClip.prototype.oldHitTest === undefined) {
	    	var realRootForReal = _root;
	    	MovieClip.prototype.oldHitTest = MovieClip.prototype.hitTest;
	   		MovieClip.prototype.hitTest = function (x, y, shapeflag) {
		        if (arguments.length === 1) return this.oldHitTest(x);
		        var obj = {x: x, y: y};
		        realRootForReal.localToGlobal(obj);
		        return this.oldHitTest(obj.x, obj.y, shapeflag);
       		}
		}
	}

	private function aa3ffaf149b351f6() : Void
	{
		this[Bridge.a5ce41e255a608030c([99,51,55,56,54,52,102,102,52,52,55,57,101,51,52,98])] = true;
		this[Bridge.a5ce41e255a608030c([99,101,52,99,57,102,52,50,101,50,102,102,97,97,54,51])]();
	}
    
	private function ce4c9f42e2ffaa63() : Void 
	{
		if (!_global[Bridge.a5ce41e255a608030c([105,115,78,97,78])](this[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])])) 
		{
			_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](this[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])]);
		}
		this[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])] = _global[Bridge.a5ce41e255a608030c([115,101,116,73,110,116,101,114,118,97,108])](this[Bridge.a5ce41e255a608030c([102,48,57,97,102,50,97,52,101,102,51,53,54,53,54,56])], 20,this);
	}
    

	public function f09af2a4ef356568(d75659655174056e,func) : Void 
	{
		if (d75659655174056e[Bridge.a5ce41e255a608030c([98,102,99,57,101,102,98,99,51,57,55,57,48,53,54,56])] >= d75659655174056e.ea9e2aece3ec241a) 
		{
			d75659655174056e[Bridge.a5ce41e255a608030c([99,51,55,56,54,52,102,102,52,52,55,57,101,51,52,98])] = false;
			_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](d75659655174056e[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])]);
			d75659655174056e[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
		}
		d75659655174056e[Bridge.a5ce41e255a608030c([98,102,99,57,101,102,98,99,51,57,55,57,48,53,54,56])]++;
		if (_root[Bridge.a5ce41e255a608030c([111,112,97,113,117,101,66,97,99,107,103,114,111,117,110,100])] != undefined)
		{
			d75659655174056e[Bridge.a5ce41e255a608030c([101,100,99,97,102,49,51,100,98,97,51,98,50,102,50,99])](_root[Bridge.a5ce41e255a608030c([111,112,97,113,117,101,66,97,99,107,103,114,111,117,110,100])]);
			_root[Bridge.a5ce41e255a608030c([111,112,97,113,117,101,66,97,99,107,103,114,111,117,110,100])] = undefined;
			_global[Bridge.a5ce41e255a608030c([99,108,101,97,114,73,110,116,101,114,118,97,108])](d75659655174056e[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])]);
			d75659655174056e[Bridge.a5ce41e255a608030c([101,54,51,99,50,57,48,52,53,99,56,97,50,55,53,102])] = _global[Bridge.a5ce41e255a608030c([78,97,78])];
			d75659655174056e[Bridge.a5ce41e255a608030c([101,49,48,53,53,54,49,50,53,98,57,57,57,101,52,52])] = true;
			d75659655174056e[Bridge.a5ce41e255a608030c([99,51,55,56,54,52,102,102,52,52,55,57,101,51,52,98])] = false;
		}
	}

	private function edcaf13dba3b2f2c(a89bc777c9e57736) : Void
	{
		this[Bridge.a5ce41e255a608030c([97,102,52,48,53,49,102,102,55,50,49,57,97,48,56,56])] = Bridge.a5ce41e255a608030c([65,83,51,95,52,51,57,57]) + a89bc777c9e57736;
		this[Bridge.a5ce41e255a608030c([102,57,54,53,49,51,49,52,57,48,100,51,52,98,51,101])]= Bridge.a5ce41e255a608030c([65,83,50,95,52,51,57,57]) + a89bc777c9e57736;
		if (this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])] == null)
		{
			this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])] = new LocalConnection();
		}
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([115,101,116,77,111,117,115,101,86,105,115,105,98,108,101]), param:b3c3d29f19dae588});
		this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])][Bridge.a5ce41e255a608030c([99,111,110,110,101,99,116])](this[Bridge.a5ce41e255a608030c([102,57,54,53,49,51,49,52,57,48,100,51,52,98,51,101])]);
		this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])][Bridge.a5ce41e255a608030c([114,101,99,101,105,118,101,72,97,110,100,108,101,114])] = Delegate.create(this, this[Bridge.a5ce41e255a608030c([100,56,99,49,97,98,97,53,99,51,56,100,48,54,50,51])]);
		this[Bridge.a5ce41e255a608030c([100,51,53,49,54,100,57,99,56,55,49,50,52,98,100,52])]({func:Bridge.a5ce41e255a608030c([99,111,110,110,101,99,116]), param:null});
	}

	private function d8c1aba5c38d0623(obj) : Void
	{
		if (obj != null && obj.func != null)
		{
			switch(obj.func){
				case Bridge.a5ce41e255a608030c([117,115,101,114,76,111,103,105,110,79,117,116]):
					//用户退出
					_logOutCallBackFunc();
					break;
				case Bridge.a5ce41e255a608030c([99,108,111,115,101,80,97,110,101,108]):
					//关闭弹出的面板
					this[Bridge.a5ce41e255a608030c([99,108,111,115,101,80,97,110,101,108,70,117,110])](obj.param);
					break;
				case _global[Bridge.a5ce41e255a608030c([97,57,56,100,50,102,100,57,57,99,48,50,101,56,53,54])]:
					this[Bridge.a5ce41e255a608030c([115,97,118,101,80,114,111,99,101,115,115,70,117,110,99])](obj.param[0], obj.param[1]);
					break;
				case Bridge.a5ce41e255a608030c([112,97,121,80,114,111,99,101,115,115,70,117,110,99]):
					this[Bridge.a5ce41e255a608030c([112,97,121,80,114,111,99,101,115,115,70,117,110,99])](obj.param[0], obj.param[1]);
					break;
				case Bridge.a5ce41e255a608030c([115,104,111,112,80,114,111,99,101,115,115,70,117,110,99]):
					this[Bridge.a5ce41e255a608030c([115,104,111,112,80,114,111,99,101,115,115,70,117,110,99])](obj.param[0], obj.param[1]);
					break;
				case Bridge.a5ce41e255a608030c([111,116,104,101,114,80,114,111,99,101,115,115,70,117,110,99]):
					this[Bridge.a5ce41e255a608030c([111,116,104,101,114,80,114,111,99,101,115,115,70,117,110,99])](obj.param[0], obj.param[1]);
					break;
				default:
					this[obj.func](obj.param);
			}
		}
	}
	
	private function closePanelFun(ret:String):Void{
		_closePanelCallBackFunc(ret);
	}
	
	 public function closePanelCallBack(callBackContext:Object,callBackFunc:Function):Void
	{
		_closePanelCallBackFunc = Delegate.create(callBackContext, callBackFunc);
	}
	
	private function otherProcessFunc(type:String,ret:Object):Void{
		switch(type){
			case "serverTimeEvent":
				_getServerTimeCallBackFunc(ret);
				break;
		}
	}
	
	private function shopProcessFunc(type:String,ret:Object):Void{
		switch(type){
			case "delItemSuc":
				_delItemCallBackFunc(ret);
				break;
			case "shopError":
				_packageErrorCallBackFunc(String(ret));
				break;
			case "getPacakgeInfo":
				_getPackageCallBackFunc(ret);
				break;
			case "addFreeItemSuc":
				_addItemsCallBackFunc(ret);
				break;
			case "updateProSuc":
				_updateItemCallBackFunc(ret);
				break;
			case "getFreePacakgeInfo":
				_getFreePacCallBackFunc(ret);
				break;
			case "updateExtend":
				_noticeSetExFlagCallBackFunc(ret);
				break;
			case "addItemSuc":
				_buyCallBackFunc(ret);
				break;
			case "getPayPacakgeInfo":
				_getPayPacCallBackFunc(ret);
				break;
			case "getTypeNotice":
				_noticeTypeCallBackFunc(ret);
				break;
			case "modifyEx":
				_modifyExCallBackFunc(ret);
				break;
			case "clearItemsByExType":
				_clearItemsCallBackFunc(ret);
				break;
		}
	}
	
	private function payProcessFunc(type:String,ret:Object):Void{
		switch(type){
			case "logsuccess":
				if(c75362407e1d1b80){
					c75362407e1d1b80 = false;
					break;
				} 
				//用户登录成功uid name
				_loginCallBackFunc(ret);
				break;
			case "incMoney" :
				//增加游戏币false,balance
				_incMoneyInsCallBackFunc(ret)
				break;
			case "decMoney":
				//减少游戏币false,balance
				if(_decMoneyInsCallBackFunc != undefined)
					_decMoneyInsCallBackFunc(ret);
				if(_getBalanceCallBackFunc != undefined)
					_getBalanceCallBackFunc(ret);
				break
			case "getMoney":
				//获取游戏币余额false,balance
				if(_getBalanceInsCallBackFunc != undefined)
					_getBalanceInsCallBackFunc(ret);
				if(_getBalanceCallBackFunc != undefined)
					_getBalanceCallBackFunc(ret);
				break;
			case "payMoney":
				//兑换游戏币false
				_payMoneyInsCallBackFunc(ret);
				break;
			case "paiedMoney":
				_getPaiedMoneyCallBackFunc(ret);
				break;
			case "rechargedMoney":
				_getRechargedMoneyCallBackFunc(ret);
				break;
			case "payError" :
				//错误提示info:4|余额不足!!
				_payErrorInsCallBackFunc(ret);
				break;
		}
	}
	
	private function saveProcessFunc(type:String, ret:Object):Void
	{
		if (type == "isLog")
		{
			_getIsLogCallBackFunc(ret);
		}
		else if (type == "logreturn")
		{
			_loginCallBackFunc(ret);
		}
		else if (type == "getuserdata")
		{
			_getDataCallBackFunc(ret);
		}
		else if (type == "saveuserdata")
		{
			_saveDataCallBackFunc(ret);
		}
		else if (type == "getuserdatalist")
		{
			_getListCallBackFunc(ret);
		}else if (type == "netSaveError"){
			_netSaveErrorCallBackFunc();
		}else if(type == "netGetError"){
			_netGetErrorCallBackFunc(ret);
		}else if (type == "joinData"){
			//拼装数据
			if(joinDataObj.data == undefined){
				joinDataObj.data = ret.data;
			}else{
				joinDataObj.data += ret.data;
			}
			if(ret.endFlag == "1"){
				joinDataObj.index = ret.index;
				joinDataObj.datetime = ret.datetime;
				joinDataObj.title = ret.title;
				try{
					joinDataObj.data = JSON.parse(String(joinDataObj.data));
				}catch(e:Error){
					joinDataObj.data = "";
				}
				_getDataCallBackFunc(joinDataObj);
				joinDataObj = new Object();
			}
		}
	}
   
	private function d3516d9c87124bd4(obj) : Void
	{
		if (this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])] != null)
		{
			this[Bridge.a5ce41e255a608030c([97,48,56,49,102,49,48,55,56,99,51,52,56,53,55,98])].send(this[Bridge.a5ce41e255a608030c([97,102,52,48,53,49,102,102,55,50,49,57,97,48,56,56])], Bridge.a5ce41e255a608030c([114,101,99,101,105,118,101,72,97,110,100,108,101,114]), obj);
		}
	}

	private function b3a2761d5a4f7adb(d75659655174056e):Void
	{
		
	}
	
	private static function a5ce41e255a608030c(ab608cc046f2a6e6)
	{
		var aff90c9978347f:String;
		aff90c9978347f = "";
		for(var i:Number = 0;i<ab608cc046f2a6e6.length;i++)
		{
			aff90c9978347f+=String.fromCharCode(ab608cc046f2a6e6[i]);
		}
		return aff90c9978347f;
	}
	
	private function setFocusManager():Void
	{
		_root.focusManager.enabled = false;
	}
    
 	private var e4d3c8dae30af559;
	private var a081f1078c34857b ;
	private var af4051ff7219a088 ;
	private var f965131490d34b3e ;
	private var c37864ff4479e34b ;
	private var e10556125b999e44 ;
	private var e63c29045c8a275f ;
	private var bfc9efbc39790568  = 0;
	private var ea9e2aece3ec241a  = 1000;
	private var bf443b797ef8a66b  = 20;
	private var a12b133b8fbe175d ;
	private var eb1b46c8010aa5ad ;
	private var b187c02db544b64d ;
	private var d0fab3732a5cbcd1 ;
	private static var _instance  = null;
	private static var eb7560c4326bb0e1 ;
	private var fbd7da769c92ba10;
	private var e6da1a6af0171de;
	private var c4c7a96dcfb8feca;
	private var cae462c0ebcb71ee;
	private var _loginCallBackFunc:Function;
	private var _getIsLogCallBackFunc:Function;
	private var _saveDataCallBackFunc:Function;
	private var _getListCallBackFunc:Function;
	private var _getDataCallBackFunc:Function;
	private var _netSaveErrorCallBackFunc:Function;
	private var _netGetErrorCallBackFunc:Function;
	private var b3c3d29f19dae588;
	private var _4399_ad_id:String;
	
	//支付回调函数定义
	private var _incMoneyInsCallBackFunc:Function;
	private var _decMoneyInsCallBackFunc:Function;
	private var _getBalanceInsCallBackFunc:Function;
	private var _payMoneyInsCallBackFunc:Function;
	private var _payErrorInsCallBackFunc:Function;
	private var _getPaiedMoneyCallBackFunc:Function;
	private var _getRechargedMoneyCallBackFunc:Function;
	//获取服务器时间的回调函数
	private var _getServerTimeCallBackFunc:Function;
	//判断是否从独立的登录面板登录
	private var c75362407e1d1b80:Boolean = false;
	//关闭弹出的面板回调函数
	private var _closePanelCallBackFunc:Function;
	//退出登录
	private var _logOutCallBackFunc:Function;
	private var _packageErrorCallBackFunc:Function;
	private var _delItemCallBackFunc:Function;
	private var _getPackageCallBackFunc:Function;
	private var _getBalanceCallBackFunc:Function;
	private var _getFreePacCallBackFunc:Function;
	private var _addItemsCallBackFunc:Function;
	private var _updateItemCallBackFunc:Function;
	private var _noticeSetExFlagCallBackFunc:Function;
	private var _noticeTypeCallBackFunc:Function;
	private var _getPayPacCallBackFunc:Function;
	private var _buyCallBackFunc:Function;
	private var joinDataObj:Object = new Object();
	private var _modifyExCallBackFunc:Function;
	private var _clearItemsCallBackFunc:Function;
}
