require "story"
story_table =
{
  {
    {
      init = function()
        for k, entity in pairs (game.surfaces[1].find_entities()) do
          if entity.name == "locomotive" then
            entity.insert"coal"
          end
          entity.minable = false
          entity.operable = false
          entity.rotatable = false
        end
        game.players[1].character.destroy()
        global.first = export_entities({area = {{-50, 8},{-10,34}}})
        global.first_param = {offset = {30, -20}}
        global.second = export_entities({area = {{-60, -24},{-22, 2}}})
        global.second_param = {offset = {40, 10}}
        global.third = export_entities({area = {{-60, -60},{-22, -28}}})
        global.third_param = {offset = {38, 44}}
        global.fourth = export_entities({area = {{-60, 36},{30, 60}}})
        global.fourth_param = {offset = {18, -54}}
        global.fifth = export_entities({area = {{-8, -60},{60, -26}}})
        global.fifth_param = {offset = {-26, 36}}
      end,
      condition = story_elapsed_check(1)
    },
    { 
      init = function()
        set_goal("", false)
        set_info({text = {"deadlock-1"}})
        set_info({custom_function = add_button}, true)
        recreate_entities(global.first, global.first_param)
      end,
      condition = function()
        return global.continue
      end
    },
    { 
      init = function()
        set_goal("", false)
        set_info({text = {"deadlock-2"}})
        set_info({custom_function = add_button}, true)
        global.locomotive = game.surfaces[1].find_entities_filtered{name = "locomotive", area = {{5, -2},{7, 2}}}[1]
        local schedule = global.locomotive.train.schedule
        schedule.records[1].station = "Cyan 2"
        global.locomotive.train.schedule = schedule
        global.locomotive.train.manual_mode = true
        global.locomotive.train.manual_mode = false
      end,
      condition = function()
        return global.continue
      end
    },
    {
      init = function()
        clear_surface()
        global.locomotives = {}
        global.arrows = {}
        global.areas = {}
        for k, entity in pairs (recreate_entities(global.first, global.first_param)) do
          if entity.name == "locomotive" then
            entity.train.manual_mode = true
            table.insert(global.locomotives, entity)
          elseif entity.name == "rail-signal" and 
            (
              (
                entity.position.x == -4.5 and 
                entity.position.y == 2.5
              ) 
              or
              (
                entity.position.x == -2.5 and 
                entity.position.y == -2.5
              )
            ) 
          then
            entity.minable = true
            table.insert(global.areas, entity.bounding_box)
            table.insert(global.arrows, game.surfaces[1].create_entity{name = "orange-arrow-with-circle", position = entity.position})
          end
        end
        set_goal({"chain-signal"})
        set_info({text = {"chain-signal-description"}, picture = "file/chain-signals.png"})
        set_info({text = {"chain-signal-1"}}, true)
        game.players[1].insert"rail-chain-signal"
      end,
      condition = function()
        for k, area in pairs (global.areas) do
          if game.surfaces[1].find_entities_filtered{name = "rail-chain-signal", area = area}[1] == nil then
            return false
          end
        end
        return true
      end,
      action = function()
        for k, arrow in pairs (global.arrows) do
          arrow.destroy()
        end
        for k, train in pairs (global.locomotives) do
          train.train.manual_mode = false
        end
        global.arrows = nil
        global.areas = nil
        global.locomotives = nil
      end
    },
    {
      init = function()
        set_goal()
        set_info({text = {"chain-signal-2"}})
        set_info({custom_function = add_button}, true)
      end,
      condition = function()
        return global.continue
      end,
      action = function()
        global.locomotive = game.surfaces[1].find_entities_filtered{name = "locomotive", area = {{5, -2},{7, 2}}}[1]
        local schedule = global.locomotive.train.schedule
        schedule.records[1].station = "Cyan 2"
        global.locomotive.train.schedule = schedule
        global.locomotive.train.manual_mode = true
        global.locomotive.train.manual_mode = false
      end
    },
    {
      condition = story_elapsed_check(4)
    },
    {
      init = function()
        clear_surface()
        set_goal({"fix-intersection"})
        set_info({custom_function = add_run_trains_button})
        global.this_puzzle_trains = {}
        for k, entity in pairs (global.second) do
          if entity.name == "locomotive" or entity.name == "fluid-wagon" then
            entity.manual_mode = true
            table.insert(global.this_puzzle_trains, entity)
          elseif entity.name == "rail-signal" then
            entity.minable = true
          end
        end
        global.this_puzzle = global.second
        global.this_puzzle_param = global.second_param
        recreate_entities(global.this_puzzle, global.this_puzzle_param)
      end,
      condition = function()
        return puzzle_condition()
      end
    },
    {
      init = function()
        clear_surface()
        set_goal({"fix-intersection"})
        set_info({custom_function = add_run_trains_button})
        global.this_puzzle_trains = {}
        for k, entity in pairs (global.third) do
          if entity.name == "locomotive" or entity.name == "fluid-wagon" then
            entity.manual_mode = true
            table.insert(global.this_puzzle_trains, entity)
          elseif entity.name == "rail-signal" then
            entity.minable = true
          end
        end
        global.this_puzzle = global.third
        global.this_puzzle_param = global.third_param
        recreate_entities(global.this_puzzle, global.this_puzzle_param)
      end,
      condition = function()
        return puzzle_condition()
      end
    },
    {
      init = function()
        clear_surface()
        set_goal({"fix-intersection"})
        set_info({custom_function = add_run_trains_button})
        global.this_puzzle_trains = {}
        for k, entity in pairs (global.fourth) do
          if entity.name == "locomotive" or entity.name == "fluid-wagon" then
            entity.manual_mode = true
            table.insert(global.this_puzzle_trains, entity)
          elseif entity.name == "rail-signal" then
            entity.minable = true
          end
        end
        global.this_puzzle = global.fourth
        global.this_puzzle_param = global.fourth_param
        recreate_entities(global.this_puzzle, global.this_puzzle_param)
      end,
      condition = function()
        return puzzle_condition()
      end
    },
    {
      init = function()
        clear_surface()
        set_goal({"fix-intersection"})
        set_info({custom_function = add_run_trains_button})
        global.this_puzzle_trains = {}
        global.this_puzzle = global.fifth
        global.this_puzzle_param = global.fifth_param
        for k, entity in pairs (global.this_puzzle) do
          if entity.name == "locomotive" or entity.name == "fluid-wagon" then
            entity.manual_mode = true
            table.insert(global.this_puzzle_trains, entity)
          elseif entity.name == "rail-signal" then
            entity.minable = true
          end
        end
        recreate_entities(global.this_puzzle, global.this_puzzle_param)
      end,
      condition = function()
        return puzzle_condition()
      end
    },
    {
      condition = story_elapsed_check(2),
      action = function ()
        set_goal()
        set_info()
        game.show_message_dialog({text = {"finish"}})
      end,
    },
  }
}

story_init_helpers(story_table)

script.on_init(function()
  game.surfaces[1].always_day = true
  game.forces["player"].manual_mining_speed_modifier = 4
  global.story = story_init(story_table)
end)

script.on_event(defines.events.on_tick, function(event)
  story_update(global.story, event, "")
end)

script.on_event(defines.events.on_gui_click, function(event)
  local element = event.element
  local player = game.players[event.player_index]
  local name = element.name
  if name == "story_continue_button" then
    global.continue = true
    element.style = "fake_disabled_button_style"
    element.style.font = "default"
    return
  end
  if name == "start_trains" then
    if element.style.name == "fake_disabled_button_style" then return end
    for k, train in pairs (game.surfaces[1].find_entities_filtered{name = "locomotive"}) do
      train.train.manual_mode = false
    end
    element.style = "fake_disabled_button_style"
    element.style.font = "default"
    game.players[1].set_controller{type = defines.controllers.ghost}
    return
  end
  if name == "reset_trains" then
    for k, train in pairs (game.surfaces[1].find_entities_filtered{name = "locomotive"}) do
      train.destroy()
    end
    for k, train in pairs (game.surfaces[1].find_entities_filtered{name = "fluid-wagon"}) do
      train.destroy()
    end
    recreate_entities(global.this_puzzle_trains, global.this_puzzle_param)
    for k, child in pairs (element.parent.children) do
      child.style = "button_style"
      child.style.font = "default"
    end
    player.set_controller{type = defines.controllers.god}
    if player.get_item_count("rail-chain-signal") < 20 then
      player.insert"rail-chain-signal"
    end
    if player.get_item_count("rail-signal") < 20 then
      player.insert"rail-signal"
    end
    return
  end
  if name == "reset_all" then
    clear_surface()
    recreate_entities(global.this_puzzle, global.this_puzzle_param)
    for k, child in pairs (element.parent.children) do
      child.style = "button_style"
      child.style.font = "default"
    end
    player.set_controller{type = defines.controllers.god}
    if player.get_item_count("rail-chain-signal") < 20 then
      player.insert"rail-chain-signal"
    end
    if player.get_item_count("rail-signal") < 20 then
      player.insert"rail-signal"
    end
    return
  end
end)

function clear_surface()
  local entities = game.surfaces[1].find_entities()
  for k, entity in pairs (entities) do
    if entity.valid and entity.name ~= "player" then
      entity.destroy()
    end
  end
  for k, entity in pairs (game.surfaces[1].find_entities()) do
    if entity.valid and entity.name ~= "player" then
      entity.destroy()
    end
  end
end

function add_button(gui)
  local button = gui.add{type = "button", name = "story_continue_button", caption = {"continue"}}
  button.style.font = "default"
  global.continue = false
end

function add_run_trains_button(gui)
  local flow = gui.add{type = "flow", direction = "horizontal"}
  local button = flow.add{type = "button", name = "start_trains", caption = {"start-trains"}}
  button.style.font = "default"
  local button = flow.add{type = "button", name = "reset_trains", caption = {"reset-trains"}}
  button.style.font = "default"
  local button = flow.add{type = "button", name = "reset_all", caption = {"reset-all"}}
  button.style.font = "default"
  local player = game.players[1]
  player.set_controller{type = defines.controllers.god}
  if player.get_item_count("rail-chain-signal") < 20 then
    player.insert"rail-chain-signal"
  end
  if player.get_item_count("rail-signal") < 20 then
    player.insert"rail-signal"
  end
  global.intermission = 0
end

function puzzle_condition()
  for k, train in pairs (game.surfaces[1].find_entities_filtered{name = "locomotive"}) do
    if train.train.speed ~= 0 then 
      return false
    end
    if train.color == nil then
      if train.train.state ~= defines.train_state.wait_station then
        return false
      end
      if train.health ~= 1000 then 
        return false
      end
    end
  end
  for k, wagon in pairs (game.surfaces[1].find_entities_filtered{name = "fluid-wagon"}) do
    if wagon.health ~= 600 then
      return false
    end
  end
  global.intermission = global.intermission + 1
  return global.intermission >= 90
end



