require "story"

story_table =
{
  {
    {
      init = function()
        for k, entity in pairs (game.surfaces[1].find_entities()) do
          entity.minable = false
        end
        if game.players[1].character then
          game.players[1].character.destroy()
        end
        global.crossroads = export_entities({area = {{-60,-60},{60,-30}}})
        global.upper_track = export_entities({area = {{-60,-22},{60,0}}})
        global.lower_track = export_entities({area = {{-60,0},{60,12}}})
        global.two_way = export_entities({area = {{-60,14},{60,44}}})
      end,
      condition = story_elapsed_check(2),
    },
    {
      init = function() 
        for k, entity in pairs (recreate_entities(global.upper_track, {offset = {0, 4}})) do
          if entity.name == "locomotive" and entity.color ~= nil then
            global.damaged_locomotive = entity
            break
          end
        end
        set_goal({"locomotive-crash", {"gui-train.automatic-mode"}})
        set_info({text = {"locomotive-crash-info"}})
      end,
      condition = function(event)
        return global.damaged_locomotive.valid and global.damaged_locomotive.health < 990
      end,
      action = function()
        global.damaged_locomotive = nil
      end
    },
    {
      condition = story_elapsed_check(2),
    },
    {
      init = function(event)
        if event.name ~= defines.events.on_tick then return end
        clear_surface()
        recreate_entities(global.upper_track, {offset = {0, 4}})
        set_goal({"place-signal"})
        set_info({text = {"place-signal-info"}})
        game.players[1].insert{name = "rail-signal", count = 50}
        for k, entity in pairs (game.surfaces[1].find_entities_filtered{name="locomotive"}) do
          if entity.color == nil then
            global.locomotive = entity
            entity.operable = false
          else
            global.other_locomotive = entity
          end
        end
      end,
      condition = function(event)
        if event.name == defines.events.on_tick then
          local area = {{-2.5, -7},{8.5, -6}}
          for k, entity in pairs (game.surfaces[1].find_entities_filtered{area = area}) do
            if entity.name == "rail-signal" then
              entity.minable = false
              return true
            end
          end
        end
      end,
      action = function()
        global.locomotive.operable = true
      end
    },
    {
      init = function()
        set_goal({"locomotive-crash", {"gui-train.automatic-mode"}})
      end,
      condition = function()
        return global.locomotive.train.state == defines.train_state.wait_signal
      end
    },
    {
      condition = story_elapsed_check(1)
    },
    {
      init = function()
        global.other_locomotive.train.schedule = 
        {
          current = 1,
          records = {
            {
              station = "Station",
              wait_conditions = {
                {
                  compare_type = "or",
                  type = "full"
                }
              }
            },
            {
              station = "Branch",
              wait_conditions = {
                {
                  compare_type = "or",
                  ticks = 18000,
                  type = "time"
                }
              }
            }
          }
        }
        set_goal({"still-blocked"})
        set_info({text = {"still-blocked-info"}})
        global.locomotive.operable = false
      end,
      condition = function()
        return global.locomotive.train.state == defines.train_state.wait_station
      end
    },
    {
      condition = story_elapsed_check(2)
    },
    {
      init = function(event)
        if event.name ~= defines.events.on_tick then return end
        clear_surface()
        for k, entity in pairs (recreate_entities(global.lower_track, {offset = {0, -10}})) do
          if entity.name == "locomotive" and entity.color == nil then
            global.locomotive = entity
            global.locomotive.operable = false
            break
          end
        end
        set_goal({"siding-signals"})
        set_info({text = {"siding-signals-info"}})
      end,
      condition = function(event)
        if event.name ~= defines.events.on_tick then return end
        return global.locomotive.train.state == defines.train_state.wait_station
      end
    },
    {
      init = function(event)
        if event.name ~= defines.events.on_tick then return end
        clear_surface()
        for k, entity in pairs (recreate_entities(global.two_way, {offset = {2, -20}})) do
          if entity.name == "locomotive" then
            if entity.color == nil then
              global.locomotive = entity
              break
            end
          end
        end
        set_goal({"siding-signals"})
        set_info()        
      end,
      condition = function(event)
        if event.name ~= defines.events.on_tick then return end
        return global.locomotive.train.state == defines.train_state.wait_station
      end
    },
    {
      init = function()
        set_goal({"siding-signals"})
        clear_surface()
        for k, entity in pairs (recreate_entities(global.crossroads, {offset = {0, 40}})) do
          if entity.name == "locomotive" then
            if entity.color == nil then
              global.locomotive = entity
              break
            end
          end
        end        
      end,
      condition = function(event)
        if event.name ~= defines.events.on_tick then return end
        return global.locomotive.train.state == defines.train_state.wait_station
      end
    },
    {
      condition = story_elapsed_check(2),
      action = function ()
        set_goal()
        set_info()
        game.show_message_dialog({text = {"finish"}})
      end,
    },
  }
}

story_init_helpers(story_table)

script.on_init(function()
  game.surfaces[1].always_day = true
  game.forces["player"].manual_mining_speed_modifier = 4
  global.story = story_init(story_table)
end)

script.on_event(defines.events.on_tick, function(event)
  story_update(global.story, event, "")
end)

function clear_surface()
  local entities = game.surfaces[1].find_entities()
  for k, entity in pairs (entities) do
    if entity.valid and entity.name ~= "player" then
      entity.destroy()
    end
  end
  for k, entity in pairs (game.surfaces[1].find_entities()) do
    if entity.valid and entity.name ~= "player" then
      entity.destroy()
    end
  end
end
